/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class FountainWizard
extends JDialog
implements ActionListener {
    private int side;
    private int level;
    private int x;
    private int y;
    private MapData data;
    private MultWallSwitchData fountainswitch = null;
    private JToggleButton[] sidebutton = new JToggleButton[4];
    private JToggleButton cantakeitems;
    private JComboBox canputitems;
    private JLabel hasswitch;
    private DMEditor dmed;

    public FountainWizard(DMEditor dMEditor) {
        super(dMEditor, "Fountain Wizard", true);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 240);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.cantakeitems = new JToggleButton("Can Take Out Items");
        this.cantakeitems.setSelected(true);
        String[] stringArray = new String[]{"None", "0", "1", "2", "3", "4"};
        this.canputitems = new JComboBox<String>(stringArray);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Maximum size of items that can be put in:"));
        jPanel2.add(this.canputitems);
        jPanel.add(this.cantakeitems);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup.add(this.sidebutton[0]);
        buttonGroup.add(this.sidebutton[1]);
        buttonGroup.add(this.sidebutton[2]);
        buttonGroup.add(this.sidebutton[3]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[0]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[1]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[3]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[2]);
        jPanel3.add(new JLabel());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Fountain Faces:"));
        this.sidebutton[2].setSelected(true);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(3, 1));
        this.hasswitch = new JLabel("No Switch");
        JButton jButton = new JButton("Add/Edit Switch");
        JButton jButton2 = new JButton("Remove Switch");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel5.add(this.hasswitch);
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(jPanel3);
        JPanel jPanel7 = new JPanel();
        JButton jButton3 = new JButton("Done");
        JButton jButton4 = new JButton("Cancel");
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jPanel7.add(jButton4);
        jPanel7.add(jButton3);
        container.add("Center", jPanel6);
        container.add("South", jPanel7);
        container.add("East", jPanel4);
        container.add("North", jPanel);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 'f') {
            FountainData fountainData = (FountainData)mapData;
            this.sidebutton[(fountainData.side + 2) % 4].doClick();
            if (fountainData.fountainswitch != null) {
                this.fountainswitch = fountainData.fountainswitch;
                this.hasswitch.setText("Has Switch");
            } else {
                this.fountainswitch = null;
                this.hasswitch.setText("No Switch");
            }
            this.cantakeitems.setSelected(fountainData.cantakeitems);
            this.canputitems.setSelectedIndex(fountainData.canputitems + 1);
        } else {
            this.fountainswitch = null;
            this.hasswitch.setText("No Switch");
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else if (actionEvent.getActionCommand().equals("Done")) {
            this.data = new FountainData(this.side, this.cantakeitems.isSelected(), this.canputitems.getSelectedIndex() - 1, this.fountainswitch);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Add/Edit Switch")) {
            MultWallSwitchData multWallSwitchData = (MultWallSwitchData)new MultWallSwitchWizard(this.dmed, this.fountainswitch, this.level, this.x, this.y, false, -1, this.side).getData();
            if (multWallSwitchData != null) {
                this.fountainswitch = multWallSwitchData;
                this.hasswitch.setText("Has Switch");
            }
        } else if (actionEvent.getActionCommand().equals("Remove Switch")) {
            if (this.hasswitch.getText().equals("No Switch")) {
                return;
            }
            this.fountainswitch = null;
            this.hasswitch.setText("No Switch");
        }
    }

    public MapData getData() {
        return this.data;
    }
}

