/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class HeroSpecials
extends JDialog
implements ActionListener,
MouseListener {
    private Vector abilities;
    private Vector abils;
    private JList abilitylist;
    private int listindex = -1;
    private AbilityPanel abilitypanel;

    public HeroSpecials(DMEditor dMEditor, Vector vector) {
        super(dMEditor, "Hero Specials", true);
        this.setDefaultCloseOperation(2);
        this.setSize(900, 600);
        this.setLocationRelativeTo(null);
        Container container = this.getContentPane();
        this.abils = vector;
        this.abilities = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.abilities.add(new SpecialAbility((SpecialAbility)vector.get(i)));
        }
        this.abilitylist = new JList(this.abilities);
        this.abilitylist.setSelectionMode(0);
        this.abilitylist.setVisibleRowCount(6);
        this.abilitylist.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.abilitylist);
        jScrollPane.setPreferredSize(new Dimension(200, 120));
        JPanel jPanel = new JPanel();
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Current Abilities"));
        JButton jButton = new JButton("< Add (Replace Selected With) Ability Above ^");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("< Remove Selected Ability");
        jButton2.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(jButton);
        box.add(jButton2);
        jPanel.add(box);
        this.abilitypanel = new AbilityPanel(dMEditor);
        this.abilitypanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Create/Edit Ability"));
        if (this.abilities.size() > 0 && !this.abilitypanel.hasLastAbility()) {
            this.abilitylist.setSelectedIndex(0);
            this.listindex = 0;
            this.abilitypanel.setAbility((SpecialAbility)this.abilities.get(0));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.abilitypanel);
        jPanel2.add(jPanel);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Abilities"));
        JPanel jPanel3 = new JPanel();
        JButton jButton3 = new JButton("Cancel");
        JButton jButton4 = new JButton("Done");
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "South");
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            this.abils.clear();
            for (int i = 0; i < this.abilities.size(); ++i) {
                this.abils.add(this.abilities.get(i));
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (actionEvent.getActionCommand().startsWith("< A")) {
            SpecialAbility specialAbility = this.abilitypanel.createSpecial();
            if (specialAbility == null) {
                return;
            }
            if (this.listindex != -1) {
                this.abilities.set(this.listindex, specialAbility);
            } else {
                this.abilities.add(specialAbility);
            }
            this.abilitylist.setListData(this.abilities);
            this.listindex = -1;
        } else if (actionEvent.getActionCommand().startsWith("< R") && this.listindex != -1) {
            this.abilities.remove(this.listindex);
            this.abilitylist.setListData(this.abilities);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.abilitylist.locationToIndex(mouseEvent.getPoint());
        if (n == -1 || n == this.listindex) {
            this.abilitylist.clearSelection();
        }
        this.listindex = this.abilitylist.getSelectedIndex();
        if (this.listindex != -1) {
            this.abilitypanel.setAbility((SpecialAbility)this.abilities.get(this.listindex));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

