/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class ItemCreator
extends JDialog
implements ActionListener,
FilenameFilter {
    private Item item;
    private int TYPE;
    private int ARMORTYPE = 2;
    private static final String[] SIZES = new String[]{"0", "1", "2", "3", "4"};
    private static final String[] POISONS = new String[]{"None", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final String[] FOODS = new String[]{"None", "150", "200", "250", "300", "350", "400", "450", "500", "550", "600", "700", "800", "900", "1000"};
    public static final String[] FUNCTIONS = new String[]{"None", "Punch", "Kick", "Stab", "Jab", "Swing", "Bash", "Slash", "Chop", "Melee", "Stun", "Thrust", "Crush", "Cleave", "Berzerk", "Disrupt", "Parry", "Throw", "Shoot", "Anti-Ven", "Arc Bolt", "Armor", "Armor Party", "Backstab", "Berserker", "Blow Horn", "Bolt", "Calm", "Climb Down", "Climb Up", "Detect Illusion", "Dispell", "Drain Life", "Drain Mana", "False Image", "Feeble Mind", "Fireball", "Freeze", "Freeze Life", "Frighten", "Good Berries", "Heal", "Invoke", "Light", "Purify", "Ruiner", "Shield", "Shield Party", "Sight", "Silence", "Slow", "Slowfall", "Spellshield", "Spellshield Party", "Steal", "Strip Defenses", "True Sight", "Ven Cloud", "Venom", "War Cry", "Weakness", "ZO"};
    public static final String[] CLASSES = new String[]{"Fighter", "Ninja", "Wizard", "Priest", "None"};
    public static final String[] LEVELS = new String[]{"None", "Neophyte", "Novice", "Apprentice", "Journeyman", "Crafstman", "Artisan", "Adept", "Expert", "LO Master", "UM Master", "ON Master", "EE Master", "PAL Master", "MON Master", "ArchMaster"};
    private static final String[] AMMO = new String[]{"None", "Arrows", "Rocks", "Darts", "Stars", "Daggers", "Fits Quiver"};
    private static final int[] defaultclass = new int[]{0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 3, 2, 3, 3, 1, 0, 3, 2, 3, 1, 1, 1, 2, 2, 2, 1, 2, 2, 3, 3, 3, 3, 3, 2, 2, 3, 2, 3, 3, 3, 3, 2, 3, 3, 3, 1, 2, 3, 2, 2, 3, 2, 2};
    private static final int[] defaultlvlneed = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 6, 5, 7, 8, 4, 1, 0, 0, 1, 1, 1, 1, 4, 4, 0, 1, 1, 0, 7, 9, 1, 4, 8, 9, 1, 1, 0, 1, 0, 4, 4, 0, 0, 8, 6, 1, 2, 0, 4, 1, 1, 2, 3, 4, 1, 9, 1, 1, 0, 1, 1};
    private static final int[] defaultpower = new int[]{0, 1, 2, 6, 6, 6, 7, 10, 10, 16, 14, 16, 19, 18, 25, 20, 4, 0, 10, 15, 3, 10, 10, 0, 3, 6, 3, 4, 0, 0, 0, 3, 50, 20, 1, 3, 3, 125, 100, 3, 20, 40, 0, 100, 0, 3, 15, 10, 25, 3, 3, 20, 15, 10, 20, 3, 20, 3, 3, 2, 3, 3};
    private static final int[] defaultspeed = new int[]{0, 3, 7, 8, 7, 10, 12, 9, 16, 18, 16, 18, 20, 19, 25, 20, 14, 10, 15, 20, 20, 20, 20, 5, 5, 15, 20, 20, 10, 20, 25, 20, 20, 25, 20, 20, 20, 14, 20, 20, 20, 25, 18, 10, 20, 25, 20, 20, 15, 20, 20, 20, 20, 20, 20, 20, 30, 20, 20, 12, 20, 20};
    private static final int[] defaultcharges = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 20, 20, -1, 20, -1, 20, 20, -1, -1, -1, 20, 20, 20, 20, 20, 20, 1, 1, 20, 20, 20, -1, 1, 20, 10, 20, 20, 20, 20, 20, 20, 20, 20, -1, 20, 10, 20, 20, -1, 20, 20};
    private Container cp;
    private JPanel equippan;
    private JPanel weaponpan;
    private JPanel armorpan;
    private JPanel miscpan;
    private JPanel picturespan;
    private JPanel picpan;
    private JPanel dpicpan;
    private JPanel epicpan;
    private JPanel upicpan;
    private JPanel throwpicpan0;
    private JPanel throwpicpan1;
    private JPanel throwpicpan2;
    private JPanel throwpicpan3;
    private JPanel cursepan;
    private JTextField name;
    private JTextField defense;
    private JTextField magicresist;
    private JTextField health;
    private JTextField stamina;
    private JTextField mana;
    private JTextField strength;
    private JTextField dexterity;
    private JTextField vitality;
    private JTextField intelligence;
    private JTextField wisdom;
    private JTextField fighter;
    private JTextField ninja;
    private JTextField wizard;
    private JTextField priest;
    private JTextField picstring;
    private JTextField dpicstring;
    private JTextField epicstring;
    private JTextField upicstring;
    private JTextField throwpicstring;
    private ImageIcon pic;
    private ImageIcon dpic;
    private ImageIcon epic;
    private ImageIcon upic;
    private ImageIcon throwpic0;
    private ImageIcon throwpic1;
    private ImageIcon throwpic2;
    private ImageIcon throwpic3;
    private JScrollPane picscrollpan;
    private JTextField weight;
    private JTextField throwpower;
    private JTextField cursed;
    private JTextField[] power;
    private JTextField[] speed;
    private JTextField[] charges;
    private JComboBox size;
    private JComboBox poison;
    private JComboBox projtype;
    private JComboBox food;
    private JComboBox foodpoison;
    private JComboBox[] functions;
    private JComboBox[] classes;
    private JComboBox[] lvlneed;
    private JToggleButton weapon;
    private JToggleButton armor;
    private JToggleButton misc;
    private JToggleButton hitsImmaterial;
    private JToggleButton[] armortype = new JToggleButton[6];
    private String oldname = null;
    private Toolkit tk;
    private DMEditor dmed;

    public ItemCreator(DMEditor dMEditor) {
        super(dMEditor, "Custom Item Creation", true);
        this.dmed = dMEditor;
        this.setDefaultCloseOperation(2);
        this.setSize(1024, 670);
        this.setLocationRelativeTo(null);
        this.cp = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.name = new JTextField("New Item", 20);
        jPanel.add(new JLabel("Name:"));
        jPanel.add(this.name);
        JPanel jPanel2 = new JPanel();
        this.weapon = new JToggleButton("Weapon");
        this.armor = new JToggleButton("Armor");
        this.misc = new JToggleButton("Misc");
        this.weapon.addActionListener(this);
        this.armor.addActionListener(this);
        this.misc.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.weapon);
        buttonGroup.add(this.armor);
        buttonGroup.add(this.misc);
        this.weapon.setSelected(true);
        jPanel2.add(this.weapon);
        jPanel2.add(this.armor);
        jPanel2.add(this.misc);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Item Name And Type"));
        this.weaponpan = new JPanel();
        this.weaponpan.setLayout(new BoxLayout(this.weaponpan, 1));
        JPanel jPanel4 = new JPanel();
        this.functions = new JComboBox[3];
        this.functions[0] = new JComboBox<String>(FUNCTIONS);
        this.functions[1] = new JComboBox<String>(FUNCTIONS);
        this.functions[2] = new JComboBox<String>(FUNCTIONS);
        this.functions[0].setEditable(true);
        this.functions[0].setSelectedIndex(0);
        this.functions[0].setActionCommand("f0");
        this.functions[0].addActionListener(this);
        this.functions[1].setEditable(true);
        this.functions[1].setSelectedIndex(0);
        this.functions[1].setActionCommand("f1");
        this.functions[1].addActionListener(this);
        this.functions[2].setEditable(true);
        this.functions[2].setSelectedIndex(0);
        this.functions[2].setActionCommand("f2");
        this.functions[2].addActionListener(this);
        this.classes = new JComboBox[3];
        this.classes[0] = new JComboBox<String>(CLASSES);
        this.classes[1] = new JComboBox<String>(CLASSES);
        this.classes[2] = new JComboBox<String>(CLASSES);
        this.classes[0].setEditable(false);
        this.classes[0].setSelectedIndex(0);
        this.classes[1].setEditable(false);
        this.classes[1].setSelectedIndex(0);
        this.classes[2].setEditable(false);
        this.classes[2].setSelectedIndex(0);
        this.lvlneed = new JComboBox[3];
        this.lvlneed[0] = new JComboBox<String>(LEVELS);
        this.lvlneed[1] = new JComboBox<String>(LEVELS);
        this.lvlneed[2] = new JComboBox<String>(LEVELS);
        this.lvlneed[0].setEditable(false);
        this.lvlneed[0].setSelectedIndex(0);
        this.lvlneed[1].setEditable(false);
        this.lvlneed[1].setSelectedIndex(0);
        this.lvlneed[2].setEditable(false);
        this.lvlneed[2].setSelectedIndex(0);
        this.power = new JTextField[3];
        this.power[0] = new JTextField("0", 4);
        this.power[1] = new JTextField("0", 4);
        this.power[2] = new JTextField("0", 4);
        this.speed = new JTextField[3];
        this.speed[0] = new JTextField("0", 4);
        this.speed[1] = new JTextField("0", 4);
        this.speed[2] = new JTextField("0", 4);
        this.charges = new JTextField[3];
        this.charges[0] = new JTextField("0", 4);
        this.charges[1] = new JTextField("0", 4);
        this.charges[2] = new JTextField("0", 4);
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        Dimension dimension = new Dimension(135, 200);
        jPanel5.setPreferredSize(dimension);
        jPanel6.setPreferredSize(dimension);
        jPanel7.setPreferredSize(dimension);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Function 1"));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Function 2"));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Function 3"));
        jPanel5.add(this.functions[0]);
        jPanel5.add(this.classes[0]);
        jPanel5.add(this.lvlneed[0]);
        JPanel jPanel8 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel = new JLabel("Power:");
        jPanel8.add(jLabel);
        jPanel8.add(this.power[0]);
        JPanel jPanel9 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel2 = new JLabel("Speed:");
        jPanel9.add(jLabel2);
        jPanel9.add(this.speed[0]);
        JPanel jPanel10 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel3 = new JLabel("Charges:");
        jPanel10.add(jLabel3);
        jPanel10.add(this.charges[0]);
        jPanel5.add(jPanel8);
        jPanel5.add(jPanel9);
        jPanel5.add(jPanel10);
        jPanel6.add(this.functions[1]);
        jPanel6.add(this.classes[1]);
        jPanel6.add(this.lvlneed[1]);
        JPanel jPanel11 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel4 = new JLabel("Power:");
        jPanel11.add(jLabel4);
        jPanel11.add(this.power[1]);
        JPanel jPanel12 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel5 = new JLabel("Speed:");
        jPanel12.add(jLabel5);
        jPanel12.add(this.speed[1]);
        JPanel jPanel13 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel6 = new JLabel("Charges:");
        jPanel13.add(jLabel6);
        jPanel13.add(this.charges[1]);
        jPanel6.add(jPanel11);
        jPanel6.add(jPanel12);
        jPanel6.add(jPanel13);
        jPanel7.add(this.functions[2]);
        jPanel7.add(this.classes[2]);
        jPanel7.add(this.lvlneed[2]);
        JPanel jPanel14 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel7 = new JLabel("Power:");
        jPanel14.add(jLabel7);
        jPanel14.add(this.power[2]);
        JPanel jPanel15 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel8 = new JLabel("Speed:");
        jPanel15.add(jLabel8);
        jPanel15.add(this.speed[2]);
        JPanel jPanel16 = new JPanel(new FlowLayout(1, 2, 0));
        JLabel jLabel9 = new JLabel("Charges:");
        jPanel16.add(jLabel9);
        jPanel16.add(this.charges[2]);
        jPanel7.add(jPanel14);
        jPanel7.add(jPanel15);
        jPanel7.add(jPanel16);
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        this.poison = new JComboBox<String>(POISONS);
        this.poison.setSelectedIndex(0);
        this.poison.setEditable(true);
        this.hitsImmaterial = new JToggleButton("Hits Non-Material");
        this.projtype = new JComboBox<String>(AMMO);
        this.projtype.setEditable(false);
        this.projtype.setSelectedIndex(0);
        JPanel jPanel17 = new JPanel();
        jPanel17.add(this.hitsImmaterial);
        JPanel jPanel18 = new JPanel();
        jPanel18.add(new JLabel("Poison Value:"));
        jPanel18.add(this.poison);
        JPanel jPanel19 = new JPanel();
        jPanel19.add(new JLabel("Ammo Type:"));
        jPanel19.add(this.projtype);
        this.weaponpan.add(jPanel4);
        this.weaponpan.add(jPanel17);
        this.weaponpan.add(jPanel18);
        this.weaponpan.add(jPanel19);
        this.armorpan = new JPanel(new GridLayout(2, 3, 5, 5));
        this.armortype[0] = new JToggleButton("Head");
        this.armortype[1] = new JToggleButton("Neck");
        this.armortype[2] = new JToggleButton("Torso");
        this.armortype[3] = new JToggleButton("Leg");
        this.armortype[4] = new JToggleButton("Foot");
        this.armortype[5] = new JToggleButton("Shield");
        this.armortype[0].addActionListener(this);
        this.armortype[1].addActionListener(this);
        this.armortype[2].addActionListener(this);
        this.armortype[3].addActionListener(this);
        this.armortype[4].addActionListener(this);
        this.armortype[5].addActionListener(this);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.armortype[0]);
        buttonGroup2.add(this.armortype[1]);
        buttonGroup2.add(this.armortype[2]);
        buttonGroup2.add(this.armortype[3]);
        buttonGroup2.add(this.armortype[4]);
        buttonGroup2.add(this.armortype[5]);
        this.armortype[0].setSelected(true);
        this.armorpan.add(this.armortype[0]);
        this.armorpan.add(this.armortype[1]);
        this.armorpan.add(this.armortype[2]);
        this.armorpan.add(this.armortype[3]);
        this.armorpan.add(this.armortype[4]);
        this.armorpan.add(this.armortype[5]);
        this.armorpan.setVisible(false);
        this.miscpan = new JPanel();
        this.miscpan.setLayout(new BoxLayout(this.miscpan, 1));
        this.food = new JComboBox<String>(FOODS);
        this.food.setSelectedIndex(0);
        this.food.setEditable(true);
        JPanel jPanel20 = new JPanel();
        jPanel20.add(new JLabel("Food Value:"));
        jPanel20.add(this.food);
        this.miscpan.add(jPanel20);
        this.foodpoison = new JComboBox<String>(POISONS);
        this.foodpoison.setSelectedIndex(0);
        this.foodpoison.setEditable(true);
        JPanel jPanel21 = new JPanel();
        jPanel21.add(new JLabel("Poison Value:"));
        jPanel21.add(this.foodpoison);
        this.miscpan.add(jPanel21);
        this.miscpan.setVisible(false);
        JPanel jPanel22 = new JPanel();
        JPanel jPanel23 = new JPanel();
        JPanel jPanel24 = new JPanel(new GridLayout(3, 1, 2, 9));
        jPanel24.add(new JLabel("Weight:"));
        jPanel24.add(new JLabel("Size:"));
        jPanel24.add(new JLabel("Throw Power:"));
        this.weight = new JTextField("0.1", 4);
        this.size = new JComboBox<String>(SIZES);
        this.size.setEditable(false);
        this.size.setSelectedIndex(0);
        this.throwpower = new JTextField("1", 4);
        JPanel jPanel25 = new JPanel(new GridLayout(3, 1, 2, 2));
        jPanel25.add(this.weight);
        jPanel25.add(this.size);
        jPanel25.add(this.throwpower);
        jPanel23.add(jPanel24);
        jPanel23.add(Box.createHorizontalStrut(5));
        jPanel23.add(jPanel25);
        jPanel22.add(this.miscpan);
        jPanel22.add(this.weaponpan);
        jPanel22.add(this.armorpan);
        jPanel22.add(jPanel23);
        this.cursepan = new JPanel();
        this.cursepan.add(new JLabel("Curse Strength:"));
        this.cursed = new JTextField("0", 3);
        this.cursepan.add(this.cursed);
        jPanel22.add(this.cursepan);
        JPanel jPanel26 = new JPanel();
        jPanel26.setLayout(new BoxLayout(jPanel26, 1));
        jPanel26.add(jPanel22);
        jPanel26.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Item Attributes"));
        this.equippan = new JPanel();
        this.defense = new JTextField("0", 4);
        this.magicresist = new JTextField("0", 4);
        this.health = new JTextField("0", 4);
        this.stamina = new JTextField("0", 4);
        this.mana = new JTextField("0", 4);
        this.strength = new JTextField("0", 4);
        this.dexterity = new JTextField("0", 4);
        this.vitality = new JTextField("0", 4);
        this.intelligence = new JTextField("0", 4);
        this.wisdom = new JTextField("0", 4);
        this.fighter = new JTextField("0", 4);
        this.ninja = new JTextField("0", 4);
        this.wizard = new JTextField("0", 4);
        this.priest = new JTextField("0", 4);
        JPanel jPanel27 = new JPanel();
        jPanel27.setLayout(new GridLayout(14, 2, 4, 2));
        jPanel27.add(new JLabel("Defense:"));
        jPanel27.add(this.defense);
        jPanel27.add(new JLabel("Magic Resist:"));
        jPanel27.add(this.magicresist);
        jPanel27.add(new JLabel("Health:"));
        jPanel27.add(this.health);
        jPanel27.add(new JLabel("Stamina:"));
        jPanel27.add(this.stamina);
        jPanel27.add(new JLabel("Mana:"));
        jPanel27.add(this.mana);
        jPanel27.add(new JLabel("Strength:"));
        jPanel27.add(this.strength);
        jPanel27.add(new JLabel("Dexterity:"));
        jPanel27.add(this.dexterity);
        jPanel27.add(new JLabel("Vitality:"));
        jPanel27.add(this.vitality);
        jPanel27.add(new JLabel("Intelligence:"));
        jPanel27.add(this.intelligence);
        jPanel27.add(new JLabel("Wisdom:"));
        jPanel27.add(this.wisdom);
        jPanel27.add(new JLabel("Fighter Level:"));
        jPanel27.add(this.fighter);
        jPanel27.add(new JLabel("Ninja Level:"));
        jPanel27.add(this.ninja);
        jPanel27.add(new JLabel("Wizard Level:"));
        jPanel27.add(this.wizard);
        jPanel27.add(new JLabel("Priest Level:"));
        jPanel27.add(this.priest);
        this.equippan.add(jPanel27);
        this.equippan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Equip Effects"));
        JPanel jPanel28 = new JPanel();
        jPanel28.add(this.equippan);
        this.picturespan = new JPanel(new GridLayout(8, 1, 5, 5));
        this.picpan = new JPanel();
        this.picpan.setLayout(new BoxLayout(this.picpan, 1));
        this.picstring = new JTextField("rock.gif", 14);
        this.picstring.setActionCommand("Refresh Pics");
        this.picstring.addActionListener(this);
        this.pic = new ImageIcon("Items" + File.separator + this.picstring.getText());
        JButton jButton = new JButton("Browse");
        jButton.setActionCommand("pic");
        jButton.addActionListener(this);
        JPanel jPanel29 = new JPanel();
        jPanel29.add(this.picstring);
        jPanel29.add(jButton);
        this.picpan.add(new JLabel(this.pic));
        this.picpan.add(jPanel29);
        this.picpan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Inventory View"));
        this.dpicpan = new JPanel();
        this.dpicpan.setLayout(new BoxLayout(this.dpicpan, 1));
        this.dpicstring = new JTextField("drock.gif", 14);
        this.dpicstring.setActionCommand("Refresh Pics");
        this.dpicstring.addActionListener(this);
        this.dpic = new ImageIcon("Items" + File.separator + this.dpicstring.getText());
        JButton jButton2 = new JButton("Browse");
        jButton2.setActionCommand("dpic");
        jButton2.addActionListener(this);
        JPanel jPanel30 = new JPanel();
        jPanel30.add(this.dpicstring);
        jPanel30.add(jButton2);
        this.dpicpan.add(new JLabel(this.dpic));
        this.dpicpan.add(jPanel30);
        this.dpicpan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Dungeon Floor View"));
        this.epicpan = new JPanel();
        this.epicpan.setLayout(new BoxLayout(this.epicpan, 1));
        this.epicstring = new JTextField(14);
        this.epicstring.setActionCommand("Refresh Pics");
        this.epicstring.addActionListener(this);
        this.epic = new ImageIcon();
        JButton jButton3 = new JButton("Browse");
        jButton3.setActionCommand("epic");
        jButton3.addActionListener(this);
        JPanel jPanel31 = new JPanel();
        jPanel31.add(this.epicstring);
        jPanel31.add(jButton3);
        JLabel jLabel10 = new JLabel(this.epic);
        jLabel10.setBackground(Color.black);
        jLabel10.setForeground(Color.black);
        jLabel10.setPreferredSize(new Dimension(32, 32));
        this.epicpan.add(jLabel10);
        this.epicpan.add(jPanel31);
        this.epicpan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Equipped Icon"));
        this.upicpan = new JPanel();
        this.upicpan.setLayout(new BoxLayout(this.upicpan, 1));
        this.upicstring = new JTextField(14);
        this.upicstring.setActionCommand("Refresh Pics");
        this.upicstring.addActionListener(this);
        this.upic = new ImageIcon();
        JButton jButton4 = new JButton("Browse");
        jButton4.setActionCommand("upic");
        jButton4.addActionListener(this);
        JPanel jPanel32 = new JPanel();
        jPanel32.add(this.upicstring);
        jPanel32.add(jButton4);
        JLabel jLabel11 = new JLabel(this.upic);
        jLabel11.setBackground(Color.black);
        jLabel11.setForeground(Color.black);
        jLabel11.setPreferredSize(new Dimension(32, 32));
        this.upicpan.add(jLabel11);
        this.upicpan.add(jPanel32);
        this.upicpan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Out-Of-Charges Icon"));
        this.throwpicpan0 = new JPanel();
        this.throwpicpan1 = new JPanel();
        this.throwpicpan2 = new JPanel();
        this.throwpicpan3 = new JPanel();
        this.throwpicpan0.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Flying Away View"));
        this.throwpicpan1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Flying Toward View"));
        this.throwpicpan2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Flying Left View"));
        this.throwpicpan3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Flying Right View"));
        this.throwpicstring = new JTextField(14);
        this.throwpicstring.setActionCommand("Refresh Pics");
        this.throwpicstring.addActionListener(this);
        this.throwpic0 = new ImageIcon("Items" + File.separator + this.dpicstring.getText());
        this.throwpic1 = new ImageIcon("Items" + File.separator + this.dpicstring.getText());
        this.throwpic2 = new ImageIcon("Items" + File.separator + this.dpicstring.getText());
        this.throwpic3 = new ImageIcon("Items" + File.separator + this.dpicstring.getText());
        JLabel jLabel12 = new JLabel(this.throwpic0);
        jLabel12.setBackground(Color.black);
        jLabel12.setForeground(Color.black);
        this.throwpicpan0.add(jLabel12);
        JLabel jLabel13 = new JLabel(this.throwpic1);
        jLabel13.setBackground(Color.black);
        jLabel13.setForeground(Color.black);
        this.throwpicpan1.add(jLabel13);
        JLabel jLabel14 = new JLabel(this.throwpic2);
        jLabel14.setBackground(Color.black);
        jLabel14.setForeground(Color.black);
        this.throwpicpan2.add(jLabel14);
        JLabel jLabel15 = new JLabel(this.throwpic3);
        jLabel15.setBackground(Color.black);
        jLabel15.setForeground(Color.black);
        this.throwpicpan3.add(jLabel15);
        this.picturespan.add(this.picpan);
        this.picturespan.add(this.dpicpan);
        this.picturespan.add(this.epicpan);
        this.picturespan.add(this.upicpan);
        this.picturespan.add(this.throwpicpan0);
        this.picturespan.add(this.throwpicpan1);
        this.picturespan.add(this.throwpicpan2);
        this.picturespan.add(this.throwpicpan3);
        this.picscrollpan = new JScrollPane(this.picturespan);
        this.picscrollpan.setPreferredSize(new Dimension(340, 400));
        JPanel jPanel33 = new JPanel();
        JButton jButton5 = new JButton("Refresh Pics");
        jButton5.addActionListener(this);
        jPanel33.add(jButton5);
        JPanel jPanel34 = new JPanel();
        jPanel34.add(new JLabel("Flying View Name:"));
        jPanel34.add(this.throwpicstring);
        this.tk = Toolkit.getDefaultToolkit();
        JPanel jPanel35 = new JPanel();
        jPanel35.setLayout(new BoxLayout(jPanel35, 1));
        jPanel35.add(jPanel33);
        jPanel35.add(this.picscrollpan);
        jPanel35.add(jPanel34);
        jPanel35.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Item Pictures"));
        JPanel jPanel36 = new JPanel();
        JButton jButton6 = new JButton("Done");
        JButton jButton7 = new JButton("Cancel");
        jButton6.addActionListener(this);
        jButton7.addActionListener(this);
        jPanel36.add(jButton7);
        jPanel36.add(jButton6);
        this.cp.add((Component)jPanel3, "North");
        this.cp.add((Component)jPanel28, "West");
        this.cp.add((Component)jPanel35, "East");
        this.cp.add((Component)jPanel26, "Center");
        this.cp.add((Component)jPanel36, "South");
    }

    public void setItem(Item item) {
        String string;
        this.name.setText(item.name);
        this.oldname = item.number < 300 ? new String(item.name) : null;
        this.weight.setText("" + item.weight);
        this.size.setSelectedIndex(item.size);
        this.throwpower.setText("" + item.throwpow);
        this.cursed.setText("" + item.cursed);
        this.picstring.setText(item.picstring);
        this.dpicstring.setText(item.dpicstring);
        this.epicstring.setText(item.equipstring);
        this.upicstring.setText(item.usedupstring);
        this.throwpicstring.setText(item.throwpicstring);
        if (item.type == 0) {
            int n;
            this.weapon.doClick();
            this.hitsImmaterial.setSelected(item.hitsImmaterial);
            if (item.poisonous > 0) {
                this.poison.setSelectedItem("" + item.poisonous);
            } else {
                this.poison.setSelectedItem("None");
            }
            this.projtype.setSelectedIndex(item.projtype);
            for (n = 0; n < item.functions; ++n) {
                this.functions[n].setSelectedItem(item.function[n][0]);
                string = item.function[n][1];
                string = string.equals("f") ? "Fighter" : (string.equals("n") ? "Ninja" : (string.equals("w") ? "Wizard" : (string.equals("p") ? "Priest" : "None")));
                this.classes[n].setSelectedItem(string);
                this.lvlneed[n].setSelectedIndex(item.level[n]);
                this.power[n].setText("" + item.power[n]);
                this.speed[n].setText("" + item.speed[n]);
                this.charges[n].setText("" + item.charges[n]);
            }
            for (n = item.functions; n < 3; ++n) {
                this.functions[n].setSelectedItem("None");
                this.classes[n].setSelectedItem("Fighter");
                this.lvlneed[n].setSelectedIndex(0);
                this.power[n].setText("0");
                this.speed[n].setText("0");
                this.charges[n].setText("0");
            }
        } else if (item.type == 7) {
            this.food.setSelectedItem("" + item.foodvalue);
            if (item.poisonous > 0) {
                this.foodpoison.setSelectedItem("" + item.poisonous);
            } else {
                this.foodpoison.setSelectedItem("None");
            }
            this.misc.doClick();
        } else if (item.type == 8) {
            this.food.setSelectedItem("None");
            this.foodpoison.setSelectedItem("None");
            this.misc.doClick();
        } else {
            if (item.type == 2) {
                this.armortype[0].doClick();
            } else if (item.type == 4) {
                this.armortype[1].doClick();
            } else if (item.type == 3) {
                this.armortype[2].doClick();
            } else if (item.type == 5) {
                this.armortype[3].doClick();
            } else if (item.type == 6) {
                this.armortype[4].doClick();
            } else if (item.type == 1) {
                this.armortype[5].doClick();
            }
            this.armor.doClick();
        }
        String string2 = "0";
        this.mana.setText(string2);
        this.health.setText(string2);
        this.stamina.setText(string2);
        this.strength.setText(string2);
        this.vitality.setText(string2);
        this.dexterity.setText(string2);
        this.intelligence.setText(string2);
        this.wisdom.setText(string2);
        this.fighter.setText(string2);
        this.ninja.setText(string2);
        this.wizard.setText(string2);
        this.priest.setText(string2);
        if (item.type != 8) {
            this.defense.setText("" + item.defense);
            this.magicresist.setText("" + item.magicresist);
            if (item.haseffect) {
                for (int i = item.effect.length; i > 0; --i) {
                    string = item.effect[i - 1].substring(0, item.effect[i - 1].indexOf(44));
                    string2 = item.effect[i - 1].substring(item.effect[i - 1].indexOf(44) + 1);
                    string.toLowerCase();
                    if (string.equals("mana")) {
                        this.mana.setText(string2);
                        continue;
                    }
                    if (string.equals("health")) {
                        this.health.setText(string2);
                        continue;
                    }
                    if (string.equals("stamina")) {
                        this.stamina.setText(string2);
                        continue;
                    }
                    if (string.equals("strength")) {
                        this.strength.setText(string2);
                        continue;
                    }
                    if (string.equals("vitality")) {
                        this.vitality.setText(string2);
                        continue;
                    }
                    if (string.equals("dexterity")) {
                        this.dexterity.setText(string2);
                        continue;
                    }
                    if (string.equals("intelligence")) {
                        this.intelligence.setText(string2);
                        continue;
                    }
                    if (string.equals("wisdom")) {
                        this.wisdom.setText(string2);
                        continue;
                    }
                    if (string.equals("flevel")) {
                        this.fighter.setText(string2);
                        continue;
                    }
                    if (string.equals("nlevel")) {
                        this.ninja.setText(string2);
                        continue;
                    }
                    if (string.equals("wlevel")) {
                        this.wizard.setText(string2);
                        continue;
                    }
                    if (!string.equals("plevel")) continue;
                    this.priest.setText(string2);
                }
            }
        }
        this.refreshPics();
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            try {
                this.item = new Item();
                this.item.name = this.name.getText();
                this.item.weight = (float)Double.parseDouble(this.weight.getText());
                this.item.size = this.size.getSelectedIndex();
                this.item.throwpow = Integer.parseInt(this.throwpower.getText());
                this.item.picstring = this.picstring.getText();
                this.item.pic = this.pic.getImage();
                this.item.dpicstring = this.dpicstring.getText();
                if (!this.throwpicstring.getText().equals("")) {
                    this.item.hasthrowpic = true;
                    this.item.throwpicstring = this.throwpicstring.getText();
                    this.item.throwpic = new Image[4];
                }
                if (this.TYPE == 0) {
                    this.item.type = 0;
                    this.item.cursed = Integer.parseInt(this.cursed.getText());
                    this.item.hitsImmaterial = this.hitsImmaterial.isSelected();
                    this.item.poisonous = this.poison.getSelectedIndex() == 0 ? 0 : Integer.parseInt((String)this.poison.getSelectedItem());
                    this.item.projtype = this.projtype.getSelectedIndex();
                    if (this.functions[0].getSelectedIndex() == 0 || this.functions[1].getSelectedIndex() == 0 && this.functions[2].getSelectedIndex() > 0) {
                        JOptionPane.showMessageDialog(this.dmed, "Weapon Functions Invalid. Must Have {1}, {1,2}, or {1,2,3}.", "Notice", 0);
                        return;
                    }
                    this.item.functions = this.functions[1].getSelectedIndex() == 0 ? 1 : (this.functions[2].getSelectedIndex() == 0 ? 2 : 3);
                    this.item.function = new String[this.item.functions][2];
                    this.item.level = new int[this.item.functions];
                    this.item.power = new int[this.item.functions];
                    this.item.speed = new int[this.item.functions];
                    for (int i = 0; i < this.item.functions; ++i) {
                        this.item.function[i][0] = (String)this.functions[i].getSelectedItem();
                        this.item.function[i][1] = this.classes[i].getSelectedIndex() != 4 ? ((String)this.classes[i].getSelectedItem()).toLowerCase().substring(0, 1) : "-";
                        this.item.level[i] = this.lvlneed[i].getSelectedIndex();
                        this.item.power[i] = Integer.parseInt(this.power[i].getText());
                        this.item.speed[i] = Integer.parseInt(this.speed[i].getText());
                        this.item.charges[i] = Integer.parseInt(this.charges[i].getText());
                    }
                    this.item.equipstring = this.epicstring.getText();
                    this.item.epic = this.epic.getImage();
                    this.item.usedupstring = this.upicstring.getText();
                } else if (this.TYPE == 1) {
                    this.item.type = this.ARMORTYPE;
                    this.item.cursed = Integer.parseInt(this.cursed.getText());
                    this.item.equipstring = this.epicstring.getText();
                    this.item.epic = this.epic.getImage();
                } else if (this.food.getSelectedIndex() != 0) {
                    this.item.foodvalue = Integer.parseInt((String)this.food.getSelectedItem());
                    this.item.type = 7;
                    this.item.poisonous = this.foodpoison.getSelectedIndex() == 0 ? 0 : Integer.parseInt((String)this.foodpoison.getSelectedItem());
                } else {
                    this.item.type = 8;
                }
                if (this.item.type != 8) {
                    this.item.defense = Integer.parseInt(this.defense.getText());
                    this.item.magicresist = Integer.parseInt(this.magicresist.getText());
                    String[] stringArray = new String[14];
                    int n = 0;
                    if (!this.health.getText().equals("0")) {
                        stringArray[n] = "health," + this.health.getText();
                        ++n;
                        Integer.parseInt(this.health.getText());
                    }
                    if (!this.stamina.getText().equals("0")) {
                        stringArray[n] = "stamina," + this.stamina.getText();
                        ++n;
                        Integer.parseInt(this.stamina.getText());
                    }
                    if (!this.mana.getText().equals("0")) {
                        stringArray[n] = "mana," + this.mana.getText();
                        ++n;
                        Integer.parseInt(this.mana.getText());
                    }
                    if (!this.strength.getText().equals("0")) {
                        stringArray[n] = "strength," + this.strength.getText();
                        ++n;
                        Integer.parseInt(this.strength.getText());
                    }
                    if (!this.dexterity.getText().equals("0")) {
                        stringArray[n] = "dexterity," + this.dexterity.getText();
                        ++n;
                        Integer.parseInt(this.dexterity.getText());
                    }
                    if (!this.vitality.getText().equals("0")) {
                        stringArray[n] = "vitality," + this.vitality.getText();
                        ++n;
                        Integer.parseInt(this.vitality.getText());
                    }
                    if (!this.intelligence.getText().equals("0")) {
                        stringArray[n] = "intelligence," + this.intelligence.getText();
                        ++n;
                        Integer.parseInt(this.intelligence.getText());
                    }
                    if (!this.wisdom.getText().equals("0")) {
                        stringArray[n] = "wisdom," + this.wisdom.getText();
                        ++n;
                        Integer.parseInt(this.wisdom.getText());
                    }
                    if (!this.fighter.getText().equals("0")) {
                        stringArray[n] = "flevel," + this.fighter.getText();
                        ++n;
                        Integer.parseInt(this.fighter.getText());
                    }
                    if (!this.ninja.getText().equals("0")) {
                        stringArray[n] = "nlevel," + this.ninja.getText();
                        ++n;
                        Integer.parseInt(this.ninja.getText());
                    }
                    if (!this.wizard.getText().equals("0")) {
                        stringArray[n] = "wlevel," + this.wizard.getText();
                        ++n;
                        Integer.parseInt(this.wizard.getText());
                    }
                    if (!this.priest.getText().equals("0")) {
                        stringArray[n] = "plevel," + this.priest.getText();
                        ++n;
                        Integer.parseInt(this.priest.getText());
                    }
                    if (n > 0) {
                        this.item.haseffect = true;
                        this.item.effect = new String[n];
                        for (int i = 0; i < n; ++i) {
                            this.item.effect[i] = stringArray[i];
                        }
                    }
                }
                if (this.oldname != null && !this.item.name.equals(this.oldname)) {
                    ItemWizard.customitems.add(this.item);
                    this.item.number = 299 + ItemWizard.customitems.size();
                }
                this.oldname = null;
                this.dispose();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.dmed, "Invalid Number: " + numberFormatException.getMessage(), "Notice", 0);
            }
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.oldname = null;
            this.item = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Weapon")) {
            this.TYPE = 0;
            this.armorpan.setVisible(false);
            this.miscpan.setVisible(false);
            this.weaponpan.setVisible(true);
            this.epicpan.setVisible(true);
            this.upicpan.setVisible(true);
            this.cursepan.setVisible(true);
            this.equippan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Equip Effects"));
        } else if (actionEvent.getActionCommand().equals("Armor")) {
            this.TYPE = 1;
            this.weaponpan.setVisible(false);
            this.miscpan.setVisible(false);
            this.armorpan.setVisible(true);
            this.upicpan.setVisible(false);
            this.epicpan.setVisible(true);
            this.cursepan.setVisible(true);
            this.equippan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Equip Effects"));
        } else if (actionEvent.getActionCommand().equals("Misc")) {
            this.TYPE = 2;
            this.weaponpan.setVisible(false);
            this.armorpan.setVisible(false);
            this.miscpan.setVisible(true);
            this.epicpan.setVisible(false);
            this.upicpan.setVisible(false);
            this.cursepan.setVisible(false);
            this.equippan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Consume Effects"));
        } else if (actionEvent.getActionCommand().equals("Head")) {
            this.ARMORTYPE = 2;
        } else if (actionEvent.getActionCommand().equals("Neck")) {
            this.ARMORTYPE = 4;
        } else if (actionEvent.getActionCommand().equals("Torso")) {
            this.ARMORTYPE = 3;
        } else if (actionEvent.getActionCommand().equals("Leg")) {
            this.ARMORTYPE = 5;
        } else if (actionEvent.getActionCommand().equals("Foot")) {
            this.ARMORTYPE = 6;
        } else if (actionEvent.getActionCommand().equals("Shield")) {
            this.ARMORTYPE = 1;
        } else if (actionEvent.getActionCommand().equals("f0")) {
            int n = this.functions[0].getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.classes[0].setSelectedIndex(defaultclass[n]);
            this.lvlneed[0].setSelectedIndex(defaultlvlneed[n]);
            this.power[0].setText("" + defaultpower[n]);
            this.speed[0].setText("" + defaultspeed[n]);
            this.charges[0].setText("" + defaultcharges[n]);
        } else if (actionEvent.getActionCommand().equals("f1")) {
            int n = this.functions[1].getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.classes[1].setSelectedIndex(defaultclass[n]);
            this.lvlneed[1].setSelectedIndex(defaultlvlneed[n]);
            this.power[1].setText("" + defaultpower[n]);
            this.speed[1].setText("" + defaultspeed[n]);
            this.charges[1].setText("" + defaultcharges[n]);
        } else if (actionEvent.getActionCommand().equals("f2")) {
            int n = this.functions[2].getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.classes[2].setSelectedIndex(defaultclass[n]);
            this.lvlneed[2].setSelectedIndex(defaultlvlneed[n]);
            this.power[2].setText("" + defaultpower[n]);
            this.speed[2].setText("" + defaultspeed[n]);
            this.charges[2].setText("" + defaultcharges[n]);
        } else if (actionEvent.getActionCommand().equals("pic")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Items"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.picstring.setText(string);
                this.refreshPics();
            }
        } else if (actionEvent.getActionCommand().equals("dpic")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Items"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.dpicstring.setText(string);
                this.refreshPics();
            }
        } else if (actionEvent.getActionCommand().equals("epic")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Items"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.epicstring.setText(string);
                this.refreshPics();
            }
        } else if (actionEvent.getActionCommand().equals("upic")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Items"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.upicstring.setText(string);
                this.refreshPics();
            }
        } else if (actionEvent.getActionCommand().equals("Refresh Pics")) {
            this.refreshPics();
        }
    }

    private void refreshPics() {
        this.pic.setImage(this.tk.getImage("Items" + File.separator + this.picstring.getText()));
        this.dpic.setImage(this.tk.getImage("Items" + File.separator + this.dpicstring.getText()));
        if (this.TYPE != 2) {
            this.epic.setImage(this.tk.getImage("Items" + File.separator + this.epicstring.getText()));
        }
        if (this.TYPE == 0) {
            this.upic.setImage(this.tk.getImage("Items" + File.separator + this.upicstring.getText()));
        }
        if (this.throwpicstring.getText().equals("")) {
            this.throwpic0.setImage(this.tk.getImage("Items" + File.separator + this.dpicstring.getText()));
            this.throwpic1.setImage(this.tk.getImage("Items" + File.separator + this.dpicstring.getText()));
            this.throwpic2.setImage(this.tk.getImage("Items" + File.separator + this.dpicstring.getText()));
            this.throwpic3.setImage(this.tk.getImage("Items" + File.separator + this.dpicstring.getText()));
        } else {
            this.throwpic0.setImage(this.tk.getImage("Items" + File.separator + this.throwpicstring.getText() + "-away.gif"));
            this.throwpic1.setImage(this.tk.getImage("Items" + File.separator + this.throwpicstring.getText() + "-toward.gif"));
            this.throwpic2.setImage(this.tk.getImage("Items" + File.separator + this.throwpicstring.getText() + "-left.gif"));
            this.throwpic3.setImage(this.tk.getImage("Items" + File.separator + this.throwpicstring.getText() + "-right.gif"));
        }
        this.picscrollpan.doLayout();
        this.picturespan.doLayout();
        this.picpan.doLayout();
        this.dpicpan.doLayout();
        this.epicpan.doLayout();
        this.upicpan.doLayout();
        this.throwpicpan0.doLayout();
        this.throwpicpan1.doLayout();
        this.throwpicpan2.doLayout();
        this.throwpicpan3.doLayout();
        this.repaint();
        this.cp.doLayout();
        this.cp.repaint();
        this.cp.validate();
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public boolean accept(File file, String string) {
        return file.getName().equals("Items") && ((string = string.toLowerCase()).endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png"));
    }
}

