/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class LauncherWizard
extends JDialog
implements ActionListener {
    private int level;
    private int x;
    private int y;
    private int side;
    private int type;
    private MapData data;
    private Item item;
    private JToggleButton spellbutton;
    private JToggleButton itembutton;
    private JPanel spellpanel;
    private JPanel itempanel;
    private JPanel cppanel;
    private JToggleButton[] sidebutton = new JToggleButton[4];
    private JComboBox spell;
    private JComboBox spellpower;
    private JComboBox style;
    private JLabel itemname;
    private JTextField shotpower;
    private JTextField ammocount;
    private JTextField ammocount2;
    private JTextField shootrate;
    private JTextField shootcount;
    private JTextField castpower;
    private JToggleButton noprojend;
    private JToggleButton isshooting;
    private JFrame frame;
    private static final String[] spells = new String[]{"Fireball", "Lightning", "Poison Bolt", "Ven Cloud", "Dispell Immaterial", "Arc Bolt", "Weakness", "Feeble Mind", "Slow", "Strip Defenses", "Silence", "Door Open"};

    public LauncherWizard(JFrame jFrame) {
        super(jFrame, "Launcher Wizard", true);
        this.frame = jFrame;
        this.setDefaultCloseOperation(2);
        this.setSize(640, 480);
        this.setLocationRelativeTo(jFrame);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup.add(this.sidebutton[0]);
        buttonGroup.add(this.sidebutton[1]);
        buttonGroup.add(this.sidebutton[2]);
        buttonGroup.add(this.sidebutton[3]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[0]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[1]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[3]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[2]);
        jPanel.add(new JLabel());
        this.sidebutton[2].setSelected(true);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Launcher faces:"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.spellbutton = new JToggleButton("Spell");
        this.itembutton = new JToggleButton("Item");
        this.spellbutton.addActionListener(this);
        this.itembutton.addActionListener(this);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.spellbutton);
        buttonGroup2.add(this.itembutton);
        jPanel2.add(Box.createHorizontalStrut(40));
        jPanel2.add(this.spellbutton);
        jPanel2.add(this.itembutton);
        this.spellbutton.setSelected(true);
        String[] stringArray = new String[]{"Both Holes", "Left Hole", "Right Hole", "Random Hole"};
        this.style = new JComboBox<String>(stringArray);
        this.style.setEditable(false);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.style);
        this.spellpanel = new JPanel();
        this.spellpanel.setPreferredSize(new Dimension(200, 30));
        this.spell = new JComboBox<String>(spells);
        this.spell.setEditable(false);
        this.spellpower = new JComboBox<String>(ItemWizard.powers);
        this.spellpower.setEditable(false);
        this.spellpower.setSelectedIndex(0);
        this.spellpanel.add(this.spell);
        this.spellpanel.add(this.spellpower);
        this.item = new Item(267);
        this.itempanel = new JPanel();
        this.itempanel.setPreferredSize(new Dimension(200, 30));
        JPanel jPanel3 = new JPanel();
        this.itemname = new JLabel("Dagger");
        this.itemname.setPreferredSize(new Dimension(100, 20));
        this.itemname.setHorizontalAlignment(0);
        JButton jButton = new JButton("Change");
        jButton.addActionListener(this);
        jPanel3.add(this.itemname);
        jPanel3.add(jButton);
        this.shotpower = new JTextField("4", 3);
        this.itempanel.add(jPanel3);
        this.itempanel.add(new JLabel("Shot Power:"));
        this.itempanel.add(this.shotpower);
        this.itempanel.setVisible(false);
        this.castpower = new JTextField("60", 4);
        this.cppanel = new JPanel();
        this.cppanel.add(new JLabel("Cast Power:"));
        this.cppanel.add(this.castpower);
        JPanel jPanel4 = new JPanel();
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Current Number Of Shots (-1 For Infinite):"));
        this.ammocount = new JTextField("-1", 4);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.ammocount);
        box.add(jPanel5);
        box.add(new JLabel("Number Of Shots To Reset To (0 For No Reset):"));
        this.ammocount2 = new JTextField("0", 4);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.ammocount2);
        box.add(jPanel6);
        box.add(new JLabel("Shot Rate (0 If Not Continuous):"));
        this.shootrate = new JTextField("0", 4);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(this.shootrate);
        box.add(jPanel7);
        box.add(new JLabel("Current Shot Counter:"));
        this.shootcount = new JTextField("0", 4);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.shootcount);
        box.add(jPanel8);
        this.noprojend = new JToggleButton("Projectiles Unending");
        JPanel jPanel9 = new JPanel();
        jPanel9.add(this.noprojend);
        box.add(jPanel9);
        this.isshooting = new JToggleButton("Is Shooting");
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.isshooting);
        box.add(jPanel10);
        jPanel4.add(box);
        Box box2 = Box.createVerticalBox();
        box2.add(this.spellpanel);
        box2.add(this.itempanel);
        box2.add(this.cppanel);
        box2.add(jPanel4);
        JPanel jPanel11 = new JPanel();
        jPanel11.add(jPanel);
        JPanel jPanel12 = new JPanel();
        JButton jButton2 = new JButton("Done");
        JButton jButton3 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel12.add(jButton3);
        jPanel12.add(jButton2);
        container.add("North", jPanel2);
        container.add("Center", box2);
        container.add("South", jPanel12);
        container.add("East", jPanel11);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 'l') {
            LauncherData launcherData = (LauncherData)mapData;
            if (launcherData.type == 1) {
                this.item = launcherData.it;
                this.itemname.setText(this.item.name);
                this.shotpower.setText("" + launcherData.power);
                this.itembutton.doClick();
                if (this.item.isbomb) {
                    this.castpower.setText("" + launcherData.castpower);
                    this.cppanel.setVisible(true);
                } else {
                    this.cppanel.setVisible(false);
                }
            } else {
                this.item = Item.createCopy(this.item);
                switch (launcherData.spnumber) {
                    case 44: {
                        this.spell.setSelectedIndex(0);
                        break;
                    }
                    case 335: {
                        this.spell.setSelectedIndex(1);
                        break;
                    }
                    case 51: {
                        this.spell.setSelectedIndex(2);
                        break;
                    }
                    case 31: {
                        this.spell.setSelectedIndex(3);
                        break;
                    }
                    case 52: {
                        this.spell.setSelectedIndex(4);
                        break;
                    }
                    case 642: {
                        this.spell.setSelectedIndex(5);
                        break;
                    }
                    case 461: {
                        this.spell.setSelectedIndex(6);
                        break;
                    }
                    case 363: {
                        this.spell.setSelectedIndex(7);
                        break;
                    }
                    case 362: {
                        this.spell.setSelectedIndex(8);
                        break;
                    }
                    case 664: {
                        this.spell.setSelectedIndex(9);
                        break;
                    }
                    case 523: {
                        this.spell.setSelectedIndex(10);
                        break;
                    }
                    case 6: {
                        this.spell.setSelectedIndex(11);
                    }
                }
                this.spellpower.setSelectedIndex(launcherData.power);
                this.castpower.setText("" + launcherData.castpower);
                this.spellbutton.doClick();
            }
            this.shootrate.setText("" + launcherData.shootrate);
            this.shootcount.setText("" + launcherData.shootcounter);
            this.ammocount.setText("" + launcherData.ammocount);
            this.ammocount2.setText("" + launcherData.ammocount2);
            this.style.setSelectedIndex(launcherData.style);
            this.isshooting.setSelected(launcherData.isShooting);
            this.noprojend.setSelected(launcherData.noprojend);
            this.sidebutton[(launcherData.side + 2) % 4].doClick();
        } else {
            this.item = Item.createCopy(this.item);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Spell")) {
            this.type = 0;
            this.itempanel.setVisible(false);
            this.spellpanel.setVisible(true);
            this.cppanel.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Item")) {
            this.type = 1;
            this.spellpanel.setVisible(false);
            this.itempanel.setVisible(true);
            if (this.item.isbomb) {
                this.cppanel.setVisible(true);
            } else {
                this.cppanel.setVisible(false);
            }
        } else if (actionEvent.getActionCommand().equals("Change")) {
            DMEditor.itemwizard.setTitle("Item Wizard - Change Launcher Item");
            DMEditor.itemwizard.setItem(this.item);
            Item item = DMEditor.itemwizard.getItem();
            if (item != null) {
                this.item = item;
                this.itemname.setText(this.item.name);
                if (this.item.isbomb) {
                    this.cppanel.setVisible(true);
                } else {
                    this.cppanel.setVisible(false);
                }
            }
        } else if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else if (actionEvent.getActionCommand().equals("Done")) {
            int n = 0;
            int n2 = 0;
            if (this.type == 0) {
                n2 = this.spellpower.getSelectedIndex();
                switch (this.spell.getSelectedIndex()) {
                    case 0: {
                        n = 44;
                        break;
                    }
                    case 1: {
                        n = 335;
                        break;
                    }
                    case 2: {
                        n = 51;
                        break;
                    }
                    case 3: {
                        n = 31;
                        break;
                    }
                    case 4: {
                        n = 52;
                        break;
                    }
                    case 5: {
                        n = 642;
                        break;
                    }
                    case 6: {
                        n = 461;
                        break;
                    }
                    case 7: {
                        n = 363;
                        break;
                    }
                    case 8: {
                        n = 362;
                        break;
                    }
                    case 9: {
                        n = 664;
                        break;
                    }
                    case 10: {
                        n = 523;
                        break;
                    }
                    case 11: {
                        n = 6;
                    }
                }
            } else {
                n2 = Integer.parseInt(this.shotpower.getText());
            }
            int n3 = 0;
            if (this.castpower.isVisible()) {
                n3 = Integer.parseInt(this.castpower.getText());
            }
            this.data = new LauncherData(this.level, this.x, this.y, this.side, this.type, n2, n3, this.style.getSelectedIndex(), this.noprojend.isSelected(), Integer.parseInt(this.shootrate.getText()), Integer.parseInt(this.ammocount.getText()), Integer.parseInt(this.ammocount2.getText()), Integer.parseInt(this.shootcount.getText()), this.isshooting.isSelected());
            if (this.type == 0) {
                ((LauncherData)this.data).spnumber = n;
            } else {
                ((LauncherData)this.data).it = this.item;
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        }
    }

    public MapData getData() {
        return this.data;
    }
}

