/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class MirrorWizard
extends HeroPanel
implements ActionListener {
    int side;
    MapData data;
    HeroData hero;
    JToggleButton[] sidebutton;
    JToggleButton allowswap;
    JToggleButton hastarget;
    JPanel targetbox2;
    JTextField targetlevel;
    JTextField targetx;
    JTextField targety;

    public MirrorWizard(JFrame jFrame) {
        DMEditor cfr_ignored_0 = (DMEditor)jFrame;
        super((DMEditor)jFrame, DMEditor.dungfont);
        this.side = 0;
        this.setTitle("Mirror Wizard");
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sidebutton = new JToggleButton[4];
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup.add(this.sidebutton[0]);
        buttonGroup.add(this.sidebutton[1]);
        buttonGroup.add(this.sidebutton[2]);
        buttonGroup.add(this.sidebutton[3]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[0]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[1]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[3]);
        jPanel.add(new JLabel());
        jPanel.add(this.sidebutton[2]);
        jPanel.add(new JLabel());
        JPanel jPanel2 = new JPanel();
        this.allowswap = new JToggleButton("Allow Swapping");
        jPanel2.add(this.allowswap);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Mirror Faces:"));
        box.add(jPanel3);
        box.add(jPanel);
        box.add(jPanel2);
        this.sidebutton[2].setSelected(true);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(box);
        this.hastarget = new JToggleButton("Activate On Use");
        this.hastarget.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.hastarget);
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createVerticalBox();
        JLabel jLabel = new JLabel(" Level ");
        JLabel jLabel2 = new JLabel("    X");
        JLabel jLabel3 = new JLabel("    Y");
        jLabel2.setHorizontalAlignment(0);
        jLabel3.setHorizontalAlignment(0);
        this.targetlevel = new JTextField("0", 3);
        this.targetx = new JTextField("0", 3);
        this.targety = new JTextField("0", 3);
        box2.add(jLabel);
        box2.add(Box.createVerticalStrut(14));
        box2.add(jLabel2);
        box2.add(Box.createVerticalStrut(15));
        box2.add(jLabel3);
        box3.add(this.targetlevel);
        box3.add(Box.createVerticalStrut(10));
        box3.add(this.targetx);
        box3.add(Box.createVerticalStrut(10));
        box3.add(this.targety);
        Box box4 = Box.createHorizontalBox();
        box4.add(box2);
        box4.add(Box.createHorizontalStrut(5));
        box4.add(box3);
        JButton jButton = new JButton("From Map...");
        jButton.addActionListener(this);
        this.targetbox2 = new JPanel();
        this.targetbox2.setLayout(new BoxLayout(this.targetbox2, 1));
        this.targetbox2.add(box4);
        this.targetbox2.add(Box.createVerticalStrut(10));
        this.targetbox2.add(jButton);
        this.targetbox2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Activation Target"));
        this.targetbox2.setVisible(false);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        jPanel6.add(this.targetbox2);
        jPanel6.add(Box.createVerticalGlue());
        JPanel jPanel7 = new JPanel();
        JButton jButton2 = new JButton("Done");
        JButton jButton3 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel7.add(jButton3);
        jPanel7.add(jButton2);
        container.add((Component)jPanel6, "East");
        container.add((Component)jPanel7, "South");
        this.setModal(true);
        this.setSize(720, 500);
        this.dispose();
    }

    public void setData(MapData mapData) {
        if (this.hero != null) {
            this.hero.removeMouseListener(this);
            this.hero = null;
            this.removeHeroes();
        }
        if (mapData.mapchar == 'm') {
            this.hero = ((MirrorData)mapData).hero != null ? new HeroData(((MirrorData)mapData).hero) : new HeroData();
            this.sidebutton[(((MirrorData)mapData).side + 2) % 4].doClick();
            this.allowswap.setSelected(((MirrorData)mapData).allowswap);
            if (((MirrorData)mapData).target != null) {
                this.targetlevel.setText("" + ((MirrorData)mapData).target.level);
                this.targetx.setText("" + ((MirrorData)mapData).target.x);
                this.targety.setText("" + ((MirrorData)mapData).target.y);
                this.hastarget.setSelected(true);
                this.targetbox2.setVisible(true);
            } else {
                this.hastarget.setSelected(false);
                this.targetbox2.setVisible(false);
            }
        } else {
            this.hero = new HeroData();
        }
        this.addHero(this.hero);
        this.setHero(this.hero);
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            MapPoint mapPoint = null;
            if (this.targetbox2.isVisible()) {
                mapPoint = new MapPoint(Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText()));
            }
            this.data = new MirrorData(this.side, this.hero, this.allowswap.isSelected(), mapPoint);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else if (actionEvent.getActionCommand().startsWith("Activate")) {
            this.targetbox2.setVisible(!this.targetbox2.isVisible());
        } else if (actionEvent.getActionCommand().equals("From Map...")) {
            DMEditor.targetframe.show();
            MapPoint mapPoint = DMEditor.targetframe.getTarget();
            if (mapPoint != null) {
                this.targetlevel.setText("" + mapPoint.level);
                this.targetx.setText("" + mapPoint.x);
                this.targety.setText("" + mapPoint.y);
            }
        }
    }

    public MapData getData() {
        return this.data;
    }
}

