/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;

class MonsterData {
    public String name;
    public String[] knownspells;
    public int number;
    public int level;
    public int x;
    public int y;
    public int subsquare;
    public int health;
    public int maxhealth;
    public int mana;
    public int maxmana;
    public int facing;
    public int defaultai;
    public int currentai;
    public int hurtitem;
    public int needitem;
    public int needhandneck;
    public int power;
    public int defense;
    public int magicresist;
    public int speed;
    public int movespeed;
    public int attackspeed;
    public int poison;
    public int fearresist;
    public int castpower;
    public int manapower;
    public int numspells;
    public int minproj;
    public int ammo;
    public int pickup;
    public int steal;
    public int timecounter;
    public int movecounter;
    public int randomcounter;
    public int runcounter;
    public int poisonpow;
    public int poisoncounter;
    public int silencecount;
    public int powerboost;
    public int defenseboost;
    public int magicresistboost;
    public int speedboost;
    public int manapowerboost;
    public int movespeedboost;
    public int attackspeedboost;
    public boolean isImmaterial;
    public boolean hasmagic = false;
    public boolean hasheal = false;
    public boolean hasdrain = false;
    public boolean wasfrightened;
    public boolean wasstuck;
    public boolean hurt;
    public boolean ispoisoned;
    public boolean silenced;
    public boolean useammo = false;
    public boolean isflying;
    public boolean canusestairs;
    public boolean ignoremons;
    public boolean canteleport;
    public boolean poisonimmune;
    public boolean HITANDRUN;
    public boolean gamewin;
    public boolean isdying = false;
    public String endanim;
    public String endsound;
    public String picstring;
    public String soundstring;
    public String footstep;
    public ArrayList carrying;
    public ArrayList equipped;
    public ImageIcon pic;
    public static boolean NOITEMS = false;
    static final ImageIcon[] MonsterIcon = new ImageIcon[]{new ImageIcon("Icons" + File.separator + "mummy.gif"), new ImageIcon("Icons" + File.separator + "screamer.gif"), new ImageIcon("Icons" + File.separator + "giggler.gif"), new ImageIcon("Icons" + File.separator + "rockpile.gif"), new ImageIcon("Icons" + File.separator + "slime.gif"), new ImageIcon("Icons" + File.separator + "wingeye.gif"), new ImageIcon("Icons" + File.separator + "ghost.gif"), new ImageIcon("Icons" + File.separator + "muncher.gif"), new ImageIcon("Icons" + File.separator + "skeleton.gif"), new ImageIcon("Icons" + File.separator + "worm.gif"), new ImageIcon("Icons" + File.separator + "fireel.gif"), new ImageIcon("Icons" + File.separator + "waterel.gif"), new ImageIcon("Icons" + File.separator + "goblin.gif"), new ImageIcon("Icons" + File.separator + "rat.gif"), new ImageIcon("Icons" + File.separator + "antman.gif"), new ImageIcon("Icons" + File.separator + "beholder.gif"), new ImageIcon("Icons" + File.separator + "couatyl.gif"), new ImageIcon("Icons" + File.separator + "fader.gif"), new ImageIcon("Icons" + File.separator + "tentacle.gif"), new ImageIcon("Icons" + File.separator + "scorpion.gif"), new ImageIcon("Icons" + File.separator + "demon.gif"), new ImageIcon("Icons" + File.separator + "knight.gif"), new ImageIcon("Icons" + File.separator + "spider.gif"), new ImageIcon("Icons" + File.separator + "golem.gif"), new ImageIcon("Icons" + File.separator + "sorcerer.gif"), new ImageIcon("Icons" + File.separator + "dragon.gif"), new ImageIcon("Icons" + File.separator + "chaos.gif"), new ImageIcon("Icons" + File.separator + "demonlord.gif"), new ImageIcon("Icons" + File.separator + "question.gif")};

    public MonsterData() {
    }

    public MonsterData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.number = objectInputStream.readInt();
        this.x = objectInputStream.readInt();
        this.y = objectInputStream.readInt();
        this.level = objectInputStream.readInt();
        if (this.number > 27) {
            this.name = objectInputStream.readUTF();
            this.picstring = objectInputStream.readUTF();
            this.soundstring = objectInputStream.readUTF();
            this.footstep = objectInputStream.readUTF();
            this.canusestairs = objectInputStream.readBoolean();
            this.isflying = objectInputStream.readBoolean();
            this.ignoremons = objectInputStream.readBoolean();
            this.canteleport = objectInputStream.readBoolean();
            File file = new File("Icons" + File.separator + this.picstring + ".gif");
            this.pic = file.exists() ? new ImageIcon(file.getPath()) : MonsterIcon[28];
        } else {
            this.pic = MonsterIcon[this.number];
            this.name = MonsterWizard.monsternames[this.number];
        }
        this.subsquare = objectInputStream.readInt();
        this.health = objectInputStream.readInt();
        this.maxhealth = objectInputStream.readInt();
        this.mana = objectInputStream.readInt();
        this.maxmana = objectInputStream.readInt();
        this.facing = objectInputStream.readInt();
        this.currentai = objectInputStream.readInt();
        this.defaultai = objectInputStream.readInt();
        this.HITANDRUN = objectInputStream.readBoolean();
        this.isImmaterial = objectInputStream.readBoolean();
        this.wasfrightened = objectInputStream.readBoolean();
        this.hurt = objectInputStream.readBoolean();
        this.wasstuck = objectInputStream.readBoolean();
        this.ispoisoned = objectInputStream.readBoolean();
        if (this.ispoisoned) {
            this.poisonpow = objectInputStream.readInt();
            this.poisoncounter = objectInputStream.readInt();
        }
        this.timecounter = objectInputStream.readInt();
        this.movecounter = objectInputStream.readInt();
        this.randomcounter = objectInputStream.readInt();
        this.runcounter = objectInputStream.readInt();
        this.carrying = (ArrayList)objectInputStream.readObject();
        if (objectInputStream.readBoolean()) {
            this.equipped = (ArrayList)objectInputStream.readObject();
        }
        this.gamewin = objectInputStream.readBoolean();
        if (this.gamewin) {
            this.endanim = objectInputStream.readUTF();
            this.endsound = objectInputStream.readUTF();
        }
        this.hurtitem = objectInputStream.readInt();
        this.needitem = objectInputStream.readInt();
        this.needhandneck = objectInputStream.readInt();
        this.power = objectInputStream.readInt();
        this.defense = objectInputStream.readInt();
        this.magicresist = objectInputStream.readInt();
        this.speed = objectInputStream.readInt();
        this.movespeed = objectInputStream.readInt();
        this.attackspeed = objectInputStream.readInt();
        this.poison = objectInputStream.readInt();
        this.fearresist = objectInputStream.readInt();
        this.hasmagic = objectInputStream.readBoolean();
        if (this.hasmagic) {
            this.castpower = objectInputStream.readInt();
            this.manapower = objectInputStream.readInt();
            this.numspells = objectInputStream.readInt();
            if (this.numspells > 0) {
                this.knownspells = (String[])objectInputStream.readObject();
            }
            this.minproj = objectInputStream.readInt();
            this.hasheal = objectInputStream.readBoolean();
            this.hasdrain = objectInputStream.readBoolean();
        }
        this.useammo = objectInputStream.readBoolean();
        if (this.useammo) {
            this.ammo = objectInputStream.readInt();
        }
        this.pickup = objectInputStream.readInt();
        this.steal = objectInputStream.readInt();
        this.poisonimmune = objectInputStream.readBoolean();
        this.powerboost = objectInputStream.readInt();
        this.defenseboost = objectInputStream.readInt();
        this.magicresistboost = objectInputStream.readInt();
        this.speedboost = objectInputStream.readInt();
        this.manapowerboost = objectInputStream.readInt();
        this.movespeedboost = objectInputStream.readInt();
        this.attackspeedboost = objectInputStream.readInt();
        this.silenced = objectInputStream.readBoolean();
        if (this.silenced) {
            this.silencecount = objectInputStream.readInt();
        }
    }

    public MonsterData(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, int n9, int n10, int n11, int n12, int n13, int n14, ArrayList arrayList, ArrayList arrayList2, boolean bl3, String string, String string2, int n15, int n16, int n17, boolean bl4, int n18, int n19, boolean bl5) {
        this(n, n2, n3, n4, n5, n6, n7, n8, bl, bl2, n9, n10, n11, n12, n13, n14, arrayList, arrayList2, bl3, string, string2, n15, n16, n17, bl4, n18, n19, MonsterWizard.monsternames[n], "", null, null, false, false, false, false, bl5);
    }

    public MonsterData(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, int n9, int n10, int n11, int n12, int n13, int n14, ArrayList arrayList, ArrayList arrayList2, boolean bl3, String string, String string2, int n15, int n16, int n17, boolean bl4, int n18, int n19, String string3, String string4, String string5, String string6, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.number = n;
        this.level = n2;
        this.x = n3;
        this.y = n4;
        this.health = n5;
        this.mana = n6;
        this.facing = n7;
        this.defaultai = n8;
        this.HITANDRUN = bl;
        this.isImmaterial = bl2;
        this.power = n9;
        this.defense = n10;
        this.magicresist = n11;
        this.speed = n12;
        this.poison = n13;
        this.fearresist = n14;
        this.carrying = arrayList;
        if (arrayList2 != null && arrayList2.size() != 0) {
            this.equipped = arrayList2;
        }
        this.gamewin = bl3;
        this.endanim = string;
        this.endsound = string2;
        this.hurtitem = n15;
        this.needitem = n16;
        this.needhandneck = n17;
        this.name = string3;
        if (n > 27) {
            this.picstring = string4;
            this.soundstring = string5;
            this.footstep = string6;
            this.canusestairs = bl5;
            this.isflying = bl6;
            this.ignoremons = bl7;
            this.canteleport = bl8;
            File file = new File("Icons" + File.separator + string4 + ".gif");
            this.pic = file.exists() ? new ImageIcon(file.getPath()) : MonsterIcon[28];
        } else {
            this.pic = MonsterIcon[n];
        }
        this.maxhealth = n5;
        this.maxmana = n6;
        this.currentai = n8 >= 4 ? n8 : 0;
        if (bl4) {
            this.subsquare = 5;
        }
        this.pickup = n18;
        this.steal = n19;
        this.poisonimmune = bl9;
    }

    public MonsterData(MonsterData monsterData) {
        int n;
        this.number = monsterData.number;
        this.level = monsterData.level;
        this.x = monsterData.x;
        this.y = monsterData.y;
        this.health = monsterData.health;
        this.mana = monsterData.mana;
        this.facing = monsterData.facing;
        this.defaultai = monsterData.defaultai;
        this.currentai = monsterData.currentai;
        this.HITANDRUN = monsterData.HITANDRUN;
        this.isImmaterial = monsterData.isImmaterial;
        this.power = monsterData.power;
        this.defense = monsterData.defense;
        this.magicresist = monsterData.magicresist;
        this.speed = monsterData.speed;
        this.poison = monsterData.poison;
        this.fearresist = monsterData.fearresist;
        this.gamewin = monsterData.gamewin;
        if (this.gamewin) {
            this.endanim = new String(monsterData.endanim);
            this.endsound = new String(monsterData.endsound);
        }
        this.hurtitem = monsterData.hurtitem;
        this.needitem = monsterData.needitem;
        this.needhandneck = monsterData.needhandneck;
        this.name = new String(monsterData.name);
        if (this.number > 27) {
            this.picstring = new String(monsterData.picstring);
            this.soundstring = new String(monsterData.soundstring);
            this.footstep = new String(monsterData.footstep);
            this.canusestairs = monsterData.canusestairs;
            this.isflying = monsterData.isflying;
            this.ignoremons = monsterData.ignoremons;
            this.canteleport = monsterData.canteleport;
        }
        this.pic = monsterData.pic;
        this.maxhealth = monsterData.maxhealth;
        this.maxmana = monsterData.maxmana;
        this.subsquare = monsterData.subsquare;
        this.pickup = monsterData.pickup;
        this.wasfrightened = monsterData.wasfrightened;
        this.hurt = monsterData.hurt;
        this.wasstuck = monsterData.wasstuck;
        this.ispoisoned = monsterData.ispoisoned;
        this.poisonpow = monsterData.poisonpow;
        this.poisoncounter = monsterData.poisoncounter;
        this.timecounter = monsterData.timecounter;
        this.movecounter = monsterData.movecounter;
        this.randomcounter = monsterData.randomcounter;
        this.runcounter = monsterData.runcounter;
        this.movespeed = monsterData.movespeed;
        this.attackspeed = monsterData.attackspeed;
        this.carrying = new ArrayList();
        if (monsterData.carrying != null && monsterData.carrying.size() > 0) {
            for (n = 0; n < monsterData.carrying.size(); ++n) {
                this.carrying.add(Item.createCopy((Item)monsterData.carrying.get(n)));
            }
        }
        if (monsterData.equipped != null && monsterData.equipped.size() > 0) {
            this.equipped = new ArrayList();
            for (n = 0; n < monsterData.equipped.size(); ++n) {
                this.equipped.add(Item.createCopy((Item)monsterData.equipped.get(n)));
            }
        }
        this.hasmagic = monsterData.hasmagic;
        if (this.hasmagic) {
            this.castpower = monsterData.castpower;
            this.manapower = monsterData.manapower;
            this.numspells = monsterData.numspells;
            if (this.numspells > 0) {
                this.knownspells = new String[monsterData.knownspells.length];
                for (n = 0; n < this.knownspells.length; ++n) {
                    this.knownspells[n] = new String(monsterData.knownspells[n]);
                }
            }
            this.minproj = monsterData.minproj;
            this.hasheal = monsterData.hasheal;
            this.hasdrain = monsterData.hasdrain;
        }
        this.useammo = monsterData.useammo;
        this.ammo = monsterData.ammo;
        this.steal = monsterData.steal;
        this.poisonimmune = monsterData.poisonimmune;
        this.powerboost = monsterData.powerboost;
        this.defenseboost = monsterData.defenseboost;
        this.magicresistboost = monsterData.magicresistboost;
        this.speedboost = monsterData.speedboost;
        this.manapowerboost = monsterData.manapowerboost;
        this.movespeedboost = monsterData.movespeedboost;
        this.attackspeedboost = monsterData.attackspeedboost;
        this.silenced = monsterData.silenced;
        this.silencecount = monsterData.silencecount;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object instanceof MonsterData && this.name.equals(((MonsterData)object).name);
    }

    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.number);
        objectOutputStream.writeInt(this.x);
        objectOutputStream.writeInt(this.y);
        objectOutputStream.writeInt(this.level);
        if (this.number > 27) {
            objectOutputStream.writeUTF(this.name);
            objectOutputStream.writeUTF(this.picstring);
            objectOutputStream.writeUTF(this.soundstring);
            objectOutputStream.writeUTF(this.footstep);
            objectOutputStream.writeBoolean(this.canusestairs);
            objectOutputStream.writeBoolean(this.isflying);
            objectOutputStream.writeBoolean(this.ignoremons);
            objectOutputStream.writeBoolean(this.canteleport);
        }
        objectOutputStream.writeInt(this.subsquare);
        objectOutputStream.writeInt(this.health);
        objectOutputStream.writeInt(this.maxhealth);
        objectOutputStream.writeInt(this.mana);
        objectOutputStream.writeInt(this.maxmana);
        objectOutputStream.writeInt(this.facing);
        objectOutputStream.writeInt(this.currentai);
        objectOutputStream.writeInt(this.defaultai);
        objectOutputStream.writeBoolean(this.HITANDRUN);
        objectOutputStream.writeBoolean(this.isImmaterial);
        objectOutputStream.writeBoolean(this.wasfrightened);
        objectOutputStream.writeBoolean(this.hurt);
        objectOutputStream.writeBoolean(this.wasstuck);
        objectOutputStream.writeBoolean(this.ispoisoned);
        if (this.ispoisoned) {
            objectOutputStream.writeInt(this.poisonpow);
            objectOutputStream.writeInt(this.poisoncounter);
        }
        objectOutputStream.writeInt(this.timecounter);
        objectOutputStream.writeInt(this.movecounter);
        objectOutputStream.writeInt(this.randomcounter);
        objectOutputStream.writeInt(this.runcounter);
        if (!NOITEMS) {
            objectOutputStream.writeObject(this.carrying);
        } else {
            objectOutputStream.writeObject(new ArrayList());
        }
        if (this.equipped != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.equipped);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        objectOutputStream.writeBoolean(this.gamewin);
        if (this.gamewin) {
            objectOutputStream.writeUTF(this.endanim);
            objectOutputStream.writeUTF(this.endsound);
        }
        objectOutputStream.writeInt(this.hurtitem);
        objectOutputStream.writeInt(this.needitem);
        objectOutputStream.writeInt(this.needhandneck);
        objectOutputStream.writeInt(this.power);
        objectOutputStream.writeInt(this.defense);
        objectOutputStream.writeInt(this.magicresist);
        objectOutputStream.writeInt(this.speed);
        objectOutputStream.writeInt(this.movespeed);
        objectOutputStream.writeInt(this.attackspeed);
        objectOutputStream.writeInt(this.poison);
        objectOutputStream.writeInt(this.fearresist);
        objectOutputStream.writeBoolean(this.hasmagic);
        if (this.hasmagic) {
            objectOutputStream.writeInt(this.castpower);
            objectOutputStream.writeInt(this.manapower);
            objectOutputStream.writeInt(this.numspells);
            if (this.numspells > 0) {
                objectOutputStream.writeObject(this.knownspells);
            }
            objectOutputStream.writeInt(this.minproj);
            objectOutputStream.writeBoolean(this.hasheal);
            objectOutputStream.writeBoolean(this.hasdrain);
        }
        objectOutputStream.writeBoolean(this.useammo);
        if (this.useammo) {
            objectOutputStream.writeInt(this.ammo);
        }
        objectOutputStream.writeInt(this.pickup);
        objectOutputStream.writeInt(this.steal);
        objectOutputStream.writeBoolean(this.poisonimmune);
        objectOutputStream.writeInt(this.powerboost);
        objectOutputStream.writeInt(this.defenseboost);
        objectOutputStream.writeInt(this.magicresistboost);
        objectOutputStream.writeInt(this.speedboost);
        objectOutputStream.writeInt(this.manapowerboost);
        objectOutputStream.writeInt(this.movespeedboost);
        objectOutputStream.writeInt(this.attackspeedboost);
        objectOutputStream.writeBoolean(this.silenced);
        if (this.silenced) {
            objectOutputStream.writeInt(this.silencecount);
        }
    }
}

