/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

class MultFloorSwitchData
extends FloorData {
    public MapPoint xy;
    public boolean haspic = true;
    public ArrayList switchlist;
    public boolean[] changing;

    public MultFloorSwitchData(MapPoint mapPoint, boolean bl, ArrayList arrayList) {
        this.xy = mapPoint;
        this.haspic = bl;
        this.switchlist = arrayList;
        this.changing = new boolean[this.switchlist.size()];
        for (int i = 0; i < this.switchlist.size(); ++i) {
            this.changing[i] = false;
        }
        this.mapchar = (char)83;
    }

    public MultFloorSwitchData() {
        this.mapchar = (char)83;
    }

    @Override
    public void changeLevel(int n, int n2) {
        this.xy = new MapPoint(this.xy.level + n, this.xy.x, this.xy.y);
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((FloorSwitchData)iterator.next()).changeLevel(n, n2);
        }
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        this.xy = new MapPoint(n, n2, n3);
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((FloorSwitchData)iterator.next()).setMapCoord(n, n2, n3);
        }
    }

    @Override
    public String toString() {
        return "Multiple Floor Switches";
    }

    public int[] getTarget(int n) {
        if (n > this.switchlist.size()) {
            return null;
        }
        FloorSwitchData floorSwitchData = (FloorSwitchData)this.switchlist.get(n);
        int[] nArray = new int[]{floorSwitchData.targetlevel, floorSwitchData.targetx, floorSwitchData.targety};
        return nArray;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeBoolean(this.haspic);
        objectOutputStream.writeObject(this.changing);
        objectOutputStream.writeInt(this.switchlist.size());
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((FloorSwitchData)iterator.next()).save(objectOutputStream);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.xy = (MapPoint)objectInputStream.readObject();
        this.haspic = objectInputStream.readBoolean();
        this.changing = (boolean[])objectInputStream.readObject();
        int n = objectInputStream.readInt();
        this.switchlist = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.switchlist.add(DMEditor.loadMapData(objectInputStream, -1, 0, 0));
        }
    }
}

