/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

class MultWallSwitchData
extends SidedWallData {
    public MapPoint xy;
    public int picnumber;
    public int pictype;
    public ArrayList switchlist;
    public boolean[] changing;
    public boolean switchstate;

    public MultWallSwitchData(MapPoint mapPoint, int n, int n2, int n3, ArrayList arrayList) {
        super(n);
        this.xy = mapPoint;
        this.pictype = n2;
        this.picnumber = n3;
        this.switchlist = arrayList;
        this.changing = new boolean[this.switchlist.size()];
        for (int i = 0; i < this.switchlist.size(); ++i) {
            this.changing[i] = false;
        }
        this.mapchar = (char)92;
    }

    public MultWallSwitchData(int n) {
        super(n);
        this.mapchar = (char)92;
    }

    @Override
    public void changeLevel(int n, int n2) {
        this.xy = new MapPoint(this.xy.level + n, this.xy.x, this.xy.y);
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((WallSwitchData)iterator.next()).changeLevel(n, n2);
        }
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        this.xy = new MapPoint(n, n2, n3);
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((WallSwitchData)iterator.next()).setMapCoord(n, n2, n3);
        }
    }

    public void setFacing(int n) {
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((WallSwitchData)iterator.next()).side = n;
        }
    }

    @Override
    public String toString() {
        String string = "Multiple WallSwitch";
        boolean bl = false;
        int n = 0;
        if (this.pictype > 0) {
            n = ((WallSwitchData)this.switchlist.get((int)0)).keynumber;
            int n2 = 1;
            while (!bl && n2 < this.switchlist.size()) {
                if (((WallSwitchData)this.switchlist.get((int)n2)).keynumber != n) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            if (!bl) {
                Item item = null;
                String string2 = null;
                if (n > 9 && n < 31) {
                    item = new Item(n, 1, 1);
                    string2 = item.name;
                } else if (n == 5) {
                    string2 = "Chest";
                } else if (n == 4) {
                    string2 = "Scroll";
                } else if (n == 9) {
                    string2 = "Torch";
                } else if (n == 73) {
                    string2 = "Waterskin";
                } else if (n == 8) {
                    string2 = "Compass";
                } else if (n < 300) {
                    item = new Item(n);
                    string2 = item.name;
                }
                string = string2 != null ? (this.pictype == 1 ? string + " (Key - " + string2 + ")" : string + " (Coin - " + string2 + ")") : (this.pictype == 1 ? string + " (Key - Custom Item #" + (n - 299) + ")" : string + " (Coin - Custom Item #" + (n - 299) + ")");
            } else {
                string = this.pictype == 1 ? string + " (Key)" : string + " (Coin)";
            }
        } else {
            string = string + " (Button)";
        }
        string = this.side == 0 ? string + " Facing South" : (this.side == 1 ? string + " Facing East" : (this.side == 2 ? string + " Facing North" : string + " Facing West"));
        return string;
    }

    public int[] getTarget(int n) {
        if (n > this.switchlist.size()) {
            return null;
        }
        WallSwitchData wallSwitchData = (WallSwitchData)this.switchlist.get(n);
        int[] nArray = new int[]{wallSwitchData.targetlevel, wallSwitchData.targetx, wallSwitchData.targety};
        return nArray;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeInt(this.pictype);
        objectOutputStream.writeInt(this.picnumber);
        objectOutputStream.writeObject(this.changing);
        objectOutputStream.writeBoolean(this.switchstate);
        objectOutputStream.writeInt(this.switchlist.size());
        Iterator iterator = this.switchlist.iterator();
        while (iterator.hasNext()) {
            ((WallSwitchData)iterator.next()).save(objectOutputStream);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.xy = (MapPoint)objectInputStream.readObject();
        this.pictype = objectInputStream.readInt();
        this.picnumber = objectInputStream.readInt();
        this.changing = (boolean[])objectInputStream.readObject();
        this.switchstate = objectInputStream.readBoolean();
        int n = objectInputStream.readInt();
        this.switchlist = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.switchlist.add(DMEditor.loadMapData(objectInputStream, -1, 0, 0));
        }
    }
}

