/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;

class Pit
extends Floor {
    public static boolean ADDEDPICS;
    public static boolean ADDEDCONCEALED;
    public static Image[][] cpic;
    private int level;
    private int xcoord;
    private int ycoord;
    public boolean isConcealed = false;
    public boolean isIllusionary = false;
    private boolean isSupplies = false;
    private int delay;
    private int reset;
    public int delaycounter = 0;
    public int resetcounter = 0;
    public boolean delaying;
    public boolean resetting;
    private boolean monswork;
    private int count;
    private int maxcount;
    private boolean resetcount;
    public boolean isOpen = true;
    public boolean isContinuous = false;
    public boolean isActive = true;
    public int blinkrateo;
    public int blinkratec;
    public int blinkcounter = 0;
    public boolean screamed = false;

    public Pit(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n4, int n5, int n6, int n7, boolean bl7, int n8, int n9, boolean bl8) {
        this.mapchar = (char)112;
        this.level = n;
        this.xcoord = n2;
        this.ycoord = n3;
        this.isOpen = bl;
        this.isConcealed = bl2;
        this.isIllusionary = bl3;
        this.isSupplies = bl4;
        this.isContinuous = bl5;
        this.isActive = bl6;
        this.blinkrateo = n4;
        this.blinkratec = n5;
        this.delay = n6;
        this.reset = n7;
        this.monswork = bl7;
        this.maxcount = n8;
        this.count = n9;
        this.resetcount = bl8;
        this.setPics();
    }

    @Override
    public void tryTeleport() {
        if (this.isOpen) {
            this.dropall(this.level + 1);
        } else if (this.isSupplies) {
            this.activate();
        }
    }

    @Override
    public void tryTeleport(dmnew.Monster monster) {
        if (monster.isflying) {
            return;
        }
        if (this.isOpen) {
            this.dropall(this.level + 1);
        } else if (this.isSupplies && this.monswork) {
            this.activate();
        }
    }

    @Override
    public boolean tryTeleport(Item item) {
        if (!this.isOpen) {
            return false;
        }
        this.addItem(item);
        this.dropall(this.level + 1);
        return true;
    }

    @Override
    public boolean changeState() {
        if (this.isSupplies) {
            if (this.delaying) {
                ++this.delaycounter;
                if (this.delaycounter >= this.delay) {
                    this.delaying = false;
                    this.delaycounter = 0;
                    this.openOrClose();
                    if (this.reset > 0) {
                        this.resetting = true;
                        return true;
                    }
                    return false;
                }
            } else if (this.resetting) {
                ++this.resetcounter;
                if (this.resetcounter >= this.reset) {
                    this.resetting = false;
                    this.resetcounter = 0;
                    this.openOrClose();
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        if (!this.isActive) {
            return true;
        }
        ++this.blinkcounter;
        if (this.isOpen) {
            if (this.blinkcounter > this.blinkrateo) {
                this.openOrClose();
                this.blinkcounter = 0;
            }
        } else if (this.blinkcounter > this.blinkratec) {
            this.openOrClose();
            this.blinkcounter = 0;
        }
        return true;
    }

    @Override
    public void toggle() {
        if (this.isContinuous) {
            this.isActive = !this.isActive;
        } else if (this.isSupplies && (this.delay > 0 || this.reset > 0)) {
            if (this.delaying || this.resetting) {
                return;
            }
            if (this.level == dmnew.level) {
                dmnew.playSound("switch.wav", this.xcoord, this.ycoord);
            }
            if (this.delay > 0) {
                this.delaying = true;
            } else {
                this.openOrClose();
                this.resetting = true;
            }
            MapPoint mapPoint = new MapPoint(this.level, this.xcoord, this.ycoord);
            if (!dmnew.mapstochange.contains(mapPoint)) {
                dmnew.mapstochange.add(mapPoint);
            }
            dmnew.mapchanging = true;
        } else {
            this.openOrClose();
        }
    }

    @Override
    public void activate() {
        if (!this.isOpen && !this.isContinuous || this.isContinuous && !this.isActive) {
            if (this.count > 0) {
                if (this.isSupplies && this.level == dmnew.level) {
                    dmnew.playSound("switch.wav", this.xcoord, this.ycoord);
                }
                --this.count;
                return;
            }
            if (this.resetcount) {
                this.count = this.maxcount;
            }
            this.toggle();
        }
    }

    @Override
    public void deactivate() {
        if (this.isOpen && !this.isContinuous) {
            this.toggle();
        } else if (this.isContinuous && this.isActive) {
            this.toggle();
            if (!this.isActive && this.isOpen) {
                this.openOrClose();
            }
        } else if (this.count < this.maxcount) {
            if (this.isSupplies && this.level == dmnew.level) {
                dmnew.playSound("switch.wav", this.xcoord, this.ycoord);
            }
            ++this.count;
        }
    }

    private void openOrClose() {
        boolean bl = this.isOpen = !this.isOpen;
        if (this.isOpen) {
            this.dropall(this.level + 1);
        } else if (this.level == dmnew.level || this.level == dmnew.level - 1) {
            int n;
            int n2 = this.xcoord - dmnew.partyx;
            if (n2 < 0) {
                n2 *= -1;
            }
            if ((n = this.ycoord - dmnew.partyy) < 0) {
                n *= -1;
            }
            if (n2 < 5 && n < 5) {
                dmnew.needredraw = true;
            }
        }
    }

    @Override
    public void doAction() {
        if (this.isOpen && (this.hasParty || this.hasMons || this.hasItems)) {
            this.dropall(this.level + 1);
        }
    }

    private boolean checkForPit(int n) {
        if (dmnew.DungeonMap[n][this.xcoord][this.ycoord] instanceof Pit && ((Pit)dmnew.DungeonMap[n][this.xcoord][this.ycoord]).isOpen) {
            if (this.hasParty) {
                dmnew.needdrawdungeon = true;
                dmnew.dview.repaint();
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                dmnew.level = n;
                dmnew.mirrorback = !dmnew.mirrorback;
                dmnew.updateDark();
            }
            this.dropall(n + 1);
            return true;
        }
        return false;
    }

    public void dropall(int n) {
        int n2;
        if (this.hasParty && !this.screamed && !dmnew.climbing) {
            dmnew.playSound("scream.wav", -1, -1);
            this.screamed = true;
        }
        if (this.checkForPit(n)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        dmnew.Monster monster = null;
        Object var5_5 = null;
        if (this.hasItems) {
            while (this.mapItems.size() > 0) {
                Item item = (Item)this.mapItems.remove(0);
                if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons) {
                    monster = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + item.subsquare);
                    if (monster == null) {
                        monster = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + 5);
                    }
                    if (monster != null && !monster.isImmaterial) {
                        monster.damage((n - this.level) * dmnew.randGen.nextInt(10), 0);
                    }
                }
                if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty) {
                    for (int i = 0; i < dmnew.numheroes; ++i) {
                        dmnew.hero[i].damage((n - this.level) * dmnew.randGen.nextInt(10), 3);
                    }
                }
                if (!dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryTeleport(item)) {
                    dmnew.DungeonMap[n][this.xcoord][this.ycoord].addItem(item);
                    dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryFloorSwitch(2);
                }
                if (!this.checkForPit(n)) continue;
                return;
            }
            this.hasItems = false;
        }
        if (this.hasMons) {
            boolean bl3 = false;
            for (int i = 0; i < 6; ++i) {
                monster = (dmnew.Monster)dmnew.dmmons.get(this.level + "," + this.xcoord + "," + this.ycoord + "," + i);
                if (monster != null) {
                    if (monster.isflying) {
                        bl3 = true;
                    } else if (monster.number != 24 || !monster.teleport()) {
                        int n3;
                        dmnew.dmmons.remove(this.level + "," + this.xcoord + "," + this.ycoord + "," + i);
                        monster.level = n;
                        if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons) {
                            if (monster.subsquare == 5) {
                                for (n3 = 0; n3 < 6; ++n3) {
                                    dmnew.Monster monster2 = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + n3);
                                    if (monster2 != null && (monster2.number != 24 && monster2.number != 26 || !monster2.teleport())) {
                                        monster2.pitDeath();
                                    }
                                    if (i != 3) continue;
                                    ++i;
                                }
                            } else {
                                dmnew.Monster monster3 = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + monster.subsquare);
                                if (monster3 != null && (monster3.number != 24 && monster3.number != 26 || !monster3.teleport())) {
                                    monster3.pitDeath();
                                }
                            }
                        } else if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty && !monster.isImmaterial) {
                            for (n3 = 0; n3 < dmnew.numheroes; ++n3) {
                                if (monster.subsquare != 5 && monster.subsquare != dmnew.hero[n3].subsquare) continue;
                                n2 = (n - this.level) * (dmnew.randGen.nextInt(16) + 20);
                                dmnew.hero[n3].damage(n2 += (n - this.level) * 15 + (n - this.level - 2) * 15, 0);
                            }
                        }
                        if (!dmnew.gameover) {
                            dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons = true;
                            dmnew.dmmons.put(n + "," + this.xcoord + "," + this.ycoord + "," + monster.subsquare, monster);
                            dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryTeleport(monster);
                            if (!dmnew.gameover && monster.level == n && monster.x == this.xcoord && monster.y == this.ycoord) {
                                dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryFloorSwitch(4);
                                if (!(monster.isdying || monster.isImmaterial || dmnew.gameover)) {
                                    n2 = (n - this.level) * (dmnew.randGen.nextInt(16) + 20);
                                    monster.damage(n2 += (n - this.level) * 15 + (n - this.level - 2) * 15, 0);
                                }
                            }
                        }
                        if (this.checkForPit(n)) {
                            return;
                        }
                    }
                }
                if (i != 3) continue;
                ++i;
            }
            if (!bl3) {
                this.hasMons = false;
            }
        }
        if (this.hasParty) {
            this.screamed = false;
            dmnew.needredraw = true;
            dmnew.needdrawdungeon = true;
            dmnew.dview.repaint();
            this.hasParty = false;
            dmnew.walkqueue.clear();
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            dmnew.level = n;
            dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty = true;
            dmnew.mirrorback = !dmnew.mirrorback;
            dmnew.nomirroradjust = true;
            dmnew.updateDark();
            if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons) {
                for (int i = 0; i < 6; ++i) {
                    if (!(i != 5 && dmnew.heroatsub[i] == -1 || (monster = (dmnew.Monster)dmnew.dmmons.get(this.level + "," + this.xcoord + "," + this.ycoord + "," + i)) == null || monster.isdying || (monster.number == 24 || monster.number == 26) && monster.teleport() || monster.isImmaterial)) {
                        n2 = (n - this.level) * (dmnew.randGen.nextInt(16) + 20);
                        monster.damage(n2 += (n - this.level) * 15 + (n - this.level - 2) * 15, 0);
                    }
                    if (i != 3) continue;
                    i = 5;
                }
            }
            if (!dmnew.gameover && dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty) {
                if (this.checkForPit(n)) {
                    return;
                }
                dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryTeleport();
                if (!dmnew.climbing && dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty) {
                    for (int i = 0; i < dmnew.numheroes; ++i) {
                        n2 = (n - this.level) * (dmnew.randGen.nextInt(16) + 20);
                        dmnew.hero[i].damage(n2 += (n - this.level) * 15 + (n - this.level - 2) * 15, 0);
                    }
                } else if (dmnew.floatcounter == 0) {
                    dmnew.climbing = false;
                }
                if (!dmnew.gameover && dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasParty) {
                    dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryFloorSwitch(0);
                }
            }
        }
        if (this.level == dmnew.level || this.level == dmnew.level - 1) {
            int n4;
            int n5 = this.xcoord - dmnew.partyx;
            if (n5 < 0) {
                n5 *= -1;
            }
            if ((n4 = this.ycoord - dmnew.partyy) < 0) {
                n4 *= -1;
            }
            if (n5 < 5 && n4 < 5) {
                dmnew.needredraw = true;
            }
        }
    }

    @Override
    public void setPics() {
        this.pic = new Image[4][5];
        if (!ADDEDPICS && !ADDEDCONCEALED) {
            Pit.cpic[0][0] = this.loadPic("cpit01.gif");
            Pit.cpic[0][1] = this.loadPic("cpit02.gif");
            Pit.cpic[0][2] = this.loadPic("cpit03.gif");
            Pit.cpic[1][0] = this.loadPic("cpit11.gif");
            Pit.cpic[1][1] = this.loadPic("cpit12.gif");
            Pit.cpic[1][2] = this.loadPic("cpit13.gif");
            Pit.cpic[2][0] = this.loadPic("cpit21.gif");
            Pit.cpic[2][1] = this.loadPic("cpit22.gif");
            Pit.cpic[2][2] = this.loadPic("cpit23.gif");
            Pit.cpic[3][0] = this.loadPic("cpit31.gif");
            Pit.cpic[3][1] = this.loadPic("cpit32.gif");
            Pit.cpic[3][2] = this.loadPic("cpit33.gif");
            tracker.addImage(cpic[0][0], 0);
            tracker.addImage(cpic[0][1], 0);
            tracker.addImage(cpic[0][2], 0);
            tracker.addImage(cpic[1][0], 0);
            tracker.addImage(cpic[1][1], 0);
            tracker.addImage(cpic[1][2], 0);
            tracker.addImage(cpic[2][0], 0);
            tracker.addImage(cpic[2][1], 0);
            tracker.addImage(cpic[2][2], 0);
            tracker.addImage(cpic[3][0], 0);
            tracker.addImage(cpic[3][1], 0);
            tracker.addImage(cpic[3][2], 0);
        }
        if (!this.isConcealed) {
            this.pic[0][1] = this.loadPic("pit01.gif");
            this.pic[0][2] = this.loadPic("pit02.gif");
            this.pic[0][3] = this.loadPic("pit03.gif");
            this.pic[1][1] = this.loadPic("pit11.gif");
            this.pic[1][2] = this.loadPic("pit12.gif");
            this.pic[1][3] = this.loadPic("pit13.gif");
            this.pic[2][1] = this.loadPic("pit21.gif");
            this.pic[2][2] = this.loadPic("pit22.gif");
            this.pic[2][3] = this.loadPic("pit23.gif");
            this.pic[3][1] = this.loadPic("pit31.gif");
            this.pic[3][2] = this.loadPic("pit32.gif");
            this.pic[3][3] = this.loadPic("pit33.gif");
            if (!ADDEDPICS) {
                tracker.addImage(this.pic[0][1], 0);
                tracker.addImage(this.pic[0][2], 0);
                tracker.addImage(this.pic[0][3], 0);
                tracker.addImage(this.pic[1][1], 0);
                tracker.addImage(this.pic[1][2], 0);
                tracker.addImage(this.pic[1][3], 0);
                tracker.addImage(this.pic[2][1], 0);
                tracker.addImage(this.pic[2][2], 0);
                tracker.addImage(this.pic[2][3], 0);
                tracker.addImage(this.pic[3][1], 0);
                tracker.addImage(this.pic[3][2], 0);
                tracker.addImage(this.pic[3][3], 0);
                ADDEDPICS = true;
            }
        } else {
            this.pic[0][1] = this.loadPic("concealpit01.gif");
            this.pic[0][2] = this.loadPic("concealpit02.gif");
            this.pic[0][3] = this.loadPic("concealpit03.gif");
            this.pic[1][1] = this.loadPic("concealpit11.gif");
            this.pic[1][2] = this.loadPic("concealpit12.gif");
            this.pic[1][3] = this.loadPic("concealpit13.gif");
            this.pic[2][1] = this.loadPic("concealpit21.gif");
            this.pic[2][2] = this.loadPic("concealpit22.gif");
            this.pic[2][3] = this.loadPic("concealpit23.gif");
            this.pic[3][1] = blankpic;
            this.pic[3][2] = blankpic;
            this.pic[3][3] = blankpic;
            if (!ADDEDCONCEALED) {
                tracker.addImage(this.pic[0][1], 1);
                tracker.addImage(this.pic[0][2], 1);
                tracker.addImage(this.pic[0][3], 1);
                tracker.addImage(this.pic[1][1], 1);
                tracker.addImage(this.pic[1][2], 1);
                tracker.addImage(this.pic[1][3], 1);
                tracker.addImage(this.pic[2][1], 1);
                tracker.addImage(this.pic[2][2], 1);
                tracker.addImage(this.pic[2][3], 1);
                ADDEDCONCEALED = true;
            }
        }
    }

    public static void redoPics() {
        String string = Wall.currentdir + File.separator;
        File file = new File(string + "cpit12.gif");
        if (!file.exists()) {
            return;
        }
        Pit.cpic[0][0] = dmnew.tk.getImage(string + "cpit01.gif");
        Pit.cpic[0][1] = dmnew.tk.getImage(string + "cpit02.gif");
        Pit.cpic[0][2] = dmnew.tk.getImage(string + "cpit03.gif");
        Pit.cpic[1][0] = dmnew.tk.getImage(string + "cpit11.gif");
        Pit.cpic[1][1] = dmnew.tk.getImage(string + "cpit12.gif");
        Pit.cpic[1][2] = dmnew.tk.getImage(string + "cpit13.gif");
        Pit.cpic[2][0] = dmnew.tk.getImage(string + "cpit21.gif");
        Pit.cpic[2][1] = dmnew.tk.getImage(string + "cpit22.gif");
        Pit.cpic[2][2] = dmnew.tk.getImage(string + "cpit23.gif");
        Pit.cpic[3][0] = dmnew.tk.getImage(string + "cpit31.gif");
        Pit.cpic[3][1] = dmnew.tk.getImage(string + "cpit32.gif");
        Pit.cpic[3][2] = dmnew.tk.getImage(string + "cpit33.gif");
        tracker.addImage(cpic[0][0], 5);
        tracker.addImage(cpic[0][1], 5);
        tracker.addImage(cpic[0][2], 5);
        tracker.addImage(cpic[1][0], 5);
        tracker.addImage(cpic[1][1], 5);
        tracker.addImage(cpic[1][2], 5);
        tracker.addImage(cpic[2][0], 5);
        tracker.addImage(cpic[2][1], 5);
        tracker.addImage(cpic[2][2], 5);
        tracker.addImage(cpic[3][0], 5);
        tracker.addImage(cpic[3][1], 5);
        tracker.addImage(cpic[3][2], 5);
        try {
            tracker.waitForID(5, 2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.removeImage(cpic[0][0], 5);
        tracker.removeImage(cpic[0][1], 5);
        tracker.removeImage(cpic[0][2], 5);
        tracker.removeImage(cpic[1][0], 5);
        tracker.removeImage(cpic[1][1], 5);
        tracker.removeImage(cpic[1][2], 5);
        tracker.removeImage(cpic[2][0], 5);
        tracker.removeImage(cpic[2][1], 5);
        tracker.removeImage(cpic[2][2], 5);
        tracker.removeImage(cpic[3][0], 5);
        tracker.removeImage(cpic[3][1], 5);
        tracker.removeImage(cpic[3][2], 5);
    }

    public void redoPitPics() {
        String string = Wall.currentdir + File.separator;
        if (!this.isConcealed) {
            File file = new File(string + "pit12.gif");
            if (!file.exists()) {
                return;
            }
            this.pic[0][1] = dmnew.tk.getImage(string + "pit01.gif");
            this.pic[0][2] = dmnew.tk.getImage(string + "pit02.gif");
            this.pic[0][3] = dmnew.tk.getImage(string + "pit03.gif");
            this.pic[1][1] = dmnew.tk.getImage(string + "pit11.gif");
            this.pic[1][2] = dmnew.tk.getImage(string + "pit12.gif");
            this.pic[1][3] = dmnew.tk.getImage(string + "pit13.gif");
            this.pic[2][1] = dmnew.tk.getImage(string + "pit21.gif");
            this.pic[2][2] = dmnew.tk.getImage(string + "pit22.gif");
            this.pic[2][3] = dmnew.tk.getImage(string + "pit23.gif");
            this.pic[3][1] = dmnew.tk.getImage(string + "pit31.gif");
            this.pic[3][2] = dmnew.tk.getImage(string + "pit32.gif");
            this.pic[3][3] = dmnew.tk.getImage(string + "pit33.gif");
        } else {
            File file = new File(string + "concealpit12.gif");
            if (!file.exists()) {
                return;
            }
            this.pic[0][1] = dmnew.tk.getImage(string + "concealpit01.gif");
            this.pic[0][2] = dmnew.tk.getImage(string + "concealpit02.gif");
            this.pic[0][3] = dmnew.tk.getImage(string + "concealpit03.gif");
            this.pic[1][1] = dmnew.tk.getImage(string + "concealpit11.gif");
            this.pic[1][2] = dmnew.tk.getImage(string + "concealpit12.gif");
            this.pic[1][3] = dmnew.tk.getImage(string + "concealpit13.gif");
            this.pic[2][1] = dmnew.tk.getImage(string + "concealpit21.gif");
            this.pic[2][2] = dmnew.tk.getImage(string + "concealpit22.gif");
            this.pic[2][3] = dmnew.tk.getImage(string + "concealpit23.gif");
        }
        tracker.addImage(this.pic[0][1], 5);
        tracker.addImage(this.pic[0][2], 5);
        tracker.addImage(this.pic[0][3], 5);
        tracker.addImage(this.pic[1][1], 5);
        tracker.addImage(this.pic[1][2], 5);
        tracker.addImage(this.pic[1][3], 5);
        tracker.addImage(this.pic[2][1], 5);
        tracker.addImage(this.pic[2][2], 5);
        tracker.addImage(this.pic[2][3], 5);
        if (!this.isConcealed) {
            tracker.addImage(this.pic[3][1], 5);
            tracker.addImage(this.pic[3][2], 5);
            tracker.addImage(this.pic[3][3], 5);
        }
        try {
            tracker.waitForID(5, 2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.removeImage(this.pic[0][1], 5);
        tracker.removeImage(this.pic[0][2], 5);
        tracker.removeImage(this.pic[0][3], 5);
        tracker.removeImage(this.pic[1][1], 5);
        tracker.removeImage(this.pic[1][2], 5);
        tracker.removeImage(this.pic[1][3], 5);
        tracker.removeImage(this.pic[2][1], 5);
        tracker.removeImage(this.pic[2][2], 5);
        tracker.removeImage(this.pic[2][3], 5);
        if (!this.isConcealed) {
            tracker.removeImage(this.pic[3][1], 5);
            tracker.removeImage(this.pic[3][2], 5);
            tracker.removeImage(this.pic[3][3], 5);
        }
    }

    @Override
    public void drawPic(int n, int n2, int n3, int n4, Graphics2D graphics2D, ImageObserver imageObserver) {
        if ((this.isOpen || this.isIllusionary && dmnew.dispell == 0) && n2 != 0 && n2 != 4 && (!this.isConcealed || n < 3)) {
            int n5 = 0;
            int n6 = 0;
            if (n == 0) {
                n5 = 50;
                n6 = 296;
            } else if (n == 1) {
                n5 = 22;
                n6 = 202;
            } else if (n == 2) {
                n5 = 16;
                n6 = 136;
            } else {
                n5 = 11;
                n6 = 102;
            }
            if (n2 == 3) {
                n3 -= this.pic[n][3].getWidth(null);
            }
            if (n2 != 2) {
                n5 = 0;
            }
            if (n2 == 2 && dmnew.mirrorback) {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n3 + n5 + this.pic[n][n2].getWidth(null), n4 + n6);
                affineTransform.scale(-1.0, 1.0);
                graphics2D.drawImage(this.pic[n][n2], affineTransform, null);
            } else {
                graphics2D.drawImage(this.pic[n][n2], n3 + n5, n4 + n6, null);
            }
        }
        if (n2 > 0 && n2 < 4) {
            this.drawContents(graphics2D, 3 - n, n2 - 1);
        }
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeInt(this.level);
        objectOutputStream.writeInt(this.xcoord);
        objectOutputStream.writeInt(this.ycoord);
        objectOutputStream.writeBoolean(this.isOpen);
        objectOutputStream.writeBoolean(this.isConcealed);
        objectOutputStream.writeBoolean(this.isIllusionary);
        objectOutputStream.writeBoolean(this.isSupplies);
        objectOutputStream.writeBoolean(this.isContinuous);
        objectOutputStream.writeBoolean(this.isActive);
        objectOutputStream.writeInt(this.blinkrateo);
        objectOutputStream.writeInt(this.blinkratec);
        objectOutputStream.writeInt(this.delay);
        objectOutputStream.writeInt(this.reset);
        objectOutputStream.writeBoolean(this.monswork);
        objectOutputStream.writeInt(this.maxcount);
        objectOutputStream.writeInt(this.count);
        objectOutputStream.writeBoolean(this.resetcount);
        objectOutputStream.writeInt(this.blinkcounter);
        objectOutputStream.writeBoolean(this.delaying);
        objectOutputStream.writeInt(this.delaycounter);
        objectOutputStream.writeBoolean(this.resetting);
        objectOutputStream.writeInt(this.resetcounter);
    }

    static {
        cpic = new Image[4][3];
    }
}

