/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class SconceWizard
extends JDialog
implements ActionListener {
    private int side;
    private int level;
    private int x;
    private int y;
    private MapData data;
    private MultWallSwitchData sconceswitch;
    private JToggleButton[] sidebutton = new JToggleButton[4];
    private JToggleButton torchbut;
    private JLabel hasswitch;
    private DMEditor dmed;

    public SconceWizard(DMEditor dMEditor) {
        super(dMEditor, "Sconce Wizard", true);
        this.dmed = dMEditor;
        this.setDefaultCloseOperation(2);
        this.setSize(500, 240);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.torchbut = new JToggleButton("Has a Torch");
        this.torchbut.setSelected(true);
        jPanel.add(this.torchbut);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup.add(this.sidebutton[0]);
        buttonGroup.add(this.sidebutton[1]);
        buttonGroup.add(this.sidebutton[2]);
        buttonGroup.add(this.sidebutton[3]);
        jPanel2.add(new JLabel());
        jPanel2.add(this.sidebutton[0]);
        jPanel2.add(new JLabel());
        jPanel2.add(this.sidebutton[1]);
        jPanel2.add(new JLabel());
        jPanel2.add(this.sidebutton[3]);
        jPanel2.add(new JLabel());
        jPanel2.add(this.sidebutton[2]);
        jPanel2.add(new JLabel());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Sconce Faces:"));
        this.sidebutton[2].setSelected(true);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1));
        this.hasswitch = new JLabel("No Switch");
        JButton jButton = new JButton("Add/Edit Switch");
        JButton jButton2 = new JButton("Remove Switch");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel4.add(this.hasswitch);
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel2);
        JPanel jPanel6 = new JPanel();
        JButton jButton3 = new JButton("Done");
        JButton jButton4 = new JButton("Cancel");
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jPanel6.add(jButton4);
        jPanel6.add(jButton3);
        container.add("Center", jPanel5);
        container.add("South", jPanel6);
        container.add("East", jPanel3);
        container.add("North", jPanel);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == '}') {
            this.sidebutton[(((SconceData)mapData).side + 2) % 4].doClick();
            this.torchbut.setSelected(((SconceData)mapData).hasTorch);
            if (((SconceData)mapData).isSwitch) {
                this.sconceswitch = ((SconceData)mapData).sconceswitch;
                this.hasswitch.setText("Has Switch");
            } else {
                this.sconceswitch = null;
                this.hasswitch.setText("No Switch");
            }
        } else {
            this.sconceswitch = null;
            this.hasswitch.setText("No Switch");
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else if (actionEvent.getActionCommand().equals("Done")) {
            this.data = this.sconceswitch == null ? new SconceData(this.side, this.torchbut.isSelected()) : new SconceData(this.side, this.torchbut.isSelected(), this.sconceswitch);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Add/Edit Switch")) {
            MultWallSwitchData multWallSwitchData = (MultWallSwitchData)new MultWallSwitchWizard(this.dmed, this.sconceswitch, this.level, this.x, this.y, false, -1, this.side).getData();
            if (multWallSwitchData != null) {
                this.sconceswitch = multWallSwitchData;
                this.hasswitch.setText("Has Switch");
            }
        } else if (actionEvent.getActionCommand().equals("Remove Switch")) {
            if (this.hasswitch.getText().equals("No Switch")) {
                return;
            }
            this.sconceswitch = null;
            this.hasswitch.setText("No Switch");
        }
    }

    public MapData getData() {
        return this.data;
    }
}

