/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwitchFinder
extends JDialog
implements ActionListener,
MouseListener {
    private Container cp;
    private DMEditor dmed;
    private JTextField targetlevel;
    private JTextField targetx;
    private JTextField targety;
    private JList foundlist;
    private JScrollPane foundpane;
    private Vector foundvec = new Vector(10);
    private int findlevel;
    private int findx;
    private int findy;

    public SwitchFinder(DMEditor dMEditor) {
        super(dMEditor, "Find Switches/Teleports", true);
        this.dmed = dMEditor;
        this.setDefaultCloseOperation(1);
        this.cp = this.getContentPane();
        JPanel jPanel = new JPanel();
        Box box = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        JLabel jLabel = new JLabel(" Level ");
        JLabel jLabel2 = new JLabel("    X");
        JLabel jLabel3 = new JLabel("    Y");
        jLabel2.setHorizontalAlignment(0);
        jLabel3.setHorizontalAlignment(0);
        this.targetlevel = new JTextField("0", 3);
        this.targetx = new JTextField("0", 3);
        this.targety = new JTextField("0", 3);
        box.add(jLabel);
        box.add(Box.createVerticalStrut(14));
        box.add(jLabel2);
        box.add(Box.createVerticalStrut(15));
        box.add(jLabel3);
        box2.add(this.targetlevel);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.targetx);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.targety);
        Box box3 = Box.createHorizontalBox();
        box3.add(box);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(box2);
        JButton jButton = new JButton("From Map...");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Get Locked");
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        Dimension dimension = new Dimension(200, 180);
        jPanel2.setPreferredSize(dimension);
        jPanel2.setMaximumSize(dimension);
        jPanel2.add(box3);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Square To Find For"));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        JButton jButton3 = new JButton("Find");
        jButton3.addActionListener(this);
        jPanel3.add(jButton3);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.foundlist = new JList();
        this.foundlist.setSelectionMode(0);
        this.foundlist.setSelectedIndex(0);
        this.foundlist.addMouseListener(this);
        this.foundpane = new JScrollPane(this.foundlist);
        Dimension dimension2 = new Dimension(238, 150);
        this.foundpane.setPreferredSize(dimension2);
        this.foundpane.setMaximumSize(dimension2);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.foundpane);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), "Locations"));
        jPanel4.add(jPanel5);
        JButton jButton4 = new JButton("Go To Selected");
        jButton4.addActionListener(this);
        jPanel4.add(jButton4);
        JPanel jPanel6 = new JPanel();
        JButton jButton5 = new JButton("Exit");
        jButton5.addActionListener(this);
        jPanel6.add(jButton5);
        this.cp.add("West", jPanel);
        this.cp.add("South", jPanel6);
        this.cp.add("East", jPanel4);
        this.pack();
        this.setLocationRelativeTo(dMEditor);
    }

    public void showFinder(boolean bl) {
        if (bl) {
            this.targetlevel.setText("" + DMEditor.currentlevel);
            this.targetx.setText("" + this.dmed.lockx);
            this.targety.setText("" + this.dmed.locky);
            this.foundvec.clear();
            this.foundlist.setListData(this.foundvec);
        }
        this.show();
    }

    private boolean searchMapData(MapData mapData, int n, int n2, int n3) {
        boolean bl = false;
        if (mapData.mapchar == '/') {
            WallSwitchData wallSwitchData = (WallSwitchData)mapData;
            if (wallSwitchData.targetlevel == this.findlevel && wallSwitchData.targetx == this.findx && wallSwitchData.targety == this.findy) {
                this.foundvec.add("Wall Switch at " + n + "," + n2 + "," + n3);
                bl = true;
            } else if (wallSwitchData.actiontype == 5 || wallSwitchData.actiontype == 6) {
                if (this.searchMapData(wallSwitchData.changeto, wallSwitchData.targetlevel, wallSwitchData.targetx, wallSwitchData.targety)) {
                    this.foundvec.add(" -- Created by Wall Switch at " + n + "," + n2 + "," + n3);
                    bl = true;
                }
                if (wallSwitchData.actiontype == 5 && wallSwitchData.switchstate && this.searchMapData(wallSwitchData.oldMapObject, wallSwitchData.targetlevel, wallSwitchData.targetx, wallSwitchData.targety)) {
                    this.foundvec.add(" -- Created by Wall Switch at " + n + "," + n2 + "," + n3);
                    bl = true;
                }
            }
        } else if (mapData.mapchar == 's') {
            FloorSwitchData floorSwitchData = (FloorSwitchData)mapData;
            if (floorSwitchData.targetlevel == this.findlevel && floorSwitchData.targetx == this.findx && floorSwitchData.targety == this.findy) {
                this.foundvec.add("Floor Switch at " + n + "," + n2 + "," + n3);
                bl = true;
            } else if (floorSwitchData.actiontype == 5 || floorSwitchData.actiontype == 6) {
                if (this.searchMapData(floorSwitchData.changeto, floorSwitchData.targetlevel, floorSwitchData.targetx, floorSwitchData.targety)) {
                    this.foundvec.add(" -- Created by Floor Switch at " + n + "," + n2 + "," + n3);
                    bl = true;
                }
                if (floorSwitchData.actiontype == 5 && floorSwitchData.switchstate && this.searchMapData(floorSwitchData.oldMapObject, floorSwitchData.targetlevel, floorSwitchData.targetx, floorSwitchData.targety)) {
                    this.foundvec.add(" -- Created by Floor Switch at " + n + "," + n2 + "," + n3);
                    bl = true;
                }
            }
        } else if (mapData.mapchar == 't') {
            TeleportData teleportData = (TeleportData)mapData;
            if (teleportData.targetlevel == this.findlevel && teleportData.targetx == this.findx && teleportData.targety == this.findy) {
                this.foundvec.add("Teleport at " + n + "," + n2 + "," + n3);
                bl = true;
            }
        } else if (mapData.mapchar == 'y') {
            FulYaPitData fulYaPitData = (FulYaPitData)mapData;
            if (fulYaPitData.keytarget.level == this.findlevel && fulYaPitData.keytarget.x == this.findx && fulYaPitData.keytarget.y == this.findy || fulYaPitData.nonkeytarget.level == this.findlevel && fulYaPitData.nonkeytarget.x == this.findx && fulYaPitData.nonkeytarget.y == this.findy) {
                this.foundvec.add("FulYa Pit at " + n + "," + n2 + "," + n3);
                bl = true;
            }
        } else if (mapData.mapchar == 'E') {
            EventSquareData eventSquareData = (EventSquareData)mapData;
            int n4 = 0;
            for (int i = 0; !bl && i < eventSquareData.choices.length; ++i) {
                while (!bl && n4 < eventSquareData.choices[i].actions.size()) {
                    Action action = (Action)eventSquareData.choices[i].actions.get(n4);
                    if (action.actiontype > 0 && action.actiontype < 4) {
                        MapPoint mapPoint = (MapPoint)action.action;
                        if (mapPoint.level == this.findlevel && mapPoint.x == this.findx && mapPoint.y == this.findy) {
                            bl = true;
                        }
                    }
                    ++n4;
                }
            }
            if (bl) {
                this.foundvec.add("EventSquare at " + n + "," + n2 + "," + n3);
            }
        } else if (mapData.mapchar == 'm') {
            if (((MirrorData)mapData).target != null && ((MirrorData)mapData).target.level == this.findlevel && ((MirrorData)mapData).target.x == this.findx && ((MirrorData)mapData).target.y == this.findy) {
                this.foundvec.add("Mirror at " + n + "," + n2 + "," + n3);
                bl = true;
            }
        } else if (mapData.mapchar == '\\') {
            for (int i = 0; i < ((MultWallSwitchData)mapData).switchlist.size(); ++i) {
                WallSwitchData wallSwitchData = (WallSwitchData)((MultWallSwitchData)mapData).switchlist.get(i);
                if (!this.searchMapData(wallSwitchData, n, n2, n3)) continue;
                bl = true;
            }
        } else if (mapData.mapchar == 'S') {
            for (int i = 0; i < ((MultFloorSwitchData)mapData).switchlist.size(); ++i) {
                FloorSwitchData floorSwitchData = (FloorSwitchData)((MultFloorSwitchData)mapData).switchlist.get(i);
                if (!this.searchMapData(floorSwitchData, n, n2, n3)) continue;
                bl = true;
            }
        } else if (mapData.mapchar == ']' || mapData.mapchar == 'a') {
            OneAlcoveData oneAlcoveData = (OneAlcoveData)mapData;
            if (oneAlcoveData.isSwitch) {
                for (int i = 0; i < oneAlcoveData.alcoveswitchdata.switchlist.size(); ++i) {
                    WallSwitchData wallSwitchData = (WallSwitchData)oneAlcoveData.alcoveswitchdata.switchlist.get(i);
                    if (!this.searchMapData(wallSwitchData, n, n2, n3)) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.foundvec.add(" -- Alcove at " + n + "," + n2 + "," + n3);
            }
        } else if (mapData.mapchar == '[') {
            AlcoveData alcoveData = (AlcoveData)mapData;
            if (alcoveData.isSwitch) {
                for (int i = 0; i < alcoveData.alcoveswitchdata.switchlist.size(); ++i) {
                    WallSwitchData wallSwitchData = (WallSwitchData)alcoveData.alcoveswitchdata.switchlist.get(i);
                    if (!this.searchMapData(wallSwitchData, n, n2, n3)) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.foundvec.add(" -- Alcove at " + n + "," + n2 + "," + n3);
            }
        } else if (mapData.mapchar == '}') {
            SconceData sconceData = (SconceData)mapData;
            if (sconceData.isSwitch) {
                for (int i = 0; i < sconceData.sconceswitch.switchlist.size(); ++i) {
                    WallSwitchData wallSwitchData = (WallSwitchData)sconceData.sconceswitch.switchlist.get(i);
                    if (!this.searchMapData(wallSwitchData, n, n2, n3)) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.foundvec.add(" -- Sconce at " + n + "," + n2 + "," + n3);
            }
        } else if (mapData.mapchar == 'f') {
            FountainData fountainData = (FountainData)mapData;
            if (fountainData.fountainswitch != null) {
                for (int i = 0; i < fountainData.fountainswitch.switchlist.size(); ++i) {
                    WallSwitchData wallSwitchData = (WallSwitchData)fountainData.fountainswitch.switchlist.get(i);
                    if (!this.searchMapData(wallSwitchData, n, n2, n3)) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.foundvec.add(" -- Fountain at " + n + "," + n2 + "," + n3);
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block18: {
            block15: {
                block17: {
                    block16: {
                        if (!actionEvent.getActionCommand().equals("Find")) break block15;
                        this.foundvec.clear();
                        this.findlevel = Integer.parseInt(this.targetlevel.getText());
                        this.findx = Integer.parseInt(this.targetx.getText());
                        this.findy = Integer.parseInt(this.targety.getText());
                        if (this.findlevel < 0 || this.findx < 0 || this.findy < 0) break block16;
                        if (this.findlevel >= DMEditor.MAPLEVELS) break block16;
                        if (this.findx >= DMEditor.MAPWIDTH) break block16;
                        if (this.findy < DMEditor.MAPHEIGHT) break block17;
                    }
                    this.foundvec.add("Illegal Map Coordinate");
                    this.foundlist.setListData(this.foundvec);
                    return;
                }
                int n = 0;
                while (true) {
                    if (n >= DMEditor.MAPLEVELS) break;
                    MapData[][] mapDataArray = (MapData[][])DMEditor.maplevels.get(n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= DMEditor.MAPWIDTH) break;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= DMEditor.MAPHEIGHT) break;
                            this.searchMapData(mapDataArray[n2][n3], n, n2, n3);
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
                if (this.foundvec.isEmpty()) {
                    this.foundvec.add("None Found");
                }
                this.foundlist.setListData(this.foundvec);
                break block18;
            }
            if (actionEvent.getActionCommand().equals("Exit")) {
                this.hide();
            } else if (actionEvent.getActionCommand().startsWith("Go To")) {
                this.mouseClicked(new MouseEvent(this.foundlist, 500, 0L, 8, 0, this.foundlist.getSelectedIndex() * 19, 2, false));
            } else if (actionEvent.getActionCommand().equals("From Map...")) {
                DMEditor.targetframe.show();
                MapPoint mapPoint = DMEditor.targetframe.getTarget();
                if (mapPoint != null) {
                    this.targetlevel.setText("" + mapPoint.level);
                    this.targetx.setText("" + mapPoint.x);
                    this.targety.setText("" + mapPoint.y);
                }
                this.show();
            } else if (actionEvent.getActionCommand().equals("Get Locked") && this.dmed.SQUARELOCKED) {
                this.targetlevel.setText("" + DMEditor.currentlevel);
                this.targetx.setText("" + this.dmed.lockx);
                this.targety.setText("" + this.dmed.locky);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2 && !SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        if (this.foundlist.getSelectedIndex() == -1) {
            return;
        }
        String string = (String)this.foundvec.get(this.foundlist.getSelectedIndex());
        if (string.startsWith("None") || string.startsWith("Illegal")) {
            return;
        }
        string = string.substring(string.lastIndexOf("at ") + 3);
        int n = Integer.parseInt(string.substring(0, string.indexOf(44)));
        int n2 = Integer.parseInt(string.substring(string.indexOf(44) + 1, string.indexOf(44, string.indexOf(44) + 1)));
        int n3 = Integer.parseInt(string.substring(string.lastIndexOf(44) + 1));
        if (DMEditor.currentlevel != n) {
            this.dmed.mappanel.setVisible(false);
            DMEditor.currentlevel = n;
            this.dmed.mapdata = (MapData[][])DMEditor.maplevels.get(DMEditor.currentlevel);
            this.dmed.mappanel.clearTargets();
            this.dmed.mappanel.repaint();
            this.dmed.mappanel.setVisible(true);
            if (DMEditor.currentlevel == 0) {
                this.dmed.mbutton[8].setEnabled(false);
            } else {
                this.dmed.mbutton[8].setEnabled(true);
            }
        }
        Point point = !this.dmed.ZOOMING ? new Point(n2 * 33, n3 * 33) : new Point(n2 * 17, n3 * 17);
        point.x -= DMEditor.mpane.getSize().width / 2;
        if (point.x < 0) {
            point.x = 0;
        }
        point.y -= DMEditor.mpane.getSize().height / 2;
        if (point.y < 0) {
            point.y = 0;
        }
        DMEditor.mpane.getViewport().setViewPosition(point);
        this.dmed.mapclick.x = n2;
        this.dmed.mapclick.y = n3;
        this.dmed.currentx = n2;
        this.dmed.currenty = n3;
        this.dmed.monitembox.removeAll();
        this.dmed.monitembox.repaint();
        boolean bl = this.dmed.mappanel.clearTargets();
        this.dmed.lockx = n2;
        this.dmed.locky = n3;
        this.dmed.setStatusBar(this.dmed.mapdata[n2][n3], n2, n3);
        boolean bl2 = this.dmed.mappanel.doTargets(this.dmed.mapdata[n2][n3], n2, n3);
        if (bl || bl2) {
            this.dmed.mappanel.forcePaint();
        }
        if (!this.dmed.SQUARELOCKED) {
            this.dmed.SQUARELOCKED = true;
            this.dmed.statusbar.setText(this.dmed.statusbar.getText() + "      (Locked)");
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

