/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

class TargetFrame
extends JDialog
implements ActionListener,
MouseListener,
MouseMotionListener,
WindowListener {
    private int oldlevel;
    private int currentlevel;
    private int currentx = 0;
    private int currenty = 0;
    private boolean didchoose = false;
    private boolean oldzoom;
    private JToggleButton zoombutton;
    private JLabel statusbar = new JLabel();
    private MapPanel mappanel;
    private Box hspacebox;
    private JScrollPane mpane;
    private DMEditor dmed;

    public TargetFrame(DMEditor dMEditor) {
        super(dMEditor, "Targets:", true);
        this.dmed = dMEditor;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.setSize(800, 600);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        this.mappanel = dMEditor.mappanel;
        this.hspacebox = Box.createHorizontalBox();
        this.hspacebox.add(Box.createHorizontalGlue());
        MyMapPanel myMapPanel = new MyMapPanel();
        myMapPanel.add(this.hspacebox);
        myMapPanel.add(Box.createVerticalGlue());
        this.mpane = new JScrollPane(myMapPanel);
        this.mpane.setPreferredSize(new Dimension(640, 400));
        JPanel jPanel = new JPanel();
        this.zoombutton = new JToggleButton(new ImageIcon("Icons" + File.separator + "zoom.gif"));
        this.zoombutton.setPreferredSize(new Dimension(42, 42));
        this.zoombutton.setMinimumSize(new Dimension(42, 42));
        this.zoombutton.setMaximumSize(new Dimension(42, 42));
        this.zoombutton.setActionCommand("Zoom");
        this.zoombutton.addActionListener(this);
        this.zoombutton.setSelected(!dMEditor.ZOOMING);
        jPanel.add(this.zoombutton);
        JButton jButton = new JButton(new ImageIcon("Icons" + File.separator + "up.gif"));
        jButton.setPreferredSize(new Dimension(36, 42));
        jButton.setActionCommand("Up");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new ImageIcon("Icons" + File.separator + "down.gif"));
        jButton2.setPreferredSize(new Dimension(36, 42));
        jButton2.setActionCommand("Down");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        this.statusbar.setPreferredSize(new Dimension(640, 20));
        this.statusbar.setHorizontalAlignment(0);
        this.statusbar.setForeground(Color.black);
        container.add("North", jPanel);
        container.add("Center", this.mpane);
        container.add("South", this.statusbar);
        this.pack();
    }

    @Override
    public void show() {
        this.mappanel.removeMouseListener(this.dmed.mapclick);
        this.mappanel.removeMouseMotionListener(this.dmed.mapclick);
        this.hspacebox.add(this.mappanel);
        this.mappanel.addMouseListener(this);
        this.mappanel.addMouseMotionListener(this);
        this.oldlevel = DMEditor.currentlevel;
        this.oldzoom = this.dmed.ZOOMING;
        this.zoombutton.setSelected(!this.oldzoom);
        this.currentlevel = DMEditor.currentlevel;
        super.show();
    }

    public MapPoint getTarget() {
        if (this.didchoose) {
            this.didchoose = false;
            return new MapPoint(this.currentlevel, this.currentx, this.currenty);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Up")) {
            if (DMEditor.currentlevel == 0) {
                return;
            }
            this.mappanel.setVisible(false);
            --this.currentlevel;
            this.dmed.mapdata = (MapData[][])DMEditor.maplevels.get(--DMEditor.currentlevel);
            this.mappanel.clearTargets();
            this.mappanel.repaint();
            this.mappanel.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Down")) {
            if (DMEditor.currentlevel == DMEditor.MAPLEVELS - 1) {
                return;
            }
            this.mappanel.setVisible(false);
            ++this.currentlevel;
            this.dmed.mapdata = (MapData[][])DMEditor.maplevels.get(++DMEditor.currentlevel);
            this.mappanel.clearTargets();
            this.mappanel.repaint();
            this.mappanel.setVisible(true);
        } else {
            this.dmed.ZOOMING = !this.dmed.ZOOMING;
            this.mappanel.setZoom();
            this.mappanel.invalidate();
            this.mpane.validate();
            this.mappanel.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2;
        block7: {
            block6: {
                if (!this.dmed.ZOOMING) {
                    n2 = mouseEvent.getX() / 33;
                    n = mouseEvent.getY() / 33;
                } else {
                    n2 = mouseEvent.getX() / 17;
                    n = mouseEvent.getY() / 17;
                }
                if (n2 == this.currentx && n == this.currenty) break block6;
                if (n2 >= DMEditor.MAPWIDTH) break block6;
                if (n < DMEditor.MAPHEIGHT) break block7;
            }
            return;
        }
        this.currentx = n2;
        this.currenty = n;
        boolean bl = this.mappanel.clearTargets();
        boolean bl2 = this.mappanel.doTargets(this.dmed.mapdata[this.currentx][this.currenty], this.currentx, this.currenty);
        if (bl || bl2) {
            this.mappanel.forcePaint();
        }
        this.statusbar.setText(this.dmed.mapdata[this.currentx][this.currenty] + " at " + this.currentlevel + "," + this.currentx + "," + this.currenty);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.didchoose = true;
        this.dispose();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.currentx = -1;
        this.currenty = -1;
        this.mappanel.clearTargets();
        this.mappanel.forcePaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.mappanel.removeMouseListener(this);
        this.mappanel.removeMouseMotionListener(this);
        this.mappanel.addMouseListener(this.dmed.mapclick);
        this.mappanel.addMouseMotionListener(this.dmed.mapclick);
        this.dmed.mapdata = (MapData[][])DMEditor.maplevels.get(this.oldlevel);
        this.dmed.ZOOMING = this.oldzoom;
        DMEditor.currentlevel = this.oldlevel;
        this.dmed.mapdata = (MapData[][])DMEditor.maplevels.get(DMEditor.currentlevel);
        this.dmed.hspacebox.add(this.mappanel);
        this.mappanel.setZoom();
        this.mappanel.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

