/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class TeleportWizard
extends JDialog
implements ActionListener {
    private int type;
    private int level;
    private int x;
    private int y;
    private MapData data;
    private boolean reusable = true;
    private boolean visible = true;
    private boolean makessound = true;
    private int newface = -1;
    JComboBox facelist;
    JTextField levelfield;
    JTextField xfield;
    JTextField yfield;
    JTextField blinkonfield;
    JTextField blinkofffield;
    JTextField blinkcounter;
    JTextField mcountfield;
    JTextField countfield;
    JTextField delay;
    JTextField reset;
    JToggleButton resetcount;
    JToggleButton isActive;
    JToggleButton isOn;
    JToggleButton switchVisible;
    JToggleButton visbutton;
    JToggleButton reusebutton;
    JToggleButton sndbutton;
    JToggleButton swapplaces;
    JToggleButton[] typebutton;

    public TeleportWizard(JFrame jFrame) {
        super(jFrame, "Teleport Wizard", true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 10, 2));
        this.typebutton = new JToggleButton[4];
        this.typebutton[0] = new JToggleButton("Party");
        this.typebutton[1] = new JToggleButton("Monsters");
        this.typebutton[2] = new JToggleButton("Items");
        this.typebutton[3] = new JToggleButton("Projectiles");
        this.typebutton[0].setActionCommand("1");
        this.typebutton[1].setActionCommand("2");
        this.typebutton[2].setActionCommand("4");
        this.typebutton[3].setActionCommand("8");
        this.typebutton[0].addActionListener(this);
        this.typebutton[1].addActionListener(this);
        this.typebutton[2].addActionListener(this);
        this.typebutton[3].addActionListener(this);
        jPanel.add(this.typebutton[0]);
        jPanel.add(this.typebutton[1]);
        jPanel.add(this.typebutton[2]);
        jPanel.add(this.typebutton[3]);
        this.typebutton[0].setSelected(true);
        this.typebutton[1].setSelected(true);
        this.typebutton[2].setSelected(true);
        this.typebutton[3].setSelected(true);
        this.type = 15;
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new GridLayout(7, 1, 10, 2));
        JPanel jPanel4 = new JPanel(new GridLayout(11, 1, 10, 2));
        this.visbutton = new JToggleButton("Visible");
        this.visbutton.addActionListener(this);
        this.visbutton.setSelected(true);
        this.sndbutton = new JToggleButton("Makes Sound");
        this.sndbutton.addActionListener(this);
        this.sndbutton.setSelected(true);
        this.isActive = new JToggleButton("Is Blinking");
        this.isActive.setSelected(false);
        this.isOn = new JToggleButton("Is On");
        this.isOn.setSelected(true);
        this.reusebutton = new JToggleButton("Reusable");
        this.reusebutton.addActionListener(this);
        this.reusebutton.setSelected(true);
        String[] stringArray = new String[]{"No Spin", "Right 90", "Left 90", "180", "North", "South", "East", "West", "Random"};
        this.facelist = new JComboBox<String>(stringArray);
        this.facelist.setEditable(false);
        this.facelist.addActionListener(this);
        this.swapplaces = new JToggleButton("Swaps Mons and Party");
        this.swapplaces.setSelected(true);
        JLabel jLabel = new JLabel("Blinkrate (On):");
        this.blinkonfield = new JTextField("0", 3);
        JLabel jLabel2 = new JLabel("Blinkrate (Off):");
        this.blinkofffield = new JTextField("0", 3);
        JLabel jLabel3 = new JLabel("Blinkcounter:");
        this.blinkcounter = new JTextField("0", 3);
        JLabel jLabel4 = new JLabel("Total Switch count:");
        this.mcountfield = new JTextField("1", 3);
        JLabel jLabel5 = new JLabel("Remaining Switch count:");
        this.countfield = new JTextField("1", 3);
        this.resetcount = new JToggleButton("Count Resets");
        jPanel3.add(this.visbutton);
        jPanel3.add(this.sndbutton);
        jPanel3.add(this.swapplaces);
        jPanel3.add(this.isActive);
        jPanel3.add(this.isOn);
        jPanel3.add(this.reusebutton);
        jPanel3.add(this.facelist);
        jPanel4.add(jLabel);
        jPanel4.add(this.blinkonfield);
        jPanel4.add(jLabel2);
        jPanel4.add(this.blinkofffield);
        jPanel4.add(jLabel3);
        jPanel4.add(this.blinkcounter);
        jPanel4.add(jLabel4);
        jPanel4.add(this.mcountfield);
        jPanel4.add(jLabel5);
        jPanel4.add(this.countfield);
        jPanel4.add(this.resetcount);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 100)));
        jPanel2.add(jPanel4);
        Box box = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        JLabel jLabel6 = new JLabel(" Level ");
        JLabel jLabel7 = new JLabel("    X");
        JLabel jLabel8 = new JLabel("    Y");
        jLabel7.setHorizontalAlignment(0);
        jLabel8.setHorizontalAlignment(0);
        this.levelfield = new JTextField("" + this.level, 3);
        this.xfield = new JTextField("" + this.x, 3);
        this.yfield = new JTextField("" + this.y, 3);
        box.add(jLabel6);
        box.add(Box.createVerticalStrut(14));
        box.add(jLabel7);
        box.add(Box.createVerticalStrut(15));
        box.add(jLabel8);
        box2.add(this.levelfield);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.xfield);
        box2.add(Box.createVerticalStrut(10));
        box2.add(this.yfield);
        Box box3 = Box.createHorizontalBox();
        box3.add(box);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(box2);
        JButton jButton = new JButton("From Map...");
        jButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(box3);
        jPanel5.add(Box.createVerticalStrut(10));
        jPanel5.add(jButton);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Target"));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        this.switchVisible = new JToggleButton("Switch Visible");
        this.reset = new JTextField("0", 4);
        this.delay = new JTextField("0", 4);
        jPanel6.add(this.switchVisible);
        jPanel6.add(new JLabel("Reset Count (0 for none):"));
        jPanel6.add(this.reset);
        jPanel6.add(new JLabel("Delay Count (0 for none):"));
        jPanel6.add(this.delay);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Switched Type"));
        Box box4 = Box.createVerticalBox();
        box4.add(jPanel5);
        box4.add(Box.createVerticalStrut(10));
        box4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(1, 20, 20));
        jPanel7.add(jPanel);
        jPanel7.add(jPanel2);
        jPanel7.add(box4);
        JPanel jPanel8 = new JPanel();
        JButton jButton2 = new JButton("Done");
        JButton jButton3 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel8.add(jButton3);
        jPanel8.add(jButton2);
        container.add("Center", jPanel7);
        container.add("South", jPanel8);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 't') {
            TeleportData teleportData = (TeleportData)mapData;
            this.type = teleportData.type;
            this.typebutton[0].setSelected((this.type & 1) != 0);
            this.typebutton[1].setSelected((this.type & 2) != 0);
            this.typebutton[2].setSelected((this.type & 4) != 0);
            this.typebutton[3].setSelected((this.type & 8) != 0);
            if (!teleportData.isVisible) {
                this.visbutton.setSelected(false);
                this.visible = false;
            } else {
                this.visbutton.setSelected(true);
                this.visible = true;
            }
            if (!teleportData.playsound) {
                this.sndbutton.setSelected(false);
                this.makessound = false;
            } else {
                this.sndbutton.setSelected(true);
                this.makessound = true;
            }
            if (!teleportData.isReusable) {
                this.reusebutton.setSelected(false);
                this.reusable = false;
            } else {
                this.reusebutton.setSelected(true);
                this.reusable = true;
            }
            this.swapplaces.setSelected(teleportData.swapplaces);
            this.switchVisible.setSelected(teleportData.switchVisible);
            this.delay.setText("" + teleportData.delay);
            this.reset.setText("" + teleportData.reset);
            this.isActive.setSelected(teleportData.isActive);
            this.isOn.setSelected(teleportData.isOn);
            this.blinkonfield.setText("" + teleportData.blinkrateon);
            this.blinkofffield.setText("" + teleportData.blinkrateoff);
            this.blinkcounter.setText("" + teleportData.blinkcounter);
            this.mcountfield.setText("" + (teleportData.maxcount + 1));
            this.countfield.setText("" + (teleportData.count + 1));
            this.resetcount.setSelected(teleportData.resetcount);
            this.levelfield.setText("" + teleportData.targetlevel);
            this.xfield.setText("" + teleportData.targetx);
            this.yfield.setText("" + teleportData.targety);
            this.newface = teleportData.newface;
            if (this.newface < 0) {
                this.facelist.setSelectedIndex(0);
            } else if (this.newface == 4) {
                this.facelist.setSelectedIndex(1);
            } else if (this.newface == 5) {
                this.facelist.setSelectedIndex(2);
            } else if (this.newface == 6) {
                this.facelist.setSelectedIndex(3);
            } else if (this.newface == 0) {
                this.facelist.setSelectedIndex(4);
            } else if (this.newface == 2) {
                this.facelist.setSelectedIndex(5);
            } else if (this.newface == 3) {
                this.facelist.setSelectedIndex(6);
            } else if (this.newface == 1) {
                this.facelist.setSelectedIndex(7);
            } else {
                this.facelist.setSelectedIndex(8);
            }
        } else {
            this.levelfield.setText("" + n);
            this.xfield.setText("" + n2);
            this.yfield.setText("" + n3);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Visible")) {
            this.visible = !this.visible;
        } else if (actionEvent.getActionCommand().equals("Makes Sound")) {
            this.makessound = !this.makessound;
        } else if (actionEvent.getActionCommand().equals("Reusable")) {
            this.reusable = !this.reusable;
        } else if (actionEvent.getSource().equals(this.facelist)) {
            String string = (String)this.facelist.getSelectedItem();
            this.newface = string.equals("No Spin") ? -1 : (string.equals("Right 90") ? 4 : (string.equals("Left 90") ? 5 : (string.equals("180") ? 6 : (string.equals("Random") ? 7 : (string.equals("North") ? 0 : (string.equals("South") ? 2 : (string.equals("East") ? 3 : 1)))))));
        } else if (actionEvent.getActionCommand().equals("From Map...")) {
            DMEditor.targetframe.show();
            MapPoint mapPoint = DMEditor.targetframe.getTarget();
            if (mapPoint != null) {
                this.levelfield.setText("" + mapPoint.level);
                this.xfield.setText("" + mapPoint.x);
                this.yfield.setText("" + mapPoint.y);
            }
        } else if (actionEvent.getActionCommand().equals("Done")) {
            int n = Integer.parseInt(this.levelfield.getText());
            int n2 = Integer.parseInt(this.xfield.getText());
            int n3 = Integer.parseInt(this.yfield.getText());
            int n4 = Integer.parseInt(this.blinkonfield.getText());
            int n5 = Integer.parseInt(this.blinkofffield.getText());
            int n6 = Integer.parseInt(this.delay.getText());
            int n7 = Integer.parseInt(this.reset.getText());
            boolean bl = false;
            if (n6 > 0 || n7 > 0) {
                bl = true;
            } else {
                this.switchVisible.setSelected(false);
            }
            this.data = new TeleportData(this.level, this.x, this.y, this.type, n, n2, n3, this.newface, n4, n5, Integer.parseInt(this.blinkcounter.getText()), bl, this.switchVisible.isSelected(), n6, n7, this.reusable, this.visible, this.isActive.isSelected(), this.isOn.isSelected(), this.makessound, this.swapplaces.isSelected(), Integer.parseInt(this.mcountfield.getText()) - 1, Integer.parseInt(this.countfield.getText()) - 1, this.resetcount.isSelected(), false, 0, false, 0, false);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            this.type = ((JToggleButton)actionEvent.getSource()).isSelected() ? (this.type += n) : (this.type -= n);
        }
    }

    public MapData getData() {
        return this.data;
    }
}

