/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class AbilityPanel
extends JPanel
implements ActionListener {
    private JComboBox actionbox;
    private JComboBox classgain;
    private JComboBox castpower;
    private JTextField name;
    private JTextField sound;
    private JTextField power;
    private JTextField speed;
    private JTextField mana;
    private JTextField strength;
    private JTextField dexterity;
    private JTextField vitality;
    private JTextField intelligence;
    private JTextField wisdom;
    private JTextField flevel;
    private JTextField nlevel;
    private JTextField wlevel;
    private JTextField plevel;
    private JComboBox[] lvlneed;
    private JToggleButton immbut;
    private JToggleButton diamondbut;
    private JToggleButton stunbut;
    private JComboBox poison;
    private JPanel conjurepanel;
    private JPanel statpanel;
    private JPanel weappanel;
    private JLabel powerlabel;
    private JLabel conjurelabel;
    private Item conjureitem;
    private DMEditor dmed;
    private static ArrayList usesymbol = new ArrayList(13);
    private static ArrayList usenone = new ArrayList(8);
    private static SpecialAbility lastability = null;

    public AbilityPanel(DMEditor dMEditor) {
        if (usesymbol.size() == 0) {
            usesymbol.add("Arc Bolt");
            usesymbol.add("Bolt");
            usesymbol.add("Dispell");
            usesymbol.add("Feeble Mind");
            usesymbol.add("Fireball");
            usesymbol.add("Ruiner");
            usesymbol.add("Silence");
            usesymbol.add("Slow");
            usesymbol.add("Strip Defenses");
            usesymbol.add("Ven Cloud");
            usesymbol.add("Venom");
            usesymbol.add("Weakness");
            usesymbol.add("ZO");
            usenone.add("Climb Down");
            usenone.add("Climb Up");
            usenone.add("Detect Illusion");
            usenone.add("Invoke");
            usenone.add("Stat Boost");
            usenone.add("Conjure");
            usenone.add("Purify");
            usenone.add("Backstab");
        }
        this.dmed = dMEditor;
        Box box = Box.createVerticalBox();
        this.name = new JTextField("Breathe Fire", 20);
        this.sound = new JTextField("roar.wav", 10);
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(this);
        this.actionbox = new JComboBox<String>(SpecialAbility.actions);
        this.actionbox.setEditable(false);
        this.actionbox.setSelectedItem("Fireball");
        this.actionbox.addActionListener(this);
        this.classgain = new JComboBox<String>(ItemCreator.CLASSES);
        this.classgain.setSelectedIndex(2);
        this.castpower = new JComboBox<String>(ItemWizard.powers);
        this.castpower.setEditable(false);
        this.castpower.setSelectedIndex(0);
        this.power = new JTextField("10", 4);
        this.power.setVisible(false);
        this.speed = new JTextField("30", 4);
        this.mana = new JTextField("0", 4);
        this.lvlneed = new JComboBox[4];
        this.lvlneed[0] = new JComboBox<String>(ItemCreator.LEVELS);
        this.lvlneed[1] = new JComboBox<String>(ItemCreator.LEVELS);
        this.lvlneed[2] = new JComboBox<String>(ItemCreator.LEVELS);
        this.lvlneed[3] = new JComboBox<String>(ItemCreator.LEVELS);
        this.lvlneed[0].setEditable(false);
        this.lvlneed[0].setSelectedIndex(0);
        this.lvlneed[1].setEditable(false);
        this.lvlneed[1].setSelectedIndex(0);
        this.lvlneed[2].setEditable(false);
        this.lvlneed[2].setSelectedIndex(9);
        this.lvlneed[3].setEditable(false);
        this.lvlneed[3].setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Name: "));
        jPanel.add(this.name);
        jPanel.add(new JLabel("Ability: "));
        jPanel.add(this.actionbox);
        jPanel.add(new JLabel("Sound: "));
        jPanel.add(this.sound);
        jPanel.add(jButton);
        box.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Class:"));
        jPanel2.add(this.classgain);
        this.powerlabel = new JLabel("Power:");
        jPanel2.add(this.powerlabel);
        jPanel2.add(this.castpower);
        jPanel2.add(this.power);
        jPanel2.add(new JLabel("Delay Before Next Use:"));
        jPanel2.add(this.speed);
        jPanel2.add(new JLabel("Mana Consumed:"));
        jPanel2.add(this.mana);
        box.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(4, 2));
        Dimension dimension = new Dimension(335, 110);
        jPanel3.setPreferredSize(dimension);
        jPanel3.setMaximumSize(dimension);
        jPanel3.add(new JLabel("Fighter Level Needed:"));
        jPanel3.add(this.lvlneed[0]);
        jPanel3.add(new JLabel("Ninja Level Needed:"));
        jPanel3.add(this.lvlneed[1]);
        jPanel3.add(new JLabel("Wizard Level Needed:"));
        jPanel3.add(this.lvlneed[2]);
        jPanel3.add(new JLabel("Priest Level Needed:"));
        jPanel3.add(this.lvlneed[3]);
        box.add(jPanel3);
        this.conjurepanel = new JPanel();
        this.conjureitem = new Item(200);
        this.conjurelabel = new JLabel(this.conjureitem.name);
        JButton jButton2 = new JButton("Change Item");
        jButton2.addActionListener(this);
        this.conjurepanel.add(this.conjurelabel);
        this.conjurepanel.add(jButton2);
        this.conjurepanel.setVisible(false);
        this.statpanel = new JPanel();
        this.strength = new JTextField("0", 3);
        this.dexterity = new JTextField("0", 3);
        this.vitality = new JTextField("0", 3);
        this.intelligence = new JTextField("0", 3);
        this.wisdom = new JTextField("0", 3);
        this.flevel = new JTextField("0", 3);
        this.nlevel = new JTextField("0", 3);
        this.wlevel = new JTextField("0", 3);
        this.plevel = new JTextField("0", 3);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel4.add(new JLabel("Strength:"));
        jPanel4.add(this.strength);
        jPanel4.add(new JLabel("Dexterity:"));
        jPanel4.add(this.dexterity);
        jPanel4.add(new JLabel("Vitality:"));
        jPanel4.add(this.vitality);
        jPanel4.add(new JLabel("Intelligence:"));
        jPanel4.add(this.intelligence);
        jPanel4.add(new JLabel("Wisdom:"));
        jPanel4.add(this.wisdom);
        jPanel5.add(new JLabel("Fighter Level:"));
        jPanel5.add(this.flevel);
        jPanel5.add(new JLabel("Ninja Level:"));
        jPanel5.add(this.nlevel);
        jPanel5.add(new JLabel("Wizard Level:"));
        jPanel5.add(this.wlevel);
        jPanel5.add(new JLabel("Priest Level:"));
        jPanel5.add(this.plevel);
        this.statpanel.setLayout(new BoxLayout(this.statpanel, 1));
        this.statpanel.add(jPanel4);
        this.statpanel.add(jPanel5);
        this.statpanel.setVisible(false);
        this.weappanel = new JPanel();
        this.immbut = new JToggleButton("Hit Non-Material");
        this.diamondbut = new JToggleButton("Diamond Edge Style");
        this.stunbut = new JToggleButton("Stunning Blow");
        String[] stringArray = new String[]{"None", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
        this.poison = new JComboBox<String>(stringArray);
        this.poison.setSelectedIndex(0);
        this.weappanel.add(this.immbut);
        this.weappanel.add(this.diamondbut);
        this.weappanel.add(this.stunbut);
        this.weappanel.add(new JLabel("Poison:"));
        this.weappanel.add(this.poison);
        this.weappanel.setVisible(false);
        Box box2 = Box.createVerticalBox();
        box2.add(box);
        box2.add(this.conjurepanel);
        box2.add(this.statpanel);
        box2.add(this.weappanel);
        this.add(box2);
        if (lastability != null) {
            this.setAbility(lastability);
        }
    }

    public SpecialAbility createSpecial() {
        int n;
        int n2;
        int n3;
        if (this.name.getText().equals("")) {
            JOptionPane.showMessageDialog(this.dmed, "You must give the ability a name.", "Notice", 0);
            this.name.requestFocus();
            return null;
        }
        int[] nArray = new int[9];
        Object object = null;
        try {
            n3 = this.power.isVisible() ? Integer.parseInt(this.power.getText()) : this.castpower.getSelectedIndex() + 1;
            n2 = Integer.parseInt(this.speed.getText());
            n = Integer.parseInt(this.mana.getText());
            if (SpecialAbility.actions[this.actionbox.getSelectedIndex()].equals("Stat Boost")) {
                nArray[0] = Integer.parseInt(this.strength.getText());
                nArray[1] = Integer.parseInt(this.dexterity.getText());
                nArray[2] = Integer.parseInt(this.vitality.getText());
                nArray[3] = Integer.parseInt(this.intelligence.getText());
                nArray[4] = Integer.parseInt(this.wisdom.getText());
                nArray[5] = Integer.parseInt(this.flevel.getText());
                nArray[6] = Integer.parseInt(this.nlevel.getText());
                nArray[7] = Integer.parseInt(this.wlevel.getText());
                nArray[8] = Integer.parseInt(this.plevel.getText());
                object = nArray;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.dmed, "Invalid Number: " + numberFormatException.getMessage(), "Notice", 0);
            return null;
        }
        char c = this.classgain.getSelectedIndex() == 0 ? (char)'f' : (this.classgain.getSelectedIndex() == 1 ? (char)'n' : (this.classgain.getSelectedIndex() == 2 ? (char)'w' : (this.classgain.getSelectedIndex() == 3 ? (char)'p' : '-')));
        if (SpecialAbility.actions[this.actionbox.getSelectedIndex()].equals("Conjure")) {
            object = this.conjureitem;
        } else if (SpecialAbility.actions[this.actionbox.getSelectedIndex()].startsWith("Enhance")) {
            object = new int[4];
            if (this.immbut.isSelected()) {
                ((int[])object)[0] = 1;
            }
            if (this.diamondbut.isSelected()) {
                ((int[])object)[1] = 1;
            }
            if (this.stunbut.isSelected()) {
                ((int[])object)[2] = 1;
            }
            ((int[])object)[3] = this.poison.getSelectedIndex();
        }
        lastability = new SpecialAbility(this.name.getText(), this.sound.getText(), this.actionbox.getSelectedIndex(), c, n3, n2, n, this.lvlneed[0].getSelectedIndex(), this.lvlneed[1].getSelectedIndex(), this.lvlneed[2].getSelectedIndex(), this.lvlneed[3].getSelectedIndex(), 0, object);
        return lastability;
    }

    public void setAbility(SpecialAbility specialAbility) {
        int[] nArray;
        this.name.setText(specialAbility.name);
        this.sound.setText(specialAbility.sound);
        this.actionbox.setSelectedIndex(specialAbility.action);
        if (specialAbility.getActionName().equals("Conjure")) {
            this.conjureitem = Item.createCopy((Item)specialAbility.data);
            this.conjurelabel.setText(this.conjureitem.name);
        } else if (specialAbility.getActionName().equals("Stat Boost")) {
            nArray = (int[])specialAbility.data;
            this.strength.setText("" + nArray[0]);
            this.dexterity.setText("" + nArray[1]);
            this.vitality.setText("" + nArray[2]);
            this.intelligence.setText("" + nArray[3]);
            this.wisdom.setText("" + nArray[4]);
            this.flevel.setText("" + nArray[5]);
            this.nlevel.setText("" + nArray[6]);
            this.wlevel.setText("" + nArray[7]);
            this.plevel.setText("" + nArray[8]);
        } else if (specialAbility.getActionName().startsWith("Enhance")) {
            nArray = (int[])specialAbility.data;
            this.immbut.setSelected(nArray[0] != 0);
            this.diamondbut.setSelected(nArray[1] != 0);
            this.stunbut.setSelected(nArray[2] != 0);
            this.poison.setSelectedIndex(nArray[3]);
        }
        int n = specialAbility.classgain == 'f' ? 0 : (specialAbility.classgain == 'n' ? 1 : (specialAbility.classgain == 'w' ? 2 : (specialAbility.classgain == 'p' ? 3 : 4)));
        this.classgain.setSelectedIndex(n);
        if (this.power.isVisible()) {
            this.power.setText("" + specialAbility.power);
        } else if (this.castpower.isVisible()) {
            this.castpower.setSelectedIndex(specialAbility.power - 1);
        }
        this.speed.setText("" + specialAbility.speed);
        this.mana.setText("" + specialAbility.mana);
        this.lvlneed[0].setSelectedIndex(specialAbility.flevelneed);
        this.lvlneed[1].setSelectedIndex(specialAbility.nlevelneed);
        this.lvlneed[2].setSelectedIndex(specialAbility.wlevelneed);
        this.lvlneed[3].setSelectedIndex(specialAbility.plevelneed);
        lastability = specialAbility;
    }

    public boolean hasLastAbility() {
        return lastability != null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.actionbox) {
            int n = this.actionbox.getSelectedIndex();
            this.conjurepanel.setVisible(false);
            this.statpanel.setVisible(false);
            this.weappanel.setVisible(false);
            if (usenone.contains(SpecialAbility.actions[n])) {
                this.powerlabel.setVisible(false);
                this.power.setVisible(false);
                this.castpower.setVisible(false);
                if (SpecialAbility.actions[n].equals("Conjure")) {
                    this.conjurepanel.setVisible(true);
                } else if (SpecialAbility.actions[n].equals("Stat Boost")) {
                    this.statpanel.setVisible(true);
                }
            } else if (usesymbol.contains(SpecialAbility.actions[n])) {
                this.power.setVisible(false);
                this.powerlabel.setVisible(true);
                this.castpower.setVisible(true);
            } else {
                this.castpower.setVisible(false);
                this.powerlabel.setVisible(true);
                this.power.setVisible(true);
                if (SpecialAbility.actions[n].startsWith("Enhance")) {
                    this.weappanel.setVisible(true);
                }
            }
            this.validate();
        } else if (actionEvent.getActionCommand().startsWith("Browse")) {
            this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Sounds"));
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                this.sound.setText(string);
            }
        } else if (actionEvent.getActionCommand().equals("Change Item")) {
            DMEditor.itemwizard.setItem(this.conjureitem);
            Item item = DMEditor.itemwizard.getItem();
            if (item != null) {
                this.conjureitem = item;
            }
            if (this.conjureitem == null) {
                this.conjureitem = new Item(200);
            }
            this.conjurelabel.setText(this.conjureitem.name);
        }
    }
}

