/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

class AlcoveData
extends WallData {
    public ArrayList northside = new ArrayList();
    public ArrayList southside = new ArrayList();
    public ArrayList eastside = new ArrayList();
    public ArrayList westside = new ArrayList();
    public boolean isSwitch = false;
    public MultWallSwitchData alcoveswitchdata;

    public AlcoveData() {
        this.mapchar = (char)91;
    }

    public AlcoveData(MultWallSwitchData multWallSwitchData) {
        this.mapchar = (char)91;
        this.alcoveswitchdata = multWallSwitchData;
        this.isSwitch = true;
    }

    @Override
    public void addItem(Item item) {
        this.addItem(item, 0);
    }

    public void addItem(Item item, int n) {
        item.subsquare = n;
        if (n == 0) {
            this.northside.add(item);
        } else if (n == 1) {
            this.westside.add(item);
        } else if (n == 2) {
            this.southside.add(item);
        } else {
            this.eastside.add(item);
        }
        int n2 = n;
        this.numitemsin[n2] = this.numitemsin[n2] + 1;
    }

    @Override
    public void removeItem(int n) {
        this.removeItem(n, 0);
    }

    public Item removeItem(int n, int n2) {
        if (this.numitemsin[n2] == 0) {
            return null;
        }
        int n3 = n2;
        this.numitemsin[n3] = this.numitemsin[n3] - 1;
        Item item = n2 == 0 ? (Item)this.northside.remove(n) : (n2 == 1 ? (Item)this.westside.remove(n) : (n2 == 2 ? (Item)this.southside.remove(n) : (Item)this.eastside.remove(n)));
        return item;
    }

    public void changeItemSide(int n, int n2, int n3) {
        Item item = this.removeItem(n, n2);
        this.addItem(item, n3);
    }

    @Override
    public void changeLevel(int n, int n2) {
        if (this.isSwitch) {
            this.alcoveswitchdata.changeLevel(n, n2);
        }
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        if (this.isSwitch) {
            this.alcoveswitchdata.setMapCoord(n, n2, n3);
        }
    }

    @Override
    public String toString() {
        if (this.isSwitch) {
            return "4-Sided Alcove (Switch)";
        }
        return "4-Sided Alcove";
    }

    public boolean holdingItems() {
        return !this.northside.isEmpty() || !this.southside.isEmpty() || !this.eastside.isEmpty() || !this.westside.isEmpty();
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.northside);
        objectOutputStream.writeObject(this.southside);
        objectOutputStream.writeObject(this.eastside);
        objectOutputStream.writeObject(this.westside);
        objectOutputStream.writeBoolean(this.isSwitch);
        if (this.isSwitch) {
            this.alcoveswitchdata.save(objectOutputStream);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.northside = (ArrayList)objectInputStream.readObject();
        this.southside = (ArrayList)objectInputStream.readObject();
        this.eastside = (ArrayList)objectInputStream.readObject();
        this.westside = (ArrayList)objectInputStream.readObject();
        this.isSwitch = objectInputStream.readBoolean();
        if (this.isSwitch) {
            this.alcoveswitchdata = (MultWallSwitchData)DMEditor.loadMapData(objectInputStream, -1, 0, 0);
        }
    }
}

