/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class DecorationWizard
extends JDialog
implements ActionListener {
    private MapData data;
    private int side = 0;
    private int number = 0;
    private JToggleButton[] sidebutton;
    private JToggleButton[] decos;

    public DecorationWizard(JFrame jFrame) {
        super(jFrame, "Decoration Wizard", true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(10, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.decos = new JToggleButton[10];
        this.decos[0] = new JToggleButton("Ring");
        this.decos[1] = new JToggleButton("Hook");
        this.decos[2] = new JToggleButton("Slime");
        this.decos[3] = new JToggleButton("Grate");
        this.decos[4] = new JToggleButton("Drain");
        this.decos[5] = new JToggleButton("Crack");
        this.decos[6] = new JToggleButton("Scratches");
        this.decos[7] = new JToggleButton("Chaos");
        this.decos[8] = new JToggleButton("Chaos w/Glow");
        this.decos[9] = new JToggleButton("Demon Face");
        for (int i = 0; i < 10; ++i) {
            this.decos[i].setActionCommand("" + i);
            this.decos[i].addActionListener(this);
            buttonGroup.add(this.decos[i]);
            jPanel2.add(this.decos[i]);
        }
        this.decos[0].setSelected(true);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Decoration"));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 3));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.sidebutton = new JToggleButton[4];
        this.sidebutton[0] = new JToggleButton("North");
        this.sidebutton[1] = new JToggleButton("West");
        this.sidebutton[2] = new JToggleButton("South");
        this.sidebutton[3] = new JToggleButton("East");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        this.sidebutton[2].addActionListener(this);
        this.sidebutton[3].addActionListener(this);
        buttonGroup2.add(this.sidebutton[0]);
        buttonGroup2.add(this.sidebutton[1]);
        buttonGroup2.add(this.sidebutton[2]);
        buttonGroup2.add(this.sidebutton[3]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[0]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[1]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[3]);
        jPanel3.add(new JLabel());
        jPanel3.add(this.sidebutton[2]);
        jPanel3.add(new JLabel());
        this.sidebutton[2].setSelected(true);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Decoration Faces"));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        JButton jButton = new JButton("Done");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel5.add(jButton2);
        jPanel5.add(jButton);
        container.add("Center", jPanel);
        container.add("East", jPanel4);
        container.add("South", jPanel5);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.dispose();
    }

    public void setData(MapData mapData) {
        if (mapData.mapchar == 'D') {
            this.sidebutton[(((DecorationData)mapData).side + 2) % 4].doClick();
            this.decos[((DecorationData)mapData).number].doClick();
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            this.data = new DecorationData(this.side, this.number);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else {
            int n;
            try {
                n = Integer.parseInt(actionEvent.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            this.number = n;
        }
    }

    public MapData getData() {
        return this.data;
    }
}

