/*
 * Decompiled with CFR 0.152.
 */
import java.awt.DisplayMode;
import javax.swing.table.DefaultTableModel;

class DisplayModeModel
extends DefaultTableModel {
    private DisplayMode[] modes;

    public DisplayModeModel(DisplayMode[] displayModeArray) {
        this.modes = displayModeArray;
    }

    public DisplayMode getDisplayMode(int n) {
        return this.modes[n];
    }

    @Override
    public String getColumnName(int n) {
        return DisplayModeTest.COLUMN_NAMES[n];
    }

    @Override
    public int getColumnCount() {
        return DisplayModeTest.COLUMN_WIDTHS.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.modes == null) {
            return 0;
        }
        return this.modes.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DisplayMode displayMode = this.modes[n];
        switch (n2) {
            case 0: {
                return Integer.toString(displayMode.getWidth());
            }
            case 1: {
                return Integer.toString(displayMode.getHeight());
            }
            case 2: {
                int n3 = displayMode.getBitDepth();
                String string = n3 == -1 ? "Multi" : Integer.toString(n3);
                return string;
            }
            case 3: {
                int n4 = displayMode.getRefreshRate();
                String string = n4 == 0 ? "Unknown" : Integer.toString(n4);
                return string;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid column value");
    }
}

