/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class DisplayModeTest
extends JFrame
implements ActionListener,
ListSelectionListener {
    private boolean waiting = false;
    private GraphicsDevice device;
    private DisplayMode originalDM;
    private JButton exit = new JButton("Exit");
    private JButton changeDM = new JButton("Set Display");
    private JLabel currentDM = new JLabel();
    private JTable dmList = new JTable();
    private JScrollPane dmPane = new JScrollPane(this.dmList);
    private boolean isFullScreen = false;
    public static final int INDEX_WIDTH = 0;
    public static final int INDEX_HEIGHT = 1;
    public static final int INDEX_BITDEPTH = 2;
    public static final int INDEX_REFRESHRATE = 3;
    public static final int[] COLUMN_WIDTHS = new int[]{100, 100, 100, 100};
    public static final String[] COLUMN_NAMES = new String[]{"Width", "Height", "Bit Depth", "Refresh Rate"};

    public DisplayModeTest(GraphicsDevice graphicsDevice) {
        super(graphicsDevice.getDefaultConfiguration());
        this.device = graphicsDevice;
        this.setTitle("Display Mode Test");
        this.originalDM = graphicsDevice.getDisplayMode();
        this.setDMLabel(this.originalDM);
        this.setDefaultCloseOperation(3);
        this.exit.addActionListener(this);
        this.changeDM.addActionListener(this);
        this.changeDM.setEnabled(graphicsDevice.isDisplayChangeSupported());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.exit) {
            this.device.setDisplayMode(this.originalDM);
            System.exit(0);
        } else {
            int n = this.dmList.getSelectionModel().getAnchorSelectionIndex();
            if (n >= 0) {
                DisplayModeModel displayModeModel = (DisplayModeModel)this.dmList.getModel();
                DisplayMode displayMode = displayModeModel.getDisplayMode(n);
                this.device.setDisplayMode(displayMode);
                this.setDMLabel(displayMode);
                this.setSize(new Dimension(displayMode.getWidth(), displayMode.getHeight()));
                this.validate();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.changeDM.setEnabled(this.device.isDisplayChangeSupported());
    }

    private void initComponents(Container container) {
        Serializable serializable;
        this.setContentPane(container);
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        container.add((Component)jPanel, "North");
        JLabel jLabel = new JLabel("Current Display Mode : ");
        jPanel.add(jLabel);
        jPanel.add(this.currentDM);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        container.add((Component)jPanel2, "Center");
        for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
            serializable = new TableColumn(i, COLUMN_WIDTHS[i]);
            ((TableColumn)serializable).setIdentifier(COLUMN_NAMES[i]);
            ((TableColumn)serializable).setHeaderValue(COLUMN_NAMES[i]);
            this.dmList.addColumn((TableColumn)serializable);
        }
        this.dmList.getSelectionModel().setSelectionMode(0);
        this.dmList.getSelectionModel().addListSelectionListener(this);
        jPanel2.add(this.dmPane);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel3);
        serializable = new JPanel(new GridLayout(2, 1));
        jPanel3.add((Component)serializable, "North");
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        ((Container)serializable).add(jPanel4);
        jPanel4.add(this.exit);
        JPanel jPanel5 = new JPanel(new FlowLayout(1));
        ((Container)serializable).add(jPanel5);
        jPanel5.add(this.changeDM);
        jPanel3.add((Component)new JPanel(), "Center");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.dmList.setModel(new DisplayModeModel(this.device.getDisplayModes()));
        }
    }

    public void setDMLabel(DisplayMode displayMode) {
        int n = displayMode.getBitDepth();
        int n2 = displayMode.getRefreshRate();
        String string = n == -1 ? "Multi" : Integer.toString(n);
        String string2 = n2 == 0 ? "Unknown" : Integer.toString(n2);
        this.currentDM.setText(COLUMN_NAMES[0] + ": " + displayMode.getWidth() + " " + COLUMN_NAMES[1] + ": " + displayMode.getHeight() + " " + COLUMN_NAMES[2] + ": " + string + " " + COLUMN_NAMES[3] + ": " + string2);
    }

    public void begin() {
        this.isFullScreen = this.device.isFullScreenSupported();
        this.setUndecorated(this.isFullScreen);
        this.setResizable(!this.isFullScreen);
        if (this.isFullScreen) {
            this.device.setFullScreenWindow(this);
            this.validate();
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < 1; ++i) {
            DisplayModeTest displayModeTest = new DisplayModeTest(graphicsDeviceArray[i]);
            displayModeTest.initComponents(displayModeTest.getContentPane());
            displayModeTest.begin();
        }
    }
}

