/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;

class DoorWizard
extends JDialog
implements ActionListener,
MouseListener {
    private MapData data;
    private int level;
    private int x;
    private int y;
    private int side = 0;
    private int pictype;
    private int opentype = 1;
    private int keynumber = 31;
    private boolean isOpen;
    private boolean isBroken;
    private JScrollPane keypanel;
    private JScrollPane tpane1;
    private JPanel keypan2;
    private JPanel custompicpan;
    private JList keylist;
    private JToggleButton buttonbut;
    private JToggleButton keybut;
    private JToggleButton nonebut;
    private JToggleButton isopenbut;
    private JToggleButton isBreakable;
    private JToggleButton isbrokenbut;
    private JToggleButton resetcount;
    private JToggleButton consumeskey;
    private JToggleButton woodbut;
    private JToggleButton gratebut;
    private JToggleButton metalbut;
    private JToggleButton fancywoodbut;
    private JToggleButton fancymetalbut;
    private JToggleButton blackbut;
    private JToggleButton woodwbut;
    private JToggleButton blackwbut;
    private JToggleButton redbut;
    private JToggleButton glassbut;
    private JToggleButton ironcrossbut;
    private JToggleButton ironfacebut;
    private JToggleButton custombut;
    private JToggleButton transparent;
    private JToggleButton[] sidebutton;
    private JTextField maxcount;
    private JTextField count;
    private JTextField breakpoints;
    private JTextField picklock;
    private JTextField custompic;

    public DoorWizard(JFrame jFrame) {
        super(jFrame, "Door Wizard", true);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 520);
        this.setLocationRelativeTo(jFrame);
        Container container = this.getContentPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.woodbut = new JToggleButton("Wood");
        this.gratebut = new JToggleButton("Grate");
        this.metalbut = new JToggleButton("Metal");
        this.fancywoodbut = new JToggleButton("Fancy Wood");
        this.fancymetalbut = new JToggleButton("Fancy Metal");
        this.blackbut = new JToggleButton("Black");
        this.woodwbut = new JToggleButton("Wood w/Window");
        this.blackwbut = new JToggleButton("Black w/Window");
        this.redbut = new JToggleButton("Red");
        this.glassbut = new JToggleButton("Ven Glass");
        this.ironcrossbut = new JToggleButton("Iron Cross");
        this.ironfacebut = new JToggleButton("Iron Face");
        this.custombut = new JToggleButton("Custom...");
        this.woodbut.addActionListener(this);
        this.gratebut.addActionListener(this);
        this.metalbut.addActionListener(this);
        this.fancywoodbut.addActionListener(this);
        this.fancymetalbut.addActionListener(this);
        this.blackbut.addActionListener(this);
        this.woodwbut.addActionListener(this);
        this.blackwbut.addActionListener(this);
        this.redbut.addActionListener(this);
        this.glassbut.addActionListener(this);
        this.ironcrossbut.addActionListener(this);
        this.ironfacebut.addActionListener(this);
        this.custombut.addActionListener(this);
        buttonGroup.add(this.woodbut);
        buttonGroup.add(this.gratebut);
        buttonGroup.add(this.metalbut);
        buttonGroup.add(this.fancywoodbut);
        buttonGroup.add(this.fancymetalbut);
        buttonGroup.add(this.blackbut);
        buttonGroup.add(this.woodwbut);
        buttonGroup.add(this.blackwbut);
        buttonGroup.add(this.redbut);
        buttonGroup.add(this.glassbut);
        buttonGroup.add(this.ironcrossbut);
        buttonGroup.add(this.ironfacebut);
        buttonGroup.add(this.custombut);
        this.woodbut.setSelected(true);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.buttonbut = new JToggleButton("Button");
        this.keybut = new JToggleButton("Key");
        this.nonebut = new JToggleButton("Other");
        this.nonebut.addActionListener(this);
        this.buttonbut.addActionListener(this);
        this.keybut.addActionListener(this);
        buttonGroup2.add(this.nonebut);
        buttonGroup2.add(this.buttonbut);
        buttonGroup2.add(this.keybut);
        this.buttonbut.setSelected(true);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(13, 1, 6, 2));
        jPanel2.add(this.woodbut);
        jPanel2.add(this.gratebut);
        jPanel2.add(this.metalbut);
        jPanel2.add(this.fancywoodbut);
        jPanel2.add(this.fancymetalbut);
        jPanel2.add(this.blackbut);
        jPanel2.add(this.woodwbut);
        jPanel2.add(this.blackwbut);
        jPanel2.add(this.redbut);
        jPanel2.add(this.glassbut);
        jPanel2.add(this.ironcrossbut);
        jPanel2.add(this.ironfacebut);
        jPanel2.add(this.custombut);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(4, 1, 6, 2));
        jPanel3.add(new JLabel("Opens By:"));
        jPanel3.add(this.buttonbut);
        jPanel3.add(this.keybut);
        jPanel3.add(this.nonebut);
        this.tpane1 = new JScrollPane(jPanel2);
        this.tpane1.setPreferredSize(new Dimension(200, 260));
        jPanel.add(this.tpane1);
        jPanel.add(jPanel3);
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.custompicpan = new JPanel();
        this.custompicpan.add(new JLabel("Pics Name:"));
        this.custompic = new JTextField(10);
        this.custompicpan.add(this.custompic);
        this.transparent = new JToggleButton("See Items Behind");
        this.custompicpan.add(this.transparent);
        this.custompicpan.setVisible(false);
        this.isopenbut = new JToggleButton("Is Open");
        this.isBreakable = new JToggleButton("Is Breakable");
        this.isbrokenbut = new JToggleButton("Is Broken");
        this.isopenbut.addActionListener(this);
        this.isBreakable.addActionListener(this);
        this.isbrokenbut.addActionListener(this);
        this.breakpoints = new JTextField("80", 4);
        this.breakpoints.setEnabled(false);
        this.keylist = new JList<String>(ItemWizard.keyitems);
        this.keylist.addMouseListener(this);
        this.keylist.setSelectedIndex(0);
        this.keypanel = new JScrollPane(this.keylist);
        this.keypanel.setPreferredSize(new Dimension(80, 80));
        this.keypanel.setVisible(false);
        this.keypan2 = new JPanel();
        this.consumeskey = new JToggleButton("Key Disappears");
        this.keypan2.add(this.consumeskey);
        this.picklock = new JTextField("0", 4);
        this.keypan2.add(new JLabel("Pick Lock:"));
        this.keypan2.add(this.picklock);
        this.keypan2.setVisible(false);
        JLabel jLabel = new JLabel("Total Switch count:");
        this.maxcount = new JTextField("1", 3);
        JLabel jLabel2 = new JLabel("Remaining Switch count:");
        this.count = new JTextField("1", 3);
        this.resetcount = new JToggleButton("Count Resets");
        JPanel jPanel4 = new JPanel(new GridLayout(5, 1));
        jPanel4.setPreferredSize(new Dimension(190, 84));
        jPanel4.add(jLabel);
        jPanel4.add(this.maxcount);
        jPanel4.add(jLabel2);
        jPanel4.add(this.count);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.resetcount);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setPreferredSize(new Dimension(140, 70));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(2, 1));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.sidebutton = new JToggleButton[2];
        this.sidebutton[0] = new JToggleButton("North/South");
        this.sidebutton[1] = new JToggleButton("East/West");
        this.sidebutton[0].addActionListener(this);
        this.sidebutton[1].addActionListener(this);
        buttonGroup3.add(this.sidebutton[0]);
        buttonGroup3.add(this.sidebutton[1]);
        jPanel8.add(this.sidebutton[0]);
        jPanel8.add(this.sidebutton[1]);
        this.sidebutton[0].setSelected(true);
        JPanel jPanel9 = new JPanel();
        JLabel jLabel3 = new JLabel("Door Faces:");
        jLabel3.setHorizontalAlignment(0);
        jPanel9.add(jLabel3);
        jPanel7.add(jPanel9);
        jPanel7.add(jPanel8);
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel4);
        jPanel6.add(Box.createVerticalGlue());
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        box.add(jPanel);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(this.isopenbut);
        jPanel10.add(this.isBreakable);
        jPanel10.add(this.breakpoints);
        jPanel10.add(this.isbrokenbut);
        box.add(this.custompicpan);
        box.add(jPanel10);
        box.add(this.keypanel);
        box.add(this.keypan2);
        box.add(Box.createGlue());
        JPanel jPanel11 = new JPanel();
        jPanel11.add(box);
        JPanel jPanel12 = new JPanel();
        JButton jButton = new JButton("Done");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel12.add(jButton2);
        jPanel12.add(jButton);
        container.add("Center", jPanel11);
        container.add("South", jPanel12);
        container.add("East", jPanel6);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 'd') {
            DoorData doorData = (DoorData)mapData;
            this.sidebutton[doorData.side].doClick();
            if (doorData.pictype == 0) {
                this.woodbut.doClick();
            } else if (doorData.pictype == 1) {
                this.gratebut.doClick();
            } else if (doorData.pictype == 2) {
                this.metalbut.doClick();
            } else if (doorData.pictype == 3) {
                this.fancywoodbut.doClick();
            } else if (doorData.pictype == 4) {
                this.fancymetalbut.doClick();
            } else if (doorData.pictype == 5) {
                this.blackbut.doClick();
            } else if (doorData.pictype == 6) {
                this.woodwbut.doClick();
            } else if (doorData.pictype == 7) {
                this.blackwbut.doClick();
            } else if (doorData.pictype == 8) {
                this.redbut.doClick();
            } else if (doorData.pictype == 9) {
                this.glassbut.doClick();
            } else if (doorData.pictype == 10) {
                this.ironcrossbut.doClick();
            } else if (doorData.pictype == 11) {
                this.ironfacebut.doClick();
            } else if (doorData.pictype == 12) {
                this.custombut.doClick();
                this.custompic.setText(doorData.custompic);
                this.transparent.setSelected(doorData.transparent);
            }
            JViewport jViewport = this.tpane1.getViewport();
            jViewport.setViewPosition(new Point(0, doorData.pictype * 27));
            if (doorData.isBroken != this.isbrokenbut.isSelected()) {
                this.isbrokenbut.doClick();
            }
            if (doorData.isOpen != this.isopenbut.isSelected()) {
                this.isopenbut.doClick();
            }
            if (doorData.isBreakable != this.isBreakable.isSelected()) {
                this.isBreakable.doClick();
            }
            if (!doorData.isBroken && doorData.isBreakable) {
                this.breakpoints.setText("" + doorData.breakpoints);
                this.breakpoints.setEnabled(true);
            } else {
                this.breakpoints.setEnabled(false);
            }
            if (doorData.opentype == 0) {
                if (!this.nonebut.isSelected()) {
                    this.nonebut.doClick();
                }
            } else if (doorData.opentype == 1) {
                if (!this.buttonbut.isSelected()) {
                    this.buttonbut.doClick();
                }
            } else {
                if (!this.keybut.isSelected()) {
                    this.keybut.doClick();
                }
                this.keylist.setSelectedValue(ItemWizard.keyitems[doorData.keynumber - 31], true);
                this.keynumber = doorData.keynumber;
                this.consumeskey.setSelected(doorData.consumeskey);
                this.picklock.setText("" + doorData.picklock);
            }
            this.maxcount.setText("" + (doorData.maxcount + 1));
            this.count.setText("" + (doorData.count + 1));
            this.resetcount.setSelected(doorData.resetcount);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Wood")) {
            this.pictype = 0;
            if (!this.isBroken) {
                this.isBreakable.setEnabled(true);
                this.isbrokenbut.setEnabled(true);
                this.breakpoints.setText("80");
            }
        } else if (actionEvent.getActionCommand().equals("Grate")) {
            this.pictype = 1;
            if (!this.isBroken) {
                this.isBreakable.setEnabled(true);
                this.isbrokenbut.setEnabled(true);
                this.breakpoints.setText("280");
            }
        } else if (actionEvent.getActionCommand().equals("Metal")) {
            this.pictype = 2;
        } else if (actionEvent.getActionCommand().equals("Fancy Wood")) {
            this.pictype = 3;
        } else if (actionEvent.getActionCommand().equals("Fancy Metal")) {
            this.pictype = 4;
        } else if (actionEvent.getActionCommand().equals("Black")) {
            this.pictype = 5;
            if (!this.isBroken) {
                this.isBreakable.setEnabled(true);
                this.isbrokenbut.setEnabled(true);
                this.breakpoints.setText("160");
            }
        } else if (actionEvent.getActionCommand().equals("Wood w/Window")) {
            this.pictype = 6;
        } else if (actionEvent.getActionCommand().equals("Black w/Window")) {
            this.pictype = 7;
        } else if (actionEvent.getActionCommand().equals("Red")) {
            this.pictype = 8;
        } else if (actionEvent.getActionCommand().equals("Ven Glass")) {
            this.pictype = 9;
        } else if (actionEvent.getActionCommand().equals("Iron Cross")) {
            this.pictype = 10;
        } else if (actionEvent.getActionCommand().equals("Iron Face")) {
            this.pictype = 11;
        } else if (actionEvent.getActionCommand().equals("Custom...")) {
            this.pictype = 12;
            this.custompicpan.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Other")) {
            this.opentype = 0;
            this.keypanel.setVisible(false);
            this.keypan2.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("Button")) {
            this.opentype = 1;
            this.keypanel.setVisible(false);
            this.keypan2.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("Key")) {
            this.opentype = 2;
            this.keypanel.setVisible(true);
            this.keypan2.setVisible(true);
            this.validate();
        } else if (actionEvent.getActionCommand().equals("Is Open")) {
            this.isOpen = !this.isOpen;
        } else if (actionEvent.getActionCommand().equals("Is Breakable")) {
            if (this.isBreakable.isSelected()) {
                this.breakpoints.setEnabled(true);
            } else {
                this.breakpoints.setEnabled(false);
            }
        } else if (actionEvent.getActionCommand().equals("Is Broken")) {
            boolean bl = this.isBroken = !this.isBroken;
            if (this.isBroken) {
                this.isOpen = true;
                this.isopenbut.setSelected(true);
                this.isopenbut.setEnabled(false);
                this.isBreakable.setSelected(true);
                this.isBreakable.setEnabled(false);
                this.breakpoints.setEnabled(false);
            } else {
                this.isopenbut.setEnabled(true);
                this.isBreakable.setEnabled(true);
                this.breakpoints.setEnabled(true);
            }
        } else if (actionEvent.getActionCommand().equals("North/South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East/West")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("Done")) {
            if (this.opentype != 2) {
                this.keynumber = -1;
            }
            this.data = new DoorData(new MapPoint(this.level, this.x, this.y), this.side, this.pictype, this.opentype, this.isOpen, this.isBreakable.isSelected(), this.isBroken, this.keynumber, this.consumeskey.isSelected(), Integer.parseInt(this.maxcount.getText()) - 1, Integer.parseInt(this.count.getText()) - 1, this.resetcount.isSelected(), Integer.parseInt(this.picklock.getText()));
            try {
                if (this.isBreakable.isSelected() && !this.isBroken) {
                    ((DoorData)this.data).breakpoints = Integer.parseInt(this.breakpoints.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                ((DoorData)this.data).breakpoints = 80;
            }
            if (this.pictype == 12) {
                ((DoorData)this.data).custompic = this.custompic.getText();
                ((DoorData)this.data).transparent = this.transparent.isSelected();
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        }
        if (this.pictype > 1 && this.pictype != 5) {
            this.isBreakable.setSelected(false);
            this.isBreakable.setEnabled(false);
            this.isbrokenbut.setSelected(false);
            this.isbrokenbut.setEnabled(false);
            this.breakpoints.setText("");
            this.breakpoints.setEnabled(false);
            this.isBroken = false;
            this.isopenbut.setEnabled(true);
        }
        if (this.pictype != 12) {
            this.custompicpan.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.keynumber = ItemWizard.keynums[this.keylist.getSelectedIndex()];
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public MapData getData() {
        return this.data;
    }
}

