/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class EventWizard
extends JDialog
implements ActionListener,
MouseListener {
    private MapData data;
    private Box centerpanel;
    private JTextField[] line = new JTextField[6];
    private JTextField[] newline = new JTextField[6];
    private JTextField picname;
    private JTextField newpicname;
    private JTextField playsound;
    private JTextField choice;
    private JTextField statfield;
    private JTextField targetlevel;
    private JTextField targetx;
    private JTextField targety;
    private JTextField health;
    private JTextField stamina;
    private JTextField mana;
    private JTextField riddle;
    private JTextField riddlenum;
    private JTextField soundstring;
    private JTextField reusable;
    private JTextField fxp;
    private JTextField nxp;
    private JTextField wxp;
    private JTextField pxp;
    private JTextField needmonslvl;
    private Color textcolor;
    private Color textcolor2;
    private JComboBox eventface;
    private JComboBox picalign;
    private JComboBox textalign;
    private JComboBox newalign;
    private JComboBox needmons;
    private JLabel textcolorlabel;
    private JLabel textcolorlabel2;
    private JLabel needitemlabel;
    private JLabel receiveitemlabel;
    private JList choicelist;
    private JList actionlist;
    private JList visiblelist;
    private Vector choicevec;
    private Vector actionvec;
    private int choiceindex = -1;
    private int actionindex = -1;
    private JPanel makechoicepanel;
    private JPanel actionpanel;
    private JPanel newpicpanel;
    private JPanel soundpanel;
    private JPanel esoundpanel;
    private JPanel targetbox2;
    private JPanel healingbox;
    private JPanel newtextlines;
    private JPanel receiveitempanel;
    private JPanel needskillpanel;
    private JPanel visiblepanel;
    private JPanel riddlepanel;
    private JPanel changecolorpanel;
    private JPanel newalignpanel;
    private JPanel reusablepan;
    private JPanel xppanel;
    private JPanel needmonspanel;
    private AbilityPanel abilitypanel;
    private JComboBox actionbox;
    private JComboBox needskillbox;
    private JComboBox levelbox;
    private JToggleButton visiblebut;
    private JToggleButton needitembut;
    private JToggleButton takeitembut;
    private JToggleButton loopsound;
    private JToggleButton needdead;
    private JToggleButton autotrigger;
    private JToggleButton blackback;
    private HeroPanel heropanel;
    private HeroData hero;
    private Item itemneeded;
    private Item itemreceived;
    private JButton done;
    private DMEditor dmed;

    public EventWizard(DMEditor dMEditor) {
        super(dMEditor, "Event Square Wizard", true);
        this.dmed = dMEditor;
        this.setDefaultCloseOperation(2);
        this.setSize(840, 600);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.picname = new JTextField(10);
        jPanel.add(new JLabel("Filename (blank for none):"));
        jPanel.add(this.picname);
        JButton jButton = new JButton("Browse");
        jButton.setActionCommand("Browse1");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        String[] stringArray = new String[]{"Bottom", "Center", "Top"};
        this.picalign = new JComboBox<String>(stringArray);
        jPanel.add(this.picalign);
        this.blackback = new JToggleButton("Black Background");
        this.blackback.setSelected(true);
        jPanel.add(this.blackback);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Initial Picture"));
        JPanel jPanel2 = new JPanel();
        Box box = Box.createVerticalBox();
        for (int i = 0; i < 6; ++i) {
            this.line[i] = new JTextField(24);
            this.line[i].setFont(DMEditor.scrollfont);
            box.add(this.line[i]);
        }
        jPanel2.add(box);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Initial Message"));
        JPanel jPanel3 = new JPanel();
        this.choicevec = new Vector();
        this.choicelist = new JList(this.choicevec);
        this.choicelist.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.choicelist);
        jScrollPane.setPreferredSize(new Dimension(250, 120));
        JButton jButton2 = new JButton("Add/Edit Choice");
        JButton jButton3 = new JButton("Delete Choice");
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton("Move Choice Up");
        JButton jButton5 = new JButton("Move Choice Down");
        jButton4.addActionListener(this);
        jButton5.addActionListener(this);
        Box box2 = Box.createVerticalBox();
        box2.add(jButton2);
        box2.add(jButton3);
        box2.add(jButton4);
        box2.add(jButton5);
        jPanel3.add(jScrollPane);
        jPanel3.add(box2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Choices"));
        JPanel jPanel4 = new JPanel();
        String[] stringArray2 = new String[]{"Any", "North", "West", "South", "East"};
        this.eventface = new JComboBox<String>(stringArray2);
        this.eventface.setSelectedIndex(0);
        jPanel4.add(this.eventface);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Direction Party Must Face To Trigger"));
        JPanel jPanel5 = new JPanel();
        this.textcolor = Color.white;
        this.textcolorlabel = new JLabel("Text Color");
        this.textcolorlabel.setForeground(this.textcolor);
        JButton jButton6 = new JButton("Set Text Color");
        jButton6.addActionListener(this);
        jPanel5.add(this.textcolorlabel);
        jPanel5.add(jButton6);
        this.textalign = new JComboBox<String>(stringArray);
        jPanel5.add(this.textalign);
        this.esoundpanel = new JPanel();
        this.esoundpanel.add(new JLabel("Filename (blank for none):"));
        this.soundstring = new JTextField(10);
        this.esoundpanel.add(this.soundstring);
        JButton jButton7 = new JButton("Browse");
        jButton7.setActionCommand("Browse4");
        jButton7.addActionListener(this);
        this.esoundpanel.add(jButton7);
        this.loopsound = new JToggleButton("Loop");
        this.esoundpanel.add(this.loopsound);
        this.esoundpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Initial Sound"));
        JPanel jPanel6 = new JPanel();
        this.choice = new JTextField("Leave", 15);
        jPanel6.add(new JLabel("Choice Name:"));
        jPanel6.add(this.choice);
        this.visiblebut = new JToggleButton("Choice Visible");
        this.visiblebut.setSelected(true);
        jPanel6.add(this.visiblebut);
        this.autotrigger = new JToggleButton("Auto-Trigger");
        jPanel6.add(this.autotrigger);
        JPanel jPanel7 = new JPanel();
        this.actionlist = new JList();
        this.actionlist.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.actionlist);
        jScrollPane2.setPreferredSize(new Dimension(250, 120));
        JButton jButton8 = new JButton("Add/Edit Action");
        JButton jButton9 = new JButton("Delete Action");
        JButton jButton10 = new JButton("Move Action Up");
        JButton jButton11 = new JButton("Move Action Down");
        jButton8.addActionListener(this);
        jButton9.addActionListener(this);
        jButton10.addActionListener(this);
        jButton11.addActionListener(this);
        Box box3 = Box.createVerticalBox();
        box3.add(jButton8);
        box3.add(jButton9);
        box3.add(jButton10);
        box3.add(jButton11);
        jPanel7.add(jScrollPane2);
        jPanel7.add(box3);
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Actions"));
        JPanel jPanel8 = new JPanel();
        this.needitemlabel = new JLabel();
        this.needitembut = new JToggleButton("Item Required");
        this.needitembut.addActionListener(this);
        this.takeitembut = new JToggleButton("Item Taken");
        this.takeitembut.setSelected(true);
        this.takeitembut.setVisible(false);
        jPanel8.add(this.needitemlabel);
        jPanel8.add(this.needitembut);
        jPanel8.add(this.takeitembut);
        jPanel8.setBorder(BorderFactory.createEtchedBorder());
        this.needskillpanel = new JPanel();
        String[] stringArray3 = new String[]{"None", "Fighter", "Ninja", "Wizard", "Priest", "Strength", "Dexterity", "Vitality", "Intelligence", "Wisdom", "Average Level", "Average Stat"};
        this.needskillbox = new JComboBox<String>(stringArray3);
        this.needskillbox.addActionListener(this);
        String[] stringArray4 = new String[]{"Neophyte", "Novice", "Apprentice", "Journeyman", "Craftsman", "Artisan", "Adept", "Expert", "LO Master", "UM Master", "ON Master", "EE Master", "PAL Master", "MON Master", "ArchMaster"};
        this.levelbox = new JComboBox<String>(stringArray4);
        this.levelbox.setVisible(false);
        this.statfield = new JTextField("50", 3);
        this.statfield.setVisible(false);
        this.needskillpanel.add(this.needskillbox);
        this.needskillpanel.add(this.levelbox);
        this.needskillpanel.add(this.statfield);
        this.needskillpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Skill Required"));
        this.needmonspanel = new JPanel();
        this.needmons = new JComboBox<String>(MonsterWizard.monsternames);
        this.needmons.insertItemAt("None", 0);
        for (int i = 0; i < MonsterWizard.custommons.size(); ++i) {
            this.needmons.addItem(MonsterWizard.custommons.get(i));
        }
        this.needmons.setSelectedIndex(0);
        this.needmonslvl = new JTextField("0", 3);
        this.needdead = new JToggleButton("Need Them Dead");
        this.needdead.setSelected(true);
        this.needmonspanel.add(new JLabel("Monster:"));
        this.needmonspanel.add(this.needmons);
        this.needmonspanel.add(new JLabel("Dungeon Level:"));
        this.needmonspanel.add(this.needmonslvl);
        this.needmonspanel.add(this.needdead);
        this.needmonspanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Requires Monsters Dead or Alive"));
        this.makechoicepanel = new JPanel();
        this.makechoicepanel.setLayout(new BoxLayout(this.makechoicepanel, 1));
        this.makechoicepanel.add(jPanel6);
        this.makechoicepanel.add(jPanel7);
        this.makechoicepanel.add(jPanel8);
        this.makechoicepanel.add(this.needskillpanel);
        this.makechoicepanel.add(this.needmonspanel);
        this.makechoicepanel.setVisible(false);
        this.actionbox = new JComboBox<String>(Action.actionnames);
        this.actionbox.addActionListener(this);
        this.reusablepan = new JPanel();
        this.reusable = new JTextField("-1", 3);
        this.reusablepan.add(new JLabel("Number of Reuses (-1 is Infinite)"));
        this.reusablepan.add(this.reusable);
        Box box4 = Box.createVerticalBox();
        Box box5 = Box.createVerticalBox();
        JLabel jLabel = new JLabel(" Level ");
        JLabel jLabel2 = new JLabel("    X");
        JLabel jLabel3 = new JLabel("    Y");
        jLabel2.setHorizontalAlignment(0);
        jLabel3.setHorizontalAlignment(0);
        this.targetlevel = new JTextField("0", 3);
        this.targetx = new JTextField("0", 3);
        this.targety = new JTextField("0", 3);
        box4.add(jLabel);
        box4.add(Box.createVerticalStrut(14));
        box4.add(jLabel2);
        box4.add(Box.createVerticalStrut(15));
        box4.add(jLabel3);
        box5.add(this.targetlevel);
        box5.add(Box.createVerticalStrut(10));
        box5.add(this.targetx);
        box5.add(Box.createVerticalStrut(10));
        box5.add(this.targety);
        Box box6 = Box.createHorizontalBox();
        box6.add(box4);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(box5);
        JButton jButton12 = new JButton("From Map...");
        jButton12.addActionListener(this);
        this.targetbox2 = new JPanel();
        this.targetbox2.setLayout(new BoxLayout(this.targetbox2, 1));
        Dimension dimension = new Dimension(200, 180);
        this.targetbox2.setPreferredSize(dimension);
        this.targetbox2.setMaximumSize(dimension);
        this.targetbox2.add(box6);
        this.targetbox2.add(Box.createVerticalStrut(10));
        this.targetbox2.add(jButton12);
        this.targetbox2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Target"));
        this.targetbox2.setVisible(false);
        JLabel jLabel4 = new JLabel("Health");
        JLabel jLabel5 = new JLabel("Stamina");
        JLabel jLabel6 = new JLabel("Mana");
        jLabel4.setHorizontalAlignment(0);
        jLabel5.setHorizontalAlignment(0);
        jLabel6.setHorizontalAlignment(0);
        this.health = new JTextField("50", 4);
        this.stamina = new JTextField("0", 4);
        this.mana = new JTextField("0", 4);
        this.healingbox = new JPanel();
        this.healingbox.setLayout(new GridLayout(3, 2, 5, 5));
        Dimension dimension2 = new Dimension(200, 110);
        this.healingbox.setPreferredSize(dimension2);
        this.healingbox.setMaximumSize(dimension2);
        this.healingbox.add(jLabel4);
        this.healingbox.add(this.health);
        this.healingbox.add(jLabel5);
        this.healingbox.add(this.stamina);
        this.healingbox.add(jLabel6);
        this.healingbox.add(this.mana);
        this.healingbox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Healing"));
        this.healingbox.setVisible(false);
        this.heropanel = new HeroPanel(dMEditor, DMEditor.dungfont);
        this.heropanel.setModal(true);
        this.receiveitempanel = new JPanel();
        this.receiveitemlabel = new JLabel("none");
        JButton jButton13 = new JButton("Change Item");
        jButton13.addActionListener(this);
        this.receiveitempanel.add(this.receiveitemlabel);
        this.receiveitempanel.add(jButton13);
        this.receiveitempanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Item Received"));
        this.receiveitempanel.setVisible(false);
        this.newtextlines = new JPanel();
        Box box7 = Box.createVerticalBox();
        for (int i = 0; i < 6; ++i) {
            this.newline[i] = new JTextField(24);
            this.newline[i].setFont(DMEditor.scrollfont);
            box7.add(this.newline[i]);
        }
        this.newtextlines.add(box7);
        this.newtextlines.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "New Text"));
        this.newtextlines.setVisible(false);
        this.newpicpanel = new JPanel();
        this.newpicname = new JTextField(10);
        this.newpicpanel.add(this.newpicname);
        JButton jButton14 = new JButton("Browse");
        jButton14.setActionCommand("Browse2");
        jButton14.addActionListener(this);
        this.newpicpanel.add(jButton14);
        this.newpicpanel.setVisible(false);
        this.soundpanel = new JPanel();
        this.playsound = new JTextField(10);
        this.soundpanel.add(this.playsound);
        JButton jButton15 = new JButton("Browse");
        jButton15.setActionCommand("Browse3");
        jButton15.addActionListener(this);
        this.soundpanel.add(jButton15);
        this.soundpanel.setVisible(false);
        this.visiblepanel = new JPanel();
        this.visiblelist = new JList(this.choicevec);
        JScrollPane jScrollPane3 = new JScrollPane(this.visiblelist);
        jScrollPane3.setPreferredSize(new Dimension(250, 160));
        this.visiblepanel.add(jScrollPane3);
        this.visiblepanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Choices To Set Visibile/Invisible"));
        this.visiblepanel.setVisible(false);
        this.abilitypanel = new AbilityPanel(dMEditor);
        this.abilitypanel.setVisible(false);
        this.riddle = new JTextField("Answer Goes Here", 20);
        this.riddlenum = new JTextField("1", 3);
        this.riddlepanel = new JPanel();
        this.riddlepanel.add(this.riddle);
        this.riddlepanel.add(new JLabel("Number Of Actions If Correct:"));
        this.riddlepanel.add(this.riddlenum);
        this.riddlepanel.setVisible(false);
        this.textcolorlabel2 = new JLabel("New Text Color");
        this.textcolor2 = Color.black;
        this.textcolorlabel2.setForeground(this.textcolor2);
        JButton jButton16 = new JButton("Change Color");
        jButton16.addActionListener(this);
        this.changecolorpanel = new JPanel();
        this.changecolorpanel.add(this.textcolorlabel2);
        this.changecolorpanel.add(jButton16);
        this.changecolorpanel.setVisible(false);
        this.newalign = new JComboBox<String>(stringArray);
        this.newalignpanel = new JPanel();
        this.newalignpanel.add(this.newalign);
        this.newalignpanel.setVisible(false);
        this.xppanel = new JPanel();
        this.fxp = new JTextField("0", 4);
        this.nxp = new JTextField("0", 4);
        this.wxp = new JTextField("0", 4);
        this.pxp = new JTextField("0", 4);
        this.xppanel.add(new JLabel("Fighter:"));
        this.xppanel.add(this.fxp);
        this.xppanel.add(new JLabel("Ninja:"));
        this.xppanel.add(this.nxp);
        this.xppanel.add(new JLabel("Wizard:"));
        this.xppanel.add(this.wxp);
        this.xppanel.add(new JLabel("Priest:"));
        this.xppanel.add(this.pxp);
        this.xppanel.setVisible(false);
        this.actionpanel = new JPanel();
        this.actionpanel.setLayout(new BoxLayout(this.actionpanel, 1));
        JPanel jPanel9 = new JPanel();
        jPanel9.add(new JLabel("Action Type:"));
        jPanel9.add(this.actionbox);
        jPanel9.add(this.reusablepan);
        this.actionpanel.add(jPanel9);
        this.actionpanel.add(this.targetbox2);
        this.actionpanel.add(this.healingbox);
        this.actionpanel.add(this.receiveitempanel);
        this.actionpanel.add(this.newtextlines);
        this.actionpanel.add(this.newpicpanel);
        this.actionpanel.add(this.soundpanel);
        this.actionpanel.add(this.visiblepanel);
        this.actionpanel.add(this.abilitypanel);
        this.actionpanel.add(this.riddlepanel);
        this.actionpanel.add(this.changecolorpanel);
        this.actionpanel.add(this.newalignpanel);
        this.actionpanel.add(this.xppanel);
        this.actionpanel.setVisible(false);
        this.centerpanel = Box.createVerticalBox();
        this.centerpanel.add(jPanel4);
        this.centerpanel.add(jPanel);
        this.centerpanel.add(this.esoundpanel);
        this.centerpanel.add(jPanel2);
        this.centerpanel.add(jPanel3);
        this.centerpanel.add(jPanel5);
        JPanel jPanel10 = new JPanel();
        this.done = new JButton("Done");
        JButton jButton17 = new JButton("Cancel");
        this.done.setActionCommand("Done");
        this.done.addActionListener(this);
        jButton17.addActionListener(this);
        jPanel10.add(jButton17);
        jPanel10.add(this.done);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.add(this.centerpanel);
        jPanel11.add(this.makechoicepanel);
        jPanel11.add(this.actionpanel);
        jPanel11.add(Box.createVerticalGlue());
        container.add(jPanel11);
        container.add("South", jPanel10);
        this.dispose();
    }

    public void setData(MapData mapData) {
        if (mapData.mapchar == 'E') {
            EventSquareData eventSquareData = (EventSquareData)mapData;
            this.eventface.setSelectedIndex(eventSquareData.eventface);
            if (eventSquareData.picname != null) {
                this.picname.setText(eventSquareData.picname);
            } else {
                this.picname.setText("");
            }
            this.picalign.setSelectedIndex(eventSquareData.picalign);
            this.blackback.setSelected(eventSquareData.blackback);
            for (int i = 0; i < 6; ++i) {
                if (eventSquareData.eventtext != null && i < eventSquareData.eventtext.length) {
                    this.line[i].setText(eventSquareData.eventtext[i]);
                    continue;
                }
                this.line[i].setText("");
            }
            this.textcolor = eventSquareData.textcolor;
            this.textcolorlabel.setForeground(this.textcolor);
            this.textalign.setSelectedIndex(eventSquareData.textalign);
            if (eventSquareData.soundstring != null) {
                this.soundstring.setText(eventSquareData.soundstring);
                this.loopsound.setSelected(eventSquareData.loopsound);
            } else {
                this.soundstring.setText("");
                this.loopsound.setSelected(false);
            }
            this.heropanel.removeHeroes();
            this.choicevec.clear();
            for (int i = 0; i < eventSquareData.choices.length; ++i) {
                Choice choice = new Choice(eventSquareData.choices[i].choicename);
                choice.visible = eventSquareData.choices[i].visible;
                choice.autotrigger = eventSquareData.choices[i].autotrigger;
                choice.needitem = eventSquareData.choices[i].needitem;
                choice.takeitem = eventSquareData.choices[i].takeitem;
                choice.needskill = eventSquareData.choices[i].needskill;
                choice.needmons = eventSquareData.choices[i].needmons;
                choice.needmonslvl = eventSquareData.choices[i].needmonslvl;
                choice.needdead = eventSquareData.choices[i].needdead;
                choice.actions = new Vector();
                for (int j = 0; j < eventSquareData.choices[i].actions.size(); ++j) {
                    choice.actions.add(eventSquareData.choices[i].actions.get(j));
                }
                this.choicevec.add(choice);
            }
        } else {
            this.choicevec.clear();
            this.choicevec.add(Choice.makeLeave());
        }
        this.choicelist.setListData(this.choicevec);
        this.choiceindex = -1;
        this.show();
    }

    public void updateMons() {
        while (this.needmons.getItemCount() > 29) {
            this.needmons.removeItemAt(29);
        }
        for (int i = 0; i < MonsterWizard.custommons.size(); ++i) {
            this.needmons.addItem(MonsterWizard.custommons.get(i));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (this.actionpanel.isVisible()) {
                this.actionpanel.setVisible(false);
                this.makechoicepanel.setVisible(true);
                if (this.actionindex == -1) {
                    this.actionvec.add(this.makeAction());
                } else {
                    this.actionvec.set(this.actionindex, this.makeAction());
                }
                this.actionlist.setListData(this.actionvec);
                this.actionindex = -1;
                this.done.setText("Done Creating Choice");
            } else if (this.makechoicepanel.isVisible()) {
                this.makechoicepanel.setVisible(false);
                this.centerpanel.setVisible(true);
                if (this.choiceindex == -1) {
                    this.choicevec.add(this.makeChoice());
                } else {
                    this.choicevec.set(this.choiceindex, this.makeChoice());
                }
                this.choicelist.setListData(this.choicevec);
                this.choiceindex = -1;
                this.done.setText("Done");
            } else if (this.choicevec.size() > 0) {
                Object object = this.line[5].getText().equals("") ? (this.line[4].getText().equals("") ? (this.line[3].getText().equals("") ? (this.line[2].getText().equals("") ? (this.line[1].getText().equals("") ? (this.line[0].getText().equals("") ? null : new String[1]) : new String[2]) : new String[3]) : new String[4]) : new String[5]) : new String[6];
                if (object != null) {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        object[i] = this.line[i].getText().trim();
                    }
                }
                Choice[] choiceArray = new Choice[this.choicevec.size()];
                for (int i = 0; i < this.choicevec.size(); ++i) {
                    choiceArray[i] = (Choice)this.choicevec.get(i);
                }
                this.data = new EventSquareData(this.eventface.getSelectedIndex(), this.picname.getText(), this.picalign.getSelectedIndex(), this.blackback.isSelected(), this.textcolor, this.textalign.getSelectedIndex(), (String[])object, this.soundstring.getText(), this.loopsound.isSelected(), choiceArray);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.dmed, "Events must have at least one choice!", "Notice", 0);
            }
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            if (this.actionpanel.isVisible()) {
                this.actionpanel.setVisible(false);
                this.makechoicepanel.setVisible(true);
                this.done.setText("Done Creating Choice");
            } else if (this.makechoicepanel.isVisible()) {
                this.makechoicepanel.setVisible(false);
                this.centerpanel.setVisible(true);
                this.done.setText("Done");
            } else {
                this.data = null;
                this.dispose();
            }
        } else if (actionEvent.getActionCommand().equals("Set Text Color")) {
            Color color = JColorChooser.showDialog(this, "Set Text Color", this.textcolor);
            if (color != null) {
                this.textcolor = color;
                this.textcolorlabel.setForeground(this.textcolor);
                this.textcolorlabel.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("Change Color")) {
            Color color = JColorChooser.showDialog(this, "Set Text Color", this.textcolor2);
            if (color != null) {
                this.textcolor2 = color;
                this.textcolorlabel2.setForeground(this.textcolor2);
                this.textcolorlabel2.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("Add/Edit Choice")) {
            Choice choice;
            this.centerpanel.setVisible(false);
            if (this.choiceindex == -1) {
                choice = new Choice("Choice " + this.choicevec.size());
                choice.actions = new Vector();
            } else {
                choice = (Choice)this.choicevec.get(this.choiceindex);
            }
            this.choice.setText(choice.choicename);
            this.visiblebut.setSelected(choice.visible);
            this.autotrigger.setSelected(choice.autotrigger);
            this.needitembut.setSelected(choice.needitem != null);
            if (this.needitembut.isSelected()) {
                this.takeitembut.setSelected(choice.takeitem);
                this.takeitembut.setVisible(true);
            } else {
                this.takeitembut.setVisible(false);
            }
            if (this.needitembut.isSelected()) {
                this.needitemlabel.setText(choice.needitem.name);
            } else {
                this.needitemlabel.setText("");
            }
            if (choice.needskill == null) {
                this.needskillbox.setSelectedIndex(0);
            } else {
                this.needskillbox.setSelectedIndex(choice.needskill[0] + 1);
                if (this.levelbox.isVisible()) {
                    this.levelbox.setSelectedIndex(choice.needskill[1] - 1);
                } else {
                    this.statfield.setText("" + choice.needskill[1]);
                }
            }
            this.needmons.setSelectedIndex(choice.needmons + 1);
            this.needmonslvl.setText("" + choice.needmonslvl);
            this.needdead.setSelected(choice.needdead);
            this.actionvec = new Vector();
            for (int i = 0; i < choice.actions.size(); ++i) {
                this.actionvec.add(choice.actions.get(i));
            }
            this.actionlist.setListData(this.actionvec);
            this.actionindex = -1;
            this.makechoicepanel.setVisible(true);
            this.done.setText("Done Creating Choice");
        } else if (actionEvent.getActionCommand().equals("Add/Edit Action")) {
            this.makechoicepanel.setVisible(false);
            Action action = this.actionindex == -1 ? new Action(0, null, -1) : (Action)this.actionvec.get(this.actionindex);
            if (action.actiontype == 4) {
                this.hero = new HeroData((HeroData)action.action);
                this.heropanel.removeHeroes();
            } else if (action.actiontype == 5) {
                this.itemreceived = (Item)action.action;
                this.receiveitemlabel.setText(this.itemreceived.name);
            }
            this.reusable.setText("" + action.reusable);
            this.actionbox.setSelectedIndex(action.actiontype);
            if (action.actiontype > 0 && action.actiontype < 4) {
                int n = ((MapPoint)action.action).level;
                int n2 = ((MapPoint)action.action).x;
                int n3 = ((MapPoint)action.action).y;
                this.targetlevel.setText("" + n);
                this.targetx.setText("" + n2);
                this.targety.setText("" + n3);
            } else if (action.actiontype == 6) {
                int n = ((MapPoint)action.action).level;
                int n4 = ((MapPoint)action.action).x;
                int n5 = ((MapPoint)action.action).y;
                this.health.setText("" + n);
                this.stamina.setText("" + n4);
                this.mana.setText("" + n5);
            } else if (action.actiontype == 7) {
                for (int i = 0; i < ((String[])action.action).length; ++i) {
                    this.newline[i].setText(((String[])action.action)[i]);
                }
            } else if (action.actiontype == 8) {
                this.newpicname.setText((String)action.action);
            } else if (action.actiontype == 9) {
                this.playsound.setText((String)action.action);
            } else if (action.actiontype == 10 || action.actiontype == 11) {
                this.visiblelist.setSelectedIndices((int[])action.action);
            } else if (action.actiontype == 12) {
                this.abilitypanel.setAbility((SpecialAbility)action.action);
            } else if (action.actiontype == 13) {
                String string = (String)action.action;
                String string2 = string.substring(string.lastIndexOf(126) + 1);
                string = string.substring(0, string.lastIndexOf(126));
                this.riddle.setText(string);
                this.riddlenum.setText(string2);
            } else if (action.actiontype == 14) {
                this.textcolor2 = (Color)action.action;
                this.textcolorlabel2.setForeground(this.textcolor2);
            } else if (action.actiontype == 15 || action.actiontype == 16) {
                this.newalign.setSelectedIndex((Integer)action.action);
            } else if (action.actiontype == 17) {
                this.fxp.setText("" + ((int[])action.action)[0]);
                this.nxp.setText("" + ((int[])action.action)[1]);
                this.wxp.setText("" + ((int[])action.action)[2]);
                this.pxp.setText("" + ((int[])action.action)[3]);
            }
            this.actionpanel.setVisible(true);
            this.done.setText("Done Creating Action");
        } else if (actionEvent.getActionCommand().equals("Delete Choice")) {
            if (this.choiceindex != -1) {
                this.choicevec.remove(this.choiceindex);
                this.choicelist.setListData(this.choicevec);
                this.choiceindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Delete Action")) {
            if (this.actionindex != -1) {
                this.actionvec.remove(this.actionindex);
                this.actionlist.setListData(this.actionvec);
                this.actionindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Move Choice Up")) {
            if (this.choiceindex > 0) {
                Choice choice = (Choice)this.choicevec.remove(this.choiceindex);
                this.choicevec.add(this.choiceindex - 1, choice);
                this.choicelist.setListData(this.choicevec);
                this.choiceindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Move Choice Down")) {
            if (this.choiceindex != -1 && this.choicevec.size() > 1 && this.choiceindex < this.choicevec.size() - 1) {
                Choice choice = (Choice)this.choicevec.remove(this.choiceindex);
                this.choicevec.add(this.choiceindex + 1, choice);
                this.choicelist.setListData(this.choicevec);
                this.choiceindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Move Action Up")) {
            if (this.actionindex > 0) {
                Action action = (Action)this.actionvec.remove(this.actionindex);
                this.actionvec.add(this.actionindex - 1, action);
                this.actionlist.setListData(this.actionvec);
                this.actionindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Move Action Down")) {
            if (this.actionindex != -1 && this.actionvec.size() > 1 && this.actionindex < this.actionvec.size() - 1) {
                Action action = (Action)this.actionvec.remove(this.actionindex);
                this.actionvec.add(this.actionindex + 1, action);
                this.actionlist.setListData(this.actionvec);
                this.actionindex = -1;
            }
        } else if (actionEvent.getActionCommand().startsWith("Browse")) {
            char c = actionEvent.getActionCommand().charAt(6);
            if (c == '3' || c == '4') {
                this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Sounds"));
            } else {
                this.dmed.chooser.setCurrentDirectory(new File(this.dmed.workingdir, "Events"));
            }
            int n = this.dmed.chooser.showOpenDialog(this);
            String string = null;
            if (n == 0) {
                string = this.dmed.chooser.getSelectedFile().getName();
            }
            if (string != null) {
                if (c == '2') {
                    this.newpicname.setText(string);
                } else if (c == '3') {
                    this.playsound.setText(string);
                } else if (c == '4') {
                    this.soundstring.setText(string);
                } else {
                    this.picname.setText(string);
                }
            }
        } else if (actionEvent.getActionCommand().equals("From Map...")) {
            DMEditor.targetframe.show();
            MapPoint mapPoint = DMEditor.targetframe.getTarget();
            if (mapPoint != null) {
                this.targetlevel.setText("" + mapPoint.level);
                this.targetx.setText("" + mapPoint.x);
                this.targety.setText("" + mapPoint.y);
            }
        } else if (actionEvent.getActionCommand().equals("Item Required")) {
            if (this.needitembut.isSelected()) {
                Item item;
                DMEditor.itemwizard.show();
                this.itemneeded = item = DMEditor.itemwizard.getItem();
                if (this.itemneeded != null) {
                    this.needitemlabel.setText(this.itemneeded.name);
                    this.takeitembut.setVisible(true);
                } else {
                    this.needitemlabel.setText("");
                    this.takeitembut.setVisible(false);
                    this.needitembut.setSelected(false);
                }
            } else {
                this.itemneeded = null;
                this.needitemlabel.setText("");
                this.takeitembut.setVisible(false);
            }
        } else if (actionEvent.getActionCommand().equals("Change Item")) {
            DMEditor.itemwizard.setItem(this.itemreceived);
            Item item = DMEditor.itemwizard.getItem();
            if (item != null) {
                this.itemreceived = item;
            }
            if (this.itemreceived == null) {
                this.itemreceived = new Item(200);
            }
            this.receiveitemlabel.setText(this.itemreceived.name);
        } else if (actionEvent.getSource() == this.actionbox) {
            int n = this.actionbox.getSelectedIndex();
            this.receiveitempanel.setVisible(false);
            this.targetbox2.setVisible(false);
            this.healingbox.setVisible(false);
            this.newtextlines.setVisible(false);
            this.newpicpanel.setVisible(false);
            this.soundpanel.setVisible(false);
            this.visiblepanel.setVisible(false);
            this.abilitypanel.setVisible(false);
            this.riddlepanel.setVisible(false);
            this.changecolorpanel.setVisible(false);
            this.newalignpanel.setVisible(false);
            this.xppanel.setVisible(false);
            if (n > 0) {
                if (n > 0 && n < 4) {
                    this.targetbox2.setVisible(true);
                } else if (n == 4) {
                    if (this.hero == null) {
                        this.hero = new HeroData();
                    }
                    if (!this.heropanel.hasHero(this.hero)) {
                        this.heropanel.addHero(this.hero);
                        this.heropanel.setHero(this.hero);
                    }
                    this.heropanel.show();
                } else if (n == 5) {
                    if (this.itemreceived != null) {
                        DMEditor.itemwizard.setItem(this.itemreceived);
                    } else {
                        DMEditor.itemwizard.show();
                    }
                    Item item = DMEditor.itemwizard.getItem();
                    if (item != null) {
                        this.itemreceived = item;
                    }
                    if (this.itemreceived == null) {
                        this.itemreceived = new Item(200);
                    }
                    this.receiveitemlabel.setText(this.itemreceived.name);
                    this.receiveitempanel.setVisible(true);
                } else if (n == 6) {
                    this.healingbox.setVisible(true);
                } else if (n == 7) {
                    this.newtextlines.setVisible(true);
                    for (int i = 0; i < 6; ++i) {
                        this.newline[i].setText("");
                    }
                } else if (n == 8) {
                    this.newpicpanel.setVisible(true);
                } else if (n == 9) {
                    this.soundpanel.setVisible(true);
                } else if (n == 10 || n == 11) {
                    this.visiblelist.setListData(this.choicevec);
                    this.visiblepanel.setVisible(true);
                } else if (n == 12) {
                    this.abilitypanel.setVisible(true);
                } else if (n == 13) {
                    this.riddlepanel.setVisible(true);
                } else if (n == 14) {
                    this.changecolorpanel.setVisible(true);
                } else if (n == 15 || n == 16) {
                    this.newalignpanel.setVisible(true);
                } else if (n == 17) {
                    this.xppanel.setVisible(true);
                }
            }
        } else if (actionEvent.getSource() == this.needskillbox) {
            if (this.needskillbox.getSelectedIndex() == 0) {
                this.statfield.setVisible(false);
                this.levelbox.setVisible(false);
            } else if (this.needskillbox.getSelectedIndex() < 5 || this.needskillbox.getSelectedIndex() == 10) {
                this.statfield.setVisible(false);
                this.levelbox.setVisible(true);
            } else {
                this.levelbox.setVisible(false);
                this.statfield.setVisible(true);
            }
            this.needskillpanel.validate();
        }
    }

    public MapData getData() {
        return this.data;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.choicelist)) {
            int n = this.choicelist.locationToIndex(mouseEvent.getPoint());
            if (n == -1 || n == this.choiceindex) {
                this.choicelist.clearSelection();
            }
            this.choiceindex = this.choicelist.getSelectedIndex();
        } else if (mouseEvent.getSource().equals(this.actionlist)) {
            int n = this.actionlist.locationToIndex(mouseEvent.getPoint());
            if (n == -1 || n == this.actionindex) {
                this.actionlist.clearSelection();
            }
            this.actionindex = this.actionlist.getSelectedIndex();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private Choice makeChoice() {
        Choice choice = new Choice(this.choice.getText());
        choice.actions = this.actionvec;
        if (this.needitembut.isSelected()) {
            choice.needitem = this.itemneeded;
            choice.takeitem = this.takeitembut.isSelected();
        }
        if (this.needskillbox.getSelectedIndex() != 0) {
            choice.needskill = new int[2];
            choice.needskill[0] = this.needskillbox.getSelectedIndex() - 1;
            choice.needskill[1] = choice.needskill[0] < 4 || choice.needskill[0] == 9 ? this.levelbox.getSelectedIndex() + 1 : Integer.parseInt(this.statfield.getText());
        }
        choice.needmons = this.needmons.getSelectedIndex() - 1;
        if (choice.needmons >= 0) {
            choice.needmonslvl = Integer.parseInt(this.needmonslvl.getText());
            choice.needdead = this.needdead.isSelected();
        }
        choice.visible = this.visiblebut.isSelected();
        choice.autotrigger = this.autotrigger.isSelected();
        return choice;
    }

    private Action makeAction() {
        Action action = new Action();
        action.actiontype = this.actionbox.getSelectedIndex();
        if (action.actiontype > 0 && action.actiontype < 4) {
            action.action = new MapPoint(Integer.parseInt(this.targetlevel.getText()), Integer.parseInt(this.targetx.getText()), Integer.parseInt(this.targety.getText()));
        } else if (action.actiontype == 4) {
            action.action = this.hero;
            this.heropanel.removeHeroes();
            this.hero = null;
        } else if (action.actiontype == 5) {
            action.action = Item.createCopy(this.itemreceived);
        } else if (action.actiontype == 6) {
            action.action = new MapPoint(Integer.parseInt(this.health.getText()), Integer.parseInt(this.stamina.getText()), Integer.parseInt(this.mana.getText()));
        } else if (action.actiontype == 7) {
            action.action = this.newline[5].getText().equals("") ? (this.newline[4].getText().equals("") ? (this.newline[3].getText().equals("") ? (this.newline[2].getText().equals("") ? (this.newline[1].getText().equals("") ? (this.newline[0].getText().equals("") ? null : new String[1]) : new String[2]) : new String[3]) : new String[4]) : new String[5]) : new String[6];
            for (int i = 0; i < ((String[])action.action).length; ++i) {
                ((String[])action.action)[i] = this.newline[i].getText().trim();
            }
        } else if (action.actiontype == 8) {
            action.action = this.newpicname.getText();
        } else if (action.actiontype == 9) {
            action.action = this.playsound.getText();
        } else if (action.actiontype == 10 || action.actiontype == 11) {
            action.action = this.visiblelist.getSelectedIndices();
        } else if (action.actiontype == 12) {
            action.action = this.abilitypanel.createSpecial();
        } else if (action.actiontype == 13) {
            action.action = this.riddle.getText() + "~" + this.riddlenum.getText();
        } else if (action.actiontype == 14) {
            action.action = new Color(this.textcolor2.getRGB());
        } else if (action.actiontype == 15 || action.actiontype == 16) {
            action.action = new Integer(this.newalign.getSelectedIndex());
        } else if (action.actiontype == 17) {
            action.action = new int[4];
            ((int[])action.action)[0] = Integer.parseInt(this.fxp.getText());
            ((int[])action.action)[1] = Integer.parseInt(this.nxp.getText());
            ((int[])action.action)[2] = Integer.parseInt(this.wxp.getText());
            ((int[])action.action)[3] = Integer.parseInt(this.pxp.getText());
        }
        action.reusable = Integer.parseInt(this.reusable.getText());
        return action;
    }
}

