/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectOutputStream;

class FDecoration
extends Floor {
    public static boolean[] ADDEDPICS = new boolean[4];
    public int number;
    private int[] xadjust;
    private int[] yadjust;
    public int level;
    public int xcoord;
    public int ycoord;

    public FDecoration(int n) {
        this.number = n;
        this.mapchar = (char)70;
        this.setPics();
    }

    public void setNumber(int n) {
        if (this.number != n) {
            this.number = n;
            this.setPics();
        }
    }

    @Override
    protected void setPics() {
        this.pic = new Image[4][5];
        this.xadjust = new int[9];
        this.yadjust = new int[3];
        switch (this.number) {
            case 0: {
                this.pic[1][2] = this.loadPic("puddle1.gif");
                this.pic[2][2] = this.loadPic("puddle2.gif");
                this.pic[3][2] = this.loadPic("puddle3.gif");
                this.yadjust[0] = 240;
                this.xadjust[0] = -44;
                this.xadjust[1] = 193;
                this.xadjust[2] = 440;
                this.yadjust[1] = 198;
                this.xadjust[3] = 20;
                this.xadjust[4] = 202;
                this.xadjust[5] = 390;
                this.yadjust[2] = 170;
                this.xadjust[6] = 70;
                this.xadjust[7] = 208;
                this.xadjust[8] = 350;
                break;
            }
            case 1: {
                this.pic[1][2] = this.loadPic("grass1.gif");
                this.pic[2][2] = this.loadPic("grass2.gif");
                this.pic[3][2] = this.loadPic("grass3.gif");
                this.yadjust[0] = 231;
                this.xadjust[0] = -70;
                this.xadjust[1] = 172;
                this.xadjust[2] = 400;
                this.yadjust[1] = 185;
                this.xadjust[3] = 10;
                this.xadjust[4] = 190;
                this.xadjust[5] = 360;
                this.yadjust[2] = 160;
                this.xadjust[6] = 60;
                this.xadjust[7] = 204;
                this.xadjust[8] = 340;
                break;
            }
            case 2: {
                this.pic[0][2] = this.loadPic("seal02.gif");
                this.pic[1][1] = this.loadPic("seal11.gif");
                this.pic[1][2] = this.loadPic("seal12.gif");
                this.pic[1][3] = this.loadPic("seal13.gif");
                this.pic[2][1] = this.loadPic("seal21.gif");
                this.pic[2][2] = this.loadPic("seal22.gif");
                this.pic[2][3] = this.loadPic("seal23.gif");
                this.pic[3][1] = this.loadPic("seal31.gif");
                this.pic[3][2] = this.loadPic("seal32.gif");
                this.pic[3][3] = this.loadPic("seal33.gif");
                this.yadjust[0] = 224;
                this.xadjust[0] = 0;
                this.xadjust[1] = 143;
                this.xadjust[2] = 389;
                this.yadjust[1] = 186;
                this.xadjust[3] = 0;
                this.xadjust[4] = 165;
                this.xadjust[5] = 335;
                this.yadjust[2] = 163;
                this.xadjust[6] = 39;
                this.xadjust[7] = 177;
                this.xadjust[8] = 310;
                break;
            }
            case 3: {
                this.pic[1][1] = this.loadPic("fgrate11.gif");
                this.pic[1][2] = this.loadPic("fgrate12.gif");
                this.pic[1][3] = this.loadPic("fgrate13.gif");
                this.pic[2][1] = this.loadPic("fgrate21.gif");
                this.pic[2][2] = this.loadPic("fgrate22.gif");
                this.pic[2][3] = this.loadPic("fgrate23.gif");
                this.pic[3][1] = this.loadPic("fgrate31.gif");
                this.pic[3][2] = this.loadPic("fgrate32.gif");
                this.pic[3][3] = this.loadPic("fgrate33.gif");
                this.yadjust[0] = 227;
                this.xadjust[0] = 0;
                this.xadjust[1] = 161;
                this.xadjust[2] = 422;
                this.yadjust[1] = 189;
                this.xadjust[3] = 0;
                this.xadjust[4] = 181;
                this.xadjust[5] = 363;
                this.yadjust[2] = 167;
                this.xadjust[6] = 51;
                this.xadjust[7] = 194;
                this.xadjust[8] = 330;
            }
        }
        if (this.number < 2) {
            this.pic[1][1] = this.pic[1][2];
            this.pic[1][3] = this.pic[1][2];
            this.pic[2][1] = this.pic[2][2];
            this.pic[2][3] = this.pic[2][2];
            this.pic[3][1] = this.pic[3][2];
            this.pic[3][3] = this.pic[3][2];
        }
        if (!ADDEDPICS[this.number]) {
            tracker.addImage(this.pic[1][2], 0);
            tracker.addImage(this.pic[2][2], 0);
            tracker.addImage(this.pic[3][2], 0);
            if (this.number > 1) {
                if (this.number == 2) {
                    tracker.addImage(this.pic[0][2], 0);
                }
                tracker.addImage(this.pic[1][1], 0);
                tracker.addImage(this.pic[1][3], 0);
                tracker.addImage(this.pic[2][1], 0);
                tracker.addImage(this.pic[2][3], 0);
                tracker.addImage(this.pic[3][1], 0);
                tracker.addImage(this.pic[3][3], 0);
            }
            FDecoration.ADDEDPICS[this.number] = true;
        }
    }

    @Override
    public void drawPic(int n, int n2, int n3, int n4, Graphics2D graphics2D, ImageObserver imageObserver) {
        if (n2 == 0 || n2 == 4) {
            return;
        }
        if (n != 0) {
            graphics2D.drawImage(this.pic[n][n2], this.xadjust[(n - 1) * 3 + n2 - 1], this.yadjust[n - 1], imageObserver);
        } else if (this.number == 2 && n2 == 2) {
            graphics2D.drawImage(this.pic[0][2], 109, 293, imageObserver);
        }
        this.drawContents(graphics2D, 3 - n, n2 - 1);
    }

    @Override
    public void tryTeleport(dmnew.Monster monster) {
        if (monster.number != 11) {
            return;
        }
        this.dropall(this.level + 1);
    }

    public void dropall(int n) {
        if (n >= dmnew.numlevels) {
            return;
        }
        if (n + 1 < dmnew.numlevels && (dmnew.DungeonMap[n][this.xcoord][this.ycoord] instanceof FDecoration && ((FDecoration)dmnew.DungeonMap[n][this.xcoord][this.ycoord]).number == 3 || dmnew.DungeonMap[n][this.xcoord][this.ycoord] instanceof Pit && ((Pit)dmnew.DungeonMap[n][this.xcoord][this.ycoord]).isOpen)) {
            this.dropall(n + 1);
            return;
        }
        if (this.hasMons) {
            boolean bl = false;
            for (int i = 0; i < 6; ++i) {
                dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.level + "," + this.xcoord + "," + this.ycoord + "," + i);
                if (monster != null) {
                    if (monster.number != 11) {
                        bl = true;
                    } else {
                        dmnew.dmmons.remove(this.level + "," + this.xcoord + "," + this.ycoord + "," + i);
                        monster.level = n;
                        if (dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons) {
                            dmnew.Monster monster2;
                            if (monster.subsquare == 5) {
                                for (int j = 0; j < 6; ++j) {
                                    monster2 = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + j);
                                    if (monster2 != null && (monster2.number != 24 && monster2.number != 26 || !monster2.teleport())) {
                                        monster2.pitDeath();
                                    }
                                    if (i != 3) continue;
                                    ++i;
                                }
                            } else {
                                monster2 = (dmnew.Monster)dmnew.dmmons.get(n + "," + this.xcoord + "," + this.ycoord + "," + monster.subsquare);
                                if (monster2 != null && (monster2.number != 24 && monster2.number != 26 || !monster2.teleport())) {
                                    monster2.pitDeath();
                                }
                            }
                        }
                        dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryFloorSwitch(4);
                        dmnew.DungeonMap[n][this.xcoord][this.ycoord].hasMons = true;
                        dmnew.dmmons.put(n + "," + this.xcoord + "," + this.ycoord + "," + monster.subsquare, monster);
                        dmnew.DungeonMap[n][this.xcoord][this.ycoord].tryTeleport(monster);
                    }
                }
                if (i != 3) continue;
                ++i;
            }
            if (!bl) {
                this.hasMons = false;
            }
        }
    }

    @Override
    public void doAction() {
        if (this.number == 3 && this.hasMons) {
            this.dropall(this.level + 1);
        }
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeInt(this.number);
        if (this.number == 3) {
            objectOutputStream.writeInt(this.level);
            objectOutputStream.writeInt(this.xcoord);
            objectOutputStream.writeInt(this.ycoord);
        }
    }
}

