/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class FloorSwitch
extends Floor {
    public static boolean ADDEDPICS;
    public static Image[][] fswitchpic;
    protected MapPoint xy;
    protected MapPoint target;
    protected int type;
    private int targetlevel;
    private int targetx;
    private int targety;
    protected boolean isReusable;
    protected boolean wasUsed;
    protected boolean playsound;
    public boolean haspic;
    protected boolean switchstate;
    public int actiontype;
    protected int delay;
    protected int reset;
    protected int changecount = 0;
    public boolean delaying;
    public boolean resetting;
    public boolean resetnotrigger;
    private MapObject changeto;
    private MapObject oldMapObject;
    private String soundstring;
    private int loopsound;
    private boolean abrupt;
    private boolean retainitems;
    public int switchface;
    static final int NORMAL = 0;
    static final int CONSTANT = 1;
    static final int CREATURE = 2;
    static final int ITEMONLY = 3;
    static final int STEPON = 4;
    static final int STEPOFF = 5;
    static final int MON = 6;
    static final int MONSTEPON = 7;
    static final int MONSTEPOFF = 8;
    static final int PARTY = 9;
    static final int PARTYSTEPON = 10;
    static final int PARTYSTEPOFF = 11;
    static final int CONSTANTON = 12;
    static final int CONSTANTOFF = 13;

    public FloorSwitch() {
        this.mapchar = (char)115;
    }

    public static void staticSetPics() {
        FloorSwitch.fswitchpic[1][1] = dmnew.tk.getImage(mapdir + "fswitch11.gif");
        FloorSwitch.fswitchpic[1][2] = dmnew.tk.getImage(mapdir + "fswitch12.gif");
        FloorSwitch.fswitchpic[1][3] = dmnew.tk.getImage(mapdir + "fswitch13.gif");
        FloorSwitch.fswitchpic[2][1] = dmnew.tk.getImage(mapdir + "fswitch21.gif");
        FloorSwitch.fswitchpic[2][2] = dmnew.tk.getImage(mapdir + "fswitch22.gif");
        FloorSwitch.fswitchpic[2][3] = dmnew.tk.getImage(mapdir + "fswitch23.gif");
        FloorSwitch.fswitchpic[3][1] = dmnew.tk.getImage(mapdir + "fswitch31.gif");
        FloorSwitch.fswitchpic[3][2] = dmnew.tk.getImage(mapdir + "fswitch32.gif");
        FloorSwitch.fswitchpic[3][3] = dmnew.tk.getImage(mapdir + "fswitch33.gif");
        tracker.addImage(fswitchpic[1][1], 0);
        tracker.addImage(fswitchpic[1][2], 0);
        tracker.addImage(fswitchpic[1][3], 0);
        tracker.addImage(fswitchpic[2][1], 0);
        tracker.addImage(fswitchpic[2][2], 0);
        tracker.addImage(fswitchpic[2][3], 0);
        tracker.addImage(fswitchpic[3][1], 0);
        tracker.addImage(fswitchpic[3][2], 0);
        tracker.addImage(fswitchpic[3][3], 0);
        ADDEDPICS = true;
    }

    public static void redoPics() {
        String string = Wall.currentdir + File.separator;
        File file = new File(string + "fswitch12.gif");
        if (!file.exists()) {
            return;
        }
        FloorSwitch.fswitchpic[1][1] = dmnew.tk.getImage(string + "fswitch11.gif");
        FloorSwitch.fswitchpic[1][2] = dmnew.tk.getImage(string + "fswitch12.gif");
        FloorSwitch.fswitchpic[1][3] = dmnew.tk.getImage(string + "fswitch13.gif");
        FloorSwitch.fswitchpic[2][1] = dmnew.tk.getImage(string + "fswitch21.gif");
        FloorSwitch.fswitchpic[2][2] = dmnew.tk.getImage(string + "fswitch22.gif");
        FloorSwitch.fswitchpic[2][3] = dmnew.tk.getImage(string + "fswitch23.gif");
        FloorSwitch.fswitchpic[3][1] = dmnew.tk.getImage(string + "fswitch31.gif");
        FloorSwitch.fswitchpic[3][2] = dmnew.tk.getImage(string + "fswitch32.gif");
        FloorSwitch.fswitchpic[3][3] = dmnew.tk.getImage(string + "fswitch33.gif");
        tracker.addImage(fswitchpic[1][1], 5);
        tracker.addImage(fswitchpic[1][2], 5);
        tracker.addImage(fswitchpic[1][3], 5);
        tracker.addImage(fswitchpic[2][1], 5);
        tracker.addImage(fswitchpic[2][2], 5);
        tracker.addImage(fswitchpic[2][3], 5);
        tracker.addImage(fswitchpic[3][1], 5);
        tracker.addImage(fswitchpic[3][2], 5);
        tracker.addImage(fswitchpic[3][3], 5);
        try {
            tracker.waitForID(5, 2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.removeImage(fswitchpic[1][1], 5);
        tracker.removeImage(fswitchpic[1][2], 5);
        tracker.removeImage(fswitchpic[1][3], 5);
        tracker.removeImage(fswitchpic[2][1], 5);
        tracker.removeImage(fswitchpic[2][2], 5);
        tracker.removeImage(fswitchpic[2][3], 5);
        tracker.removeImage(fswitchpic[3][1], 5);
        tracker.removeImage(fswitchpic[3][2], 5);
        tracker.removeImage(fswitchpic[3][3], 5);
    }

    @Override
    public void drawPic(int n, int n2, int n3, int n4, Graphics2D graphics2D, ImageObserver imageObserver) {
        if (n2 == 0 || n2 == 4) {
            return;
        }
        if (this.haspic && n != 0) {
            if (n2 == 3) {
                n3 -= fswitchpic[n][n2].getWidth(null);
            }
            if (n2 == 2 && dmnew.mirrorback) {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n3 + fswitchpic[n][n2].getWidth(null), n4);
                affineTransform.scale(-1.0, 1.0);
                graphics2D.drawImage(fswitchpic[n][n2], affineTransform, null);
            } else {
                graphics2D.drawImage(fswitchpic[n][n2], n3, n4, imageObserver);
            }
        }
        this.drawContents(graphics2D, 3 - n, n2 - 1);
    }

    @Override
    public void tryFloorSwitch(int n) {
        if (!this.isReusable && this.wasUsed) {
            return;
        }
        if (this.switchface > 0 && (n == 0 || n == 1) && dmnew.facing != this.switchface - 1) {
            return;
        }
        if (this.type == 1 || this.type == 12 || this.type == 13) {
            if (this.hasItems && (n != 2 || this.mapItems.size() > 1) || this.hasParty && n != 0 && n != 1 && (this.switchface == 0 || this.switchface - 1 == dmnew.facing)) {
                return;
            }
            if (this.hasMons) {
                int n2 = 0;
                int n3 = n == 4 ? 2 : 1;
                int n4 = 0;
                while (n4 < 6 && n2 < n3) {
                    dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.xy.level + "," + this.xy.x + "," + this.xy.y + "," + n4);
                    if (monster != null && !monster.isflying && !monster.isdying) {
                        ++n2;
                    }
                    if (n4 == 3) {
                        n4 = 5;
                        continue;
                    }
                    ++n4;
                }
                if (n2 >= n3) {
                    return;
                }
            }
            if (this.type == 12 && n != 0 && n != 4 && n != 2) {
                return;
            }
            if (this.delaying) {
                this.delaying = false;
                this.changecount = 0;
                return;
            }
            if (this.resetting) {
                this.changecount = 0;
                return;
            }
        }
        if (this.type == 2 && (n == 2 || n == 3)) {
            return;
        }
        if (this.type == 3 && n != 2 && n != 3) {
            return;
        }
        if (this.type == 4 && n != 0 && n != 4) {
            return;
        }
        if (this.type == 5 && (n == 2 || n == 3)) {
            return;
        }
        if (this.type == 6 && n != 4 && n != 5) {
            return;
        }
        if (this.type == 7 && n != 4) {
            return;
        }
        if (this.type == 8 && n != 5) {
            return;
        }
        if (this.type == 9 && n != 0 && n != 1) {
            return;
        }
        if (this.type == 10 && n != 0) {
            return;
        }
        if (this.type == 11 && n != 1) {
            return;
        }
        if (this.playsound && this.xy.level == dmnew.level) {
            dmnew.playSound("switch.wav", this.xy.x, this.xy.y);
        }
        if (!(this.type != 5 && this.type != 13 || n != 0 && n != 4 && n != 2)) {
            return;
        }
        if (this.delaying && this.actiontype > 2 && this.actiontype != 6 && this.actiontype != 7) {
            this.delaying = false;
            this.resetting = false;
            this.changecount = 0;
            return;
        }
        if (this.resetting && this.actiontype > 2 && this.actiontype != 6 && this.actiontype != 7) {
            this.changecount = 0;
            return;
        }
        if (this.delaying || this.resetting) {
            return;
        }
        if (this.delay > 0) {
            this.delaying = true;
        } else if (this.actiontype == 0) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].toggle();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 1) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 2) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 3) {
            if (!this.switchstate) {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            } else {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            }
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 4) {
            if (!this.switchstate) {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            } else {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            }
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 5) {
            if (!this.switchstate && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.changeto) {
                if (!this.changeto.isPassable || this.changeto.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        this.delaying = true;
                    } else if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n5 = 0;
                        while (n5 < 6 && !this.delaying) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n5);
                            if (monster != null && !monster.isImmaterial) {
                                this.delaying = true;
                                continue;
                            }
                            if (n5 == 3) {
                                n5 = 5;
                                continue;
                            }
                            ++n5;
                        }
                    }
                }
                if (!this.delaying && !this.changeto.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    this.delaying = true;
                }
                if (!this.delaying) {
                    this.oldMapObject = dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety];
                    dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.changeto;
                    boolean bl = this.switchstate = !this.switchstate;
                    if (!dmnew.mapstochange.contains(this.target)) {
                        dmnew.mapstochange.add(this.target);
                    }
                    if (this.oldMapObject.hasCloud) {
                        this.oldMapObject.hasCloud = false;
                        this.changeto.hasCloud = true;
                    }
                    if (this.oldMapObject.numProjs > 0) {
                        this.changeto.numProjs = this.oldMapObject.numProjs;
                        this.oldMapObject.numProjs = 0;
                    }
                    if (this.oldMapObject.hasMons) {
                        this.changeto.hasMons = true;
                        this.oldMapObject.hasMons = false;
                    }
                    if (this.oldMapObject.hasParty) {
                        this.changeto.hasParty = true;
                        this.oldMapObject.hasParty = false;
                    }
                    if (this.retainitems && this.oldMapObject.hasItems) {
                        while (this.oldMapObject.mapItems.size() > 0) {
                            this.changeto.addItem((Item)this.oldMapObject.mapItems.remove(0));
                        }
                        this.changeto.hasItems = true;
                        this.oldMapObject.hasItems = false;
                    }
                    this.changeto.doAction();
                }
                dmnew.needredraw = true;
            } else if (this.switchstate && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.oldMapObject) {
                if (!this.oldMapObject.isPassable || this.oldMapObject.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        this.delaying = true;
                    } else if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n6 = 0;
                        while (n6 < 6 && !this.delaying) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n6);
                            if (monster != null && !monster.isImmaterial) {
                                this.delaying = true;
                                continue;
                            }
                            if (n6 == 3) {
                                n6 = 5;
                                continue;
                            }
                            ++n6;
                        }
                    }
                }
                if (!this.delaying && !this.oldMapObject.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    this.delaying = true;
                }
                if (!this.delaying) {
                    dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.oldMapObject;
                    boolean bl = this.switchstate = !this.switchstate;
                    if (!dmnew.mapstochange.contains(this.target)) {
                        dmnew.mapstochange.add(this.target);
                    }
                    if (this.changeto.hasCloud) {
                        this.changeto.hasCloud = false;
                        this.oldMapObject.hasCloud = true;
                    }
                    if (this.changeto.numProjs > 0) {
                        this.oldMapObject.numProjs = this.changeto.numProjs;
                        this.changeto.numProjs = 0;
                    }
                    if (this.changeto.hasMons) {
                        this.oldMapObject.hasMons = true;
                        this.changeto.hasMons = false;
                    }
                    if (this.changeto.hasParty) {
                        this.oldMapObject.hasParty = true;
                        this.changeto.hasParty = false;
                    }
                    if (this.retainitems && this.changeto.hasItems) {
                        while (this.changeto.mapItems.size() > 0) {
                            this.oldMapObject.addItem((Item)this.changeto.mapItems.remove(0));
                        }
                        this.oldMapObject.hasItems = true;
                        this.changeto.hasItems = false;
                    }
                    this.oldMapObject.doAction();
                }
                dmnew.needredraw = true;
            }
        } else if (this.actiontype == 6) {
            if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.changeto) {
                if (!this.changeto.isPassable || this.changeto.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        this.delaying = true;
                    } else if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n7 = 0;
                        while (n7 < 6 && !this.delaying) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n7);
                            if (monster != null && !monster.isImmaterial) {
                                this.delaying = true;
                                continue;
                            }
                            if (n7 == 3) {
                                n7 = 5;
                                continue;
                            }
                            ++n7;
                        }
                    }
                }
                if (!this.delaying && !this.changeto.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    this.delaying = true;
                }
                if (!this.delaying) {
                    this.oldMapObject = dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety];
                    dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.changeto;
                    boolean bl = this.switchstate = !this.switchstate;
                    if (!dmnew.mapstochange.contains(this.target)) {
                        dmnew.mapstochange.add(this.target);
                    }
                    if (this.oldMapObject.hasCloud) {
                        this.oldMapObject.hasCloud = false;
                        this.changeto.hasCloud = true;
                    }
                    if (this.oldMapObject.numProjs > 0) {
                        this.changeto.numProjs = this.oldMapObject.numProjs;
                        this.oldMapObject.numProjs = 0;
                    }
                    if (this.oldMapObject.hasMons) {
                        this.changeto.hasMons = true;
                        this.oldMapObject.hasMons = false;
                    }
                    if (this.oldMapObject.hasParty) {
                        this.changeto.hasParty = true;
                        this.oldMapObject.hasParty = false;
                    }
                    if (this.retainitems && this.oldMapObject.hasItems) {
                        while (this.oldMapObject.mapItems.size() > 0) {
                            this.changeto.addItem((Item)this.oldMapObject.mapItems.remove(0));
                        }
                        this.changeto.hasItems = true;
                        this.oldMapObject.hasItems = false;
                    }
                    this.changeto.doAction();
                }
                dmnew.needredraw = true;
            }
        } else if (this.actiontype == 7) {
            dmnew.playSound(this.soundstring, this.targetx, this.targety, this.loopsound);
        } else if (this.actiontype == 8) {
            dmnew.stopSounds(this.abrupt);
        }
        this.wasUsed = true;
        if (this.delaying || this.reset > 0) {
            if (this.reset > 0) {
                this.resetting = true;
            }
            if (!dmnew.mapstochange.contains(this.xy)) {
                dmnew.mapstochange.add(this.xy);
            }
            dmnew.mapchanging = true;
        }
    }

    @Override
    public boolean changeState() {
        boolean bl = true;
        if (this.delaying) {
            ++this.changecount;
            if (this.changecount > this.delay) {
                if (this.doSwitch()) {
                    this.delaying = false;
                    this.changecount = 0;
                    if (this.reset == 0) {
                        bl = false;
                    } else {
                        this.resetting = true;
                    }
                } else {
                    --this.changecount;
                }
            }
        } else if (this.resetting) {
            ++this.changecount;
            if (this.changecount > this.reset) {
                if (this.resetnotrigger || this.doSwitch()) {
                    this.resetting = false;
                    this.changecount = 0;
                    bl = false;
                } else {
                    --this.changecount;
                }
            }
        } else {
            this.changecount = 0;
            bl = false;
        }
        return bl;
    }

    @Override
    public void toggle() {
        if (this.delaying || this.resetting) {
            return;
        }
        if (this.delay > 0 || !this.doSwitch()) {
            this.delaying = true;
            if (!dmnew.mapstochange.contains(this.xy)) {
                dmnew.mapstochange.add(this.xy);
            }
            dmnew.mapchanging = true;
            return;
        }
        if (this.reset > 0) {
            this.resetting = true;
            if (!dmnew.mapstochange.contains(this.xy)) {
                dmnew.mapstochange.add(this.xy);
            }
            dmnew.mapchanging = true;
        }
    }

    @Override
    public void activate() {
        this.toggle();
    }

    @Override
    public void doAction() {
        if (this.hasParty) {
            this.tryFloorSwitch(0);
        }
        if (this.hasMons) {
            this.tryFloorSwitch(4);
        }
    }

    protected boolean doSwitch() {
        if (this.actiontype == 0) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].toggle();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 1) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 2) {
            dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 3) {
            if (!this.switchstate) {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            } else {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            }
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 4) {
            if (!this.switchstate) {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].deactivate();
            } else {
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].activate();
            }
            this.switchstate = !this.switchstate;
        } else if (this.actiontype == 5) {
            if (!this.switchstate && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.changeto) {
                if (!this.changeto.isPassable || this.changeto.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        return false;
                    }
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n = 0;
                        while (n < 6) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n);
                            if (monster != null && !monster.isImmaterial) {
                                return false;
                            }
                            if (n == 3) {
                                n = 5;
                                continue;
                            }
                            ++n;
                        }
                    }
                }
                if (!this.changeto.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    return false;
                }
                this.oldMapObject = dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety];
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.changeto;
                boolean bl = this.switchstate = !this.switchstate;
                if (!dmnew.mapstochange.contains(this.target)) {
                    dmnew.mapstochange.add(this.target);
                }
                if (this.oldMapObject.hasCloud) {
                    this.oldMapObject.hasCloud = false;
                    this.changeto.hasCloud = true;
                }
                if (this.oldMapObject.numProjs > 0) {
                    this.changeto.numProjs = this.oldMapObject.numProjs;
                    this.oldMapObject.numProjs = 0;
                }
                if (this.oldMapObject.hasMons) {
                    this.changeto.hasMons = true;
                    this.oldMapObject.hasMons = false;
                }
                if (this.oldMapObject.hasParty) {
                    this.changeto.hasParty = true;
                    this.oldMapObject.hasParty = false;
                }
                if (this.retainitems && this.oldMapObject.hasItems) {
                    while (this.oldMapObject.mapItems.size() > 0) {
                        this.changeto.addItem((Item)this.oldMapObject.mapItems.remove(0));
                    }
                    this.changeto.hasItems = true;
                    this.oldMapObject.hasItems = false;
                }
                this.changeto.doAction();
            } else if (this.switchstate && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.oldMapObject) {
                if (!this.oldMapObject.isPassable || this.oldMapObject.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        return false;
                    }
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n = 0;
                        while (n < 6) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n);
                            if (monster != null && !monster.isImmaterial) {
                                return false;
                            }
                            if (n == 3) {
                                n = 5;
                                continue;
                            }
                            ++n;
                        }
                    }
                }
                if (!this.oldMapObject.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    return false;
                }
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.oldMapObject;
                boolean bl = this.switchstate = !this.switchstate;
                if (!dmnew.mapstochange.contains(this.target)) {
                    dmnew.mapstochange.add(this.target);
                }
                if (this.changeto.hasCloud) {
                    this.changeto.hasCloud = false;
                    this.oldMapObject.hasCloud = true;
                }
                if (this.changeto.numProjs > 0) {
                    this.oldMapObject.numProjs = this.changeto.numProjs;
                    this.changeto.numProjs = 0;
                }
                if (this.changeto.hasMons) {
                    this.oldMapObject.hasMons = true;
                    this.changeto.hasMons = false;
                }
                if (this.changeto.hasParty) {
                    this.oldMapObject.hasParty = true;
                    this.changeto.hasParty = false;
                }
                if (this.retainitems && this.changeto.hasItems) {
                    while (this.changeto.mapItems.size() > 0) {
                        this.oldMapObject.addItem((Item)this.changeto.mapItems.remove(0));
                    }
                    this.oldMapObject.hasItems = true;
                    this.changeto.hasItems = false;
                }
                this.oldMapObject.doAction();
            }
        } else if (this.actiontype == 6) {
            if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] != this.changeto) {
                if (!this.changeto.isPassable || this.changeto.mapchar == '>') {
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasParty) {
                        return false;
                    }
                    if (dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].hasMons) {
                        int n = 0;
                        while (n < 6) {
                            dmnew.Monster monster = (dmnew.Monster)dmnew.dmmons.get(this.targetlevel + "," + this.targetx + "," + this.targety + "," + n);
                            if (monster != null && !monster.isImmaterial) {
                                return false;
                            }
                            if (n == 3) {
                                n = 5;
                                continue;
                            }
                            ++n;
                        }
                    }
                }
                if (!this.changeto.canPassProjs && dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety].numProjs > 0) {
                    return false;
                }
                this.oldMapObject = dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety];
                dmnew.DungeonMap[this.targetlevel][this.targetx][this.targety] = this.changeto;
                boolean bl = this.switchstate = !this.switchstate;
                if (!dmnew.mapstochange.contains(this.target)) {
                    dmnew.mapstochange.add(this.target);
                }
                if (this.oldMapObject.hasCloud) {
                    this.oldMapObject.hasCloud = false;
                    this.changeto.hasCloud = true;
                }
                if (this.oldMapObject.numProjs > 0) {
                    this.changeto.numProjs = this.oldMapObject.numProjs;
                    this.oldMapObject.numProjs = 0;
                }
                if (this.oldMapObject.hasMons) {
                    this.changeto.hasMons = true;
                    this.oldMapObject.hasMons = false;
                }
                if (this.oldMapObject.hasParty) {
                    this.changeto.hasParty = true;
                    this.oldMapObject.hasParty = false;
                }
                if (this.retainitems && this.oldMapObject.hasItems) {
                    while (this.oldMapObject.mapItems.size() > 0) {
                        this.changeto.addItem((Item)this.oldMapObject.mapItems.remove(0));
                    }
                    this.changeto.hasItems = true;
                    this.oldMapObject.hasItems = false;
                }
                this.changeto.doAction();
            }
        } else if (this.actiontype == 7) {
            dmnew.playSound(this.soundstring, this.targetx, this.targety, this.loopsound);
        } else if (this.actiontype == 8) {
            dmnew.stopSounds(this.abrupt);
        }
        dmnew.needredraw = true;
        return true;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeInt(this.type);
        objectOutputStream.writeInt(this.targetlevel);
        objectOutputStream.writeInt(this.targetx);
        objectOutputStream.writeInt(this.targety);
        objectOutputStream.writeBoolean(this.isReusable);
        objectOutputStream.writeInt(this.delay);
        objectOutputStream.writeInt(this.reset);
        objectOutputStream.writeBoolean(this.haspic);
        objectOutputStream.writeBoolean(this.playsound);
        objectOutputStream.writeInt(this.changecount);
        objectOutputStream.writeBoolean(this.delaying);
        objectOutputStream.writeBoolean(this.resetting);
        objectOutputStream.writeBoolean(this.resetnotrigger);
        objectOutputStream.writeBoolean(this.switchstate);
        objectOutputStream.writeInt(this.switchface);
        objectOutputStream.writeBoolean(this.wasUsed);
        objectOutputStream.writeInt(this.actiontype);
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto.save(objectOutputStream);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject.save(objectOutputStream);
            }
            objectOutputStream.writeBoolean(this.retainitems);
        } else if (this.actiontype == 7) {
            objectOutputStream.writeUTF(this.soundstring);
            objectOutputStream.writeInt(this.loopsound);
        } else if (this.actiontype == 8) {
            objectOutputStream.writeBoolean(this.abrupt);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.xy = (MapPoint)objectInputStream.readObject();
        this.type = objectInputStream.readInt();
        this.targetlevel = objectInputStream.readInt();
        this.targetx = objectInputStream.readInt();
        this.targety = objectInputStream.readInt();
        this.target = new MapPoint(this.targetlevel, this.targetx, this.targety);
        this.isReusable = objectInputStream.readBoolean();
        this.delay = objectInputStream.readInt();
        this.reset = objectInputStream.readInt();
        this.haspic = objectInputStream.readBoolean();
        this.playsound = objectInputStream.readBoolean();
        this.changecount = objectInputStream.readInt();
        this.delaying = objectInputStream.readBoolean();
        this.resetting = objectInputStream.readBoolean();
        this.resetnotrigger = objectInputStream.readBoolean();
        this.switchstate = objectInputStream.readBoolean();
        this.switchface = objectInputStream.readInt();
        this.wasUsed = objectInputStream.readBoolean();
        this.actiontype = objectInputStream.readInt();
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto = dmnew.loadMapObject(objectInputStream);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject = dmnew.loadMapObject(objectInputStream);
            }
            this.retainitems = objectInputStream.readBoolean();
        } else if (this.actiontype == 7) {
            this.soundstring = objectInputStream.readUTF();
            this.loopsound = objectInputStream.readInt();
        } else if (this.actiontype == 8) {
            this.abrupt = objectInputStream.readBoolean();
        }
        if (!ADDEDPICS && this.haspic) {
            FloorSwitch.staticSetPics();
        }
    }

    static {
        fswitchpic = new Image[4][5];
    }
}

