/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

class FountainData
extends SidedWallData {
    public MultWallSwitchData fountainswitch;
    public boolean cantakeitems = true;
    public int canputitems = -1;

    public FountainData(int n) {
        super(n);
        this.mapchar = (char)102;
    }

    public FountainData(int n, boolean bl, int n2, MultWallSwitchData multWallSwitchData) {
        super(n);
        this.mapchar = (char)102;
        this.cantakeitems = bl;
        this.canputitems = n2;
        this.fountainswitch = multWallSwitchData;
        if (this.fountainswitch != null) {
            this.fountainswitch.setFacing(n);
        }
    }

    @Override
    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        if (this.mapItems == null) {
            this.mapItems = new ArrayList();
        }
        item.subsquare = (this.side + 2) % 4;
        this.mapItems.add(item);
        this.hasItems = true;
        int n = (this.side + 2) % 4;
        this.numitemsin[n] = this.numitemsin[n] + 1;
    }

    @Override
    public void removeItem(int n) {
        if (this.mapItems.size() == 1) {
            this.hasItems = false;
        }
        int n2 = (this.side + 2) % 4;
        this.numitemsin[n2] = this.numitemsin[n2] - 1;
        this.mapItems.remove(n);
    }

    @Override
    public void changeLevel(int n, int n2) {
        if (this.fountainswitch != null) {
            this.fountainswitch.changeLevel(n, n2);
        }
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        if (this.fountainswitch != null) {
            this.fountainswitch.setMapCoord(n, n2, n3);
        }
    }

    @Override
    public String toString() {
        String string = this.side == 0 ? "Fountain Facing South" : (this.side == 1 ? "Fountain Facing East" : (this.side == 2 ? "Fountain Facing North" : "Fountain Facing West"));
        if (this.fountainswitch != null) {
            string = string + " (Switch)";
        }
        return string;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeBoolean(this.cantakeitems);
        objectOutputStream.writeInt(this.canputitems);
        if (this.fountainswitch != null) {
            objectOutputStream.writeBoolean(true);
            this.fountainswitch.save(objectOutputStream);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cantakeitems = objectInputStream.readBoolean();
        this.canputitems = objectInputStream.readInt();
        if (objectInputStream.readBoolean()) {
            this.fountainswitch = (MultWallSwitchData)DMEditor.loadMapData(objectInputStream, -1, 0, 0);
        }
    }
}

