/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class GeneratorWizard
extends JDialog
implements ActionListener {
    private MapData data;
    private int level;
    private int x;
    private int y;
    private MonsterData mon;
    private JTextField genrate;
    private JTextField maxgen;
    private JTextField maxcount;
    private JTextField count;
    private JToggleButton isActive;
    private JToggleButton resetcount;
    private JLabel monsterlabel;
    private JComboBox numtogen;
    private JFrame frame;

    public GeneratorWizard(JFrame jFrame) {
        super(jFrame, "Generator Wizard", true);
        this.frame = jFrame;
        this.level = this.level;
        this.x = this.x;
        this.y = this.y;
        this.setDefaultCloseOperation(2);
        this.setSize(570, 230);
        this.setLocationRelativeTo(jFrame);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.mon = new MonsterData(10, this.level, this.x, this.y, MonsterWizard.defaulthealth[10], 0, 0, 4, false, true, MonsterWizard.defaultpower[10], MonsterWizard.defaultdefense[10], MonsterWizard.defaultmresist[10], MonsterWizard.defaultspeed[10], 0, 0, new ArrayList(), null, false, null, null, 0, 0, 0, true, 0, 0, false);
        this.mon.movespeed = 11;
        this.mon.attackspeed = 4;
        this.monsterlabel = new JLabel(this.mon.name, MonsterData.MonsterIcon[this.mon.number], 4);
        JButton jButton = new JButton("Edit");
        jButton.addActionListener(this);
        String[] stringArray = new String[]{"1", "2", "3", "4", "Random"};
        this.numtogen = new JComboBox<String>(stringArray);
        this.numtogen.setEditable(false);
        this.numtogen.setVisible(false);
        jPanel.add(this.numtogen);
        jPanel.add(this.monsterlabel);
        jPanel.add(jButton);
        Box box = Box.createVerticalBox();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Generation Rate (0 If Not Continuous):"));
        this.genrate = new JTextField("0", 4);
        jPanel2.add(this.genrate);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("# Generations Before Deactivation (0 For Infinite):"));
        this.maxgen = new JTextField("0", 4);
        jPanel3.add(this.maxgen);
        JPanel jPanel4 = new JPanel();
        this.isActive = new JToggleButton("Is Active");
        jPanel4.add(this.isActive);
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel);
        jPanel5.add(box);
        JLabel jLabel = new JLabel("Total Switch count:");
        this.maxcount = new JTextField("1", 3);
        JLabel jLabel2 = new JLabel("Remaining Switch count:");
        this.count = new JTextField("1", 3);
        this.resetcount = new JToggleButton("Count Resets");
        JPanel jPanel6 = new JPanel(new GridLayout(5, 1));
        jPanel6.add(jLabel);
        jPanel6.add(this.maxcount);
        jPanel6.add(jLabel2);
        jPanel6.add(this.count);
        jPanel6.add(this.resetcount);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(Box.createGlue());
        jPanel7.add(jPanel6);
        jPanel7.add(Box.createGlue());
        JPanel jPanel8 = new JPanel();
        JButton jButton2 = new JButton("Done");
        JButton jButton3 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel8.add(jButton3);
        jPanel8.add(jButton2);
        container.add("Center", jPanel5);
        container.add("South", jPanel8);
        container.add("East", jPanel7);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 'g') {
            GeneratorData generatorData = (GeneratorData)mapData;
            this.mon = new MonsterData(generatorData.monster);
            this.monsterlabel.setText(this.mon.name);
            this.monsterlabel.setIcon(this.mon.pic);
            if (this.mon.subsquare != 5) {
                this.numtogen.setSelectedIndex(generatorData.numtogen - 1);
                this.numtogen.setVisible(true);
            } else {
                this.numtogen.setSelectedIndex(0);
                this.numtogen.setVisible(false);
            }
            this.genrate.setText("" + generatorData.genrate);
            this.maxgen.setText("" + generatorData.maxgen);
            this.isActive.setSelected(generatorData.isActive);
            this.maxcount.setText("" + (generatorData.maxcount + 1));
            this.count.setText("" + (generatorData.count + 1));
            this.resetcount.setSelected(generatorData.resetcount);
        } else {
            this.mon = new MonsterData(this.mon);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (Integer.parseInt(this.genrate.getText()) == 0) {
                this.isActive.setSelected(false);
            }
            this.data = new GeneratorData(this.level, this.x, this.y, this.numtogen.getSelectedIndex() + 1, Integer.parseInt(this.maxgen.getText()), Integer.parseInt(this.genrate.getText()), this.isActive.isSelected(), 0, 0, Integer.parseInt(this.maxcount.getText()) - 1, Integer.parseInt(this.count.getText()) - 1, this.resetcount.isSelected(), this.mon);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Edit")) {
            DMEditor.monsterwizard.setMonster(this.mon, this.level, this.x, this.y);
            MonsterData monsterData = DMEditor.monsterwizard.getData();
            if (monsterData != null) {
                this.mon = monsterData;
                this.monsterlabel.setText(this.mon.name);
                this.monsterlabel.setIcon(this.mon.pic);
                if (this.mon.subsquare != 5) {
                    this.numtogen.setVisible(true);
                } else {
                    this.numtogen.setSelectedIndex(0);
                    this.numtogen.setVisible(false);
                }
            }
        }
    }

    public MapData getData() {
        return this.data;
    }
}

