/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class HeroPanel
extends JDialog
implements MouseListener {
    private JPanel hpanel;
    private HeroSheet sheet;
    private Image hsheet;
    private Image poisonedpic;
    private Image hurtweapon;
    private Image hurthand;
    private Image hurthead;
    private Image hurttorso;
    private Image hurtlegs;
    private Image hurtfeet;
    private MediaTracker tracker;
    private DMEditor dmed;
    public static final String[] LEVELNAMES = new String[]{"None", "Neophyte", "Novice", "Apprentice", "Journeyman", "Craftsman", "Artisan", "Adept", "Expert", "LO Master", "UM Master", "ON Master", "EE Master", "PAL Master", "MON Master", "ArchMaster"};

    public HeroPanel(DMEditor dMEditor, Font font) {
        super(dMEditor, "Edit Party", false);
        this.dmed = dMEditor;
        this.pack();
        this.setSize(new Dimension(448, 423));
        this.setLocationRelativeTo(dMEditor);
        this.hpanel = new JPanel();
        this.hpanel.setBackground(Color.black);
        this.getContentPane().add((Component)this.hpanel, "North");
        this.sheet = new HeroSheet(font);
        SheetClick sheetClick = new SheetClick();
        this.sheet.addMouseListener(sheetClick);
        this.sheet.addMouseMotionListener(sheetClick);
        this.getContentPane().add((Component)this.sheet, "Center");
        this.addKeyListener(sheetClick);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.hsheet = toolkit.createImage("Interface" + File.separator + "hsheet.gif");
        this.poisonedpic = toolkit.createImage("Interface" + File.separator + "poisoned.gif");
        this.hurtweapon = toolkit.createImage("Icons" + File.separator + "hurt_weapon.gif");
        this.hurthand = toolkit.createImage("Icons" + File.separator + "hurt_hand.gif");
        this.hurthead = toolkit.createImage("Icons" + File.separator + "hurt_head.gif");
        this.hurttorso = toolkit.createImage("Icons" + File.separator + "hurt_torso.gif");
        this.hurtlegs = toolkit.createImage("Icons" + File.separator + "hurt_legs.gif");
        this.hurtfeet = toolkit.createImage("Icons" + File.separator + "hurt_feet.gif");
        this.tracker = new MediaTracker(this);
        this.tracker.addImage(this.hsheet, 0);
        this.tracker.addImage(this.poisonedpic, 0);
        this.tracker.addImage(this.hurtweapon, 0);
        this.tracker.addImage(this.hurthand, 0);
        this.tracker.addImage(this.hurthead, 0);
        this.tracker.addImage(this.hurttorso, 0);
        this.tracker.addImage(this.hurtlegs, 0);
        this.tracker.addImage(this.hurtfeet, 0);
        this.tracker.checkID(0, true);
    }

    public void addHero(HeroData heroData) {
        this.hpanel.add(heroData);
        heroData.addMouseListener(this);
    }

    protected void removeHeroes() {
        this.hpanel.removeAll();
        this.sheet.hero = null;
    }

    public boolean hasHero(HeroData heroData) {
        return this.hpanel.isAncestorOf(heroData);
    }

    public void setHero(HeroData heroData) {
        if (this.sheet.hero != null) {
            this.sheet.hero.setBorder(null);
        }
        heroData.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.sheet.setHero(heroData);
        if (this.isVisible()) {
            this.hpanel.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.sheet.hero != null && mouseEvent.getSource() == this.sheet.hero) {
            new ChampionEdit(this.dmed, this.sheet.hero);
        } else {
            this.setHero((HeroData)mouseEvent.getSource());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    class ChampionEdit
    extends JDialog
    implements ActionListener,
    FilenameFilter {
        HeroData hero;
        JTextField name;
        JTextField lastname;
        JTextField health;
        JTextField maxhealth;
        JTextField stamina;
        JTextField maxstamina;
        JTextField mana;
        JTextField maxmana;
        JTextField strength;
        JTextField nstrength;
        JTextField dexterity;
        JTextField ndexterity;
        JTextField vitality;
        JTextField nvitality;
        JTextField intelligence;
        JTextField nintelligence;
        JTextField wisdom;
        JTextField nwisdom;
        JTextField defense;
        JTextField ndefense;
        JTextField magicresist;
        JTextField nmagicresist;
        JTextField food;
        JTextField water;
        JComboBox flevelbox;
        JComboBox nlevelbox;
        JComboBox wlevelbox;
        JComboBox plevelbox;
        JComboBox flevelbox2;
        JComboBox nlevelbox2;
        JComboBox wlevelbox2;
        JComboBox plevelbox2;
        JTextField poisoned;
        JTextField silenced;
        String picname;
        String picdirectory;
        ImageIcon pic;
        JLabel portrait;
        int picnumber;
        File portraitdirectory;
        File[] portraitfiles;
        Toolkit tk;
        Vector abilities;

        public ChampionEdit(JFrame jFrame, HeroData heroData) {
            File file;
            super(jFrame, "Edit Champion", true);
            this.picnumber = 0;
            this.abilities = new Vector();
            this.setSize(720, 480);
            this.setLocationRelativeTo(jFrame);
            Container container = this.getContentPane();
            this.hero = heroData;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(14, 1, 2, 11));
            jPanel.add(new JLabel("Fighter Level:", 4));
            jPanel.add(new JLabel("Ninja Level:", 4));
            jPanel.add(new JLabel("Wizard Level:", 4));
            jPanel.add(new JLabel("Priest Level:", 4));
            jPanel.add(new JLabel("Health:", 4));
            jPanel.add(new JLabel("Stamina:", 4));
            jPanel.add(new JLabel("Mana:", 4));
            jPanel.add(new JLabel("Strength:", 4));
            jPanel.add(new JLabel("Dexterity:", 4));
            jPanel.add(new JLabel("Vitality:", 4));
            jPanel.add(new JLabel("Intelligence:", 4));
            jPanel.add(new JLabel("Wisdom:", 4));
            jPanel.add(new JLabel("Defense:", 4));
            jPanel.add(new JLabel("Magic Resist:", 4));
            this.name = new JTextField(heroData.name, 8);
            this.lastname = new JTextField(heroData.lastname, 25);
            this.food = new JTextField("" + heroData.food, 4);
            this.water = new JTextField("" + heroData.water, 4);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel("Food:", 4));
            jPanel2.add(this.food);
            jPanel2.add(new JLabel("Water:", 4));
            jPanel2.add(this.water);
            this.poisoned = new JTextField("0", 3);
            this.silenced = new JTextField("0", 3);
            if (heroData.ispoisoned) {
                this.poisoned.setText("" + heroData.poison);
            }
            if (heroData.silenced) {
                this.silenced.setText("" + heroData.silencecount);
            }
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel("Poisoned:", 4));
            jPanel3.add(this.poisoned);
            jPanel3.add(new JLabel("Silenced:", 4));
            jPanel3.add(this.silenced);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(this.name);
            jPanel4.add(this.lastname);
            jPanel4.add(jPanel2);
            jPanel4.add(jPanel3);
            jPanel4.setPreferredSize(new Dimension(300, 120));
            this.flevelbox = new JComboBox<String>(LEVELNAMES);
            this.flevelbox.setEditable(false);
            this.flevelbox.setSelectedIndex(heroData.flevel);
            this.nlevelbox = new JComboBox<String>(LEVELNAMES);
            this.nlevelbox.setEditable(false);
            this.nlevelbox.setSelectedIndex(heroData.nlevel);
            this.wlevelbox = new JComboBox<String>(LEVELNAMES);
            this.wlevelbox.setEditable(false);
            this.wlevelbox.setSelectedIndex(heroData.wlevel);
            this.plevelbox = new JComboBox<String>(LEVELNAMES);
            this.plevelbox.setEditable(false);
            this.plevelbox.setSelectedIndex(heroData.plevel);
            this.flevelbox2 = new JComboBox<String>(LEVELNAMES);
            this.flevelbox2.setEditable(false);
            this.flevelbox2.setSelectedIndex(heroData.flevel - heroData.flevelboost);
            this.nlevelbox2 = new JComboBox<String>(LEVELNAMES);
            this.nlevelbox2.setEditable(false);
            this.nlevelbox2.setSelectedIndex(heroData.nlevel - heroData.nlevelboost);
            this.wlevelbox2 = new JComboBox<String>(LEVELNAMES);
            this.wlevelbox2.setEditable(false);
            this.wlevelbox2.setSelectedIndex(heroData.wlevel - heroData.wlevelboost);
            this.plevelbox2 = new JComboBox<String>(LEVELNAMES);
            this.plevelbox2.setEditable(false);
            this.plevelbox2.setSelectedIndex(heroData.plevel - heroData.plevelboost);
            this.health = new JTextField("" + heroData.health, 4);
            this.maxhealth = new JTextField("" + heroData.maxhealth, 4);
            this.stamina = new JTextField("" + heroData.stamina, 4);
            this.maxstamina = new JTextField("" + heroData.maxstamina, 4);
            this.mana = new JTextField("" + heroData.mana, 4);
            this.maxmana = new JTextField("" + heroData.maxmana, 4);
            this.strength = new JTextField("" + heroData.strength, 4);
            this.nstrength = new JTextField("" + (heroData.strength - heroData.strengthboost), 4);
            this.dexterity = new JTextField("" + heroData.dexterity, 4);
            this.ndexterity = new JTextField("" + (heroData.dexterity - heroData.dexterityboost), 4);
            this.vitality = new JTextField("" + heroData.vitality, 4);
            this.nvitality = new JTextField("" + (heroData.vitality - heroData.vitalityboost), 4);
            this.intelligence = new JTextField("" + heroData.intelligence, 4);
            this.nintelligence = new JTextField("" + (heroData.intelligence - heroData.intelligenceboost), 4);
            this.wisdom = new JTextField("" + heroData.wisdom, 4);
            this.nwisdom = new JTextField("" + (heroData.wisdom - heroData.wisdomboost), 4);
            this.defense = new JTextField("" + heroData.defense, 4);
            this.ndefense = new JTextField("" + (heroData.defense - heroData.defenseboost), 4);
            this.magicresist = new JTextField("" + heroData.magicresist, 4);
            this.nmagicresist = new JTextField("" + (heroData.magicresist - heroData.magicresistboost), 4);
            FlowLayout flowLayout = new FlowLayout(0, 2, 0);
            JPanel jPanel5 = new JPanel(flowLayout);
            jPanel5.add(this.flevelbox);
            jPanel5.add(new JLabel("/"));
            jPanel5.add(this.flevelbox2);
            JPanel jPanel6 = new JPanel(flowLayout);
            jPanel6.add(this.nlevelbox);
            jPanel6.add(new JLabel("/"));
            jPanel6.add(this.nlevelbox2);
            JPanel jPanel7 = new JPanel(flowLayout);
            jPanel7.add(this.wlevelbox);
            jPanel7.add(new JLabel("/"));
            jPanel7.add(this.wlevelbox2);
            JPanel jPanel8 = new JPanel(flowLayout);
            jPanel8.add(this.plevelbox);
            jPanel8.add(new JLabel("/"));
            jPanel8.add(this.plevelbox2);
            JPanel jPanel9 = new JPanel(flowLayout);
            jPanel9.add(this.health);
            jPanel9.add(new JLabel("/"));
            jPanel9.add(this.maxhealth);
            JPanel jPanel10 = new JPanel(flowLayout);
            jPanel10.add(this.stamina);
            jPanel10.add(new JLabel("/"));
            jPanel10.add(this.maxstamina);
            JPanel jPanel11 = new JPanel(flowLayout);
            jPanel11.add(this.mana);
            jPanel11.add(new JLabel("/"));
            jPanel11.add(this.maxmana);
            JPanel jPanel12 = new JPanel(flowLayout);
            jPanel12.add(this.strength);
            jPanel12.add(new JLabel("/"));
            jPanel12.add(this.nstrength);
            JPanel jPanel13 = new JPanel(flowLayout);
            jPanel13.add(this.dexterity);
            jPanel13.add(new JLabel("/"));
            jPanel13.add(this.ndexterity);
            JPanel jPanel14 = new JPanel(flowLayout);
            jPanel14.add(this.vitality);
            jPanel14.add(new JLabel("/"));
            jPanel14.add(this.nvitality);
            JPanel jPanel15 = new JPanel(flowLayout);
            jPanel15.add(this.intelligence);
            jPanel15.add(new JLabel("/"));
            jPanel15.add(this.nintelligence);
            JPanel jPanel16 = new JPanel(flowLayout);
            jPanel16.add(this.wisdom);
            jPanel16.add(new JLabel("/"));
            jPanel16.add(this.nwisdom);
            JPanel jPanel17 = new JPanel(flowLayout);
            jPanel17.add(this.defense);
            jPanel17.add(new JLabel("/"));
            jPanel17.add(this.ndefense);
            JPanel jPanel18 = new JPanel(flowLayout);
            jPanel18.add(this.magicresist);
            jPanel18.add(new JLabel("/"));
            jPanel18.add(this.nmagicresist);
            JPanel jPanel19 = new JPanel();
            jPanel19.setLayout(new GridLayout(14, 1, 5, 0));
            jPanel19.add(jPanel5);
            jPanel19.add(jPanel6);
            jPanel19.add(jPanel7);
            jPanel19.add(jPanel8);
            jPanel19.add(jPanel9);
            jPanel19.add(jPanel10);
            jPanel19.add(jPanel11);
            jPanel19.add(jPanel12);
            jPanel19.add(jPanel13);
            jPanel19.add(jPanel14);
            jPanel19.add(jPanel15);
            jPanel19.add(jPanel16);
            jPanel19.add(jPanel17);
            jPanel19.add(jPanel18);
            JPanel jPanel20 = new JPanel();
            jPanel20.add(Box.createHorizontalStrut(5));
            jPanel20.add(jPanel);
            jPanel20.add(jPanel19);
            jPanel20.setBorder(BorderFactory.createEtchedBorder());
            container.add((Component)jPanel20, "West");
            this.tk = Toolkit.getDefaultToolkit();
            ((HeroPanel)HeroPanel.this).dmed.chooser.setCurrentDirectory(new File(((HeroPanel)HeroPanel.this).dmed.workingdir, "Heroes"));
            this.picdirectory = "";
            boolean bl = false;
            if (heroData.picname.indexOf(47) > 0) {
                this.picdirectory = heroData.picname.substring(0, heroData.picname.lastIndexOf(47));
                file = new File("Heroes/" + this.picdirectory);
                if (!file.exists()) {
                    this.picdirectory = "";
                    heroData.picname = "balaan.gif";
                    bl = true;
                }
            }
            this.portraitdirectory = new File("Heroes/" + this.picdirectory);
            this.portraitfiles = this.portraitdirectory.listFiles(this);
            Arrays.sort(this.portraitfiles);
            file = new File("Heroes/" + heroData.picname);
            if (!this.picdirectory.equals("")) {
                this.picdirectory = this.picdirectory + '/';
            }
            if (!file.exists()) {
                heroData.picname = this.picdirectory + this.portraitfiles[0].getName();
                bl = true;
            }
            this.pic = bl ? new ImageIcon("Heroes/" + heroData.picname) : new ImageIcon(heroData.pic);
            this.picname = heroData.picname = heroData.picname.replace('\\', '/');
            this.portrait = new JLabel(this.pic);
            String string = this.picname;
            if (string.indexOf(47) > 0) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            boolean bl2 = false;
            while (!bl2 && this.picnumber < this.portraitfiles.length) {
                if (this.portraitfiles[this.picnumber].getName().equals(string)) {
                    bl2 = true;
                    continue;
                }
                ++this.picnumber;
            }
            if (!bl2) {
                this.picnumber = 0;
            }
            JButton jButton = new JButton(new ImageIcon("Icons" + File.separator + "leftarrow.gif"));
            JButton jButton2 = new JButton(new ImageIcon("Icons" + File.separator + "rightarrow.gif"));
            JButton jButton3 = new JButton("Browse");
            JPanel jPanel21 = new JPanel();
            JPanel jPanel22 = new JPanel();
            JPanel jPanel23 = new JPanel();
            jButton2.setActionCommand("<");
            jButton2.addActionListener(this);
            jButton.setActionCommand(">");
            jButton.addActionListener(this);
            jButton3.addActionListener(this);
            jPanel23.add(this.portrait);
            jPanel23.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Portrait"));
            jPanel21.add(jButton);
            jPanel21.add(jButton2);
            jPanel21.add(jButton3);
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalGlue());
            box.add(jPanel4);
            box.add(Box.createVerticalStrut(20));
            box.add(jPanel23);
            box.add(jPanel21);
            box.add(Box.createVerticalGlue());
            container.add((Component)box, "Center");
            if (heroData.abilities != null) {
                for (int i = 0; i < heroData.abilities.length; ++i) {
                    this.abilities.add(new SpecialAbility(heroData.abilities[i]));
                }
            }
            JButton jButton4 = new JButton("Done");
            JButton jButton5 = new JButton("Cancel");
            JButton jButton6 = new JButton("Special Abilities...");
            jButton4.addActionListener(this);
            jButton5.addActionListener(this);
            jButton6.addActionListener(this);
            JPanel jPanel24 = new JPanel();
            jPanel24.add(jButton6);
            jPanel24.add(Box.createHorizontalStrut(60));
            jPanel24.add(jButton5);
            jPanel24.add(jButton4);
            container.add((Component)jPanel24, "South");
            this.show();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(">")) {
                --this.picnumber;
                if (this.picnumber < 0) {
                    this.picnumber = this.portraitfiles.length - 1;
                }
                this.picname = this.picdirectory + this.portraitfiles[this.picnumber].getName();
                this.pic.setImage(this.tk.getImage("Heroes/" + this.picname));
                this.portrait.repaint();
            } else if (actionEvent.getActionCommand().equals("<")) {
                ++this.picnumber;
                if (this.picnumber == this.portraitfiles.length) {
                    this.picnumber = 0;
                }
                this.picname = this.picdirectory + this.portraitfiles[this.picnumber].getName();
                this.pic.setImage(this.tk.getImage("Heroes/" + this.picname));
                this.portrait.repaint();
            } else if (actionEvent.getActionCommand().equals("Browse")) {
                int n = ((HeroPanel)HeroPanel.this).dmed.chooser.showOpenDialog(this);
                if (n == 0) {
                    File file = ((HeroPanel)HeroPanel.this).dmed.chooser.getSelectedFile();
                    String string = file.getName();
                    String string2 = file.getParent();
                    int n2 = string2.indexOf("Heroes");
                    if (n2 >= 0) {
                        this.picdirectory = string2.substring(n2 + 6) + "/";
                        this.picdirectory = this.picdirectory.length() == 1 ? "" : this.picdirectory.substring(1);
                        this.picdirectory = this.picdirectory.replace('\\', '/');
                        this.picname = this.picdirectory + string;
                        this.picname = this.picname.replace('\\', '/');
                        this.pic.setImage(this.tk.getImage("Heroes/" + this.picname));
                        this.portrait.repaint();
                        if (!file.getParent().equals(this.portraitdirectory.getPath())) {
                            this.portraitdirectory = new File(file.getParent() + File.separator);
                            this.portraitfiles = this.portraitdirectory.listFiles(this);
                            Arrays.sort(this.portraitfiles);
                        }
                        this.picnumber = 0;
                        boolean bl = false;
                        String string3 = string;
                        while (!bl && this.picnumber < this.portraitfiles.length) {
                            if (this.portraitfiles[this.picnumber].getName().equals(string3)) {
                                bl = true;
                                continue;
                            }
                            ++this.picnumber;
                        }
                        if (!bl) {
                            this.picnumber = 0;
                        }
                    }
                }
            } else if (actionEvent.getActionCommand().equals("Done")) {
                int n;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                try {
                    n23 = Integer.parseInt(this.health.getText());
                    n22 = Integer.parseInt(this.maxhealth.getText());
                    n21 = Integer.parseInt(this.stamina.getText());
                    n20 = Integer.parseInt(this.maxstamina.getText());
                    n19 = Integer.parseInt(this.mana.getText());
                    n18 = Integer.parseInt(this.maxmana.getText());
                    n17 = Integer.parseInt(this.strength.getText());
                    n16 = Integer.parseInt(this.nstrength.getText());
                    n15 = Integer.parseInt(this.dexterity.getText());
                    n14 = Integer.parseInt(this.ndexterity.getText());
                    n13 = Integer.parseInt(this.vitality.getText());
                    n12 = Integer.parseInt(this.nvitality.getText());
                    n11 = Integer.parseInt(this.intelligence.getText());
                    n10 = Integer.parseInt(this.nintelligence.getText());
                    n9 = Integer.parseInt(this.wisdom.getText());
                    n8 = Integer.parseInt(this.nwisdom.getText());
                    n7 = Integer.parseInt(this.defense.getText());
                    n6 = Integer.parseInt(this.ndefense.getText());
                    n5 = Integer.parseInt(this.magicresist.getText());
                    n4 = Integer.parseInt(this.nmagicresist.getText());
                    n3 = Integer.parseInt(this.food.getText());
                    n = Integer.parseInt(this.water.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(HeroPanel.this.dmed, "Invalid Number: " + numberFormatException.getMessage(), "Notice", 0);
                    return;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(HeroPanel.this.dmed, "Invalid Entry: " + exception.getMessage(), "Notice", 0);
                    return;
                }
                if (n23 < 1) {
                    n23 = 1;
                }
                if (n22 < 1) {
                    n22 = 1;
                }
                if (n21 < 1) {
                    n21 = 1;
                }
                if (n20 < 10) {
                    n20 = 10;
                }
                if (n19 < 0) {
                    n19 = 0;
                }
                if (n18 < 0) {
                    n18 = 0;
                }
                if (n17 < 1) {
                    n17 = 1;
                }
                if (n16 < 1) {
                    n16 = 1;
                }
                if (n15 < 1) {
                    n15 = 1;
                }
                if (n14 < 1) {
                    n14 = 1;
                }
                if (n13 < 1) {
                    n13 = 1;
                }
                if (n12 < 1) {
                    n12 = 1;
                }
                if (n11 < 1) {
                    n11 = 1;
                }
                if (n10 < 1) {
                    n10 = 1;
                }
                if (n9 < 1) {
                    n9 = 1;
                }
                if (n8 < 1) {
                    n8 = 1;
                }
                this.hero.health = n23;
                this.hero.maxhealth = n22;
                this.hero.isdead = false;
                this.hero.stamina = n21;
                this.hero.maxstamina = n20;
                this.hero.mana = n19;
                this.hero.maxmana = n18;
                this.hero.strength = n17;
                this.hero.dexterity = n15;
                this.hero.vitality = n13;
                this.hero.intelligence = n11;
                this.hero.wisdom = n9;
                this.hero.defense = n7;
                this.hero.magicresist = n5;
                this.hero.strengthboost = this.hero.strength - n16;
                this.hero.dexterityboost = this.hero.dexterity - n14;
                this.hero.vitalityboost = this.hero.vitality - n12;
                this.hero.intelligenceboost = this.hero.intelligence - n10;
                this.hero.wisdomboost = this.hero.wisdom - n8;
                this.hero.defenseboost = this.hero.defense - n6;
                this.hero.magicresistboost = this.hero.magicresist - n4;
                this.hero.setMaxLoad();
                if (n3 < 11) {
                    n3 = 10;
                } else if (n3 > 1000) {
                    n3 = 1000;
                }
                if (n < 11) {
                    n = 10;
                } else if (n > 1000) {
                    n = 1000;
                }
                this.hero.food = n3;
                this.hero.water = n;
                this.hero.flevel = this.flevelbox.getSelectedIndex();
                this.hero.nlevel = this.nlevelbox.getSelectedIndex();
                this.hero.wlevel = this.wlevelbox.getSelectedIndex();
                this.hero.plevel = this.plevelbox.getSelectedIndex();
                this.hero.flevelboost = this.hero.flevel - this.flevelbox2.getSelectedIndex();
                this.hero.nlevelboost = this.hero.nlevel - this.nlevelbox2.getSelectedIndex();
                this.hero.wlevelboost = this.hero.wlevel - this.wlevelbox2.getSelectedIndex();
                this.hero.plevelboost = this.hero.plevel - this.plevelbox2.getSelectedIndex();
                this.hero.poison = Integer.parseInt(this.poisoned.getText());
                this.hero.silencecount = Integer.parseInt(this.silenced.getText());
                if (this.hero.poison > 0) {
                    this.hero.ispoisoned = true;
                }
                if (this.hero.silencecount > 0) {
                    this.hero.silenced = true;
                }
                if (this.hero.poison < 0) {
                    this.hero.poison = 0;
                }
                if (this.hero.silencecount < 0) {
                    this.hero.silencecount = 0;
                }
                this.hero.name = this.name.getText();
                this.hero.lastname = this.lastname.getText();
                if (this.hero.name.length() > 8) {
                    this.hero.name = this.hero.name.substring(8);
                }
                if (this.hero.lastname.length() > 30) {
                    this.hero.name = this.hero.lastname.substring(30);
                }
                this.hero.pic = this.pic.getImage();
                this.hero.picname = this.picname;
                if (this.abilities.size() > 0) {
                    this.hero.abilities = new SpecialAbility[this.abilities.size()];
                    for (int i = 0; i < this.abilities.size(); ++i) {
                        this.hero.abilities[i] = (SpecialAbility)this.abilities.get(i);
                    }
                } else {
                    this.hero.abilities = null;
                }
                ((ImageIcon)this.hero.getIcon()).setImage(this.hero.pic);
                HeroPanel.this.sheet.repaint();
                HeroPanel.this.hpanel.repaint();
                this.dispose();
            } else if (actionEvent.getActionCommand().startsWith("Special")) {
                new HeroSpecials(HeroPanel.this.dmed, this.abilities);
            } else {
                this.dispose();
            }
        }

        @Override
        public boolean accept(File file, String string) {
            return (string = string.toLowerCase()).endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png");
        }
    }

    class SheetClick
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        int x;
        int y;

        SheetClick() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                HeroSheet heroSheet = HeroPanel.this.sheet;
                if (this.x > 124 && this.x < 156 && this.y < 136 && this.y > 104 && heroSheet.hero.weapon != DMEditor.fistfoot) {
                    if (heroSheet.hero.weapon.type == 0 || heroSheet.hero.weapon.type == 1) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.weapon);
                    }
                    heroSheet.hero.load -= heroSheet.hero.weapon.weight;
                    heroSheet.hero.weapon = DMEditor.fistfoot;
                    heroSheet.repaint();
                } else if (this.x > 12 && this.x < 44 && this.y < 136 && this.y > 104 && heroSheet.hero.hand != null) {
                    if (heroSheet.hero.hand.type == 1) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.hand);
                    }
                    heroSheet.hero.load -= heroSheet.hero.hand.weight;
                    heroSheet.hero.hand = null;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 84 && this.y > 52 && heroSheet.hero.head != null) {
                    if (heroSheet.hero.head.type == 2) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.head);
                    }
                    heroSheet.hero.load -= heroSheet.hero.head.weight;
                    heroSheet.hero.head = null;
                    heroSheet.repaint();
                } else if (this.x > 12 && this.x < 44 && this.y < 98 && this.y > 66 && heroSheet.hero.neck != null) {
                    if (heroSheet.hero.neck.type == 4) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.neck);
                    }
                    heroSheet.hero.load -= heroSheet.hero.neck.weight;
                    heroSheet.hero.neck = null;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 124 && this.y > 92 && heroSheet.hero.torso != null) {
                    if (heroSheet.hero.torso.type == 3) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.torso);
                    }
                    heroSheet.hero.load -= heroSheet.hero.torso.weight;
                    heroSheet.hero.torso = null;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 164 && this.y > 132 && heroSheet.hero.legs != null) {
                    if (heroSheet.hero.legs.type == 5) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.legs);
                    }
                    heroSheet.hero.load -= heroSheet.hero.legs.weight;
                    heroSheet.hero.legs = null;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 204 && this.y > 172 && heroSheet.hero.feet != null) {
                    if (heroSheet.hero.feet.type == 6) {
                        heroSheet.hero.unEquipEffect(heroSheet.hero.feet);
                    }
                    heroSheet.hero.load -= heroSheet.hero.feet.weight;
                    heroSheet.hero.feet = null;
                    heroSheet.repaint();
                } else if (this.x > 12 && this.x < 44 && this.y < 199 && this.y > 167 && heroSheet.hero.pouch1 != null) {
                    heroSheet.hero.load -= heroSheet.hero.pouch1.weight;
                    heroSheet.hero.pouch1 = null;
                    heroSheet.repaint();
                } else if (this.x > 12 && this.x < 44 && this.y < 233 && this.y > 201 && heroSheet.hero.pouch2 != null) {
                    heroSheet.hero.load -= heroSheet.hero.pouch2.weight;
                    heroSheet.hero.pouch2 = null;
                    heroSheet.repaint();
                } else if (this.x > 166 && this.x < 436 && this.y < 98 && this.y > 32) {
                    int n = 0;
                    if (this.y > 65) {
                        n = 8;
                    }
                    if (heroSheet.hero.pack[(this.x - 166) / 34 + n] != null) {
                        heroSheet.hero.load -= heroSheet.hero.pack[(this.x - 166) / 34 + n].weight;
                        heroSheet.hero.pack[(this.x - 166) / 34 + n] = null;
                        heroSheet.repaint();
                    }
                } else if (this.x > 124 && this.x < 190 && this.y < 267 && this.y > 167) {
                    int n = 0;
                    if (this.y > 234) {
                        n = 4;
                    } else if (this.y > 200) {
                        n = 2;
                    }
                    if (heroSheet.hero.quiver[(this.x - 124) / 34 + n] != null) {
                        heroSheet.hero.load -= heroSheet.hero.quiver[(this.x - 124) / 34 + n].weight;
                        heroSheet.hero.quiver[(this.x - 124) / 34 + n] = null;
                        heroSheet.repaint();
                    }
                }
            } else if (keyEvent.getKeyCode() == 155) {
                HeroSheet heroSheet = HeroPanel.this.sheet;
                if (this.x > 124 && this.x < 156 && this.y < 136 && this.y > 104) {
                    heroSheet.hero.hurtweapon = !heroSheet.hero.hurtweapon;
                    heroSheet.repaint();
                } else if (this.x > 12 && this.x < 44 && this.y < 136 && this.y > 104) {
                    heroSheet.hero.hurthand = !heroSheet.hero.hurthand;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 84 && this.y > 52) {
                    heroSheet.hero.hurthead = !heroSheet.hero.hurthead;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 124 && this.y > 92) {
                    heroSheet.hero.hurttorso = !heroSheet.hero.hurttorso;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 164 && this.y > 132) {
                    heroSheet.hero.hurtlegs = !heroSheet.hero.hurtlegs;
                    heroSheet.repaint();
                } else if (this.x > 68 && this.x < 100 && this.y < 204 && this.y > 172) {
                    heroSheet.hero.hurtfeet = !heroSheet.hero.hurtfeet;
                    heroSheet.repaint();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HeroSheet heroSheet = (HeroSheet)mouseEvent.getSource();
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            if (this.x > 124 && this.x < 156 && this.y < 136 && this.y > 104) {
                Item item;
                if (heroSheet.hero.weapon.number == 219 || heroSheet.hero.weapon.number == 261) {
                    return;
                }
                if (heroSheet.hero.weapon != DMEditor.fistfoot) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Weapon Hand");
                    DMEditor.itemwizard.setItem(heroSheet.hero.weapon);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Weapon Hand");
                    DMEditor.itemwizard.showFromHero(0);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null) {
                    if (heroSheet.hero.weapon != null) {
                        if (heroSheet.hero.weapon.type == 0 || heroSheet.hero.weapon.type == 1) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.weapon);
                        }
                        heroSheet.hero.load -= heroSheet.hero.weapon.weight;
                    }
                    heroSheet.hero.weapon = item;
                    if (item.type == 0 || item.type == 1) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 12 && this.x < 44 && this.y < 136 && this.y > 104) {
                Item item;
                if (heroSheet.hero.hand != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Ready Hand");
                    DMEditor.itemwizard.setItem(heroSheet.hero.hand);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Ready Hand");
                    DMEditor.itemwizard.showFromHero(1);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null) {
                    if (heroSheet.hero.hand != null) {
                        if (heroSheet.hero.hand.type == 1) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.hand);
                        }
                        heroSheet.hero.load -= heroSheet.hero.hand.weight;
                    }
                    heroSheet.hero.hand = item;
                    if (item.type == 1) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 68 && this.x < 100 && this.y < 84 && this.y > 52) {
                Item item;
                if (heroSheet.hero.head != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item On " + heroSheet.hero.name + "'s Head");
                    DMEditor.itemwizard.setItem(heroSheet.hero.head);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item On " + heroSheet.hero.name + "'s Head");
                    DMEditor.itemwizard.showFromHero(2);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 2) {
                    if (heroSheet.hero.head != null) {
                        if (heroSheet.hero.head.type == 2) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.head);
                        }
                        heroSheet.hero.load -= heroSheet.hero.head.weight;
                    }
                    heroSheet.hero.head = item;
                    if (item.type == 2) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 12 && this.x < 44 && this.y < 98 && this.y > 66) {
                Item item;
                if (heroSheet.hero.neck != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item Around " + heroSheet.hero.name + "'s Neck");
                    DMEditor.itemwizard.setItem(heroSheet.hero.neck);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item Around " + heroSheet.hero.name + "'s Neck");
                    DMEditor.itemwizard.showFromHero(4);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 4) {
                    if (heroSheet.hero.neck != null) {
                        if (heroSheet.hero.neck.type == 4) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.neck);
                        }
                        heroSheet.hero.load -= heroSheet.hero.neck.weight;
                    }
                    heroSheet.hero.neck = item;
                    if (item.type == 4) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 68 && this.x < 100 && this.y < 124 && this.y > 92) {
                Item item;
                if (heroSheet.hero.torso != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item On " + heroSheet.hero.name + "'s Torso");
                    DMEditor.itemwizard.setItem(heroSheet.hero.torso);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item On " + heroSheet.hero.name + "'s Torso");
                    DMEditor.itemwizard.showFromHero(3);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 3) {
                    if (heroSheet.hero.torso != null) {
                        if (heroSheet.hero.torso.type == 3) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.torso);
                        }
                        heroSheet.hero.load -= heroSheet.hero.torso.weight;
                    }
                    heroSheet.hero.torso = item;
                    if (item.type == 3) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 68 && this.x < 100 && this.y < 164 && this.y > 132) {
                Item item;
                if (heroSheet.hero.legs != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item On " + heroSheet.hero.name + "'s Legs");
                    DMEditor.itemwizard.setItem(heroSheet.hero.legs);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item On " + heroSheet.hero.name + "'s Legs");
                    DMEditor.itemwizard.showFromHero(5);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 5) {
                    if (heroSheet.hero.legs != null) {
                        if (heroSheet.hero.legs.type == 5) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.legs);
                        }
                        heroSheet.hero.load -= heroSheet.hero.legs.weight;
                    }
                    heroSheet.hero.legs = item;
                    if (item.type == 5) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 68 && this.x < 100 && this.y < 204 && this.y > 172) {
                Item item;
                if (heroSheet.hero.feet != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item On " + heroSheet.hero.name + "'s Feet");
                    DMEditor.itemwizard.setItem(heroSheet.hero.feet);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item On " + heroSheet.hero.name + "'s Feet");
                    DMEditor.itemwizard.showFromHero(6);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 6) {
                    if (heroSheet.hero.feet != null) {
                        if (heroSheet.hero.feet.type == 6) {
                            heroSheet.hero.unEquipEffect(heroSheet.hero.feet);
                        }
                        heroSheet.hero.load -= heroSheet.hero.feet.weight;
                    }
                    heroSheet.hero.feet = item;
                    if (item.type == 6) {
                        heroSheet.hero.equipEffect(item);
                    }
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 12 && this.x < 44 && this.y < 199 && this.y > 167) {
                Item item;
                if (heroSheet.hero.pouch1 != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Pouch");
                    DMEditor.itemwizard.setItem(heroSheet.hero.pouch1);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Pouch");
                    DMEditor.itemwizard.show();
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.size < 2) {
                    if (heroSheet.hero.pouch1 != null) {
                        heroSheet.hero.load -= heroSheet.hero.pouch1.weight;
                    }
                    heroSheet.hero.pouch1 = item;
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 12 && this.x < 44 && this.y < 233 && this.y > 201) {
                Item item;
                if (heroSheet.hero.pouch2 != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Pouch");
                    DMEditor.itemwizard.setItem(heroSheet.hero.pouch2);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Pouch");
                    DMEditor.itemwizard.show();
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.size < 2) {
                    if (heroSheet.hero.pouch2 != null) {
                        heroSheet.hero.load -= heroSheet.hero.pouch2.weight;
                    }
                    heroSheet.hero.pouch2 = item;
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 166 && this.x < 436 && this.y < 98 && this.y > 32) {
                Item item;
                int n = 0;
                if (this.y > 65) {
                    n = 8;
                }
                if (heroSheet.hero.pack[(this.x - 166) / 34 + n] != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Pack");
                    DMEditor.itemwizard.setItem(heroSheet.hero.pack[(this.x - 166) / 34 + n]);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Pack");
                    DMEditor.itemwizard.show();
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null) {
                    if (heroSheet.hero.pack[(this.x - 166) / 34 + n] != null) {
                        heroSheet.hero.load -= heroSheet.hero.pack[(this.x - 166) / 34 + n].weight;
                    }
                    heroSheet.hero.pack[(this.x - 166) / 34 + n] = item;
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 124 && this.x < 190 && this.y < 267 && this.y > 167) {
                Item item;
                int n = 0;
                if (this.y > 234) {
                    n = 4;
                } else if (this.y > 200) {
                    n = 2;
                }
                if (heroSheet.hero.quiver[(this.x - 124) / 34 + n] != null) {
                    DMEditor.itemwizard.setTitle("Item Wizard - Change Item In " + heroSheet.hero.name + "'s Quiver");
                    DMEditor.itemwizard.setItem(heroSheet.hero.quiver[(this.x - 124) / 34 + n]);
                    item = DMEditor.itemwizard.getItem();
                } else {
                    DMEditor.itemwizard.setTitle("Item Wizard - Put An Item In " + heroSheet.hero.name + "'s Quiver");
                    DMEditor.itemwizard.showFromHero(7);
                    item = DMEditor.itemwizard.getItem();
                }
                if (item != null && item.type == 0 && (item.projtype > 0 && item.size < 2 || item.size < 4 && (this.x - 124) / 34 + n == 0)) {
                    if (heroSheet.hero.quiver[(this.x - 124) / 34 + n] != null) {
                        heroSheet.hero.load -= heroSheet.hero.quiver[(this.x - 124) / 34 + n].weight;
                    }
                    heroSheet.hero.quiver[(this.x - 124) / 34 + n] = item;
                    heroSheet.hero.load += item.weight;
                    heroSheet.repaint();
                }
            } else if (this.x > 5 && this.x < 250 && this.y < 20 && this.y > 4 || this.x > 10 && this.x < 190 && this.y > 272 || this.x > 205 && this.x < 438 && this.y < 295 && this.y > 103) {
                new ChampionEdit(HeroPanel.this.dmed, heroSheet.hero);
            } else if (this.x > 22 && this.x < 57 && this.y < 58 && this.y > 24 || this.x > 109 && this.x < 146 && this.y < 58 && this.y > 24) {
                heroSheet.viewing = true;
                heroSheet.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (((HeroPanel)HeroPanel.this).sheet.viewing) {
                ((HeroPanel)HeroPanel.this).sheet.viewing = false;
                HeroPanel.this.sheet.paint(HeroPanel.this.sheet.getGraphics());
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    private class HeroSheet
    extends JComponent {
        HeroData hero;
        BufferedImage offscreen;
        Graphics2D offg;
        boolean viewing = false;
        Font dungfont14;
        Font dungfont24;

        public HeroSheet(Font font) {
            this.setSize(448, 326);
            this.setBackground(Color.black);
            this.offscreen = new BufferedImage(448, 326, 4);
            this.offg = this.offscreen.createGraphics();
            this.offg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.dungfont14 = font.deriveFont(14.0f);
            this.dungfont24 = this.dungfont14.deriveFont(24.0f);
        }

        public void setHero(HeroData heroData) {
            this.hero = heroData;
            if (this.isVisible()) {
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            this.offg.setFont(this.dungfont14);
            this.offg.drawImage(HeroPanel.this.hsheet, 0, 0, null);
            this.offg.setColor(new Color(30, 30, 30));
            this.offg.drawString(this.hero.name + "   " + this.hero.lastname, 8, 20);
            this.offg.drawString("Health", 18, 288);
            this.offg.drawString(this.hero.health + " / " + this.hero.maxhealth, 128, 288);
            this.offg.drawString("Stamina", 18, 306);
            this.offg.drawString(this.hero.stamina + " / " + this.hero.maxstamina, 128, 306);
            this.offg.drawString("Mana", 18, 324);
            this.offg.drawString(this.hero.mana + " / " + this.hero.maxmana, 128, 324);
            this.offg.setColor(Color.white);
            this.offg.drawString(this.hero.name + "   " + this.hero.lastname, 5, 17);
            this.offg.drawString("Health", 15, 285);
            this.offg.drawString("Stamina", 15, 303);
            this.offg.drawString("Mana", 15, 321);
            if (this.hero.health < this.hero.maxhealth / 3) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString(this.hero.health + " / " + this.hero.maxhealth, 125, 285);
            if (this.hero.stamina < this.hero.maxstamina / 3) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString(this.hero.stamina + " / " + this.hero.maxstamina, 125, 303);
            if (this.hero.mana < this.hero.maxmana / 3) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString(this.hero.mana + " / " + this.hero.maxmana, 125, 321);
            this.offg.setColor(new Color(30, 30, 30));
            this.offg.drawString("Load       " + (float)((int)(this.hero.load * 10.0f + 0.5f)) / 10.0f + " / " + (float)((int)(this.hero.maxload * 10.0f + 0.5f)) / 10.0f, 263, 324);
            this.offg.drawString("Kg", 423, 324);
            if (this.hero.load > this.hero.maxload) {
                this.offg.setColor(Color.red);
            } else if (this.hero.load > this.hero.maxload * 3.0f / 4.0f) {
                this.offg.setColor(Color.yellow);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("Load       " + (float)((int)(this.hero.load * 10.0f + 0.5f)) / 10.0f + " / " + (float)((int)(this.hero.maxload * 10.0f + 0.5f)) / 10.0f, 260, 321);
            this.offg.drawString("Kg", 420, 321);
            if (this.hero.ispoisoned) {
                this.offg.setColor(new Color(0, 150, 0));
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(106, 22, 40, 37);
                if (this.viewing) {
                    this.offg.drawImage(HeroPanel.this.poisonedpic, 224, 209, null);
                }
            }
            if (this.viewing && this.hero.silenced) {
                this.offg.setFont(this.dungfont24);
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.drawString("SILENCED", 264, 284);
                this.offg.setColor(Color.red);
                this.offg.drawString("SILENCED", 260, 280);
                this.offg.setFont(this.dungfont14);
            }
            if (this.hero.strengthboost < 0 || this.hero.dexterityboost < 0 || this.hero.vitalityboost < 0 || this.hero.intelligenceboost < 0 || this.hero.wisdomboost < 0 || this.hero.defenseboost < 0 || this.hero.magicresistboost < 0) {
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(18, 22, 40, 37);
            }
            if (!this.viewing) {
                this.showStats();
            } else {
                n = (int)((float)this.hero.food / 1000.0f * 170.0f);
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.fillRect(245, 150, n, 10);
                if (this.hero.food < 75) {
                    this.offg.setColor(Color.red);
                } else if (this.hero.food < 100) {
                    this.offg.setColor(Color.yellow);
                } else {
                    this.offg.setColor(new Color(200, 130, 10));
                }
                this.offg.fillRect(240, 145, n, 10);
                n = (int)((float)this.hero.water / 1000.0f * 170.0f);
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.fillRect(245, 197, n, 10);
                if (this.hero.water < 75) {
                    this.offg.setColor(Color.red);
                } else if (this.hero.water < 100) {
                    this.offg.setColor(Color.yellow);
                } else {
                    this.offg.setColor(Color.blue);
                }
                this.offg.fillRect(240, 192, n, 10);
            }
            this.offg.setColor(new Color(63, 63, 63));
            this.offg.drawImage(this.hero.weapon.pic, 124, 106, this);
            if (this.hero.hurtweapon) {
                if (this.hero.weapon.number == 6) {
                    this.offg.drawImage(HeroPanel.this.hurtweapon, 124, 106, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(123, 105, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.head != null) {
                this.offg.fillRect(68, 52, 32, 32);
                this.offg.drawImage(this.hero.head.pic, 68, 52, this);
            }
            if (this.hero.hurthead) {
                if (this.hero.head == null) {
                    this.offg.drawImage(HeroPanel.this.hurthead, 68, 52, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(67, 51, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.neck != null) {
                this.offg.fillRect(12, 66, 32, 32);
                this.offg.drawImage(this.hero.neck.pic, 12, 66, this);
            }
            if (this.hero.torso != null) {
                this.offg.fillRect(68, 92, 32, 32);
                this.offg.drawImage(this.hero.torso.pic, 68, 92, this);
            }
            if (this.hero.hurttorso) {
                if (this.hero.torso == null) {
                    this.offg.drawImage(HeroPanel.this.hurttorso, 68, 92, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(67, 91, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.hand != null) {
                this.offg.fillRect(12, 106, 32, 32);
                this.offg.drawImage(this.hero.hand.pic, 12, 106, this);
            }
            if (this.hero.hurthand) {
                if (this.hero.hand == null) {
                    this.offg.drawImage(HeroPanel.this.hurthand, 12, 106, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(11, 105, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.legs != null) {
                this.offg.fillRect(68, 132, 32, 32);
                this.offg.drawImage(this.hero.legs.pic, 68, 132, this);
            }
            if (this.hero.hurtlegs) {
                if (this.hero.legs == null) {
                    this.offg.drawImage(HeroPanel.this.hurtlegs, 68, 132, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(67, 131, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.feet != null) {
                this.offg.fillRect(68, 172, 32, 32);
                this.offg.drawImage(this.hero.feet.pic, 68, 172, this);
            }
            if (this.hero.hurtfeet) {
                if (this.hero.feet == null) {
                    this.offg.drawImage(HeroPanel.this.hurtfeet, 68, 172, this);
                }
                this.offg.setColor(Color.red);
                this.offg.setStroke(new BasicStroke(2.0f));
                this.offg.drawRect(67, 171, 34, 34);
                this.offg.setColor(new Color(63, 63, 63));
            }
            if (this.hero.pouch1 != null) {
                this.offg.drawImage(this.hero.pouch1.pic, 12, 167, this);
            }
            if (this.hero.pouch2 != null) {
                this.offg.drawImage(this.hero.pouch2.pic, 12, 201, this);
            }
            for (n = 0; n < 8; ++n) {
                if (this.hero.pack[n] == null) continue;
                this.offg.drawImage(this.hero.pack[n].pic, 166 + 34 * n, 32, this);
            }
            for (n = 0; n < 8; ++n) {
                if (this.hero.pack[n + 8] == null) continue;
                this.offg.drawImage(this.hero.pack[n + 8].pic, 166 + 34 * n, 66, this);
            }
            for (n = 0; n < 2; ++n) {
                if (this.hero.quiver[n] == null) continue;
                this.offg.drawImage(this.hero.quiver[n].pic, 124 + 34 * n, 167, this);
            }
            for (n = 0; n < 2; ++n) {
                if (this.hero.quiver[n + 2] == null) continue;
                this.offg.drawImage(this.hero.quiver[n + 2].pic, 124 + 34 * n, 201, this);
            }
            for (n = 0; n < 2; ++n) {
                if (this.hero.quiver[n + 4] == null) continue;
                this.offg.drawImage(this.hero.quiver[n + 4].pic, 124 + 34 * n, 235, this);
            }
            graphics.drawImage(this.offscreen, 0, 0, null);
        }

        public void showStats() {
            this.offg.setColor(new Color(60, 60, 60));
            this.offg.fillRect(206, 104, 232, 190);
            this.offg.setColor(new Color(95, 95, 95));
            this.offg.setStroke(new BasicStroke(2.0f));
            this.offg.drawRect(207, 105, 230, 190);
            this.offg.setFont(this.dungfont14);
            int n = 120;
            if (this.hero.flevel > 0) {
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.drawString(LEVELNAMES[this.hero.flevel] + " Fighter", 218, n + 3);
                if (this.hero.flevelboost > 0) {
                    this.offg.setColor(Color.green);
                } else if (this.hero.flevelboost < 0) {
                    this.offg.setColor(Color.red);
                } else {
                    this.offg.setColor(Color.white);
                }
                this.offg.drawString(LEVELNAMES[this.hero.flevel] + " Fighter", 215, n);
                n += 15;
            }
            if (this.hero.nlevel > 0) {
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.drawString(LEVELNAMES[this.hero.nlevel] + " Ninja", 218, n + 3);
                if (this.hero.nlevelboost > 0) {
                    this.offg.setColor(Color.green);
                } else if (this.hero.nlevelboost < 0) {
                    this.offg.setColor(Color.red);
                } else {
                    this.offg.setColor(Color.white);
                }
                this.offg.drawString(LEVELNAMES[this.hero.nlevel] + " Ninja", 215, n);
                n += 15;
            }
            if (this.hero.wlevel > 0) {
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.drawString(LEVELNAMES[this.hero.wlevel] + " Wizard", 218, n + 3);
                if (this.hero.wlevelboost > 0) {
                    this.offg.setColor(Color.green);
                } else if (this.hero.wlevelboost < 0) {
                    this.offg.setColor(Color.red);
                } else {
                    this.offg.setColor(Color.white);
                }
                this.offg.drawString(LEVELNAMES[this.hero.wlevel] + " Wizard", 215, n);
                n += 15;
            }
            if (this.hero.plevel > 0) {
                this.offg.setColor(new Color(30, 30, 30));
                this.offg.drawString(LEVELNAMES[this.hero.plevel] + " Priest", 218, n + 3);
                if (this.hero.plevelboost > 0) {
                    this.offg.setColor(Color.green);
                } else if (this.hero.plevelboost < 0) {
                    this.offg.setColor(Color.red);
                } else {
                    this.offg.setColor(Color.white);
                }
                this.offg.drawString(LEVELNAMES[this.hero.plevel] + " Priest", 215, n);
            }
            this.offg.setColor(new Color(30, 30, 30));
            this.offg.drawString("Strength", 218, 200);
            this.offg.drawString("Dexterity", 218, 214);
            this.offg.drawString("Vitality", 218, 228);
            this.offg.drawString("Intelligence", 218, 242);
            this.offg.drawString("Wisdom", 218, 256);
            this.offg.drawString("Defense", 218, 275);
            this.offg.drawString("Resist Magic", 218, 290);
            int n2 = 218 + this.offg.getFontMetrics().stringWidth("Resist Magic") + 13;
            this.offg.drawString("" + this.hero.strength, n2, 200);
            this.offg.drawString("" + this.hero.dexterity, n2, 214);
            this.offg.drawString("" + this.hero.vitality, n2, 228);
            this.offg.drawString("" + this.hero.intelligence, n2, 242);
            this.offg.drawString("" + this.hero.wisdom, n2, 256);
            this.offg.drawString("" + this.hero.defense, n2, 275);
            this.offg.drawString("" + this.hero.magicresist, n2, 290);
            this.offg.setColor(Color.white);
            this.offg.drawString("Strength", 215, 197);
            this.offg.drawString("Dexterity", 215, 211);
            this.offg.drawString("Vitality", 215, 225);
            this.offg.drawString("Intelligence", 215, 239);
            this.offg.drawString("Wisdom", 215, 253);
            this.offg.drawString("Defense", 215, 272);
            this.offg.drawString("Resist Magic", 215, 287);
            n2 -= 3;
            if (this.hero.strengthboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.strengthboost < 0) {
                this.offg.setColor(Color.red);
            }
            this.offg.drawString("" + this.hero.strength, n2, 197);
            if (this.hero.dexterityboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.dexterityboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.dexterity, n2, 211);
            if (this.hero.vitalityboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.vitalityboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.vitality, n2, 225);
            if (this.hero.intelligenceboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.intelligenceboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.intelligence, n2, 239);
            if (this.hero.wisdomboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.wisdomboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.wisdom, n2, 253);
            if (this.hero.defenseboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.defenseboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.defense, n2, 272);
            if (this.hero.magicresistboost > 0) {
                this.offg.setColor(Color.green);
            } else if (this.hero.magicresistboost < 0) {
                this.offg.setColor(Color.red);
            } else {
                this.offg.setColor(Color.white);
            }
            this.offg.drawString("" + this.hero.magicresist, n2, 287);
        }
    }
}

