/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JPanel;

public class ImageTilePanel
extends JPanel {
    public static final int BOTTOM = 0;
    public static final int CENTER = 1;
    public static final int TOP = 2;
    protected Image tilepic;
    protected MediaTracker tracker;
    protected boolean tiled = true;
    protected boolean scaled = false;
    protected int valign = 2;

    public ImageTilePanel() {
        this.setOpaque(false);
    }

    public ImageTilePanel(String string) {
        this.setOpaque(false);
        File file = new File(string);
        if (file.exists()) {
            this.tilepic = Toolkit.getDefaultToolkit().getImage(string);
            this.tracker = new MediaTracker(this);
            this.tracker.addImage(this.tilepic, 0);
            try {
                this.tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tracker.removeImage(this.tilepic);
        }
    }

    public ImageTilePanel(Image image) {
        this.setOpaque(false);
        this.tilepic = image;
    }

    public void setImage(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.tilepic = Toolkit.getDefaultToolkit().getImage(string);
            this.tracker = new MediaTracker(this);
            this.tracker.addImage(this.tilepic, 0);
            try {
                this.tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tracker.removeImage(this.tilepic);
            this.repaint();
        }
    }

    public void setImage(Image image) {
        this.tilepic = image;
        this.repaint();
    }

    public Image getImage() {
        return this.tilepic;
    }

    public void setTiled(boolean bl) {
        this.tiled = bl;
    }

    public boolean getTiled() {
        return this.tiled;
    }

    public void setScaled(boolean bl) {
        this.scaled = bl;
    }

    public boolean getScaled() {
        return this.scaled;
    }

    public void setVerticalAlignment(int n) {
        this.valign = n;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.tilepic != null) {
            int n = this.tilepic.getWidth(this);
            int n2 = this.tilepic.getHeight(this);
            int n3 = this.getSize().width;
            int n4 = this.getSize().height;
            if (this.tiled) {
                int n5 = n4 / n2;
                if (n4 % n2 > 0) {
                    ++n5;
                }
                int n6 = n3 / n;
                if (n3 % n > 0) {
                    ++n6;
                }
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        graphics.drawImage(this.tilepic, j * n, i * n2, this);
                    }
                }
            } else if (this.scaled) {
                graphics.drawImage(this.tilepic, 0, 0, n3, n4, 0, 0, n, n2, this);
            } else if (this.valign == 2) {
                graphics.drawImage(this.tilepic, n3 / 2 - n / 2, 0, this);
            } else if (this.valign == 1) {
                graphics.drawImage(this.tilepic, n3 / 2 - n / 2, n4 / 2 - n2 / 2, this);
            } else {
                graphics.drawImage(this.tilepic, n3 / 2 - n / 2, n4 - n2, this);
            }
        }
        super.paint(graphics);
    }
}

