/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class MapPanel
extends JPanel {
    public static final ImageIcon WallIcon = MapPanel.makeIcon("wall.gif");
    public static final ImageIcon DoorIcon = MapPanel.makeIcon("door.gif");
    public static final ImageIcon FakeWallIcon = MapPanel.makeIcon("fakewall.gif");
    public static final ImageIcon AltarIcon = MapPanel.makeIcon("altar.gif");
    public static final ImageIcon AlcoveIcon = MapPanel.makeIcon("alcove.gif");
    public static final ImageIcon FountainIcon = MapPanel.makeIcon("fountain.gif");
    public static final ImageIcon StairsDownIcon = MapPanel.makeIcon("stairsdown.gif");
    public static final ImageIcon StairsUpIcon = MapPanel.makeIcon("stairsup.gif");
    public static final ImageIcon TeleportIcon = MapPanel.makeIcon("teleport.gif");
    public static final ImageIcon PitIcon = MapPanel.makeIcon("pit.gif");
    public static final ImageIcon MirrorIcon = MapPanel.makeIcon("mirror.gif");
    public static final ImageIcon WritingIcon = MapPanel.makeIcon("writing.gif");
    public static final ImageIcon LauncherIcon = MapPanel.makeIcon("launcher.gif");
    public static final ImageIcon GeneratorIcon = MapPanel.makeIcon("generator.gif");
    public static final ImageIcon WallSwitchIcon = MapPanel.makeIcon("wallswitch.gif");
    public static final ImageIcon MultWallSwitchIcon = MapPanel.makeIcon("multwallswitch.gif");
    public static final ImageIcon FloorSwitchIcon = MapPanel.makeIcon("floorswitch.gif");
    public static final ImageIcon MultFloorSwitchIcon = MapPanel.makeIcon("multfloorswitch.gif");
    public static final ImageIcon SconceIcon = MapPanel.makeIcon("sconce.gif");
    public static final ImageIcon DecorationIcon = MapPanel.makeIcon("decoration.gif");
    public static final ImageIcon FDecorationIcon = MapPanel.makeIcon("fdecoration.gif");
    public static final ImageIcon PillarIcon = MapPanel.makeIcon("pillar.gif");
    public static final ImageIcon InvisibleWallIcon = MapPanel.makeIcon("invisiblewall.gif");
    public static final ImageIcon EventIcon = MapPanel.makeIcon("event.gif");
    public static final ImageIcon GameWinIcon = MapPanel.makeIcon("gamewin.gif");
    public static final ImageIcon StormIcon = MapPanel.makeIcon("stormbringer.gif");
    public static final ImageIcon GemIcon = MapPanel.makeIcon("powergem.gif");
    public static final ImageIcon FulYaIcon = MapPanel.makeIcon("fulya.gif");
    public static final ImageIcon WallIconS = MapPanel.makeIcon("wall-s.gif");
    public static final ImageIcon DoorIconS = MapPanel.makeIcon("door-s.gif");
    public static final ImageIcon FakeWallIconS = MapPanel.makeIcon("fakewall-s.gif");
    public static final ImageIcon AltarIconS = MapPanel.makeIcon("altar-s.gif");
    public static final ImageIcon AlcoveIconS = MapPanel.makeIcon("alcove-s.gif");
    public static final ImageIcon FountainIconS = MapPanel.makeIcon("fountain-s.gif");
    public static final ImageIcon StairsDownIconS = MapPanel.makeIcon("stairsdown-s.gif");
    public static final ImageIcon StairsUpIconS = MapPanel.makeIcon("stairsup-s.gif");
    public static final ImageIcon TeleportIconS = MapPanel.makeIcon("teleport-s.gif");
    public static final ImageIcon PitIconS = MapPanel.makeIcon("pit-s.gif");
    public static final ImageIcon MirrorIconS = MapPanel.makeIcon("mirror-s.gif");
    public static final ImageIcon WritingIconS = MapPanel.makeIcon("writing-s.gif");
    public static final ImageIcon LauncherIconS = MapPanel.makeIcon("launcher-s.gif");
    public static final ImageIcon GeneratorIconS = MapPanel.makeIcon("generator-s.gif");
    public static final ImageIcon WallSwitchIconS = MapPanel.makeIcon("wallswitch-s.gif");
    public static final ImageIcon MultWallSwitchIconS = MapPanel.makeIcon("multwallswitch-s.gif");
    public static final ImageIcon FloorSwitchIconS = MapPanel.makeIcon("floorswitch-s.gif");
    public static final ImageIcon MultFloorSwitchIconS = MapPanel.makeIcon("multfloorswitch-s.gif");
    public static final ImageIcon SconceIconS = MapPanel.makeIcon("sconce-s.gif");
    public static final ImageIcon DecorationIconS = MapPanel.makeIcon("decoration-s.gif");
    public static final ImageIcon FDecorationIconS = MapPanel.makeIcon("fdecoration-s.gif");
    public static final ImageIcon PillarIconS = MapPanel.makeIcon("pillar-s.gif");
    public static final ImageIcon InvisibleWallIconS = MapPanel.makeIcon("invisiblewall-s.gif");
    public static final ImageIcon EventIconS = MapPanel.makeIcon("event-s.gif");
    public static final ImageIcon GameWinIconS = MapPanel.makeIcon("gamewin-s.gif");
    public static final ImageIcon StormIconS = MapPanel.makeIcon("stormbringer-s.gif");
    public static final ImageIcon GemIconS = MapPanel.makeIcon("powergem-s.gif");
    public static final ImageIcon FulYaIconS = MapPanel.makeIcon("fulya-s.gif");
    public static final boolean showDirIndicators = true;
    private DMEditor dmed;
    private ArrayList targets;
    private boolean needupdate = true;
    private Dimension bigdim;
    private Dimension smalldim;
    private Font bigfont;
    private Font smallfont;
    private Stroke normalstroke;
    private Stroke arrowstroke;
    private Color floorcolor;
    private Graphics2D g;
    private BufferedImage pic;

    public static ImageIcon makeIcon(String string) {
        return new ImageIcon("Icons" + File.separator + string);
    }

    public MapPanel(DMEditor dMEditor) {
        super(false);
        this.dmed = dMEditor;
        this.targets = new ArrayList(1);
        this.bigdim = new Dimension(DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33);
        this.smalldim = new Dimension(DMEditor.MAPWIDTH * 17, DMEditor.MAPHEIGHT * 17);
        this.arrowstroke = new BasicStroke(2.0f);
        this.floorcolor = new Color(40, 30, 30);
        this.setBackground(this.floorcolor);
        this.setPreferredSize(this.bigdim);
        this.setMaximumSize(this.bigdim);
        this.bigfont = DMEditor.dungfont.deriveFont(8.0f);
        this.smallfont = DMEditor.dungfont.deriveFont(6.0f);
        this.pic = new BufferedImage(1650, 1650, 4);
        this.g = this.pic.createGraphics();
        this.normalstroke = this.g.getStroke();
    }

    public void setNewSize() {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (DMEditor.MAPWIDTH != (int)this.bigdim.getWidth() / 33) break block2;
                        if (DMEditor.MAPHEIGHT == (int)this.bigdim.getHeight() / 33) break block3;
                    }
                    this.bigdim = new Dimension(DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33);
                    this.smalldim = new Dimension(DMEditor.MAPWIDTH * 17, DMEditor.MAPHEIGHT * 17);
                    if (DMEditor.MAPWIDTH > this.pic.getWidth(null) / 33) break block4;
                    if (DMEditor.MAPHEIGHT <= this.pic.getHeight(null) / 33) break block5;
                }
                this.pic.flush();
                this.g.dispose();
                this.pic = null;
                System.gc();
                this.pic = new BufferedImage(DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33, 4);
                this.g = this.pic.createGraphics();
                this.normalstroke = this.g.getStroke();
            }
            this.setZoom();
            this.g.setClip(0, 0, DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33);
        }
    }

    public void setZoom() {
        if (!this.dmed.ZOOMING) {
            this.setPreferredSize(this.bigdim);
            this.setMaximumSize(this.bigdim);
            this.g.setFont(this.bigfont);
        } else {
            this.g.setColor(this.floorcolor);
            this.g.fillRect(0, 0, DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33);
            this.setPreferredSize(this.smalldim);
            this.setMaximumSize(this.smalldim);
            this.g.setFont(this.smallfont);
        }
    }

    public void forcePaint() {
        super.repaint();
    }

    @Override
    public void repaint() {
        this.needupdate = true;
        super.repaint();
    }

    private static void setAntiAliasing(Graphics2D graphics2D, boolean bl) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawDirIndicator(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setColor(Color.yellow);
        if (!this.dmed.ZOOMING) {
            switch (n3) {
                case 0: {
                    graphics2D.fillRect(n + 14, n2 + 31, 4, 1);
                    graphics2D.fillRect(n + 15, n2 + 30, 2, 1);
                    break;
                }
                case 1: {
                    graphics2D.fillRect(n + 31, n2 + 14, 1, 4);
                    graphics2D.fillRect(n + 30, n2 + 15, 1, 2);
                    break;
                }
                case 2: {
                    graphics2D.fillRect(n + 14, n2, 4, 1);
                    graphics2D.fillRect(n + 15, n2 + 1, 2, 1);
                    break;
                }
                case 3: {
                    graphics2D.fillRect(n, n2 + 14, 1, 4);
                    graphics2D.fillRect(n + 1, n2 + 15, 1, 2);
                }
            }
        } else {
            switch (n3) {
                case 0: {
                    graphics2D.fillRect(n + 6, n2 + 15, 4, 1);
                    graphics2D.fillRect(n + 7, n2 + 14, 2, 1);
                    break;
                }
                case 1: {
                    graphics2D.fillRect(n + 15, n2 + 6, 1, 4);
                    graphics2D.fillRect(n + 14, n2 + 7, 1, 2);
                    break;
                }
                case 2: {
                    graphics2D.fillRect(n + 6, n2, 4, 1);
                    graphics2D.fillRect(n + 7, n2 + 1, 2, 1);
                    break;
                }
                case 3: {
                    graphics2D.fillRect(n, n2 + 6, 1, 4);
                    graphics2D.fillRect(n + 1, n2 + 7, 1, 2);
                }
            }
        }
    }

    private void drawFieldAt(Graphics2D graphics2D, int n, int n2, MapData mapData, boolean bl) {
        if (bl) {
            Image image = this.getPic(mapData);
            if (image != null) {
                graphics2D.drawImage(image, n, n2, this);
            }
            if (mapData.nomons) {
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n, n2, 31, 31);
            } else if (mapData.noghosts) {
                graphics2D.setColor(Color.green);
                graphics2D.drawRect(n, n2, 31, 31);
            }
            graphics2D.setColor(new Color(0, 100, 255));
            if (mapData.hasItems && mapData.mapchar != ']' && mapData.mapchar != '[' && mapData.mapchar != 'a' && mapData.mapchar != 'f') {
                if (mapData.numitemsin[0] > 0) {
                    graphics2D.drawString("*", n + 4, n2 + 11);
                }
                if (mapData.numitemsin[1] > 0) {
                    graphics2D.drawString("*", n + 25, n2 + 11);
                }
                if (mapData.numitemsin[2] > 0) {
                    graphics2D.drawString("*", n + 25, n2 + 29);
                }
                if (mapData.numitemsin[3] > 0) {
                    graphics2D.drawString("*", n + 4, n2 + 29);
                }
            } else {
                if (mapData.numitemsin[0] > 0) {
                    graphics2D.drawString("*", n + 14, n2 + 12);
                }
                if (mapData.numitemsin[1] > 0) {
                    graphics2D.drawString("*", n + 4, n2 + 20);
                }
                if (mapData.numitemsin[2] > 0) {
                    graphics2D.drawString("*", n + 14, n2 + 29);
                }
                if (mapData.numitemsin[3] > 0) {
                    graphics2D.drawString("*", n + 24, n2 + 20);
                }
            }
            if (mapData.hasMons) {
                graphics2D.setColor(Color.red);
                if (mapData.hasmonin[0]) {
                    graphics2D.drawString("*", n + 7, n2 + 14);
                }
                if (mapData.hasmonin[1]) {
                    graphics2D.drawString("*", n + 22, n2 + 14);
                }
                if (mapData.hasmonin[2]) {
                    graphics2D.drawString("*", n + 22, n2 + 26);
                }
                if (mapData.hasmonin[3]) {
                    graphics2D.drawString("*", n + 7, n2 + 26);
                }
                if (mapData.hasmonin[4]) {
                    graphics2D.drawString("*", n + 14, n2 + 20);
                }
            }
            if (image != null) {
                if (mapData.mapchar == 'd') {
                    int n3 = ((DoorData)mapData).side;
                    this.drawDirIndicator(graphics2D, n, n2, n3);
                    this.drawDirIndicator(graphics2D, n, n2, n3 + 2 & 3);
                } else if (mapData instanceof SidedWallData) {
                    int n4 = ((SidedWallData)mapData).side;
                    this.drawDirIndicator(graphics2D, n, n2, n4);
                }
            }
            if (mapData.hasParty) {
                MapPanel.setAntiAliasing(graphics2D, true);
                graphics2D.setColor(Color.green);
                graphics2D.drawArc(n + 2, n2 + 2, 28, 28, 45, 90);
                graphics2D.setColor(Color.yellow);
                graphics2D.drawArc(n + 2, n2 + 2, 28, 28, 135, 90);
                graphics2D.setColor(Color.red);
                graphics2D.drawArc(n + 2, n2 + 2, 28, 28, 225, 90);
                graphics2D.setColor(Color.blue);
                graphics2D.drawArc(n + 2, n2 + 2, 28, 28, 315, 90);
                MapPanel.setAntiAliasing(graphics2D, false);
            }
        } else {
            Image image = this.getPic(mapData);
            if (image != null) {
                graphics2D.drawImage(image, n, n2, this);
            }
            if (mapData.nomons) {
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n, n2, 15, 15);
            } else if (mapData.noghosts) {
                graphics2D.setColor(Color.green);
                graphics2D.drawRect(n, n2, 15, 15);
            }
            graphics2D.setColor(new Color(0, 100, 255));
            if (mapData.hasItems && mapData.mapchar != ']' && mapData.mapchar != '[' && mapData.mapchar != 'a' && mapData.mapchar != 'f') {
                if (mapData.numitemsin[0] > 0) {
                    graphics2D.drawString("*", n + 2, n2 + 6);
                }
                if (mapData.numitemsin[1] > 0) {
                    graphics2D.drawString("*", n + 12, n2 + 6);
                }
                if (mapData.numitemsin[2] > 0) {
                    graphics2D.drawString("*", n + 12, n2 + 16);
                }
                if (mapData.numitemsin[3] > 0) {
                    graphics2D.drawString("*", n + 2, n2 + 16);
                }
            } else {
                if (mapData.numitemsin[0] > 0) {
                    graphics2D.drawString("*", n + 7, n2 + 6);
                }
                if (mapData.numitemsin[1] > 0) {
                    graphics2D.drawString("*", n + 2, n2 + 11);
                }
                if (mapData.numitemsin[2] > 0) {
                    graphics2D.drawString("*", n + 7, n2 + 16);
                }
                if (mapData.numitemsin[3] > 0) {
                    graphics2D.drawString("*", n + 12, n2 + 11);
                }
            }
            if (mapData.hasMons) {
                graphics2D.setColor(Color.red);
                if (mapData.hasmonin[0]) {
                    graphics2D.drawString("*", n + 4, n2 + 8);
                }
                if (mapData.hasmonin[1]) {
                    graphics2D.drawString("*", n + 10, n2 + 8);
                }
                if (mapData.hasmonin[2]) {
                    graphics2D.drawString("*", n + 10, n2 + 14);
                }
                if (mapData.hasmonin[3]) {
                    graphics2D.drawString("*", n + 4, n2 + 14);
                }
                if (mapData.hasmonin[4]) {
                    graphics2D.drawString("*", n + 7, n2 + 11);
                }
            }
            if (image != null) {
                if (mapData.mapchar == 'd') {
                    int n5 = ((DoorData)mapData).side;
                    this.drawDirIndicator(graphics2D, n, n2, n5);
                    this.drawDirIndicator(graphics2D, n, n2, n5 + 2 & 3);
                } else if (mapData instanceof SidedWallData) {
                    int n6 = ((SidedWallData)mapData).side;
                    this.drawDirIndicator(graphics2D, n, n2, n6);
                }
            }
            if (mapData.hasParty) {
                MapPanel.setAntiAliasing(graphics2D, true);
                graphics2D.setColor(Color.green);
                graphics2D.drawArc(n + 1, n2 + 1, 14, 14, 45, 90);
                graphics2D.setColor(Color.yellow);
                graphics2D.drawArc(n + 1, n2 + 1, 14, 14, 135, 90);
                graphics2D.setColor(Color.red);
                graphics2D.drawArc(n + 1, n2 + 1, 14, 14, 225, 90);
                graphics2D.setColor(Color.blue);
                graphics2D.drawArc(n + 1, n2 + 1, 14, 14, 315, 90);
                MapPanel.setAntiAliasing(graphics2D, false);
            }
        }
    }

    public void paintSquare(int n, int n2, boolean bl) {
        if (!this.dmed.ZOOMING) {
            this.g.setColor(this.floorcolor);
            this.g.fillRect(n * 33, n2 * 33, 32, 32);
            this.drawFieldAt(this.g, n * 33, n2 * 33, this.dmed.mapdata[n][n2], true);
        } else {
            this.g.setColor(this.floorcolor);
            this.g.fillRect(n * 17, n2 * 17, 16, 16);
            this.drawFieldAt(this.g, n * 17, n2 * 17, this.dmed.mapdata[n][n2], false);
        }
        if (bl) {
            this.paint(this.getGraphics());
        }
    }

    private void drawFieldLock(Graphics2D graphics2D) {
        if (this.dmed.SQUARELOCKED) {
            int n = this.dmed.ZOOMING ? 16 : 32;
            graphics2D.setColor(Color.white);
            MapPanel.setAntiAliasing(graphics2D, true);
            graphics2D.drawOval(this.dmed.lockx * (n + 1) - 3 * n / 8, this.dmed.locky * (n + 1) - 3 * n / 8, (int)((double)n * 1.75), (int)((double)n * 1.75));
            MapPanel.setAntiAliasing(graphics2D, false);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.needupdate) {
            graphics2D.drawImage((Image)this.pic, 0, 0, this);
            if (!this.targets.isEmpty()) {
                this.drawTargets(graphics2D);
            }
            this.drawFieldLock(graphics2D);
            return;
        }
        if (!this.dmed.ZOOMING) {
            this.g.setColor(this.floorcolor);
            this.g.fillRect(0, 0, DMEditor.MAPWIDTH * 33, DMEditor.MAPHEIGHT * 33);
            this.g.setFont(this.bigfont);
            int n = 0;
            while (true) {
                if (n < DMEditor.MAPHEIGHT) {
                    int n2 = 0;
                    while (true) {
                        if (n2 >= DMEditor.MAPWIDTH) break;
                        this.drawFieldAt(this.g, n2 * 33, n * 33, this.dmed.mapdata[n2][n], true);
                        ++n2;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            this.g.setColor(this.floorcolor);
            this.g.fillRect(0, 0, DMEditor.MAPWIDTH * 17, DMEditor.MAPHEIGHT * 17);
            this.g.setFont(this.smallfont);
            int n = 0;
            while (true) {
                if (n >= DMEditor.MAPHEIGHT) break;
                int n3 = 0;
                while (true) {
                    if (n3 >= DMEditor.MAPWIDTH) break;
                    this.drawFieldAt(this.g, n3 * 17, n * 17, this.dmed.mapdata[n3][n], false);
                    ++n3;
                }
                ++n;
            }
        }
        this.needupdate = false;
        graphics2D.drawImage((Image)this.pic, 0, 0, this);
        if (!this.targets.isEmpty()) {
            this.drawTargets(graphics2D);
        }
        this.drawFieldLock(graphics2D);
    }

    private void drawTargets(Graphics2D graphics2D) {
        Target target;
        int n;
        int n2 = this.dmed.ZOOMING ? 16 : 32;
        graphics2D.setColor(Color.red);
        int n3 = this.targets.size();
        for (n = 0; n < n3; ++n) {
            target = (Target)this.targets.get(n);
            if (target.targetl != DMEditor.currentlevel) continue;
            graphics2D.drawRect(target.targetx * (n2 + 1), target.targety * (n2 + 1), n2 - 1, n2 - 1);
        }
        if (!this.dmed.ZOOMING) {
            graphics2D.setStroke(this.arrowstroke);
        }
        for (n = 0; n < n3; ++n) {
            target = (Target)this.targets.get(n);
            if (target.targetl == DMEditor.currentlevel) {
                graphics2D.drawLine(target.originx * (n2 + 1) + n2 / 2, target.originy * (n2 + 1) + n2 / 2, target.targetx * (n2 + 1) + n2 / 2, target.targety * (n2 + 1) + n2 / 2);
                continue;
            }
            MapPanel.setAntiAliasing(graphics2D, true);
            graphics2D.drawOval(target.originx * (n2 + 1) - n2 / 4, target.originy * (n2 + 1) - n2 / 4, (int)((double)n2 * 1.5), (int)((double)n2 * 1.5));
            MapPanel.setAntiAliasing(graphics2D, false);
        }
        if (!this.dmed.ZOOMING) {
            graphics2D.setStroke(this.normalstroke);
        }
    }

    private Image getPic(MapData mapData) {
        if (mapData.mapchar == '1') {
            if (!this.dmed.ZOOMING) {
                return WallIcon.getImage();
            }
            return WallIconS.getImage();
        }
        if (mapData.mapchar == '0') {
            return null;
        }
        if (mapData.mapchar == '2') {
            if (!this.dmed.ZOOMING) {
                return FakeWallIcon.getImage();
            }
            return FakeWallIconS.getImage();
        }
        if (mapData.mapchar == '>') {
            if (!this.dmed.ZOOMING) {
                if (((StairsData)mapData).goesUp) {
                    return StairsUpIcon.getImage();
                }
                return StairsDownIcon.getImage();
            }
            if (((StairsData)mapData).goesUp) {
                return StairsUpIconS.getImage();
            }
            return StairsDownIconS.getImage();
        }
        if (mapData.mapchar == 'd') {
            if (!this.dmed.ZOOMING) {
                return DoorIcon.getImage();
            }
            return DoorIconS.getImage();
        }
        if (mapData.mapchar == 's') {
            if (!this.dmed.ZOOMING) {
                return FloorSwitchIcon.getImage();
            }
            return FloorSwitchIconS.getImage();
        }
        if (mapData.mapchar == '/') {
            if (!this.dmed.ZOOMING) {
                return WallSwitchIcon.getImage();
            }
            return WallSwitchIconS.getImage();
        }
        if (mapData.mapchar == 't') {
            if (!this.dmed.ZOOMING) {
                return TeleportIcon.getImage();
            }
            return TeleportIconS.getImage();
        }
        if (mapData.mapchar == ']' || mapData.mapchar == '[') {
            if (!this.dmed.ZOOMING) {
                return AlcoveIcon.getImage();
            }
            return AlcoveIconS.getImage();
        }
        if (mapData.mapchar == 'a') {
            if (!this.dmed.ZOOMING) {
                return AltarIcon.getImage();
            }
            return AltarIconS.getImage();
        }
        if (mapData.mapchar == 'f') {
            if (!this.dmed.ZOOMING) {
                return FountainIcon.getImage();
            }
            return FountainIconS.getImage();
        }
        if (mapData.mapchar == 'p') {
            if (!this.dmed.ZOOMING) {
                return PitIcon.getImage();
            }
            return PitIconS.getImage();
        }
        if (mapData.mapchar == 'l') {
            if (!this.dmed.ZOOMING) {
                return LauncherIcon.getImage();
            }
            return LauncherIconS.getImage();
        }
        if (mapData.mapchar == 'm') {
            if (!this.dmed.ZOOMING) {
                return MirrorIcon.getImage();
            }
            return MirrorIconS.getImage();
        }
        if (mapData.mapchar == 'g') {
            if (!this.dmed.ZOOMING) {
                return GeneratorIcon.getImage();
            }
            return GeneratorIconS.getImage();
        }
        if (mapData.mapchar == 'w') {
            if (!this.dmed.ZOOMING) {
                return WritingIcon.getImage();
            }
            return WritingIconS.getImage();
        }
        if (mapData.mapchar == 'S') {
            if (!this.dmed.ZOOMING) {
                return MultFloorSwitchIcon.getImage();
            }
            return MultFloorSwitchIconS.getImage();
        }
        if (mapData.mapchar == '\\') {
            if (!this.dmed.ZOOMING) {
                return MultWallSwitchIcon.getImage();
            }
            return MultWallSwitchIconS.getImage();
        }
        if (mapData.mapchar == '}') {
            if (!this.dmed.ZOOMING) {
                return SconceIcon.getImage();
            }
            return SconceIconS.getImage();
        }
        if (mapData.mapchar == 'D') {
            if (!this.dmed.ZOOMING) {
                return DecorationIcon.getImage();
            }
            return DecorationIconS.getImage();
        }
        if (mapData.mapchar == 'F') {
            if (!this.dmed.ZOOMING) {
                return FDecorationIcon.getImage();
            }
            return FDecorationIconS.getImage();
        }
        if (mapData.mapchar == 'P') {
            if (!this.dmed.ZOOMING) {
                return PillarIcon.getImage();
            }
            return PillarIconS.getImage();
        }
        if (mapData.mapchar == 'i') {
            if (!this.dmed.ZOOMING) {
                return InvisibleWallIcon.getImage();
            }
            return InvisibleWallIconS.getImage();
        }
        if (mapData.mapchar == 'E') {
            if (!this.dmed.ZOOMING) {
                return EventIcon.getImage();
            }
            return EventIconS.getImage();
        }
        if (mapData.mapchar == '!') {
            if (!this.dmed.ZOOMING) {
                return StormIcon.getImage();
            }
            return StormIconS.getImage();
        }
        if (mapData.mapchar == 'G') {
            if (!this.dmed.ZOOMING) {
                return GemIcon.getImage();
            }
            return GemIconS.getImage();
        }
        if (mapData.mapchar == 'y') {
            if (!this.dmed.ZOOMING) {
                return FulYaIcon.getImage();
            }
            return FulYaIconS.getImage();
        }
        if (mapData.mapchar == 'W') {
            if (!this.dmed.ZOOMING) {
                return GameWinIcon.getImage();
            }
            return GameWinIconS.getImage();
        }
        return null;
    }

    public boolean clearTargets() {
        if (this.targets.isEmpty()) {
            return false;
        }
        this.targets.clear();
        return true;
    }

    public boolean doTargets(MapData mapData, int n, int n2) {
        int n3 = this.targets.size();
        if (mapData.mapchar == 't') {
            this.targets.add(new Target(n, n2, ((TeleportData)mapData).targetlevel, ((TeleportData)mapData).targetx, ((TeleportData)mapData).targety));
        } else if (mapData.mapchar == '/') {
            this.targets.add(new Target(n, n2, ((WallSwitchData)mapData).targetlevel, ((WallSwitchData)mapData).targetx, ((WallSwitchData)mapData).targety));
        } else if (mapData.mapchar == 's') {
            this.targets.add(new Target(n, n2, ((FloorSwitchData)mapData).targetlevel, ((FloorSwitchData)mapData).targetx, ((FloorSwitchData)mapData).targety));
        } else if (mapData.mapchar == '\\') {
            MultWallSwitchData multWallSwitchData = (MultWallSwitchData)mapData;
            for (int i = 0; i < multWallSwitchData.switchlist.size(); ++i) {
                int[] nArray = multWallSwitchData.getTarget(i);
                this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
            }
        } else if (mapData.mapchar == 'S') {
            MultFloorSwitchData multFloorSwitchData = (MultFloorSwitchData)mapData;
            for (int i = 0; i < multFloorSwitchData.switchlist.size(); ++i) {
                int[] nArray = multFloorSwitchData.getTarget(i);
                this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
            }
        } else if (mapData.mapchar == '}') {
            SconceData sconceData = (SconceData)mapData;
            if (sconceData.isSwitch) {
                for (int i = 0; i < sconceData.sconceswitch.switchlist.size(); ++i) {
                    int[] nArray = sconceData.sconceswitch.getTarget(i);
                    this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
                }
            }
        } else if (mapData instanceof OneAlcoveData) {
            OneAlcoveData oneAlcoveData = (OneAlcoveData)mapData;
            if (oneAlcoveData.isSwitch) {
                for (int i = 0; i < oneAlcoveData.alcoveswitchdata.switchlist.size(); ++i) {
                    int[] nArray = oneAlcoveData.alcoveswitchdata.getTarget(i);
                    this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
                }
            }
        } else if (mapData.mapchar == '[') {
            AlcoveData alcoveData = (AlcoveData)mapData;
            if (alcoveData.isSwitch) {
                for (int i = 0; i < alcoveData.alcoveswitchdata.switchlist.size(); ++i) {
                    int[] nArray = alcoveData.alcoveswitchdata.getTarget(i);
                    this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
                }
            }
        } else if (mapData.mapchar == 'f') {
            FountainData fountainData = (FountainData)mapData;
            if (fountainData.fountainswitch != null) {
                for (int i = 0; i < fountainData.fountainswitch.switchlist.size(); ++i) {
                    int[] nArray = fountainData.fountainswitch.getTarget(i);
                    this.targets.add(new Target(n, n2, nArray[0], nArray[1], nArray[2]));
                }
            }
        } else if (mapData.mapchar == 'E') {
            EventSquareData eventSquareData = (EventSquareData)mapData;
            for (int i = 0; i < eventSquareData.choices.length; ++i) {
                for (int j = 0; j < eventSquareData.choices[i].actions.size(); ++j) {
                    Action action = (Action)eventSquareData.choices[i].actions.get(j);
                    if (action.actiontype <= 0 || action.actiontype >= 4) continue;
                    this.targets.add(new Target(n, n2, ((MapPoint)action.action).level, ((MapPoint)action.action).x, ((MapPoint)action.action).y));
                }
            }
        } else if (mapData.mapchar == 'm') {
            if (((MirrorData)mapData).target != null) {
                this.targets.add(new Target(n, n2, ((MirrorData)mapData).target.level, ((MirrorData)mapData).target.x, ((MirrorData)mapData).target.y));
            }
        } else if (mapData.mapchar == 'y') {
            FulYaPitData fulYaPitData = (FulYaPitData)mapData;
            this.targets.add(new Target(n, n2, fulYaPitData.keytarget.level, fulYaPitData.keytarget.x, fulYaPitData.keytarget.y));
            this.targets.add(new Target(n, n2, fulYaPitData.nonkeytarget.level, fulYaPitData.nonkeytarget.x, fulYaPitData.nonkeytarget.y));
        }
        return this.targets.size() != n3;
    }

    private class Target {
        int originx;
        int originy;
        int targetl;
        int targetx;
        int targety;

        public Target(int n, int n2, int n3, int n4, int n5) {
            this.originx = n;
            this.originy = n2;
            this.targetl = n3;
            this.targetx = n4;
            this.targety = n5;
        }
    }
}

