/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class MirrorData
extends SidedWallData {
    public boolean wasUsed = false;
    public boolean allowswap = false;
    public HeroData hero;
    public MapPoint target;

    public MirrorData(int n, HeroData heroData, boolean bl, MapPoint mapPoint) {
        super(n);
        this.hero = heroData;
        this.allowswap = bl;
        this.target = mapPoint;
        this.mapchar = (char)109;
    }

    public MirrorData(int n) {
        super(n);
        this.mapchar = (char)109;
    }

    @Override
    public String toString() {
        String string = this.wasUsed ? "used" : this.hero.name;
        if (this.side == 0) {
            return "Mirror (" + string + ") Facing South";
        }
        if (this.side == 1) {
            return "Mirror (" + string + ") Facing East";
        }
        if (this.side == 2) {
            return "Mirror (" + string + ") Facing North";
        }
        return "Mirror (" + string + ") Facing West";
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeBoolean(this.wasUsed);
        if (!this.wasUsed) {
            this.hero.save(objectOutputStream);
            objectOutputStream.writeBoolean(this.allowswap);
            if (this.target != null) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.target);
            } else {
                objectOutputStream.writeBoolean(false);
            }
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.wasUsed = objectInputStream.readBoolean();
        if (!this.wasUsed) {
            this.hero = new HeroData(objectInputStream.readUTF());
            this.hero.load(objectInputStream);
            this.allowswap = objectInputStream.readBoolean();
            if (objectInputStream.readBoolean()) {
                this.target = (MapPoint)objectInputStream.readObject();
            }
        }
    }
}

