/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class MonsterWizard
extends JDialog
implements ActionListener,
MouseListener {
    static final String[] monsternames = new String[]{"Mummy", "Screamer", "Giggler", "Rock Pile", "Slime", "Wing Eye", "Ghost", "Muncher", "Skeleton", "Worm", "Fire Elemental", "Water Elemental", "Goblin", "Giant Rat", "Ant Man", "Beholder", "Couatyl", "Fader", "Tentacle Beast", "Scorpion", "Demon", "Deth Knight", "Spider", "Stone Golem", "Sorcerer", "Dragon", "Lord Chaos", "Demon Lord"};
    static final int[] defaulthealth = new int[]{100, 120, 60, 120, 110, 150, 150, 40, 300, 250, 540, 440, 200, 320, 450, 180, 380, 240, 300, 400, 500, 650, 600, 1040, 640, 2700, 10000, 8000, 1};
    static final int[] defaultmana = new int[]{0, 0, 0, 0, 0, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 500, 0, 1500, 500, 0, 1000, 0, 500, 0, 5000, 0, 10000, 10000, 0};
    static final int[] defaultpower = new int[]{12, 12, 1, 20, 15, 10, 27, 6, 40, 40, 70, 50, 35, 45, 70, 24, 65, 35, 55, 70, 85, 140, 100, 150, 70, 210, 150, 200, 1};
    static final int[] defaultdefense = new int[]{0, 0, 10, 65, 40, 10, 20, 50, 20, 15, 30, 25, 30, 30, 40, 10, 20, 30, 40, 45, 50, 75, 35, 95, 20, 50, 50, 50, 0};
    static final int[] defaultmresist = new int[]{0, 0, 10, 30, 0, 30, 5, 0, 10, 10, 20, 20, 15, 20, 30, 30, 20, 30, 20, 10, 40, 90, 20, 90, 90, 40, 50, 50, 0};
    static final int[] defaultspeed = new int[]{55, 50, 140, 50, 60, 75, 70, 95, 70, 65, 75, 70, 75, 70, 70, 80, 75, 70, 70, 70, 75, 75, 75, 70, 80, 80, 100, 100, 50};
    static final int[] defaultpoison = new int[]{0, 0, 0, 4, 2, 0, 0, 8, 0, 2, 0, 0, 0, 0, 0, 0, 8, 0, 3, 8, 0, 0, 12, 0, 0, 0, 0, 0, 0};
    static final int[] defaultfresist = new int[]{9, 8, 10, 5, 8, 2, 0, 10, 3, 4, 0, 0, 5, 2, 4, 3, 5, 0, 5, 4, 1, 1, 2, 3, 1, 1, 0, 0, 5};
    static final int[] defaultcpower = new int[]{0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 5, 4, 0, 4, 0, 3, 0, 5, 5, 5, 5, 0};
    static final int[] defaultmpower = new int[]{0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 70, 70, 0, 90, 0, 60, 0, 140, 150, 150, 150, 0};
    static final int[] defaultai = new int[]{1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 4, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1};
    static final int[] defaultmspeed = new int[]{4, 10, 1, 15, 10, 4, 6, 2, 5, 8, 11, 10, 5, 6, 5, 5, 5, 7, 8, 6, 6, 6, 6, 12, 5, 6, 6, 5, 6};
    static final int[] defaultaspeed = new int[]{-1, 2, 0, 10, 0, 0, 2, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 2, 1, 1, 2, 3, 2, 3, 1, 1, 1, 1, 0};
    static final int[] defaultpickup = new int[]{2, 2, 4, 2, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 4, 4, 0};
    static final String[] pickupstr = new String[]{"Never Pick Up", "25% Pick Up", "50% Pick Up", "75% Pick Up", "Always Pick Up"};
    static final String[] stealstr = new String[]{"Never Steal", "25% Steal", "50% Steal", "75% Steal", "Always Steal"};
    int carryingindex = -1;
    int cmonsterindex = -1;
    MonsterData data = null;
    JList monsterlist;
    JList cmonsterlist;
    int level;
    int x;
    int y;
    int number = 0;
    int ai = 1;
    int facing = 0;
    boolean HITANDRUN;
    boolean isImmaterial;
    JTextField health;
    JTextField mana;
    JTextField power;
    JTextField defense;
    JTextField magicresist;
    JTextField speed;
    JTextField poison;
    JTextField fearresist;
    JTextField movespeed;
    JTextField attackspeed;
    JTextField name;
    JTextField picstring;
    JTextField soundstring;
    JTextField footstep;
    JComboBox facebox;
    JComboBox aibox;
    JComboBox pickup;
    JComboBox steal;
    JToggleButton hitandrunbut;
    JToggleButton immaterialbut;
    JToggleButton sub5;
    JToggleButton isflyingbut;
    JToggleButton canusestairsbut;
    JToggleButton ignoremonsbut;
    JToggleButton canteleport;
    JToggleButton poisonimmune;
    JScrollPane monpane;
    JScrollPane cmonsterpane;
    JPanel ccenter;
    static Vector custommons = new Vector();
    public boolean gamewin = false;
    public String endanim;
    public String endsound;
    public int hurtitem;
    public int needitem;
    public int needhandneck;
    JToggleButton hasmagic;
    JToggleButton hasheal;
    JToggleButton hasdrain;
    JToggleButton useammo;
    JToggleButton predefinedbutton;
    JToggleButton custombutton;
    Vector spells = new Vector(3);
    Vector spellnames = new Vector(3);
    JList knownspells;
    JComboBox castpower;
    JComboBox spellbox;
    JButton addspellbut;
    JButton removespellbut;
    JTextField manapower;
    JPanel spellpanel;
    String[] spellnumbers = new String[]{"44", "335", "51", "31", "642", "461", "363", "362", "664", "523", "6"};
    ArrayList carrying = new ArrayList(1);
    ArrayList equipped = new ArrayList(3);
    Vector carryingnames = new Vector(3);
    JList carryinglist;
    JButton additembut;
    JButton removeitembut;
    JButton equipitembut;
    static final Random randGen = new Random();
    static final String[] powers = new String[]{"LO", "UM", "ON", "EE", "PAL", "MON"};
    DMEditor dmed;

    public MonsterWizard(DMEditor dMEditor) {
        super(dMEditor, "Monster Wizard", true);
        this.setDefaultCloseOperation(2);
        this.setSize(900, 685);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        this.dmed = dMEditor;
        this.monsterlist = new JList<String>(monsternames);
        this.monsterlist.setSelectionMode(0);
        this.monsterlist.setCellRenderer(new MonCellRenderer());
        this.monsterlist.setSelectedIndex(0);
        this.monsterlist.addMouseListener(this);
        this.monpane = new JScrollPane(this.monsterlist);
        this.monpane.setPreferredSize(new Dimension(200, 120));
        this.cmonsterlist = new JList(custommons);
        this.cmonsterlist.setSelectionMode(0);
        this.cmonsterlist.setCellRenderer(new MonCellRenderer());
        this.cmonsterlist.setPreferredSize(new Dimension(182, custommons.size() * 34));
        this.cmonsterlist.addMouseListener(this);
        this.cmonsterpane = new JScrollPane(this.cmonsterlist);
        this.cmonsterpane.setPreferredSize(new Dimension(200, 120));
        JButton jButton = new JButton("Add/Update Mon");
        JButton jButton2 = new JButton("Delete Mon");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.cmonsterpane);
        jPanel2.add(jPanel);
        this.name = new JTextField("Monster Name", 8);
        this.picstring = new JTextField("mummy", 10);
        this.soundstring = new JTextField("mummy.wav", 10);
        this.footstep = new JTextField("step1.wav", 10);
        this.canusestairsbut = new JToggleButton("Use Stairs");
        this.canusestairsbut.setSelected(true);
        this.isflyingbut = new JToggleButton("Flying");
        this.ignoremonsbut = new JToggleButton("Better AI");
        this.canteleport = new JToggleButton("Teleports");
        JPanel jPanel3 = new JPanel(new GridLayout(8, 2));
        jPanel3.setPreferredSize(new Dimension(200, 150));
        jPanel3.add(new JLabel("Name:", 4));
        jPanel3.add(this.name);
        jPanel3.add(new JLabel("Pics Name:", 4));
        jPanel3.add(this.picstring);
        jPanel3.add(new JLabel("Sound:", 4));
        jPanel3.add(this.soundstring);
        jPanel3.add(new JLabel("Footstep:", 4));
        jPanel3.add(this.footstep);
        jPanel3.add(this.canusestairsbut);
        jPanel3.add(this.isflyingbut);
        jPanel3.add(this.ignoremonsbut);
        jPanel3.add(this.canteleport);
        this.ccenter = new JPanel();
        this.ccenter.add(jPanel2);
        this.ccenter.add(jPanel3);
        this.ccenter.setVisible(false);
        this.predefinedbutton = new JToggleButton("Predefined");
        this.custombutton = new JToggleButton("Custom");
        this.predefinedbutton.addActionListener(this);
        this.custombutton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.predefinedbutton);
        buttonGroup.add(this.custombutton);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.predefinedbutton);
        jPanel4.add(this.custombutton);
        this.predefinedbutton.setSelected(true);
        this.health = new JTextField("" + defaulthealth[0], 6);
        this.mana = new JTextField("" + defaultmana[0], 6);
        this.power = new JTextField("" + defaultpower[0], 6);
        this.defense = new JTextField("" + defaultdefense[0], 6);
        this.magicresist = new JTextField("" + defaultmresist[0], 6);
        this.speed = new JTextField("" + defaultspeed[0], 6);
        this.fearresist = new JTextField("" + defaultfresist[0], 2);
        this.poison = new JTextField("0", 2);
        this.movespeed = new JTextField("" + defaultmspeed[0], 3);
        this.attackspeed = new JTextField("" + defaultaspeed[0], 3);
        JPanel jPanel5 = new JPanel(new GridLayout(5, 2));
        JPanel jPanel6 = new JPanel(new GridLayout(5, 2));
        jPanel5.add(new JLabel("Health:", 4));
        jPanel5.add(this.health);
        jPanel5.add(new JLabel("Mana:", 4));
        jPanel5.add(this.mana);
        jPanel5.add(new JLabel("Power:", 4));
        jPanel5.add(this.power);
        jPanel5.add(new JLabel("Defense:", 4));
        jPanel5.add(this.defense);
        jPanel5.add(new JLabel("Magic Resist:", 4));
        jPanel5.add(this.magicresist);
        jPanel6.add(new JLabel("Dexterity:", 4));
        jPanel6.add(this.speed);
        jPanel6.add(new JLabel("Fear Resist:", 4));
        jPanel6.add(this.fearresist);
        jPanel6.add(new JLabel("Poison Power:", 4));
        jPanel6.add(this.poison);
        jPanel6.add(new JLabel("Move Speed:", 4));
        jPanel6.add(this.movespeed);
        jPanel6.add(new JLabel("Attack Mod:", 4));
        jPanel6.add(this.attackspeed);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        String[] stringArray = new String[]{"Facing North", "Facing West", "Facing South", "Facing East"};
        this.facebox = new JComboBox<String>(stringArray);
        this.facebox.setEditable(false);
        this.facebox.addActionListener(this);
        String[] stringArray2 = new String[]{"Aggressively Attack", "Attack From Distance", "Always Run Away", "Unmoving", "Friendly", "Friendly Unmoving"};
        this.aibox = new JComboBox<String>(stringArray2);
        this.aibox.setEditable(false);
        this.aibox.addActionListener(this);
        this.hitandrunbut = new JToggleButton("Flees after an Attack");
        this.hitandrunbut.setActionCommand("HITANDRUN");
        this.hitandrunbut.addActionListener(this);
        this.poisonimmune = new JToggleButton("Poison Immunity");
        this.immaterialbut = new JToggleButton("Non-Material");
        this.immaterialbut.addActionListener(this);
        this.hasmagic = new JToggleButton("Has Magic");
        this.hasmagic.setSelected(false);
        this.hasmagic.addActionListener(this);
        this.useammo = new JToggleButton("Throw Weapons");
        this.useammo.setSelected(false);
        this.sub5 = new JToggleButton("Fills Square");
        this.sub5.setSelected(false);
        this.pickup = new JComboBox<String>(pickupstr);
        this.pickup.setSelectedIndex(2);
        this.pickup.setEditable(false);
        this.steal = new JComboBox<String>(stealstr);
        this.steal.setSelectedIndex(0);
        this.steal.setEditable(false);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.facebox);
        jPanel8.add(this.aibox);
        jPanel8.add(this.hitandrunbut);
        jPanel8.add(this.sub5);
        jPanel8.add(this.immaterialbut);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(this.hasmagic);
        jPanel9.add(this.poisonimmune);
        jPanel9.add(this.useammo);
        jPanel9.add(this.pickup);
        jPanel9.add(this.steal);
        this.spellpanel = new JPanel(new FlowLayout(1, 0, 0));
        this.spellpanel.setPreferredSize(new Dimension(640, 190));
        this.hasheal = new JToggleButton("Has Heal Magic");
        this.hasheal.setSelected(false);
        this.hasdrain = new JToggleButton("Has Drain Magic");
        this.hasdrain.setSelected(false);
        String[] stringArray3 = new String[]{"LO", "UM", "ON", "EE", "PAL", "MON"};
        this.castpower = new JComboBox<String>(stringArray3);
        this.castpower.setEditable(false);
        this.castpower.setSelectedIndex(0);
        this.manapower = new JTextField("50", 3);
        this.knownspells = new JList();
        this.knownspells.setSelectionMode(0);
        this.knownspells.setVisibleRowCount(4);
        String[] stringArray4 = new String[]{"Fireball", "Lightning", "Poison Bolt", "Ven Cloud", "Arc Bolt", "Weakness", "Feeble Mind", "Slow", "Strip Defenses", "Silence", "Door Open"};
        this.spellbox = new JComboBox<String>(stringArray4);
        this.spellbox.setEditable(false);
        this.addspellbut = new JButton("^ Add Above Spell");
        this.removespellbut = new JButton("< Remove Selected Spell");
        this.addspellbut.addActionListener(this);
        this.removespellbut.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(this.spellbox);
        box.add(this.addspellbut);
        box.add(this.removespellbut);
        JScrollPane jScrollPane = new JScrollPane(this.knownspells);
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        JPanel jPanel10 = new JPanel();
        jPanel10.add(jScrollPane);
        jPanel10.add(box);
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Known Projectile Type"));
        JPanel jPanel11 = new JPanel();
        jPanel11.add(this.hasheal);
        jPanel11.add(this.hasdrain);
        jPanel11.add(new JLabel("Casting Power:"));
        jPanel11.add(this.castpower);
        jPanel11.add(new JLabel("Intelligence:"));
        jPanel11.add(this.manapower);
        this.spellpanel.add(jPanel11);
        this.spellpanel.add(jPanel10);
        this.spellpanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Spells"));
        this.spellpanel.setVisible(false);
        this.carryinglist = new JList();
        this.carryinglist.setSelectionMode(0);
        this.carryinglist.setVisibleRowCount(6);
        this.carryinglist.addMouseListener(this);
        this.additembut = new JButton("Add/Edit Item");
        this.equipitembut = new JButton("Equip/UnEquip Item");
        this.removeitembut = new JButton("Remove Item");
        this.additembut.setActionCommand("Add Item");
        this.additembut.addActionListener(this);
        this.equipitembut.addActionListener(this);
        this.removeitembut.addActionListener(this);
        Box box2 = Box.createVerticalBox();
        box2.add(this.additembut);
        box2.add(this.equipitembut);
        box2.add(this.removeitembut);
        JPanel jPanel12 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane(this.carryinglist);
        jScrollPane2.setPreferredSize(new Dimension(200, 100));
        jPanel12.add(jScrollPane2);
        jPanel12.add(box2);
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Carrying"));
        JPanel jPanel13 = new JPanel(new FlowLayout(1, 5, 2));
        jPanel13.setPreferredSize(new Dimension(500, 450));
        jPanel13.add(this.monpane);
        jPanel13.add(this.ccenter);
        jPanel13.add(jPanel7);
        jPanel13.add(jPanel8);
        jPanel13.add(jPanel9);
        jPanel13.add(this.spellpanel);
        jPanel13.add(jPanel12);
        JPanel jPanel14 = new JPanel();
        JButton jButton3 = new JButton("Done");
        JButton jButton4 = new JButton("Cancel");
        JButton jButton5 = new JButton("Specials...");
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(this);
        jPanel14.add(jButton5);
        jPanel14.add(Box.createHorizontalStrut(40));
        jPanel14.add(jButton4);
        jPanel14.add(jButton3);
        container.add("North", jPanel4);
        container.add("Center", jPanel13);
        container.add("South", jPanel14);
        this.dispose();
    }

    public void setMonster(MonsterData monsterData, int n, int n2, int n3) {
        this.data = monsterData;
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (monsterData != null) {
            int n4;
            this.number = this.data.number;
            if (this.number > 27) {
                this.cmonsterlist.clearSelection();
                this.cmonsterindex = -1;
                this.cmonsterlist.setSelectedValue(this.data, true);
                if (!this.ccenter.isVisible()) {
                    this.predefinedbutton.setSelected(false);
                    this.custombutton.setSelected(true);
                    this.monpane.setVisible(false);
                    this.ccenter.setVisible(true);
                }
                this.cmonsterindex = this.cmonsterlist.getSelectedIndex();
                if (this.cmonsterindex >= 0) {
                    this.cmonsterlist.ensureIndexIsVisible(this.cmonsterindex);
                }
                this.name.setText(this.data.name);
                this.picstring.setText(this.data.picstring);
                this.soundstring.setText(this.data.soundstring);
                this.footstep.setText(this.data.footstep);
                this.canusestairsbut.setSelected(this.data.canusestairs);
                this.isflyingbut.setSelected(this.data.isflying);
                this.canteleport.setSelected(this.data.canteleport);
            } else {
                this.monsterlist.setSelectedValue(monsternames[this.data.number], true);
                if (this.ccenter.isVisible()) {
                    this.ccenter.setVisible(false);
                    this.monpane.setVisible(true);
                    this.custombutton.setSelected(false);
                    this.predefinedbutton.setSelected(true);
                }
                this.monsterlist.ensureIndexIsVisible(this.monsterlist.getSelectedIndex());
            }
            this.ai = this.data.defaultai;
            this.aibox.setSelectedIndex(this.ai - 1);
            this.facing = this.data.facing;
            this.facebox.setSelectedIndex(this.facing);
            this.pickup.setSelectedIndex(this.data.pickup);
            this.steal.setSelectedIndex(this.data.steal);
            this.poisonimmune.setSelected(this.data.poisonimmune);
            if (this.data.HITANDRUN != this.HITANDRUN) {
                this.hitandrunbut.doClick();
            }
            if (this.data.isImmaterial != this.immaterialbut.isSelected()) {
                this.immaterialbut.doClick();
            }
            if (this.number == 9 || this.number == 10 || this.number == 13 || this.number == 16 || this.number == 19 || this.number == 22 || this.number == 25 || this.number == 26 || this.number == 27) {
                this.sub5.setSelected(true);
                this.sub5.setEnabled(false);
            } else {
                this.sub5.setEnabled(true);
                this.sub5.setSelected(this.data.subsquare == 5);
            }
            this.health.setText("" + this.data.maxhealth);
            this.mana.setText("" + this.data.maxmana);
            this.power.setText("" + this.data.power);
            this.defense.setText("" + this.data.defense);
            this.magicresist.setText("" + this.data.magicresist);
            this.speed.setText("" + this.data.speed);
            this.movespeed.setText("" + this.data.movespeed);
            this.attackspeed.setText("" + this.data.attackspeed);
            this.poison.setText("" + this.data.poison);
            this.fearresist.setText("" + this.data.fearresist);
            this.useammo.setSelected(this.data.useammo);
            if (this.data.hasmagic != this.hasmagic.isSelected()) {
                this.hasmagic.doClick();
            }
            if (this.data.hasmagic) {
                this.hasheal.setSelected(this.data.hasheal);
                this.hasdrain.setSelected(this.data.hasdrain);
                this.manapower.setText("" + this.data.manapower);
                this.castpower.setSelectedIndex(this.data.castpower - 1);
                this.spells.clear();
                this.spellnames.clear();
                for (int i = 0; i < this.data.knownspells.length; ++i) {
                    this.spells.add(this.data.knownspells[i]);
                    if (this.data.knownspells[i].equals("44")) {
                        this.spellnames.add("Fireball");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("335")) {
                        this.spellnames.add("Lightning");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("51")) {
                        this.spellnames.add("Poison Bolt");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("31")) {
                        this.spellnames.add("Ven Cloud");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("642")) {
                        this.spellnames.add("Arc Bolt");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("461")) {
                        this.spellnames.add("Weakness");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("363")) {
                        this.spellnames.add("Feeble Mind");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("362")) {
                        this.spellnames.add("Slow");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("664")) {
                        this.spellnames.add("Strip Defenses");
                        continue;
                    }
                    if (this.data.knownspells[i].equals("523")) {
                        this.spellnames.add("Silence");
                        continue;
                    }
                    if (!this.data.knownspells[i].equals("6")) continue;
                    this.spellnames.add("Door Open");
                }
                this.knownspells.setListData(this.spellnames);
            }
            this.carrying = new ArrayList(1);
            this.equipped = new ArrayList(3);
            this.carryingnames.clear();
            if (this.data.equipped != null) {
                for (n4 = 0; n4 < this.data.equipped.size(); ++n4) {
                    Item item = (Item)this.data.equipped.get(n4);
                    this.equipped.add(Item.createCopy(item));
                    if (item.ispotion) {
                        this.carryingnames.add(item.name + " (" + powers[item.potioncastpow - 1] + ") (E)");
                        continue;
                    }
                    if (item instanceof Waterskin) {
                        if (((Waterskin)item).drinks == 0) {
                            this.carryingnames.add("Waterskin (Empty) (E)");
                            continue;
                        }
                        if (((Waterskin)item).drinks == 1) {
                            this.carryingnames.add("Waterskin (Almost Empty) (E)");
                            continue;
                        }
                        if (((Waterskin)item).drinks == 2) {
                            this.carryingnames.add("Waterskin (Almost Full) (E)");
                            continue;
                        }
                        this.carryingnames.add("Waterskin (Full) (E)");
                        continue;
                    }
                    this.carryingnames.add(item.name + " (E)");
                }
            }
            for (n4 = 0; n4 < this.data.carrying.size(); ++n4) {
                Item item = (Item)this.data.carrying.get(n4);
                this.carrying.add(Item.createCopy(item));
                if (item.ispotion) {
                    this.carryingnames.add(item.name + " (" + powers[item.potioncastpow - 1] + ")");
                    continue;
                }
                if (item instanceof Waterskin) {
                    if (((Waterskin)item).drinks == 0) {
                        this.carryingnames.add("Waterskin (Empty)");
                        continue;
                    }
                    if (((Waterskin)item).drinks == 1) {
                        this.carryingnames.add("Waterskin (Almost Empty)");
                        continue;
                    }
                    if (((Waterskin)item).drinks == 2) {
                        this.carryingnames.add("Waterskin (Almost Full)");
                        continue;
                    }
                    this.carryingnames.add("Waterskin (Full)");
                    continue;
                }
                this.carryingnames.add(item.name);
            }
            this.carryinglist.setListData(this.carryingnames);
            this.gamewin = this.data.gamewin;
            if (this.gamewin) {
                this.endanim = this.data.endanim;
                this.endsound = this.data.endsound;
            }
            this.hurtitem = this.data.hurtitem;
            this.needitem = this.data.needitem;
            this.needhandneck = this.data.needhandneck;
        } else if (this.cmonsterindex != -1) {
            this.cmonsterlist.setSelectedIndex(this.cmonsterindex);
            this.cmonsterlist.ensureIndexIsVisible(this.cmonsterindex);
        }
        this.show();
    }

    public void updateCustomMons() {
        this.cmonsterlist.setListData(custommons);
        this.cmonsterlist.setPreferredSize(new Dimension(182, custommons.size() * 34));
        DMEditor.NEEDSAVEMONS = true;
        DMEditor.eventwizard.updateMons();
    }

    public MonsterData getData() {
        return this.data;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (this.ccenter.isVisible() && !this.name.getText().equals("")) {
                this.data = new MonsterData(28, this.level, this.x, this.y, Integer.parseInt(this.health.getText()), Integer.parseInt(this.mana.getText()), this.facing, this.ai, this.HITANDRUN, this.isImmaterial, Integer.parseInt(this.power.getText()), Integer.parseInt(this.defense.getText()), Integer.parseInt(this.magicresist.getText()), Integer.parseInt(this.speed.getText()), Integer.parseInt(this.poison.getText()), Integer.parseInt(this.fearresist.getText()), this.carrying, this.equipped, this.gamewin, this.endanim, this.endsound, this.hurtitem, this.needitem, this.needhandneck, this.sub5.isSelected(), this.pickup.getSelectedIndex(), this.steal.getSelectedIndex(), this.name.getText(), this.picstring.getText(), this.soundstring.getText(), this.footstep.getText(), this.canusestairsbut.isSelected(), this.isflyingbut.isSelected(), !this.ignoremonsbut.isSelected(), this.canteleport.isSelected(), this.poisonimmune.isSelected());
                int n = this.cmonsterlist.getSelectedIndex();
                if (n == -1) {
                    n = custommons.indexOf(this.data);
                }
                if (n == -1) {
                    n = custommons.size();
                }
                this.data.number = this.number = 28 + n;
                if (n == custommons.size()) {
                    custommons.add(this.data);
                    this.cmonsterlist.setPreferredSize(new Dimension(182, custommons.size() * 34));
                    this.cmonsterlist.setListData(custommons);
                    this.cmonsterlist.setSelectedIndex(n);
                    this.cmonsterindex = n;
                    this.cmonsterlist.ensureIndexIsVisible(this.cmonsterindex);
                    DMEditor.NEEDSAVEMONS = true;
                }
            } else {
                this.data = new MonsterData(this.number, this.level, this.x, this.y, Integer.parseInt(this.health.getText()), Integer.parseInt(this.mana.getText()), this.facing, this.ai, this.HITANDRUN, this.isImmaterial, Integer.parseInt(this.power.getText()), Integer.parseInt(this.defense.getText()), Integer.parseInt(this.magicresist.getText()), Integer.parseInt(this.speed.getText()), Integer.parseInt(this.poison.getText()), Integer.parseInt(this.fearresist.getText()), this.carrying, this.equipped, this.gamewin, this.endanim, this.endsound, this.hurtitem, this.needitem, this.needhandneck, this.sub5.isSelected(), this.pickup.getSelectedIndex(), this.steal.getSelectedIndex(), this.poisonimmune.isSelected());
            }
            this.finishCreation();
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Specials...")) {
            new MonSpecials(this);
        } else if (actionEvent.getActionCommand().equals("Has Magic")) {
            this.spellpanel.setVisible(!this.spellpanel.isVisible());
            this.spellpanel.invalidate();
            this.getContentPane().validate();
        } else if (actionEvent.getActionCommand().equals("^ Add Above Spell")) {
            this.spellnames.add(this.spellbox.getSelectedItem());
            this.spells.add(this.spellnumbers[this.spellbox.getSelectedIndex()]);
            this.knownspells.setListData(this.spellnames);
        } else if (actionEvent.getActionCommand().equals("< Remove Selected Spell")) {
            int n = this.knownspells.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.spellnames.remove(n);
            this.spells.remove(n);
            this.knownspells.setListData(this.spellnames);
        } else if (actionEvent.getActionCommand().equals("Add Item")) {
            int n = this.carryinglist.getSelectedIndex();
            if (n == -1) {
                DMEditor.itemwizard.setTitle("Item Wizard - Give This Monster An Item");
                DMEditor.itemwizard.show();
                Item item = DMEditor.itemwizard.getItem();
                if (item == null) {
                    this.carryinglist.clearSelection();
                    return;
                }
                this.carrying.add(item);
                if (item.ispotion) {
                    this.carryingnames.add(item.name + " (" + powers[item.potioncastpow - 1] + ")");
                } else if (item instanceof Waterskin) {
                    if (((Waterskin)item).drinks == 0) {
                        this.carryingnames.add("Waterskin (Empty)");
                    } else if (((Waterskin)item).drinks == 1) {
                        this.carryingnames.add("Waterskin (Almost Empty)");
                    } else if (((Waterskin)item).drinks == 2) {
                        this.carryingnames.add("Waterskin (Almost Full)");
                    } else {
                        this.carryingnames.add("Waterskin (Full)");
                    }
                } else {
                    this.carryingnames.add(item.name);
                }
                this.carryinglist.setListData(this.carryingnames);
            } else {
                DMEditor.itemwizard.setTitle("Item Wizard - Change An Item This Monster Is Carrying");
                ArrayList arrayList = this.getActualList(n);
                int n2 = this.getActualIndex(arrayList, n);
                DMEditor.itemwizard.setItem((Item)arrayList.get(n2));
                Item item = DMEditor.itemwizard.getItem();
                if (item == null) {
                    this.carryinglist.clearSelection();
                    this.carryingindex = -1;
                    return;
                }
                arrayList.set(n2, item);
                String string = item.ispotion ? item.name + " (" + powers[item.potioncastpow - 1] + ")" : (item instanceof Waterskin ? (((Waterskin)item).drinks == 0 ? "Waterskin (Empty)" : (((Waterskin)item).drinks == 1 ? "Waterskin (Almost Empty)" : (((Waterskin)item).drinks == 2 ? "Waterskin (Almost Full)" : "Waterskin (Full)"))) : item.name);
                if (arrayList == this.equipped) {
                    string = string + " (E)";
                }
                this.carryingnames.set(n, string);
                this.carryinglist.setListData(this.carryingnames);
                this.carryingindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Equip/UnEquip Item")) {
            if (this.carryingnames.size() == 0) {
                return;
            }
            int n = this.carryinglist.getSelectedIndex();
            if (n == -1) {
                return;
            }
            ArrayList arrayList = this.getActualList(n);
            int n3 = this.getActualIndex(arrayList, n);
            Item item = (Item)arrayList.remove(n3);
            this.carryingnames.remove(n);
            if (arrayList == this.carrying) {
                this.equipped.add(item);
                this.carryingnames.add(item.name + " (E)");
            } else {
                this.carrying.add(item);
                this.carryingnames.add(item.name);
            }
            this.carryinglist.setListData(this.carryingnames);
            this.carryingindex = -1;
        } else if (actionEvent.getActionCommand().equals("Remove Item")) {
            if (this.carryingnames.size() == 0) {
                return;
            }
            int n = this.carryinglist.getSelectedIndex();
            if (n == -1) {
                return;
            }
            ArrayList arrayList = this.getActualList(n);
            int n4 = this.getActualIndex(arrayList, n);
            arrayList.remove(n4);
            this.carryingnames.remove(n);
            this.carryinglist.setListData(this.carryingnames);
            this.carryingindex = -1;
        } else if (actionEvent.getActionCommand().equals("HITANDRUN")) {
            this.HITANDRUN = !this.HITANDRUN;
        } else if (actionEvent.getActionCommand().equals("Non-Material")) {
            boolean bl = this.isImmaterial = !this.isImmaterial;
            if (this.isImmaterial) {
                this.carrying.clear();
                this.carryingnames.clear();
                this.carryinglist.setListData(this.carryingnames);
                this.additembut.setEnabled(false);
                this.equipitembut.setEnabled(false);
                this.removeitembut.setEnabled(false);
                this.pickup.setSelectedIndex(0);
                this.pickup.setEnabled(false);
                this.steal.setSelectedIndex(0);
                this.steal.setEnabled(false);
                this.useammo.setSelected(false);
                this.useammo.setEnabled(false);
                this.poisonimmune.setSelected(true);
                this.poisonimmune.setEnabled(false);
            } else {
                this.additembut.setEnabled(true);
                this.equipitembut.setEnabled(true);
                this.removeitembut.setEnabled(true);
                this.pickup.setEnabled(true);
                this.steal.setEnabled(true);
                this.useammo.setEnabled(true);
                this.poisonimmune.setEnabled(true);
            }
        } else if (actionEvent.getSource().equals(this.facebox)) {
            this.facing = this.facebox.getSelectedIndex();
        } else if (actionEvent.getSource().equals(this.aibox)) {
            this.ai = this.aibox.getSelectedIndex() + 1;
        } else if (actionEvent.getActionCommand().equals("Predefined")) {
            this.ccenter.setVisible(false);
            this.monpane.setVisible(true);
            this.number = this.monsterlist.getSelectedIndex();
            this.mousePressed(new MouseEvent(this.monsterlist, 501, 0L, 0, 0, this.number * 34 + 1, 1, false));
        } else if (actionEvent.getActionCommand().equals("Custom")) {
            this.monpane.setVisible(false);
            this.ccenter.setVisible(true);
            this.cmonsterlist.clearSelection();
            this.cmonsterindex = -1;
            this.name.setText("");
            this.sub5.setSelected(false);
            this.sub5.setEnabled(true);
            if (this.immaterialbut.isSelected()) {
                this.immaterialbut.doClick();
            }
            this.carrying.clear();
            this.equipped.clear();
            this.carryingnames.clear();
            this.carryinglist.setListData(this.carryingnames);
        } else if (actionEvent.getActionCommand().equals("Add/Update Mon")) {
            if (this.name.getText().equals("")) {
                return;
            }
            this.data = new MonsterData(28, this.level, this.x, this.y, Integer.parseInt(this.health.getText()), Integer.parseInt(this.mana.getText()), this.facing, this.ai, this.HITANDRUN, this.isImmaterial, Integer.parseInt(this.power.getText()), Integer.parseInt(this.defense.getText()), Integer.parseInt(this.magicresist.getText()), Integer.parseInt(this.speed.getText()), Integer.parseInt(this.poison.getText()), Integer.parseInt(this.fearresist.getText()), this.carrying, this.equipped, this.gamewin, this.endanim, this.endsound, this.hurtitem, this.needitem, this.needhandneck, this.sub5.isSelected(), this.pickup.getSelectedIndex(), this.steal.getSelectedIndex(), this.name.getText(), this.picstring.getText(), this.soundstring.getText(), this.footstep.getText(), this.canusestairsbut.isSelected(), this.isflyingbut.isSelected(), !this.ignoremonsbut.isSelected(), this.canteleport.isSelected(), this.poisonimmune.isSelected());
            int n = this.cmonsterlist.getSelectedIndex();
            if (n == -1) {
                n = custommons.indexOf(this.data);
            }
            if (n == -1) {
                n = custommons.size();
            }
            this.data.number = this.number = 28 + n;
            this.finishCreation();
            if (n < custommons.size()) {
                custommons.set(n, this.data);
            } else {
                custommons.add(this.data);
                this.cmonsterlist.setPreferredSize(new Dimension(182, custommons.size() * 34));
            }
            this.cmonsterlist.setListData(custommons);
            this.cmonsterlist.setSelectedIndex(n);
            this.cmonsterindex = n;
            DMEditor.NEEDSAVEMONS = true;
        } else if (actionEvent.getActionCommand().equals("Delete Mon")) {
            int n = this.cmonsterlist.getSelectedIndex();
            if (n == -1) {
                return;
            }
            custommons.remove(n);
            for (int i = n; i < custommons.size(); ++i) {
                --((MonsterData)MonsterWizard.custommons.get((int)i)).number;
            }
            this.cmonsterlist.setListData(custommons);
            this.cmonsterlist.setPreferredSize(new Dimension(182, custommons.size() * 34));
            this.cmonsterindex = -1;
            DMEditor.NEEDSAVEMONS = true;
        }
    }

    private ArrayList getActualList(int n) {
        ArrayList arrayList = this.carrying;
        if (((String)this.carryingnames.get(n)).endsWith("(E)")) {
            arrayList = this.equipped;
        }
        return arrayList;
    }

    private int getActualIndex(ArrayList arrayList, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)this.carryingnames.get(i);
            if (string.endsWith("(E)")) {
                if (arrayList != this.equipped) continue;
                ++n2;
                continue;
            }
            if (arrayList != this.carrying) continue;
            ++n2;
        }
        return n2;
    }

    private void finishCreation() {
        int n;
        int n2;
        this.data.timecounter = randGen.nextInt(100);
        this.data.movecounter = randGen.nextInt(10);
        this.data.movespeed = Integer.parseInt(this.movespeed.getText());
        this.data.attackspeed = Integer.parseInt(this.attackspeed.getText());
        if (this.data.movespeed <= 0) {
            this.data.movespeed = 1;
        }
        if (this.data.attackspeed >= this.data.movespeed) {
            this.data.attackspeed = this.data.movespeed - 1;
        }
        if (this.hasmagic.isSelected()) {
            this.data.hasmagic = true;
            this.data.hasheal = this.hasheal.isSelected();
            this.data.hasdrain = this.hasdrain.isSelected();
            this.data.castpower = this.castpower.getSelectedIndex() + 1;
            this.data.manapower = Integer.parseInt(this.manapower.getText());
            this.data.numspells = this.spells.size();
            n2 = 24;
            if (this.data.numspells > 0) {
                this.data.knownspells = new String[this.data.numspells];
                n2 = 21;
                for (n = 0; n < this.data.numspells; ++n) {
                    this.data.knownspells[n] = (String)this.spells.get(n);
                    if (n2 > 17 && (this.data.knownspells[n].equals("363") || this.data.knownspells[n].equals("335") || this.data.knownspells[n].equals("642") || this.data.knownspells[n].equals("461"))) {
                        n2 = 17;
                        continue;
                    }
                    if (n2 > 16 && this.data.knownspells[n].equals("362")) {
                        n2 = 16;
                        continue;
                    }
                    if (n2 > 15 && this.data.knownspells[n].equals("523")) {
                        n2 = 15;
                        continue;
                    }
                    if (n2 > 13 && this.data.knownspells[n].equals("44")) {
                        n2 = 13;
                        continue;
                    }
                    if (n2 > 11 && this.data.knownspells[n].equals("51")) {
                        n2 = 11;
                        continue;
                    }
                    if (n2 > 9 && this.data.knownspells[n].equals("31")) {
                        n2 = 9;
                        continue;
                    }
                    if (n2 <= 8 || !this.data.knownspells[n].equals("6")) continue;
                    n2 = 8;
                }
                if (this.number == 25 && this.spells.contains("44")) {
                    n2 = 0;
                }
            }
            this.data.minproj = n2;
        }
        if (this.useammo.isSelected()) {
            this.data.useammo = true;
            this.data.ammo = 0;
            for (n2 = 0; n2 < this.carrying.size(); ++n2) {
                Item item = (Item)this.carrying.get(n2);
                if (item.number <= 220 || !item.hasthrowpic && item.number != 266) continue;
                ++this.data.ammo;
            }
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(3);
        for (n = 0; n < this.carrying.size(); ++n) {
            arrayList.add(Item.createCopy((Item)this.carrying.get(n)));
        }
        this.carrying = arrayList;
        ArrayList<Item> arrayList2 = new ArrayList<Item>(3);
        for (int i = 0; i < this.equipped.size(); ++i) {
            arrayList2.add(Item.createCopy((Item)this.equipped.get(i)));
        }
        this.equipped = arrayList2;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.carryinglist)) {
            int n = this.carryinglist.locationToIndex(mouseEvent.getPoint());
            if (n == -1 || n == this.carryingindex) {
                this.carryinglist.clearSelection();
            }
            this.carryingindex = this.carryinglist.getSelectedIndex();
        } else if (mouseEvent.getSource().equals(this.cmonsterlist)) {
            int n = this.cmonsterlist.locationToIndex(mouseEvent.getPoint());
            if (n == -1 || n == this.cmonsterindex) {
                this.cmonsterlist.clearSelection();
            }
            this.cmonsterindex = this.cmonsterlist.getSelectedIndex();
            if (this.cmonsterindex != -1) {
                this.data = (MonsterData)custommons.get(this.cmonsterindex);
                this.name.setText(this.data.name);
                this.picstring.setText(this.data.picstring);
                this.soundstring.setText(this.data.soundstring);
                this.footstep.setText(this.data.footstep);
                this.health.setText("" + this.data.health);
                this.mana.setText("" + this.data.mana);
                this.power.setText("" + this.data.power);
                this.defense.setText("" + this.data.defense);
                this.magicresist.setText("" + this.data.magicresist);
                this.speed.setText("" + this.data.speed);
                this.fearresist.setText("" + this.data.fearresist);
                this.poison.setText("" + this.data.poison);
                this.movespeed.setText("" + this.data.movespeed);
                this.attackspeed.setText("" + this.data.attackspeed);
                this.ai = this.data.defaultai;
                this.aibox.setSelectedIndex(this.ai - 1);
                this.carrying.clear();
                this.equipped.clear();
                this.carryingnames.clear();
                if (this.data.equipped != null) {
                    for (int i = 0; i < this.data.equipped.size(); ++i) {
                        Item item = Item.createCopy((Item)this.data.equipped.get(i));
                        this.equipped.add(item);
                        this.carryingnames.add(item.name + " (E)");
                    }
                }
                this.carryinglist.setListData(this.carryingnames);
                this.spells.clear();
                this.spellnames.clear();
                if (this.data.hasmagic) {
                    if (!this.hasmagic.isSelected()) {
                        this.hasmagic.doClick();
                    }
                    this.hasheal.setSelected(this.data.hasheal);
                    this.hasdrain.setSelected(this.data.hasdrain);
                    this.castpower.setSelectedIndex(this.data.castpower - 1);
                    this.manapower.setText("" + this.data.manapower);
                    for (int i = 0; i < this.data.knownspells.length; ++i) {
                        this.spells.add(this.data.knownspells[i]);
                        if (this.data.knownspells[i].equals("44")) {
                            this.spellnames.add("Fireball");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("335")) {
                            this.spellnames.add("Lightning");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("51")) {
                            this.spellnames.add("Poison Bolt");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("31")) {
                            this.spellnames.add("Ven Cloud");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("642")) {
                            this.spellnames.add("Arc Bolt");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("461")) {
                            this.spellnames.add("Weakness");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("363")) {
                            this.spellnames.add("Feeble Mind");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("362")) {
                            this.spellnames.add("Slow");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("664")) {
                            this.spellnames.add("Strip Defenses");
                            continue;
                        }
                        if (this.data.knownspells[i].equals("523")) {
                            this.spellnames.add("Silence");
                            continue;
                        }
                        if (!this.data.knownspells[i].equals("6")) continue;
                        this.spellnames.add("Door Open");
                    }
                    this.knownspells.setListData(this.spellnames);
                } else if (this.hasmagic.isSelected()) {
                    this.hasmagic.doClick();
                }
                this.useammo.setSelected(this.data.useammo);
                if (this.data.isImmaterial != this.immaterialbut.isSelected()) {
                    this.immaterialbut.doClick();
                }
                this.HITANDRUN = this.data.HITANDRUN;
                this.hitandrunbut.setSelected(this.HITANDRUN);
                this.canusestairsbut.setSelected(this.data.canusestairs);
                this.ignoremonsbut.setSelected(!this.data.ignoremons);
                this.isflyingbut.setSelected(this.data.isflying);
                this.canteleport.setSelected(this.data.canteleport);
                this.sub5.setSelected(this.data.subsquare == 5);
                this.pickup.setSelectedIndex(this.data.pickup);
                this.steal.setSelectedIndex(this.data.steal);
                this.poisonimmune.setSelected(this.data.poisonimmune);
            }
        } else {
            int n;
            this.number = this.monsterlist.getSelectedIndex();
            this.health.setText("" + defaulthealth[this.number]);
            this.mana.setText("" + defaultmana[this.number]);
            this.power.setText("" + defaultpower[this.number]);
            this.defense.setText("" + defaultdefense[this.number]);
            this.magicresist.setText("" + defaultmresist[this.number]);
            this.speed.setText("" + defaultspeed[this.number]);
            this.fearresist.setText("" + defaultfresist[this.number]);
            this.poison.setText("" + defaultpoison[this.number]);
            this.movespeed.setText("" + defaultmspeed[this.number]);
            this.attackspeed.setText("" + defaultaspeed[this.number]);
            this.aibox.setSelectedIndex(defaultai[this.number] - 1);
            this.castpower.setSelectedIndex(defaultcpower[this.number]);
            this.manapower.setText("" + defaultmpower[this.number]);
            this.carrying.clear();
            this.equipped.clear();
            this.carryingnames.clear();
            this.spells.clear();
            this.spellnames.clear();
            if (this.hasmagic.isSelected()) {
                this.hasmagic.doClick();
            }
            this.hasheal.setSelected(false);
            this.hasdrain.setSelected(false);
            this.useammo.setSelected(false);
            this.pickup.setSelectedIndex(defaultpickup[this.number]);
            this.steal.setSelectedIndex(0);
            this.poisonimmune.setSelected(false);
            if (this.HITANDRUN) {
                this.hitandrunbut.doClick();
            }
            if (this.isImmaterial) {
                this.immaterialbut.doClick();
            }
            if (this.number == 9 || this.number == 10 || this.number == 13 || this.number == 16 || this.number == 19 || this.number == 22 || this.number == 25 || this.number == 26 || this.number == 27) {
                this.sub5.setSelected(true);
                this.sub5.setEnabled(false);
            } else {
                this.sub5.setSelected(false);
                this.sub5.setEnabled(true);
            }
            switch (this.number) {
                case 1: {
                    int n2 = randGen.nextInt(3) + 2;
                    for (int i = 0; i < n2; ++i) {
                        this.equipped.add(new Item(65));
                    }
                    break;
                }
                case 2: {
                    this.hitandrunbut.doClick();
                    this.carryinglist.setListData(this.carryingnames);
                    this.steal.setSelectedIndex(4);
                    return;
                }
                case 3: {
                    int n2 = randGen.nextInt(3) + 2;
                    for (int i = 0; i < n2; ++i) {
                        this.equipped.add(new Item(266));
                    }
                    this.equipped.add(new Item(76));
                    if (!randGen.nextBoolean()) break;
                    this.equipped.add(new Item(76));
                    break;
                }
                case 4: {
                    this.poisonimmune.setSelected(true);
                    break;
                }
                case 5: {
                    this.spells.add("335");
                    this.spells.add("664");
                    this.spells.add("335");
                    this.spellnames.add("Lightning");
                    this.spellnames.add("Strip Defenses");
                    this.spellnames.add("Lightning");
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 8: {
                    this.equipped.add(new Item(200));
                    this.equipped.add(new Item(104));
                    this.poisonimmune.setSelected(true);
                    break;
                }
                case 9: {
                    int n2 = randGen.nextInt(4) + 1;
                    for (int i = 0; i < n2; ++i) {
                        this.equipped.add(new Item(61));
                    }
                    break;
                }
                case 12: {
                    int n2 = randGen.nextInt(5) + 4;
                    for (int i = 0; i < n2; ++i) {
                        this.carrying.add(new Item(267));
                    }
                    this.useammo.setSelected(true);
                    break;
                }
                case 13: {
                    this.equipped.add(new Item(67));
                    if (!randGen.nextBoolean()) break;
                    this.equipped.add(new Item(67));
                    break;
                }
                case 14: {
                    this.equipped.add(new Item(226));
                    break;
                }
                case 15: {
                    this.spells.add("6");
                    this.spells.add("44");
                    this.spells.add("335");
                    this.spells.add("642");
                    this.spells.add("363");
                    this.spells.add("362");
                    this.spellnames.add("Door Open");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Lightning");
                    this.spellnames.add("Arc Bolt");
                    this.spellnames.add("Feeble Mind");
                    this.spellnames.add("Slow");
                    this.knownspells.setListData(this.spellnames);
                    this.hasheal.setSelected(true);
                    this.hasdrain.setSelected(true);
                    this.hasmagic.doClick();
                    break;
                }
                case 17: {
                    this.immaterialbut.doClick();
                    this.spells.add("44");
                    this.spells.add("523");
                    this.spells.add("664");
                    this.spells.add("44");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Silence");
                    this.spellnames.add("Strip Defenses");
                    this.spellnames.add("Fireball");
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 18: {
                    this.spells.add("461");
                    this.spellnames.add("Weakness");
                    this.poisonimmune.setSelected(true);
                }
                case 22: {
                    this.spells.add("51");
                    this.spells.add("31");
                    this.spellnames.add("Poison Bolt");
                    this.spellnames.add("Ven Cloud");
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 20: {
                    this.spells.add("44");
                    this.spells.add("461");
                    this.spells.add("44");
                    this.spells.add("44");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Weakness");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Fireball");
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 21: {
                    Item item = new Item(201);
                    item.cursed = 100;
                    item.haseffect = true;
                    item.effect = new String[2];
                    item.effect[0] = "strength,-5";
                    item.effect[1] = "vitality,-5";
                    this.equipped.add(item);
                    this.equipped.add(Item.createCopy(item));
                    Item item2 = new Item(143);
                    item2.cursed = 100;
                    item2.haseffect = true;
                    item2.effect = new String[2];
                    item2.effect[0] = "strength,-5";
                    item2.effect[1] = "vitality,-5";
                    this.equipped.add(item2);
                    Item item3 = new Item(163);
                    item3.cursed = 100;
                    item3.haseffect = true;
                    item3.effect = new String[2];
                    item3.effect[0] = "strength,-5";
                    item3.effect[1] = "vitality,-5";
                    this.equipped.add(item3);
                    Item item4 = new Item(181);
                    item4.cursed = 100;
                    item4.haseffect = true;
                    item4.effect = new String[2];
                    item4.effect[0] = "strength,-5";
                    item4.effect[1] = "vitality,-5";
                    this.equipped.add(item4);
                    this.poisonimmune.setSelected(true);
                    break;
                }
                case 23: {
                    int n3;
                    this.equipped.add(new Item(227));
                    int n2 = randGen.nextInt(3) + 2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.equipped.add(new Item(266));
                    }
                    this.equipped.add(new Item(76));
                    if (randGen.nextBoolean()) {
                        this.equipped.add(new Item(76));
                    }
                    this.poisonimmune.setSelected(true);
                    break;
                }
                case 24: {
                    this.spells.add("642");
                    this.spells.add("363");
                    this.spellnames.add("Arc Bolt");
                    this.spellnames.add("Feeble Mind");
                }
                case 26: {
                    this.spells.add("44");
                    this.spells.add("335");
                    this.spells.add("51");
                    this.spells.add("31");
                    this.spells.add("664");
                    this.spells.add("523");
                    this.spells.add("461");
                    this.spells.add("362");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Lightning");
                    this.spellnames.add("Poison Bolt");
                    this.spellnames.add("Ven Cloud");
                    this.spellnames.add("Strip Defenses");
                    this.spellnames.add("Silence");
                    this.spellnames.add("Weakness");
                    this.spellnames.add("Slow");
                    this.hasheal.setSelected(true);
                    this.hasdrain.setSelected(true);
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    this.poisonimmune.setSelected(true);
                    break;
                }
                case 25: {
                    int n3;
                    int n2 = randGen.nextInt(4) + 4;
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.equipped.add(new Item(69));
                    }
                    this.spells.add("44");
                    this.spellnames.add("Fireball");
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 27: {
                    this.spells.add("44");
                    this.spells.add("664");
                    this.spells.add("44");
                    this.spells.add("44");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Strip Defenses");
                    this.spellnames.add("Fireball");
                    this.spellnames.add("Fireball");
                    this.hasdrain.setSelected(true);
                    this.knownspells.setListData(this.spellnames);
                    this.hasmagic.doClick();
                    break;
                }
                case 6: 
                case 10: 
                case 11: {
                    this.immaterialbut.doClick();
                }
            }
            for (n = 0; n < this.equipped.size(); ++n) {
                this.carryingnames.add(((Item)this.equipped.get((int)n)).name + " (E)");
            }
            for (n = 0; n < this.carrying.size(); ++n) {
                this.carryingnames.add(((Item)this.carrying.get((int)n)).name);
            }
            this.carryinglist.setListData(this.carryingnames);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

