/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

class MultFloorSwitchWizard
extends JDialog
implements ActionListener,
MouseListener {
    private MapData data;
    private int level;
    private int x;
    private int y;
    private int switchindex = -1;
    private JList switchlist;
    private ArrayList switches = new ArrayList(3);
    private Vector switchnames = new Vector(3);
    private JToggleButton isVisible;
    private DMEditor dmed;

    public MultFloorSwitchWizard(DMEditor dMEditor, MapData mapData, int n, int n2, int n3) {
        super(dMEditor, "Multiple Floor Switches Wizard", true);
        this.dmed = dMEditor;
        this.level = n;
        this.x = n2;
        this.y = n3;
        this.setDefaultCloseOperation(2);
        this.setSize(520, 250);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.switchlist = new JList();
        this.switchlist.setVisibleRowCount(6);
        this.switchlist.addMouseListener(this);
        Box box = Box.createVerticalBox();
        JScrollPane jScrollPane = new JScrollPane(this.switchlist);
        jScrollPane.setPreferredSize(new Dimension(240, 120));
        box.add(Box.createVerticalStrut(20));
        box.add(new JLabel("Switches:"));
        box.add(jScrollPane);
        Box box2 = Box.createVerticalBox();
        JButton jButton = new JButton("Add/Edit Switch");
        JButton jButton2 = new JButton("Remove Switch");
        JButton jButton3 = new JButton("Move Switch Up");
        JButton jButton4 = new JButton("Move Switch Down");
        Font font = jButton.getFont().deriveFont(9.0f);
        jButton.setFont(font);
        jButton2.setFont(font);
        jButton3.setFont(font);
        jButton4.setFont(font);
        jButton.setMargin(new Insets(0, 5, 0, 5));
        jButton2.setMargin(new Insets(0, 5, 0, 5));
        jButton3.setMargin(new Insets(0, 5, 0, 5));
        jButton4.setMargin(new Insets(0, 5, 0, 5));
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        box2.add(Box.createVerticalStrut(20));
        box2.add(jButton);
        box2.add(jButton2);
        box2.add(Box.createVerticalStrut(5));
        box2.add(jButton3);
        box2.add(jButton4);
        jPanel.add(box);
        jPanel.add(box2);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        Box box3 = Box.createVerticalBox();
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(120, 50));
        this.isVisible = new JToggleButton("Visible");
        jPanel3.add(this.isVisible);
        this.isVisible.setSelected(true);
        box3.add(Box.createVerticalGlue());
        box3.add(jPanel3);
        box3.add(Box.createVerticalGlue());
        JPanel jPanel4 = new JPanel();
        JButton jButton5 = new JButton("Done");
        JButton jButton6 = new JButton("Cancel");
        jButton5.addActionListener(this);
        jButton6.addActionListener(this);
        jPanel4.add(jButton6);
        jPanel4.add(jButton5);
        if (mapData.mapchar == 'S') {
            MultFloorSwitchData multFloorSwitchData = (MultFloorSwitchData)mapData;
            for (int i = 0; i < multFloorSwitchData.switchlist.size(); ++i) {
                FloorSwitchData floorSwitchData = (FloorSwitchData)multFloorSwitchData.switchlist.get(i);
                this.switches.add(floorSwitchData);
                this.switchnames.add("Targets: " + floorSwitchData.targetlevel + "," + floorSwitchData.targetx + "," + floorSwitchData.targety);
            }
            this.switchlist.setListData(this.switchnames);
            if (!multFloorSwitchData.haspic) {
                this.isVisible.setSelected(false);
            }
        } else if (mapData.mapchar == 's') {
            this.switches.add(mapData);
            this.switchnames.add("Targets: " + ((FloorSwitchData)mapData).targetlevel + "," + ((FloorSwitchData)mapData).targetx + "," + ((FloorSwitchData)mapData).targety);
            this.switchlist.setListData(this.switchnames);
        }
        container.add("Center", jPanel2);
        container.add("East", box3);
        container.add("South", jPanel4);
        this.show();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.switchlist.locationToIndex(mouseEvent.getPoint());
        if (n == -1 || n == this.switchindex) {
            this.switchlist.clearSelection();
        }
        this.switchindex = this.switchlist.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (this.switches.size() < 2) {
                return;
            }
            this.data = new MultFloorSwitchData(new MapPoint(this.level, this.x, this.y), this.isVisible.isSelected(), this.switches);
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Add/Edit Switch")) {
            int n = this.switchlist.getSelectedIndex();
            if (n == -1) {
                FloorSwitchData floorSwitchData = (FloorSwitchData)new FloorSwitchWizard(this.dmed, null, this.level, this.x, this.y).getData();
                if (floorSwitchData == null) {
                    return;
                }
                this.switches.add(floorSwitchData);
                this.switchnames.add("Targets: " + floorSwitchData.targetlevel + "," + floorSwitchData.targetx + "," + floorSwitchData.targety);
                this.switchlist.setListData(this.switchnames);
            } else {
                FloorSwitchData floorSwitchData = (FloorSwitchData)new FloorSwitchWizard(this.dmed, (FloorSwitchData)this.switches.get(n), this.level, this.x, this.y).getData();
                if (floorSwitchData == null) {
                    this.switchlist.clearSelection();
                    this.switchindex = -1;
                    return;
                }
                this.switches.set(n, floorSwitchData);
                this.switchnames.set(n, "Targets: " + floorSwitchData.targetlevel + "," + floorSwitchData.targetx + "," + floorSwitchData.targety);
                this.switchlist.setListData(this.switchnames);
                this.switchindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Remove Switch")) {
            if (this.switchnames.size() == 0 || this.switchlist.isSelectionEmpty()) {
                return;
            }
            int n = this.switchlist.getSelectedIndex();
            this.switches.remove(n);
            this.switchnames.removeElementAt(n);
            this.switchlist.setListData(this.switchnames);
            this.switchindex = -1;
        } else if (actionEvent.getActionCommand().endsWith("Up")) {
            if (this.switchindex > 0) {
                Object e = this.switches.remove(this.switchindex);
                Object e2 = this.switchnames.remove(this.switchindex);
                this.switches.add(this.switchindex - 1, e);
                this.switchnames.add(this.switchindex - 1, e2);
                this.switchlist.setListData(this.switchnames);
                this.switchindex = -1;
            }
        } else if (actionEvent.getActionCommand().endsWith("Down") && this.switchindex != -1 && this.switches.size() > 1 && this.switchindex < this.switches.size() - 1) {
            Object e = this.switches.remove(this.switchindex);
            Object e3 = this.switchnames.remove(this.switchindex);
            this.switches.add(this.switchindex + 1, e);
            this.switchnames.add(this.switchindex + 1, e3);
            this.switchlist.setListData(this.switchnames);
            this.switchindex = -1;
        }
    }

    public MapData getData() {
        return this.data;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

