/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;

class MultWallSwitchWizard
extends JDialog
implements ActionListener,
MouseListener {
    private MapData data;
    private int level;
    private int x;
    private int y;
    private int side;
    private int pictype = 0;
    private int picnum = 0;
    private int switchindex = -1;
    private int alcove;
    private JList switchlist;
    private ArrayList switches = new ArrayList(3);
    private Vector switchnames = new Vector(3);
    private JPanel typepanel;
    private JPanel buttonpanel;
    private JPanel keypanel;
    private JPanel switchpanel;
    private JToggleButton buttonbut;
    private JToggleButton keybut;
    private JToggleButton coinbut;
    private DMEditor dmed;

    public MultWallSwitchWizard(DMEditor dMEditor, MapData mapData, int n, int n2, int n3) {
        this(dMEditor, mapData, n, n2, n3, true, -1, 0);
    }

    public MultWallSwitchWizard(DMEditor dMEditor, MapData mapData, int n, int n2, int n3, boolean bl, int n4, int n5) {
        super(dMEditor, "Multiple Wall Switches Wizard", true);
        this.dmed = dMEditor;
        this.level = n;
        this.x = n2;
        this.y = n3;
        this.alcove = n4;
        this.side = n5;
        this.setDefaultCloseOperation(2);
        this.setSize(800, 480);
        this.setLocationRelativeTo(dMEditor);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 20));
        JLabel jLabel = new JLabel("Picture Used:");
        jPanel.add(jLabel);
        this.typepanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttonbut = new JToggleButton("Button");
        this.keybut = new JToggleButton("Key");
        this.coinbut = new JToggleButton("Coin");
        this.buttonbut.addActionListener(this);
        this.keybut.addActionListener(this);
        this.coinbut.addActionListener(this);
        buttonGroup.add(this.buttonbut);
        buttonGroup.add(this.keybut);
        buttonGroup.add(this.coinbut);
        this.typepanel.add(this.buttonbut);
        this.typepanel.add(this.keybut);
        this.typepanel.add(this.coinbut);
        this.buttonbut.setSelected(true);
        this.buttonpanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(11, 1));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        JToggleButton[] jToggleButtonArray = new JToggleButton[]{new JToggleButton("Stone Button"), new JToggleButton("Lever"), new JToggleButton("Small Button"), new JToggleButton("Green Gem"), new JToggleButton("Blue Gem"), new JToggleButton("Red Gem"), new JToggleButton("Wall Ring"), new JToggleButton("Wall Crack"), new JToggleButton("Chaos Face"), new JToggleButton("Eye"), new JToggleButton("Demon Face")};
        for (int i = 0; i < 11; ++i) {
            jToggleButtonArray[i].setActionCommand("" + i);
            jToggleButtonArray[i].addActionListener(this);
            buttonGroup2.add(jToggleButtonArray[i]);
            jPanel2.add(jToggleButtonArray[i]);
        }
        jToggleButtonArray[0].setSelected(true);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setPreferredSize(new Dimension(200, 165));
        this.buttonpanel.add(jScrollPane);
        this.keypanel = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(23, 1));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        JToggleButton[] jToggleButtonArray2 = new JToggleButton[]{new JToggleButton("Iron Keyhole"), new JToggleButton("Brass Keyhole"), new JToggleButton("Gold Keyhole"), new JToggleButton("Emerald Keyhole"), new JToggleButton("Ruby Keyhole"), new JToggleButton("Ruby (Alt) Keyhole"), new JToggleButton("Onyx Keyhole"), new JToggleButton("Tourquoise Keyhole"), new JToggleButton("Winged Keyhole"), new JToggleButton("Master Keyhole"), new JToggleButton("Ra Keyhole"), new JToggleButton("Skeleton Keyhole"), new JToggleButton("Gem Hole"), new JToggleButton("Eye"), new JToggleButton("Wall Drain"), new JToggleButton("Wall Crack"), new JToggleButton("Block Keyhole"), new JToggleButton("Cross Keyhole"), new JToggleButton("Double Keyhole"), new JToggleButton("Iron (Alt) Keyhole"), new JToggleButton("Solid Keyhole"), new JToggleButton("Square Keyhole"), new JToggleButton("Topaz Keyhole")};
        for (int i = 0; i < 23; ++i) {
            jToggleButtonArray2[i].setActionCommand("" + i);
            jToggleButtonArray2[i].addActionListener(this);
            buttonGroup3.add(jToggleButtonArray2[i]);
            jPanel3.add(jToggleButtonArray2[i]);
        }
        jToggleButtonArray2[0].setSelected(true);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel3);
        jScrollPane2.setPreferredSize(new Dimension(200, 191));
        this.keypanel.add(jScrollPane2);
        this.keypanel.setVisible(false);
        this.switchpanel = new JPanel();
        this.switchlist = new JList();
        this.switchlist.setVisibleRowCount(6);
        this.switchlist.addMouseListener(this);
        Box box = Box.createVerticalBox();
        JScrollPane jScrollPane3 = new JScrollPane(this.switchlist);
        jScrollPane3.setPreferredSize(new Dimension(380, 120));
        box.add(Box.createVerticalStrut(20));
        box.add(new JLabel("Switches:"));
        box.add(jScrollPane3);
        Box box2 = Box.createVerticalBox();
        JButton jButton = new JButton("Add/Edit Switch");
        JButton jButton2 = new JButton("Remove Switch");
        JButton jButton3 = new JButton("Move Switch Up");
        JButton jButton4 = new JButton("Move Switch Down");
        Font font = jButton.getFont().deriveFont(9.0f);
        jButton.setFont(font);
        jButton2.setFont(font);
        jButton3.setFont(font);
        jButton4.setFont(font);
        jButton.setMargin(new Insets(0, 5, 0, 5));
        jButton2.setMargin(new Insets(0, 5, 0, 5));
        jButton3.setMargin(new Insets(0, 5, 0, 5));
        jButton4.setMargin(new Insets(0, 5, 0, 5));
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        box2.add(Box.createVerticalStrut(20));
        box2.add(jButton);
        box2.add(jButton2);
        box2.add(Box.createVerticalStrut(5));
        box2.add(jButton3);
        box2.add(jButton4);
        this.switchpanel.add(box);
        this.switchpanel.add(box2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.switchpanel);
        jPanel4.add(jPanel);
        jPanel4.add(this.typepanel);
        jPanel4.add(this.buttonpanel);
        jPanel4.add(this.keypanel);
        Box box3 = Box.createVerticalBox();
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(240, 70));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(3, 3));
        ButtonGroup buttonGroup4 = new ButtonGroup();
        JToggleButton[] jToggleButtonArray3 = new JToggleButton[]{new JToggleButton("North"), new JToggleButton("West"), new JToggleButton("South"), new JToggleButton("East")};
        jToggleButtonArray3[0].addActionListener(this);
        jToggleButtonArray3[1].addActionListener(this);
        jToggleButtonArray3[2].addActionListener(this);
        jToggleButtonArray3[3].addActionListener(this);
        buttonGroup4.add(jToggleButtonArray3[0]);
        buttonGroup4.add(jToggleButtonArray3[1]);
        buttonGroup4.add(jToggleButtonArray3[2]);
        buttonGroup4.add(jToggleButtonArray3[3]);
        jPanel6.add(new JLabel());
        jPanel6.add(jToggleButtonArray3[0]);
        jPanel6.add(new JLabel());
        jPanel6.add(jToggleButtonArray3[1]);
        jPanel6.add(new JLabel());
        jPanel6.add(jToggleButtonArray3[3]);
        jPanel6.add(new JLabel());
        jPanel6.add(jToggleButtonArray3[2]);
        jPanel6.add(new JLabel());
        jToggleButtonArray3[(n5 + 2) % 4].setSelected(true);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Switches Face:"));
        jPanel5.add(jPanel6);
        box3.add(Box.createVerticalGlue());
        box3.add(jPanel5);
        box3.add(Box.createVerticalGlue());
        JPanel jPanel7 = new JPanel();
        JButton jButton5 = new JButton("Done");
        JButton jButton6 = new JButton("Cancel");
        jButton5.addActionListener(this);
        jButton6.addActionListener(this);
        jPanel7.add(jButton6);
        jPanel7.add(jButton5);
        if (mapData != null && mapData.mapchar == '\\') {
            Object object;
            MultWallSwitchData multWallSwitchData = (MultWallSwitchData)mapData;
            if (multWallSwitchData.pictype == 0) {
                jToggleButtonArray[multWallSwitchData.picnumber].doClick();
                object = jScrollPane.getViewport();
                ((JViewport)object).setViewPosition(new Point(0, multWallSwitchData.picnumber * 27));
            } else if (multWallSwitchData.pictype == 1) {
                this.keybut.doClick();
                jToggleButtonArray2[multWallSwitchData.picnumber].doClick();
                object = jScrollPane2.getViewport();
                ((JViewport)object).setViewPosition(new Point(0, multWallSwitchData.picnumber * 27));
            } else {
                this.coinbut.doClick();
            }
            jToggleButtonArray3[(multWallSwitchData.side + 2) % 4].doClick();
            for (int i = 0; i < multWallSwitchData.switchlist.size(); ++i) {
                object = (WallSwitchData)multWallSwitchData.switchlist.get(i);
                this.switches.add(object);
                this.switchnames.add(((WallSwitchData)object).toString() + " Targets: " + ((WallSwitchData)object).targetlevel + "," + ((WallSwitchData)object).targetx + "," + ((WallSwitchData)object).targety);
            }
            this.switchlist.setListData(this.switchnames);
        } else if (mapData != null && mapData.mapchar == '/') {
            this.switches.add(mapData);
            this.switchnames.add(mapData.toString() + " Targets: " + ((WallSwitchData)mapData).targetlevel + "," + ((WallSwitchData)mapData).targetx + "," + ((WallSwitchData)mapData).targety);
            this.switchlist.setListData(this.switchnames);
        }
        container.add("Center", jPanel4);
        container.add("East", box3);
        container.add("South", jPanel7);
        if (!bl) {
            box3.setVisible(false);
            jPanel.setVisible(false);
            this.typepanel.setVisible(false);
            this.buttonpanel.setVisible(false);
            this.keypanel.setVisible(false);
        }
        this.show();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.switchlist.locationToIndex(mouseEvent.getPoint());
        if (n == -1 || n == this.switchindex) {
            this.switchlist.clearSelection();
        }
        this.switchindex = this.switchlist.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Done")) {
            if (this.switches.size() < 1) {
                return;
            }
            this.data = new MultWallSwitchData(new MapPoint(this.level, this.x, this.y), this.side, this.pictype, this.picnum, this.switches);
            if (this.alcove <= 0) {
                ((MultWallSwitchData)this.data).setFacing(this.side);
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Button")) {
            this.pictype = 0;
            this.keypanel.setVisible(false);
            this.buttonpanel.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Key")) {
            this.pictype = 1;
            this.buttonpanel.setVisible(false);
            this.keypanel.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("Coin")) {
            this.pictype = 2;
            this.buttonpanel.setVisible(false);
            this.keypanel.setVisible(false);
        } else if (actionEvent.getActionCommand().equals("Add/Edit Switch")) {
            int n = this.switchlist.getSelectedIndex();
            if (n == -1) {
                WallSwitchData wallSwitchData = (WallSwitchData)new WallSwitchWizard(this.dmed, null, this.level, this.x, this.y, true, this.alcove, this.side, this.pictype).getData();
                if (wallSwitchData == null) {
                    return;
                }
                this.switches.add(wallSwitchData);
                this.switchnames.add(wallSwitchData.toString() + " Targets: " + wallSwitchData.targetlevel + "," + wallSwitchData.targetx + "," + wallSwitchData.targety);
                this.switchlist.setListData(this.switchnames);
            } else {
                WallSwitchData wallSwitchData = (WallSwitchData)new WallSwitchWizard(this.dmed, (WallSwitchData)this.switches.get(n), this.level, this.x, this.y, true, this.alcove, this.side, this.pictype).getData();
                if (wallSwitchData == null) {
                    this.switchlist.clearSelection();
                    this.switchindex = -1;
                    return;
                }
                this.switches.set(n, wallSwitchData);
                this.switchnames.set(n, wallSwitchData.toString() + " Targets: " + wallSwitchData.targetlevel + "," + wallSwitchData.targetx + "," + wallSwitchData.targety);
                this.switchlist.setListData(this.switchnames);
                this.switchindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("Remove Switch")) {
            if (this.switchnames.size() == 0 || this.switchlist.isSelectionEmpty()) {
                return;
            }
            int n = this.switchlist.getSelectedIndex();
            this.switches.remove(n);
            this.switchnames.removeElementAt(n);
            this.switchlist.setListData(this.switchnames);
            this.switchindex = -1;
        } else if (actionEvent.getActionCommand().endsWith("Up")) {
            if (this.switchindex > 0) {
                Object e = this.switches.remove(this.switchindex);
                Object e2 = this.switchnames.remove(this.switchindex);
                this.switches.add(this.switchindex - 1, e);
                this.switchnames.add(this.switchindex - 1, e2);
                this.switchlist.setListData(this.switchnames);
                this.switchindex = -1;
            }
        } else if (actionEvent.getActionCommand().endsWith("Down")) {
            if (this.switchindex != -1 && this.switches.size() > 1 && this.switchindex < this.switches.size() - 1) {
                Object e = this.switches.remove(this.switchindex);
                Object e3 = this.switchnames.remove(this.switchindex);
                this.switches.add(this.switchindex + 1, e);
                this.switchnames.add(this.switchindex + 1, e3);
                this.switchlist.setListData(this.switchnames);
                this.switchindex = -1;
            }
        } else if (actionEvent.getActionCommand().equals("North")) {
            this.side = 2;
        } else if (actionEvent.getActionCommand().equals("South")) {
            this.side = 0;
        } else if (actionEvent.getActionCommand().equals("East")) {
            this.side = 1;
        } else if (actionEvent.getActionCommand().equals("West")) {
            this.side = 3;
        } else {
            int n;
            try {
                n = Integer.parseInt(actionEvent.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            this.picnum = n;
        }
    }

    public MapData getData() {
        return this.data;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

