/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;

class OptionsDialog
extends JDialog
implements ActionListener {
    public static final int LOAD = 1;
    public static final int SAVE = 2;
    public static final int NEWGAME = 3;
    public static final int NEWCUST = 4;
    private int value = 0;
    private JToggleButton dark;
    private JToggleButton trans;
    private JToggleButton steps;
    private JToggleButton antialias;
    private JToggleButton automap;
    private JToggleButton showparty;
    private JButton savegame;
    private JSlider sleeper;
    private JSlider difficulty;
    private JSlider brightadjust;
    private JSlider scaleSlider;
    private JFrame frame;

    public OptionsDialog(JFrame jFrame) {
        super(jFrame, "Options", true);
        this.frame = jFrame;
        this.setDefaultCloseOperation(1);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Load Game");
        this.savegame = new JButton("Save Game");
        JButton jButton2 = new JButton("New Game");
        JButton jButton3 = new JButton("New Custom");
        jButton.addActionListener(this);
        this.savegame.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(this.savegame);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.savegame.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        this.dark = new JToggleButton("Have Darkness");
        this.trans = new JToggleButton("Use Transparency");
        this.steps = new JToggleButton("Play Footsteps");
        JPanel jPanel3 = new JPanel();
        this.antialias = new JToggleButton("Text Antialiasing");
        this.automap = new JToggleButton("Use AutoMap");
        this.showparty = new JToggleButton("Show Party on Map");
        if (!dmnew.NODARK) {
            this.dark.setSelected(true);
        }
        if (!dmnew.NOTRANS) {
            this.trans.setSelected(true);
        }
        this.steps.setSelected(dmnew.PLAYFOOTSTEPS);
        if (dmnew.TEXTANTIALIAS) {
            this.antialias.setSelected(true);
        }
        this.automap.setSelected(dmnew.AUTOMAP);
        if (!dmnew.AUTOMAP) {
            this.showparty.setVisible(false);
        } else {
            this.showparty.setSelected(dmnew.SHOWPARTYMAP);
        }
        this.automap.addActionListener(this);
        jPanel2.add(this.dark);
        jPanel2.add(this.trans);
        jPanel2.add(this.steps);
        jPanel3.add(this.antialias);
        jPanel3.add(this.automap);
        jPanel3.add(this.showparty);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JPanel jPanel5 = new JPanel();
        this.brightadjust = new JSlider(0, 32, dmnew.BRIGHTADJUST);
        this.brightadjust.setMajorTickSpacing(1);
        this.brightadjust.setPaintTicks(true);
        jPanel5.add(new JLabel("None"));
        jPanel5.add(this.brightadjust);
        jPanel5.add(new JLabel("Brighter"));
        jPanel4.add(jPanel5);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Brightness Boost"));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = new JPanel();
        this.sleeper = new JSlider(10, 100, dmnew.SLEEPTIME);
        this.sleeper.setInverted(true);
        this.sleeper.setMajorTickSpacing(5);
        this.sleeper.setPaintTicks(true);
        jPanel7.add(new JLabel("Slowest"));
        jPanel7.add(this.sleeper);
        jPanel7.add(new JLabel("Fastest"));
        jPanel6.add(jPanel7);
        JButton jButton4 = new JButton("Restore Default");
        jButton4.addActionListener(this);
        jPanel6.add(jButton4);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Game Speed"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        JPanel jPanel9 = new JPanel();
        this.difficulty = new JSlider(-2, 2, dmnew.DIFFICULTY);
        this.difficulty.setMajorTickSpacing(1);
        this.difficulty.setPaintTicks(true);
        this.difficulty.setSnapToTicks(true);
        jPanel9.add(new JLabel("Easiest"));
        jPanel9.add(this.difficulty);
        jPanel9.add(new JLabel("Hardest"));
        jPanel8.add(jPanel9);
        JButton jButton5 = new JButton("Restore Default");
        jButton5.setActionCommand("Restore Difficulty");
        jButton5.addActionListener(this);
        jPanel8.add(jButton5);
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Game Difficulty"));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        JPanel jPanel11 = new JPanel();
        this.scaleSlider = new JSlider(10, 40, (int)(dmnew.DungeonViewScale * 10.0));
        this.scaleSlider.setMajorTickSpacing(5);
        this.scaleSlider.setMinorTickSpacing(1);
        this.scaleSlider.setSnapToTicks(true);
        this.scaleSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(4);
        hashtable.put(new Integer(10), new JLabel("1x"));
        hashtable.put(new Integer(20), new JLabel("2x"));
        hashtable.put(new Integer(30), new JLabel("3x"));
        hashtable.put(new Integer(40), new JLabel("4x"));
        this.scaleSlider.setLabelTable(hashtable);
        this.scaleSlider.setPaintLabels(true);
        this.scaleSlider.setPreferredSize(new Dimension(320, 40));
        jPanel11.add(this.scaleSlider);
        jPanel10.add(jPanel11);
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dungeon View Scale"));
        JPanel jPanel12 = new JPanel();
        JButton jButton6 = new JButton("Done");
        JButton jButton7 = new JButton("Cancel");
        JButton jButton8 = new JButton("Quit Game");
        jButton6.addActionListener(this);
        jButton7.addActionListener(this);
        jButton8.addActionListener(this);
        jPanel12.add(jButton8);
        jPanel12.add(Box.createHorizontalStrut(180));
        jPanel12.add(jButton7);
        jPanel12.add(jButton6);
        jPanel12.setBorder(BorderFactory.createRaisedBevelBorder());
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(jPanel4);
        box.add(jPanel6);
        box.add(jPanel8);
        box.add(jPanel10);
        container.add((Component)box, "Center");
        container.add((Component)jPanel12, "South");
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.hide();
    }

    public void setAndShow(boolean bl) {
        this.savegame.setEnabled(bl);
        this.value = 0;
        this.resetOptions();
        this.show();
    }

    public void resetOptions() {
        this.dark.setSelected(!dmnew.NODARK);
        this.trans.setSelected(!dmnew.NOTRANS);
        this.steps.setSelected(dmnew.PLAYFOOTSTEPS);
        this.antialias.setSelected(dmnew.TEXTANTIALIAS);
        this.automap.setSelected(dmnew.AUTOMAP);
        this.brightadjust.setValue(dmnew.BRIGHTADJUST);
        this.sleeper.setValue(dmnew.SLEEPTIME);
        this.difficulty.setValue(dmnew.DIFFICULTY);
        this.scaleSlider.setValue((int)(dmnew.DungeonViewScale * 10.0));
        this.showparty.setVisible(dmnew.AUTOMAP);
        this.showparty.setSelected(dmnew.SHOWPARTYMAP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.resetOptions();
        } else if (actionEvent.getActionCommand().equals("New Game")) {
            int n = JOptionPane.showConfirmDialog(this.frame, "Start New Game. Are You Sure?", "New Game?", 0, 3);
            if (n != 0) return;
            this.value = 3;
        } else if (actionEvent.getActionCommand().equals("New Custom")) {
            int n = JOptionPane.showConfirmDialog(this.frame, "Start New Custom Game. Are You Sure?", "Custom Game?", 0, 3);
            if (n != 0) return;
            this.value = 4;
        } else if (actionEvent.getActionCommand().equals("Load Game")) {
            this.value = 1;
        } else if (actionEvent.getActionCommand().equals("Save Game")) {
            this.value = 2;
        } else {
            if (actionEvent.getActionCommand().equals("Restore Default")) {
                this.sleeper.setValue(45);
                return;
            }
            if (actionEvent.getActionCommand().equals("Restore Difficulty")) {
                this.difficulty.setValue(0);
                return;
            }
            if (actionEvent.getActionCommand().equals("Use AutoMap")) {
                this.showparty.setVisible(this.automap.isSelected());
                return;
            }
            if (actionEvent.getActionCommand().equals("Quit Game")) {
                int n = JOptionPane.showConfirmDialog(this.frame, "Quit Game. Are You Sure?", "Quit?", 0, 3);
                if (n != 0) return;
                dmnew.shutDown();
            } else {
                dmnew.NODARK = !this.dark.isSelected();
                dmnew.NOTRANS = !this.trans.isSelected();
                dmnew.PLAYFOOTSTEPS = this.steps.isSelected();
                if (!dmnew.TEXTANTIALIAS && this.antialias.isSelected()) {
                    dmnew.TEXTANTIALIAS = true;
                    dmnew.herosheet.offg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                } else if (dmnew.TEXTANTIALIAS && !this.antialias.isSelected()) {
                    dmnew.TEXTANTIALIAS = false;
                    dmnew.herosheet.offg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                }
                dmnew.BRIGHTADJUST = this.brightadjust.getValue();
                dmnew.SLEEPTIME = this.sleeper.getValue();
                dmnew.DIFFICULTY = this.difficulty.getValue();
                dmnew.AUTOMAP = this.automap.isSelected();
                if (dmnew.AUTOMAP) {
                    dmnew.SHOWPARTYMAP = this.showparty.isSelected();
                    if (dmnew.dmmap == null) {
                        dmnew.dmmap = new DMMap((dmnew)dmnew.frame, dmnew.numlevels, dmnew.mapwidth, dmnew.mapheight, null);
                        dmnew.hspacebox.add(dmnew.dmmap);
                        dmnew.hspacebox.add(Box.createHorizontalGlue());
                        dmnew.dmmap.invalidate();
                        dmnew.vspacebox.invalidate();
                        dmnew.mappane.validate();
                    }
                }
                dmnew.setDungeonViewScale((double)this.scaleSlider.getValue() / 10.0);
            }
        }
        this.hide();
    }

    public int getValue() {
        return this.value;
    }
}

