/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class PitWizard
extends JDialog
implements ActionListener {
    private MapData data;
    private int level;
    private int x;
    private int y;
    private boolean isOpen = true;
    private boolean isConcealed = false;
    private boolean isIllusionary = false;
    private boolean isContinuous = false;
    private boolean isActive = false;
    JToggleButton monswork;
    JToggleButton resetcount;
    JToggleButton openbutton;
    JToggleButton concealbutton;
    JToggleButton illusbutton;
    JToggleButton activebutton;
    JTextField blinkfieldo;
    JTextField blinkfieldc;
    JTextField blinkcounter;
    JTextField delay;
    JTextField reset;
    JTextField maxcount;
    JTextField count;
    JPanel resetdelay;

    public PitWizard(JFrame jFrame) {
        super(jFrame, "Pit Wizard", true);
        this.setDefaultCloseOperation(2);
        this.setSize(640, 340);
        this.setLocationRelativeTo(jFrame);
        Container container = this.getContentPane();
        this.openbutton = new JToggleButton("Is Open");
        this.openbutton.addActionListener(this);
        this.openbutton.setSelected(true);
        this.concealbutton = new JToggleButton("Concealed");
        this.concealbutton.addActionListener(this);
        this.illusbutton = new JToggleButton("Has Illusion");
        this.illusbutton.addActionListener(this);
        this.activebutton = new JToggleButton("Is Blinking");
        this.activebutton.addActionListener(this);
        JLabel jLabel = new JLabel("Blinkrate (Open):");
        this.blinkfieldo = new JTextField("0", 3);
        JLabel jLabel2 = new JLabel("Blinkrate (Closed):");
        this.blinkfieldc = new JTextField("0", 3);
        JLabel jLabel3 = new JLabel("Blinkcounter:");
        this.blinkcounter = new JTextField("0", 3);
        JPanel jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jLabel);
        jPanel.add(this.blinkfieldo);
        jPanel.add(jLabel2);
        jPanel.add(this.blinkfieldc);
        jPanel.add(jLabel3);
        jPanel.add(this.blinkcounter);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.activebutton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(200, 90));
        this.resetdelay = new JPanel();
        this.resetdelay.setLayout(new BoxLayout(this.resetdelay, 1));
        this.reset = new JTextField("0", 4);
        this.delay = new JTextField("0", 4);
        this.monswork = new JToggleButton("Monsters Also Trigger");
        this.resetdelay.add(this.monswork);
        this.resetdelay.add(new JLabel("Reset Count (0 for none):"));
        this.resetdelay.add(this.reset);
        this.resetdelay.add(new JLabel("Delay Count (0 for none):"));
        this.resetdelay.add(this.delay);
        this.resetdelay.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Supplies For Quick Type"));
        jPanel2.add(this.resetdelay);
        JLabel jLabel4 = new JLabel("Total Switch count:");
        this.maxcount = new JTextField("1", 3);
        JLabel jLabel5 = new JLabel("Remaining Switch count:");
        this.count = new JTextField("1", 3);
        this.resetcount = new JToggleButton("Count Resets");
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1));
        jPanel3.add(jLabel4);
        jPanel3.add(this.maxcount);
        jPanel3.add(jLabel5);
        jPanel3.add(this.count);
        jPanel3.add(this.resetcount);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(Box.createGlue());
        jPanel4.add(jPanel3);
        jPanel4.add(Box.createGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 20, 20));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this.openbutton);
        jPanel5.add(this.concealbutton);
        jPanel5.add(this.illusbutton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.setPreferredSize(new Dimension(300, 120));
        JPanel jPanel6 = new JPanel();
        JButton jButton = new JButton("Done");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel6.add(jButton2);
        jPanel6.add(jButton);
        container.add("North", jPanel5);
        container.add("Center", jPanel2);
        container.add("East", jPanel4);
        container.add("South", jPanel6);
        this.dispose();
    }

    public void setData(MapData mapData, int n, int n2, int n3) {
        this.level = n;
        this.x = n2;
        this.y = n3;
        if (mapData.mapchar == 'p') {
            PitData pitData = (PitData)mapData;
            if (!pitData.isOpen) {
                this.openbutton.setSelected(false);
                this.isOpen = false;
            } else {
                this.openbutton.setSelected(true);
                this.isOpen = true;
            }
            if (pitData.isConcealed) {
                this.concealbutton.setSelected(true);
                this.isConcealed = true;
            } else {
                this.concealbutton.setSelected(false);
                this.isConcealed = false;
            }
            if (pitData.isIllusionary) {
                this.illusbutton.setSelected(true);
                this.isIllusionary = true;
            } else {
                this.illusbutton.setSelected(false);
                this.isIllusionary = false;
            }
            if (pitData.isActive) {
                this.activebutton.setSelected(true);
                this.isActive = true;
            } else {
                this.activebutton.setSelected(false);
                this.isActive = false;
            }
            this.blinkfieldo.setText("" + pitData.blinkrateo);
            this.blinkfieldc.setText("" + pitData.blinkratec);
            this.blinkcounter.setText("" + pitData.blinkcounter);
            this.monswork.setSelected(pitData.monswork);
            this.delay.setText("" + pitData.delay);
            this.reset.setText("" + pitData.reset);
            this.maxcount.setText("" + (pitData.maxcount + 1));
            this.count.setText("" + (pitData.count + 1));
            this.resetcount.setSelected(pitData.resetcount);
        }
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Is Open")) {
            this.isOpen = !this.isOpen;
            return;
        }
        if (actionEvent.getActionCommand().equals("Concealed")) {
            this.isConcealed = !this.isConcealed;
            return;
        }
        if (actionEvent.getActionCommand().equals("Has Illusion")) {
            this.isIllusionary = !this.isIllusionary;
            return;
        }
        if (actionEvent.getActionCommand().equals("Is Blinking")) {
            this.isActive = !this.isActive;
            return;
        }
        if (actionEvent.getActionCommand().equals("Done")) {
            int n = Integer.parseInt(this.blinkfieldo.getText());
            int n2 = Integer.parseInt(this.blinkfieldc.getText());
            if (n <= 0) {
                n = 0;
            }
            if (n2 <= 0) {
                n2 = 0;
            }
            if (n == 0 && n2 == 0) {
                this.isContinuous = false;
                this.isActive = false;
            } else {
                this.isContinuous = true;
            }
            int n3 = Integer.parseInt(this.delay.getText());
            int n4 = Integer.parseInt(this.reset.getText());
            boolean bl = false;
            if (n3 > 0 || n4 > 0) {
                bl = true;
            }
            this.data = new PitData(this.level, this.x, this.y, this.isOpen, this.isConcealed, this.isIllusionary, bl, this.isContinuous, this.isActive, n, n2, n3, n4, this.monswork.isSelected(), Integer.parseInt(this.maxcount.getText()) - 1, Integer.parseInt(this.count.getText()) - 1, this.resetcount.isSelected(), Integer.parseInt(this.blinkcounter.getText()), false, 0, false, 0);
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.data = null;
        }
        this.dispose();
    }

    public MapData getData() {
        return this.data;
    }
}

