/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class SconceData
extends SidedWallData {
    public Torch torch;
    public boolean hasTorch;
    public boolean isSwitch = false;
    public MultWallSwitchData sconceswitch;

    public SconceData(int n, boolean bl) {
        super(n);
        this.mapchar = (char)125;
        this.hasTorch = bl;
        if (bl) {
            this.torch = new Torch();
        }
    }

    public SconceData(int n, boolean bl, MultWallSwitchData multWallSwitchData) {
        super(n);
        this.mapchar = (char)125;
        this.hasTorch = bl;
        if (bl) {
            this.torch = new Torch();
        }
        this.sconceswitch = multWallSwitchData;
        this.isSwitch = true;
        this.sconceswitch.setFacing(n);
    }

    public SconceData(int n) {
        super(n);
        this.mapchar = (char)125;
    }

    @Override
    public void changeLevel(int n, int n2) {
        if (this.isSwitch) {
            this.sconceswitch.changeLevel(n, n2);
        }
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        if (this.isSwitch) {
            this.sconceswitch.setMapCoord(n, n2, n3);
        }
    }

    @Override
    public String toString() {
        String string = this.side == 0 ? "Sconce Facing South" : (this.side == 1 ? "Sconce Facing East" : (this.side == 2 ? "Sconce Facing North" : "Sconce Facing West"));
        if (this.hasTorch) {
            string = string + " - Has Torch";
        }
        if (this.isSwitch) {
            string = string + " (Switch)";
        }
        return string;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeBoolean(this.hasTorch);
        if (this.hasTorch) {
            objectOutputStream.writeObject(this.torch);
        }
        objectOutputStream.writeBoolean(this.isSwitch);
        if (this.isSwitch) {
            this.sconceswitch.save(objectOutputStream);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hasTorch = objectInputStream.readBoolean();
        if (this.hasTorch) {
            this.torch = (Torch)objectInputStream.readObject();
        }
        this.isSwitch = objectInputStream.readBoolean();
        if (this.isSwitch) {
            this.sconceswitch = (MultWallSwitchData)DMEditor.loadMapData(objectInputStream, -1, 0, 0);
        }
    }
}

