/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectOutputStream;

class SidedWall2
extends Wall {
    protected int side;
    protected int[] xadjust;
    protected int[] yadjust;
    protected Image[] facingside;
    protected Image[] col1pic;
    protected Image[] col3pic;

    public SidedWall2(int n) {
        super(0);
        this.side = n;
        this.xadjust = new int[9];
        this.yadjust = new int[9];
        for (int i = 0; i < 9; ++i) {
            this.xadjust[i] = 0;
            this.yadjust[i] = 0;
        }
        this.facingside = new Image[3];
        this.col1pic = new Image[3];
        this.col3pic = new Image[3];
    }

    @Override
    protected void setPics() {
        super.setPics();
        for (int i = 0; i < 3; ++i) {
            this.col1pic[i] = blankpic;
            this.col3pic[i] = blankpic;
            this.facingside[i] = blankpic;
        }
    }

    @Override
    public void drawPic(int n, int n2, int n3, int n4, Graphics2D graphics2D, ImageObserver imageObserver) {
        super.drawPic(n, n2, n3, n4, graphics2D, imageObserver);
        if (n2 == 0 || n2 == 4 || n == 0) {
            return;
        }
        if (n2 == 3) {
            n3 -= wallpic[n][n2].getWidth(imageObserver);
        }
        if (dmnew.facing == this.side) {
            if (n == 1 && n2 != 2) {
                return;
            }
            if (n == 2 && n2 == 1) {
                n3 -= 90;
            } else if (n == 2 && n2 == 3) {
                n3 += 34;
            } else if (n == 3 && n2 == 1) {
                n3 -= 4;
            } else if (n == 3 && n2 == 3) {
                n3 += 23;
            }
            graphics2D.drawImage(this.facingside[n - 1], n3 + this.xadjust[n - 1], n4 + this.yadjust[n - 1], imageObserver);
            return;
        }
        int n5 = this.side - 1;
        if (n5 < 0) {
            n5 = 3;
        }
        if (dmnew.facing == n5 && n2 == 1) {
            graphics2D.drawImage(this.col1pic[n - 1], n3 + this.xadjust[n + 2], n4 + this.yadjust[n + 2], imageObserver);
            return;
        }
        n5 = this.side + 1;
        if (n5 > 3) {
            n5 = 0;
        }
        if (dmnew.facing == n5 && n2 == 3) {
            graphics2D.drawImage(this.col3pic[n - 1], n3 + this.xadjust[n + 5], n4 + this.yadjust[n + 5], imageObserver);
            return;
        }
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeInt(this.side);
    }
}

