/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class SpecialAbility {
    public String name;
    public String sound;
    public int action;
    public int power;
    public int speed;
    public int mana;
    public int flevelneed;
    public int nlevelneed;
    public int wlevelneed;
    public int plevelneed;
    public int count;
    public char classgain;
    public Object data;
    public static final String[] actions = new String[]{"Anti-Ven", "Arc Bolt", "Armor", "Armor Party", "Backstab", "Berserker", "Blow Horn", "Bolt", "Calm", "Climb Down", "Climb Up", "Conjure", "Detect Illusion", "Dispell", "Drain Life", "Drain Mana", "Enhance Fist", "Enhance Weapon", "False Image", "Feeble Mind", "Fireball", "Freeze", "Freeze Life", "Frighten", "Good Berries", "Heal", "Invoke", "Light", "Purify", "Ruiner", "Shield", "Shield Party", "Sight", "Silence", "Slow", "Slowfall", "Spellshield", "Spellshield Party", "Stat Boost", "Steal", "Strip Defenses", "True Sight", "Ven Cloud", "Venom", "War Cry", "Weakness", "ZO"};

    public static int getActionNumber(String string) {
        return Arrays.binarySearch(actions, string);
    }

    public static String getActionName(int n) {
        if (n < actions.length) {
            return actions[n];
        }
        return null;
    }

    public SpecialAbility(String string, String string2, int n, char c, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        this.name = string;
        this.sound = string2;
        this.action = n;
        this.classgain = c;
        this.power = n2;
        this.speed = n3;
        this.mana = n4;
        this.flevelneed = n5;
        this.nlevelneed = n6;
        this.wlevelneed = n7;
        this.plevelneed = n8;
        this.count = n9;
        this.data = object;
    }

    public SpecialAbility(SpecialAbility specialAbility) {
        this.name = new String(specialAbility.name);
        this.sound = new String(specialAbility.sound);
        this.action = specialAbility.action;
        this.classgain = specialAbility.classgain;
        this.power = specialAbility.power;
        this.speed = specialAbility.speed;
        this.mana = specialAbility.mana;
        this.flevelneed = specialAbility.flevelneed;
        this.nlevelneed = specialAbility.nlevelneed;
        this.wlevelneed = specialAbility.wlevelneed;
        this.plevelneed = specialAbility.plevelneed;
        this.count = specialAbility.count;
        if (specialAbility.data != null) {
            if (actions[this.action].startsWith("Enhance") || actions[this.action].equals("Stat Boost")) {
                int[] nArray = (int[])specialAbility.data;
                this.data = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    ((int[])this.data)[i] = nArray[i];
                }
            } else if (actions[this.action].equals("Conjure")) {
                this.data = Item.createCopy((Item)specialAbility.data);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof SpecialAbility) {
            SpecialAbility specialAbility = (SpecialAbility)object;
            if (specialAbility.action == this.action && specialAbility.classgain == this.classgain && specialAbility.power == this.power && specialAbility.speed == this.speed && specialAbility.mana == this.mana && specialAbility.name.equals(this.name)) {
                return true;
            }
        }
        return false;
    }

    public String getActionName() {
        if (this.action < actions.length) {
            return actions[this.action];
        }
        return "";
    }

    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeUTF(this.sound);
        objectOutputStream.writeInt(this.action);
        objectOutputStream.writeChar(this.classgain);
        objectOutputStream.writeInt(this.power);
        objectOutputStream.writeInt(this.speed);
        objectOutputStream.writeInt(this.mana);
        objectOutputStream.writeInt(this.flevelneed);
        objectOutputStream.writeInt(this.nlevelneed);
        objectOutputStream.writeInt(this.wlevelneed);
        objectOutputStream.writeInt(this.plevelneed);
        objectOutputStream.writeInt(this.count);
        if (this.data != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.data);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    public SpecialAbility(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.sound = objectInputStream.readUTF();
        this.action = objectInputStream.readInt();
        this.classgain = objectInputStream.readChar();
        this.power = objectInputStream.readInt();
        this.speed = objectInputStream.readInt();
        this.mana = objectInputStream.readInt();
        this.flevelneed = objectInputStream.readInt();
        this.nlevelneed = objectInputStream.readInt();
        this.wlevelneed = objectInputStream.readInt();
        this.plevelneed = objectInputStream.readInt();
        this.count = objectInputStream.readInt();
        if (objectInputStream.readBoolean()) {
            this.data = objectInputStream.readObject();
        }
    }
}

