/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class WallSwitchData
extends SidedWallData {
    public MapPoint xy;
    public int type;
    public int keynumber;
    public int keysneeded;
    public int keysgotten = 0;
    public int picklock;
    public int picnumber;
    public int targetlevel;
    public int targetx;
    public int targety;
    public boolean isReusable;
    public boolean consumeskey;
    public boolean stopswitch;
    public boolean wasUsed;
    public boolean switchstate;
    public int actiontype;
    public int delay;
    public int reset;
    public int changecount = 0;
    public boolean delaying;
    public boolean resetting;
    public boolean resetnotrigger;
    public MapData changeto;
    public MapData oldMapObject;
    public String soundstring;
    public int loopsound;
    public boolean abrupt;
    public boolean retainitems;

    public WallSwitchData(MapPoint mapPoint, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3, int n9, int n10, boolean bl4, int n11, MapData mapData, int n12, boolean bl5) {
        super(n);
        this.xy = mapPoint;
        this.type = n2;
        this.keynumber = n3;
        this.keysneeded = n4;
        this.picklock = n5;
        this.targetlevel = n6;
        this.targetx = n7;
        this.targety = n8;
        this.isReusable = bl;
        this.consumeskey = bl2;
        this.stopswitch = bl3;
        this.delay = n9;
        this.reset = n10;
        this.resetnotrigger = bl4;
        this.actiontype = n11;
        this.changeto = mapData;
        this.picnumber = n12;
        this.retainitems = bl5;
        this.mapchar = (char)47;
    }

    public WallSwitchData(int n) {
        super(n);
        this.mapchar = (char)47;
    }

    @Override
    public void changeLevel(int n, int n2) {
        if (this.targetlevel >= n2) {
            this.targetlevel += n;
        }
        if (this.targetlevel < 0) {
            this.targetlevel = 0;
        }
        this.xy = new MapPoint(this.xy.level + n, this.xy.x, this.xy.y);
    }

    @Override
    public void setMapCoord(int n, int n2, int n3) {
        this.xy = new MapPoint(n, n2, n3);
    }

    @Override
    public String toString() {
        String string = "WallSwitch";
        if (this.type == 0) {
            string = string + " (Button)";
        } else {
            Item item = null;
            String string2 = null;
            if (this.keynumber > 9 && this.keynumber < 31) {
                item = new Item(this.keynumber, 1, 1);
                string2 = item.name;
            } else if (this.keynumber == 5) {
                string2 = "Chest";
            } else if (this.keynumber == 4) {
                string2 = "Scroll";
            } else if (this.keynumber == 9) {
                string2 = "Torch";
            } else if (this.keynumber == 73) {
                string2 = "Waterskin";
            } else if (this.keynumber == 8) {
                string2 = "Compass";
            } else if (this.keynumber < 300) {
                item = new Item(this.keynumber);
                string2 = item.name;
            }
            string = string2 != null ? (this.type == 1 ? string + " (Key - " + string2 + ")" : string + " (Coin - " + string2 + ")") : (this.type == 1 ? string + " (Key - Custom Item #" + (this.keynumber - 299) + ")" : string + " (Coin - Custom Item #" + (this.keynumber - 299) + ")");
        }
        string = this.side == 0 ? string + " Facing South" : (this.side == 1 ? string + " Facing East" : (this.side == 2 ? string + " Facing North" : string + " Facing West"));
        return string;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        super.save(objectOutputStream);
        objectOutputStream.writeObject(this.xy);
        objectOutputStream.writeInt(this.type);
        objectOutputStream.writeInt(this.keynumber);
        objectOutputStream.writeInt(this.keysneeded);
        objectOutputStream.writeInt(this.keysgotten);
        objectOutputStream.writeInt(this.picklock);
        objectOutputStream.writeInt(this.targetlevel);
        objectOutputStream.writeInt(this.targetx);
        objectOutputStream.writeInt(this.targety);
        objectOutputStream.writeBoolean(this.isReusable);
        objectOutputStream.writeBoolean(this.consumeskey);
        objectOutputStream.writeBoolean(this.stopswitch);
        objectOutputStream.writeInt(this.delay);
        objectOutputStream.writeInt(this.reset);
        objectOutputStream.writeInt(this.picnumber);
        objectOutputStream.writeInt(this.changecount);
        objectOutputStream.writeBoolean(this.delaying);
        objectOutputStream.writeBoolean(this.resetting);
        objectOutputStream.writeBoolean(this.resetnotrigger);
        objectOutputStream.writeBoolean(this.switchstate);
        objectOutputStream.writeBoolean(this.wasUsed);
        objectOutputStream.writeInt(this.actiontype);
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto.save(objectOutputStream);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject.save(objectOutputStream);
            }
            objectOutputStream.writeBoolean(this.retainitems);
        } else if (this.actiontype == 7) {
            objectOutputStream.writeUTF(this.soundstring);
            objectOutputStream.writeInt(this.loopsound);
        } else if (this.actiontype == 8) {
            objectOutputStream.writeBoolean(this.abrupt);
        }
    }

    @Override
    public void load(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.xy = (MapPoint)objectInputStream.readObject();
        this.type = objectInputStream.readInt();
        this.keynumber = objectInputStream.readInt();
        this.keysneeded = objectInputStream.readInt();
        this.keysgotten = objectInputStream.readInt();
        this.picklock = objectInputStream.readInt();
        this.targetlevel = objectInputStream.readInt();
        this.targetx = objectInputStream.readInt();
        this.targety = objectInputStream.readInt();
        this.isReusable = objectInputStream.readBoolean();
        this.consumeskey = objectInputStream.readBoolean();
        this.stopswitch = objectInputStream.readBoolean();
        this.delay = objectInputStream.readInt();
        this.reset = objectInputStream.readInt();
        this.picnumber = objectInputStream.readInt();
        this.changecount = objectInputStream.readInt();
        this.delaying = objectInputStream.readBoolean();
        this.resetting = objectInputStream.readBoolean();
        this.resetnotrigger = objectInputStream.readBoolean();
        this.switchstate = objectInputStream.readBoolean();
        this.wasUsed = objectInputStream.readBoolean();
        this.actiontype = objectInputStream.readInt();
        if (this.actiontype == 5 || this.actiontype == 6) {
            this.changeto = DMEditor.loadMapData(objectInputStream, -1, 0, 0);
            if (this.switchstate && this.actiontype == 5) {
                this.oldMapObject = DMEditor.loadMapData(objectInputStream, -1, 0, 0);
            }
            this.retainitems = objectInputStream.readBoolean();
        } else if (this.actiontype == 7) {
            this.soundstring = objectInputStream.readUTF();
            this.loopsound = objectInputStream.readInt();
        } else if (this.actiontype == 8) {
            this.abrupt = objectInputStream.readBoolean();
        }
    }
}

