/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.spike;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.model.dsl.internal.spike.ModelRegistryDslHelperStatementGenerator;
import org.gradle.model.dsl.internal.spike.ReferenceDetectingVisitor;
import org.gradle.model.dsl.internal.spike.ReferenceExtractor;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeVisitor
extends ReferenceDetectingVisitor {
    private final ModelRegistryDslHelperStatementGenerator statementGenerator;
    private final List<String> scope;
    private final SourceUnit sourceUnit;
    private final Map<String, String> referenceAliases = Maps.newHashMap();

    public ScopeVisitor(SourceUnit sourceUnit, ModelRegistryDslHelperStatementGenerator statementGenerator) {
        this(sourceUnit, statementGenerator, (List<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of());
    }

    private ScopeVisitor(SourceUnit sourceUnit, ModelRegistryDslHelperStatementGenerator statementGenerator, List<String> scope, Map<String, String> referenceAliases) {
        super(sourceUnit, "Expression not allowed");
        this.statementGenerator = statementGenerator;
        this.scope = scope;
        this.sourceUnit = sourceUnit;
        this.referenceAliases.putAll(referenceAliases);
    }

    private ScopeVisitor nestedScope(String name) {
        ImmutableList.Builder nestedScopeBuilder = ImmutableList.builder();
        nestedScopeBuilder.addAll(this.scope);
        nestedScopeBuilder.add((Object)name);
        return new ScopeVisitor(this.sourceUnit, this.statementGenerator, (List<String>)nestedScopeBuilder.build(), (Map<String, String>)ImmutableMap.copyOf(this.referenceAliases));
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        Expression rightExpression = expression.getRightExpression();
        rightExpression.visit((GroovyCodeVisitor)this);
        String referencePath = (String)rightExpression.getNodeMetaData((Object)AST_NODE_REFERENCE_PATH_KEY);
        if (referencePath != null) {
            this.referenceAliases.put(expression.getLeftExpression().getText(), referencePath);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        ClosureExpression nestedAction;
        String methodName = AstUtils.extractConstantMethodName((MethodCallExpression)call);
        if (methodName != null && (nestedAction = AstUtils.getSingleClosureArg((MethodCall)call)) != null) {
            nestedAction.getCode().visit((GroovyCodeVisitor)this.nestedScope(methodName));
            return;
        }
        super.visitMethodCallExpression(call);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        Token operation = expression.getOperation();
        if (operation.isA(280) && expression.getLeftExpression() instanceof VariableExpression && expression.getRightExpression() instanceof ClosureExpression) {
            this.addCreator(this.scope, (VariableExpression)expression.getLeftExpression(), (ClosureExpression)expression.getRightExpression());
        } else if (operation.isA(100)) {
            if (expression.getLeftExpression() instanceof VariableExpression) {
                this.addCreator(this.scope, (VariableExpression)expression.getLeftExpression(), expression.getRightExpression());
            } else if (expression.getLeftExpression() instanceof PropertyExpression) {
                this.addCreator(this.scope, (PropertyExpression)expression.getLeftExpression(), expression.getRightExpression());
            } else {
                super.visitBinaryExpression(expression);
            }
        } else {
            super.visitBinaryExpression(expression);
        }
    }

    private String getPath(List<String> scope, Expression propertyPathExpression) {
        String propertyPath = propertyPathExpression.getText();
        String scopePath = CollectionUtils.join((String)".", scope);
        return scopePath.length() > 0 ? String.format("%s.%s", scopePath, propertyPath) : propertyPath;
    }

    private void addCreator(String path, ClosureExpression creator) {
        final ImmutableMap referenceAliasesMap = ImmutableMap.copyOf(this.referenceAliases);
        ReferenceExtractor extractor = new ReferenceExtractor(this.sourceUnit, (Map<String, String>)referenceAliasesMap);
        Iterators.removeIf((Iterator)creator.getVariableScope().getReferencedLocalVariablesIterator(), (Predicate)new Predicate<Variable>(){

            public boolean apply(Variable variable) {
                return referenceAliasesMap.keySet().contains((Object)variable.getName());
            }
        });
        creator.getCode().visit((GroovyCodeVisitor)extractor);
        this.statementGenerator.addCreator(path, creator, (Set<String>)extractor.getReferencedPaths());
    }

    private void addCreator(List<String> scope, VariableExpression propertyPathExpression, ClosureExpression creator) {
        this.addCreator(this.getPath(scope, (Expression)propertyPathExpression), creator);
    }

    private void addCreator(String path, Expression expression) {
        ClosureExpression wrappingClosure = new ClosureExpression(new Parameter[0], (Statement)new ExpressionStatement(expression));
        wrappingClosure.setVariableScope(new VariableScope());
        this.addCreator(path, wrappingClosure);
    }

    public void addCreator(List<String> scope, VariableExpression propertyPathExpression, Expression expression) {
        this.addCreator(this.getPath(scope, (Expression)propertyPathExpression), expression);
    }

    public void addCreator(List<String> scope, PropertyExpression propertyPathExpression, Expression expression) {
        this.addCreator(this.getPath(scope, (Expression)propertyPathExpression), expression);
    }

    @Override
    protected String getReferenceAliasPath(String aliasName) {
        return this.referenceAliases.get(aliasName);
    }
}

