/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.Nullable;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.groovy.scripts.internal.ScriptSourceDescriptionTransformer;
import org.gradle.model.dsl.internal.transform.RuleVisitor;
import org.gradle.model.dsl.internal.transform.RulesBlock;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.internal.core.ModelPath;

public class RulesVisitor
extends RestrictiveCodeVisitor {
    private static final String AST_NODE_METADATA_KEY = RulesVisitor.class.getName();
    private static final ClassNode ANNOTATION_CLASS_NODE = new ClassNode(RulesBlock.class);
    public static final String INVALID_STATEMENT = "illegal rule";
    public static final String ARGUMENT_HAS_TO_BE_CLOSURE_LITERAL_MESSAGE = "Rules can only be specified using a closure literal";
    private final SourceUnit sourceUnit;
    private final RuleVisitor ruleVisitor;

    public RulesVisitor(SourceUnit sourceUnit, RuleVisitor ruleVisitor) {
        super(sourceUnit, INVALID_STATEMENT);
        this.sourceUnit = sourceUnit;
        this.ruleVisitor = ruleVisitor;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode method = AstUtils.getGeneratedClosureImplMethod((ClassNode)node);
        Boolean isRulesBlock = (Boolean)method.getCode().getNodeMetaData((Object)AST_NODE_METADATA_KEY);
        if (isRulesBlock != null) {
            AnnotationNode markerAnnotation = new AnnotationNode(ANNOTATION_CLASS_NODE);
            node.addAnnotation(markerAnnotation);
        }
    }

    public void visitBlockStatement(BlockStatement block) {
        block.setNodeMetaData((Object)AST_NODE_METADATA_KEY, (Object)true);
        for (Statement statement : block.getStatements()) {
            statement.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        statement.getExpression().visit((GroovyCodeVisitor)this);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        ClosureExpression closureExpression = AstUtils.getSingleClosureArg((MethodCall)call);
        if (closureExpression == null) {
            this.restrict((ASTNode)call, ARGUMENT_HAS_TO_BE_CLOSURE_LITERAL_MESSAGE);
            return;
        }
        String modelPath = this.extractModelPathFromMethodTarget(call);
        if (modelPath == null) {
            return;
        }
        ConstantExpression modelPathArgument = new ConstantExpression((Object)modelPath);
        ArgumentListExpression replacedArgumentList = new ArgumentListExpression((Expression)modelPathArgument, (Expression)closureExpression);
        call.setMethod((Expression)new ConstantExpression((Object)"configure"));
        call.setArguments((Expression)replacedArgumentList);
        call.setImplicitThis(true);
        call.setObjectExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "getDelegate", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        SourceLocation sourceLocation = new SourceLocation(this.getScriptSourceDescription(), call.getLineNumber(), call.getColumnNumber());
        closureExpression.getCode().setNodeMetaData((Object)RuleVisitor.AST_NODE_METADATA_LOCATION_KEY, (Object)sourceLocation);
        closureExpression.visit((GroovyCodeVisitor)this.ruleVisitor);
    }

    private String getScriptSourceDescription() {
        return (String)this.sourceUnit.getAST().getNodeMetaData((Object)ScriptSourceDescriptionTransformer.AST_NODE_METADATA_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private String extractModelPathFromMethodTarget(MethodCallExpression call) {
        block7: {
            Expression target = call.getMethod();
            LinkedList names = Lists.newLinkedList();
            while (true) {
                if (target instanceof ConstantExpression) {
                    if (target.getType().equals((Object)ClassHelper.STRING_TYPE)) {
                        String name = target.getText();
                        names.add(0, name);
                        if (call.isImplicitThis()) {
                            return ModelPath.pathString((Iterable)names);
                        }
                        target = call.getObjectExpression();
                        continue;
                    }
                } else {
                    ConstantExpression constantProperty;
                    if (!(target instanceof PropertyExpression)) break;
                    PropertyExpression propertyExpression = (PropertyExpression)target;
                    Expression property = propertyExpression.getProperty();
                    if (property instanceof ConstantExpression && (constantProperty = (ConstantExpression)property).getType().equals((Object)ClassHelper.STRING_TYPE)) {
                        String name = constantProperty.getText();
                        names.add(0, name);
                        target = propertyExpression.getObjectExpression();
                        continue;
                    }
                }
                break block7;
                break;
            }
            if (target instanceof VariableExpression) {
                names.add(0, ((VariableExpression)target).getName());
                return ModelPath.pathString((Iterable)names);
            }
        }
        this.restrict((ASTNode)call);
        return null;
    }
}

