/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MagicLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjParser
extends JavaParser {
    private static final boolean DEBUG_DUMP_PARSE_ERRORS = false;
    private final LintClient mClient;
    private final Project mProject;
    private Map<File, ICompilationUnit> mSourceUnits;
    private Map<ICompilationUnit, CompilationUnitDeclaration> mCompiled;
    private Parser mParser;
    private INameEnvironment mEnvironment;

    public EcjParser(@NonNull LintCliClient client, @Nullable Project project) {
        this.mClient = client;
        this.mProject = project;
        this.mParser = this.getParser();
    }

    public static CompilerOptions createCompilerOptions() {
        long languageLevel;
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = languageLevel = 0x330000L;
        options.sourceLevel = languageLevel;
        options.targetJDK = languageLevel;
        options.originalComplianceLevel = languageLevel;
        options.originalSourceLevel = languageLevel;
        options.inlineJsrBytecode = true;
        options.parseLiteralExpressionsAsConstants = true;
        options.analyseResourceLeaks = false;
        options.docCommentSupport = false;
        options.defaultEncoding = "UTF-8";
        options.suppressOptionalErrors = true;
        options.generateClassFiles = false;
        options.isAnnotationBasedNullAnalysisEnabled = false;
        options.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        options.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
        options.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
        options.reportUnusedParameterIncludeDocCommentReference = false;
        options.reportUnusedParameterWhenImplementingAbstract = false;
        options.reportUnusedParameterWhenOverridingConcrete = false;
        options.suppressWarnings = true;
        options.processAnnotations = true;
        options.storeAnnotations = true;
        options.verbose = false;
        return options;
    }

    public static long getLanguageLevel(int major, int minor) {
        assert (major == 1);
        switch (minor) {
            case 5: {
                return 0x310000L;
            }
            case 6: {
                return 0x320000L;
            }
        }
        return 0x330000L;
    }

    private Parser getParser() {
        if (this.mParser == null) {
            CompilerOptions options = EcjParser.createCompilerOptions();
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, (IProblemFactory)new DefaultProblemFactory());
            this.mParser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
            this.mParser.javadocParser.checkDocComment = false;
        }
        return this.mParser;
    }

    public void prepareJavaParse(@NonNull List<JavaContext> contexts) {
        if (this.mProject == null || contexts.isEmpty()) {
            return;
        }
        ArrayList sources = Lists.newArrayListWithExpectedSize((int)contexts.size());
        this.mSourceUnits = Maps.newHashMapWithExpectedSize((int)sources.size());
        for (JavaContext context : contexts) {
            String contents = context.getContents();
            if (contents == null) continue;
            File file = context.file;
            CompilationUnit unit = new CompilationUnit(contents.toCharArray(), file.getPath(), "UTF-8");
            sources.add(unit);
            this.mSourceUnits.put(file, (ICompilationUnit)unit);
        }
        List<String> classPath = this.computeClassPath(contexts);
        this.mCompiled = Maps.newHashMapWithExpectedSize((int)this.mSourceUnits.size());
        try {
            this.mEnvironment = EcjParser.parse(EcjParser.createCompilerOptions(), sources, classPath, this.mCompiled, this.mClient);
        }
        catch (Throwable t) {
            this.mClient.log(t, "ECJ compiler crashed", new Object[0]);
        }
    }

    public static INameEnvironment parse(CompilerOptions options, @NonNull List<ICompilationUnit> sourceUnits, @NonNull List<String> classPath, @NonNull Map<ICompilationUnit, CompilationUnitDeclaration> outputMap, @Nullable LintClient client) {
        FileSystem environment;
        block9: {
            environment = new FileSystem(classPath.toArray(new String[classPath.size()]), new String[0], options.defaultEncoding);
            IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
            DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
            ICompilerRequestor requestor = new ICompilerRequestor(){

                public void acceptResult(CompilationResult result) {
                }
            };
            NonGeneratingCompiler compiler = new NonGeneratingCompiler((INameEnvironment)environment, policy, options, requestor, (IProblemFactory)problemFactory, outputMap);
            try {
                compiler.compile(sourceUnits.toArray(new ICompilationUnit[sourceUnits.size()]));
            }
            catch (OutOfMemoryError e) {
                environment.cleanup();
                compiler = null;
                environment = null;
                requestor = null;
                problemFactory = null;
                policy = null;
                String msg = "Ran out of memory analyzing .java sources with ECJ: Some lint checks may not be accurate (missing type information from the compiler)";
                if (client != null) {
                    client.log(null, msg, new Object[0]);
                } else {
                    System.out.println(msg);
                }
            }
            catch (Throwable t) {
                if (client != null) {
                    CompilationUnitDeclaration currentUnit = compiler.getCurrentUnit();
                    if (currentUnit == null || currentUnit.getFileName() == null) {
                        client.log(t, "ECJ compiler crashed", new Object[0]);
                    } else {
                        client.log(t, "ECJ compiler crashed processing %1$s", new Object[]{new String(currentUnit.getFileName())});
                    }
                } else {
                    t.printStackTrace();
                }
                if (environment == null) break block9;
                environment.cleanup();
                environment = null;
            }
        }
        return environment;
    }

    @NonNull
    private List<String> computeClassPath(@NonNull List<JavaContext> contexts) {
        String androidJar;
        assert (this.mProject != null);
        ArrayList classPath = Lists.newArrayList();
        IAndroidTarget compileTarget = this.mProject.getBuildTarget();
        if (compileTarget != null && (androidJar = compileTarget.getPath(1)) != null && new File(androidJar).exists()) {
            classPath.add(androidJar);
        }
        HashSet libraries = Sets.newHashSet();
        HashSet names = Sets.newHashSet();
        for (File library : this.mProject.getJavaLibraries()) {
            libraries.add(library);
            names.add(EcjParser.getLibraryName(library));
        }
        for (Project project : this.mProject.getAllLibraries()) {
            for (File library : project.getJavaLibraries()) {
                String name = EcjParser.getLibraryName(library);
                if (names.contains(name)) continue;
                libraries.add(library);
                names.add(name);
            }
        }
        for (File file : libraries) {
            if (!file.exists()) continue;
            classPath.add(file.getPath());
        }
        EnumSet scope = contexts.get(0).getScope();
        if (!scope.contains(Scope.ALL_JAVA_FILES)) {
            for (File dir : this.mProject.getJavaClassFolders()) {
                if (!dir.exists()) continue;
                classPath.add(dir.getPath());
            }
        }
        return classPath;
    }

    @NonNull
    private static String getLibraryName(@NonNull File library) {
        String name = library.getName();
        if (name.equals("classes.jar")) {
            String path = library.getPath();
            int index = path.indexOf("exploded-aar");
            if (index != -1) {
                return path.substring(index);
            }
            index = path.indexOf("exploded-bundles");
            if (index != -1) {
                return path.substring(index);
            }
            File parent = library.getParentFile();
            if (parent != null) {
                return parent.getName() + File.separatorChar + name;
            }
        }
        return name;
    }

    public Node parseJava(@NonNull JavaContext context) {
        String code = context.getContents();
        if (code == null) {
            return null;
        }
        CompilationUnitDeclaration unit = this.getParsedUnit(context, code);
        try {
            EcjTreeConverter converter = new EcjTreeConverter();
            converter.visit(code, (ASTNode)unit);
            List nodes = converter.getAll();
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!(node instanceof lombok.ast.CompilationUnit)) continue;
                    return node;
                }
            }
            return null;
        }
        catch (Throwable t) {
            this.mClient.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    @Nullable
    private CompilationUnitDeclaration getParsedUnit(@NonNull JavaContext context, @NonNull String code) {
        CompilationUnitDeclaration unit;
        ICompilationUnit sourceUnit = null;
        if (this.mSourceUnits != null && this.mCompiled != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null && (unit = this.mCompiled.get(sourceUnit)) != null) {
            return unit;
        }
        if (sourceUnit == null) {
            sourceUnit = new CompilationUnit(code.toCharArray(), context.file.getName(), "UTF-8");
        }
        try {
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
            return this.getParser().parse(sourceUnit, compilationResult);
        }
        catch (AbortCompilation e) {
            return null;
        }
    }

    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        Position position = node.getPosition();
        return Location.create((File)context.file, (String)context.getContents(), (int)position.getStart(), (int)position.getEnd());
    }

    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
        ICompilationUnit sourceUnit;
        if (this.mSourceUnits != null && this.mCompiled != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null) {
            this.mSourceUnits.remove(context.file);
            this.mCompiled.remove(sourceUnit);
        }
    }

    public void dispose() {
        if (this.mEnvironment != null) {
            this.mEnvironment.cleanup();
            this.mEnvironment = null;
        }
    }

    @Nullable
    private static Object getNativeNode(@NonNull Node node) {
        lombok.ast.TypeReference typeReference;
        VariableDeclaration declaration;
        VariableDefinition definition;
        Object nativeNode = node.getNativeNode();
        if (nativeNode != null) {
            return nativeNode;
        }
        Node parent = node.getParent();
        if (parent != null && (nativeNode = parent.getNativeNode()) != null) {
            return nativeNode;
        }
        if (node instanceof VariableDefinitionEntry) {
            node = node.getParent().getParent();
        }
        if (node instanceof VariableDeclaration && (definition = (declaration = (VariableDeclaration)node).astDefinition()) != null && (typeReference = definition.astTypeReference()) != null) {
            return typeReference.getNativeNode();
        }
        return null;
    }

    @Nullable
    public JavaParser.ResolvedNode resolve(@NonNull JavaContext context, @NonNull Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof NameReference) {
            return EcjParser.resolve(((NameReference)nativeNode).binding);
        }
        if (nativeNode instanceof TypeReference) {
            return EcjParser.resolve((Binding)((TypeReference)nativeNode).resolvedType);
        }
        if (nativeNode instanceof MessageSend) {
            return EcjParser.resolve((Binding)((MessageSend)nativeNode).binding);
        }
        if (nativeNode instanceof AllocationExpression) {
            return EcjParser.resolve((Binding)((AllocationExpression)nativeNode).binding);
        }
        if (nativeNode instanceof TypeDeclaration) {
            return EcjParser.resolve((Binding)((TypeDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof ExplicitConstructorCall) {
            return EcjParser.resolve((Binding)((ExplicitConstructorCall)nativeNode).binding);
        }
        if (nativeNode instanceof Annotation) {
            return EcjParser.resolve((Binding)((Annotation)nativeNode).resolvedType);
        }
        if (nativeNode instanceof AbstractMethodDeclaration) {
            return EcjParser.resolve((Binding)((AbstractMethodDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof AbstractVariableDeclaration) {
            if (nativeNode instanceof LocalDeclaration) {
                return EcjParser.resolve((Binding)((LocalDeclaration)nativeNode).binding);
            }
            if (nativeNode instanceof FieldDeclaration) {
                return EcjParser.resolve((Binding)((FieldDeclaration)nativeNode).binding);
            }
        }
        return null;
    }

    private static JavaParser.ResolvedNode resolve(@Nullable Binding binding) {
        if (binding == null || binding instanceof ProblemBinding) {
            return null;
        }
        if (binding instanceof TypeBinding) {
            TypeBinding tb = (TypeBinding)binding;
            return new EcjResolvedClass(tb);
        }
        if (binding instanceof MethodBinding) {
            MethodBinding mb = (MethodBinding)binding;
            if (mb instanceof ProblemMethodBinding) {
                return null;
            }
            if (mb.declaringClass != null) {
                return new EcjResolvedMethod(mb);
            }
        } else if (binding instanceof LocalVariableBinding) {
            LocalVariableBinding lvb = (LocalVariableBinding)binding;
            if (lvb.type != null) {
                return new EcjResolvedVariable(lvb);
            }
        } else if (binding instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)binding;
            if (fb instanceof ProblemFieldBinding) {
                return null;
            }
            if (fb.type != null && fb.declaringClass != null) {
                return new EcjResolvedField(fb);
            }
        }
        return null;
    }

    @Nullable
    public JavaParser.TypeDescriptor getType(@NonNull JavaContext context, @NonNull Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof MessageSend) {
            nativeNode = ((MessageSend)nativeNode).binding;
        } else if (nativeNode instanceof AllocationExpression) {
            nativeNode = ((AllocationExpression)nativeNode).resolvedType;
        } else if (nativeNode instanceof NameReference) {
            nativeNode = ((NameReference)nativeNode).resolvedType;
        } else if (nativeNode instanceof Expression) {
            if (nativeNode instanceof Literal) {
                if (nativeNode instanceof StringLiteral) {
                    return EcjParser.getTypeDescriptor("java.lang.String");
                }
                if (nativeNode instanceof NumberLiteral) {
                    if (nativeNode instanceof IntLiteral) {
                        return EcjParser.getTypeDescriptor("int");
                    }
                    if (nativeNode instanceof LongLiteral) {
                        return EcjParser.getTypeDescriptor("long");
                    }
                    if (nativeNode instanceof CharLiteral) {
                        return EcjParser.getTypeDescriptor("char");
                    }
                    if (nativeNode instanceof FloatLiteral) {
                        return EcjParser.getTypeDescriptor("float");
                    }
                    if (nativeNode instanceof DoubleLiteral) {
                        return EcjParser.getTypeDescriptor("double");
                    }
                } else if (nativeNode instanceof MagicLiteral) {
                    if (nativeNode instanceof TrueLiteral || nativeNode instanceof FalseLiteral) {
                        return EcjParser.getTypeDescriptor("boolean");
                    }
                    if (nativeNode instanceof NullLiteral) {
                        return EcjParser.getTypeDescriptor("null");
                    }
                }
            }
            nativeNode = ((Expression)nativeNode).resolvedType;
        } else if (nativeNode instanceof TypeDeclaration) {
            nativeNode = ((TypeDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof AbstractMethodDeclaration) {
            nativeNode = ((AbstractMethodDeclaration)nativeNode).binding;
        }
        if (nativeNode instanceof Binding) {
            Binding binding = (Binding)nativeNode;
            if (binding instanceof TypeBinding) {
                TypeBinding tb = (TypeBinding)binding;
                return EcjParser.getTypeDescriptor(tb);
            }
            if (binding instanceof LocalVariableBinding) {
                LocalVariableBinding lvb = (LocalVariableBinding)binding;
                if (lvb.type != null) {
                    return EcjParser.getTypeDescriptor(lvb.type);
                }
            } else if (binding instanceof FieldBinding) {
                FieldBinding fb = (FieldBinding)binding;
                if (fb.type != null) {
                    return EcjParser.getTypeDescriptor(fb.type);
                }
            } else {
                if (binding instanceof MethodBinding) {
                    return EcjParser.getTypeDescriptor(((MethodBinding)binding).returnType);
                }
                if (binding instanceof ProblemBinding) {
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public JavaParser.ResolvedClass findClass(@NonNull JavaContext context, @NonNull String fullyQualifiedName) {
        Node compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        Object nativeObj = EcjParser.getNativeNode(compilationUnit);
        if (!(nativeObj instanceof CompilationUnitDeclaration)) {
            return null;
        }
        CompilationUnitDeclaration ecjUnit = (CompilationUnitDeclaration)nativeObj;
        ArrayList arrays = Lists.newArrayList();
        for (String segment : Splitter.on((char)'.').split((CharSequence)fullyQualifiedName)) {
            arrays.add(segment.toCharArray());
        }
        char[][] compoundName = new char[arrays.size()][];
        int n = arrays.size();
        for (int i = 0; i < n; ++i) {
            compoundName[i] = (char[])arrays.get(i);
        }
        Binding typeOrPackage = ecjUnit.scope.getTypeOrPackage((char[][])compoundName);
        if (typeOrPackage instanceof TypeBinding && !(typeOrPackage instanceof ProblemReferenceBinding)) {
            return new EcjResolvedClass((TypeBinding)typeOrPackage);
        }
        return null;
    }

    @Nullable
    private static JavaParser.TypeDescriptor getTypeDescriptor(@Nullable TypeBinding resolvedType) {
        if (resolvedType == null) {
            return null;
        }
        return new EcjTypeDescriptor(resolvedType);
    }

    private static JavaParser.TypeDescriptor getTypeDescriptor(String fqn) {
        return new JavaParser.DefaultTypeDescriptor(fqn);
    }

    private static boolean sameChars(String str, char[] chars) {
        int length = str.length();
        if (chars.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (chars[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class EcjResolvedAnnotation
    extends JavaParser.ResolvedAnnotation {
        private AnnotationBinding mBinding;

        private EcjResolvedAnnotation(AnnotationBinding binding) {
            this.mBinding = binding;
        }

        @NonNull
        public String getName() {
            return new String(this.mBinding.getAnnotationType().readableName());
        }

        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.getAnnotationType().readableName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor((TypeBinding)this.mBinding.getAnnotationType());
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @NonNull
        public List<JavaParser.ResolvedAnnotation.Value> getValues() {
            ElementValuePair[] pairs = this.mBinding.getElementValuePairs();
            if (pairs != null && pairs.length > 0) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)pairs.length);
                for (ElementValuePair pair : pairs) {
                    values.add(new JavaParser.ResolvedAnnotation.Value(new String(pair.getName()), pair.getValue()));
                }
            }
            return Collections.emptyList();
        }

        @Nullable
        public Object getValue(@NonNull String name) {
            ElementValuePair[] pairs = this.mBinding.getElementValuePairs();
            if (pairs != null) {
                for (ElementValuePair pair : pairs) {
                    if (!EcjParser.sameChars(name, pair.getName())) continue;
                    return pair.getValue();
                }
            }
            return null;
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public int getModifiers() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedAnnotation that = (EcjResolvedAnnotation)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals((Object)that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private static class EcjResolvedVariable
    extends JavaParser.ResolvedVariable {
        private LocalVariableBinding mBinding;

        private EcjResolvedVariable(LocalVariableBinding binding) {
            this.mBinding = binding;
        }

        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public int getModifiers() {
            return this.mBinding.modifiers;
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedVariable that = (EcjResolvedVariable)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private static class EcjResolvedField
    extends JavaParser.ResolvedField {
        private FieldBinding mBinding;

        private EcjResolvedField(FieldBinding binding) {
            this.mBinding = binding;
        }

        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @NonNull
        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass((TypeBinding)this.mBinding.declaringClass);
        }

        @Nullable
        public Object getValue() {
            Constant constant = this.mBinding.constant();
            if (constant != null) {
                if (constant instanceof StringConstant) {
                    return constant.stringValue();
                }
                if (constant instanceof IntConstant) {
                    return constant.intValue();
                }
                if (constant instanceof BooleanConstant) {
                    return constant.booleanValue();
                }
                if (constant instanceof LongConstant) {
                    return constant.longValue();
                }
                if (constant instanceof DoubleConstant) {
                    return constant.doubleValue();
                }
                if (constant instanceof CharConstant) {
                    return Character.valueOf(constant.charValue());
                }
                if (constant instanceof FloatConstant) {
                    return Float.valueOf(constant.floatValue());
                }
                if (constant instanceof ShortConstant) {
                    return constant.shortValue();
                }
                if (constant instanceof ByteConstant) {
                    return constant.byteValue();
                }
            }
            return null;
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    result.add(new EcjResolvedAnnotation(annotation));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedField that = (EcjResolvedField)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private static class EcjResolvedClass
    extends JavaParser.ResolvedClass {
        private final TypeBinding mBinding;

        private EcjResolvedClass(TypeBinding binding) {
            this.mBinding = binding;
        }

        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        @NonNull
        public String getSimpleName() {
            return new String(this.mBinding.shortReadableName());
        }

        public boolean matches(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        @Nullable
        public JavaParser.ResolvedClass getSuperClass() {
            ReferenceBinding refBinding;
            ReferenceBinding superClass;
            if (this.mBinding instanceof ReferenceBinding && (superClass = (refBinding = (ReferenceBinding)this.mBinding).superclass()) != null) {
                return new EcjResolvedClass((TypeBinding)superClass);
            }
            return null;
        }

        @Nullable
        public JavaParser.ResolvedClass getContainingClass() {
            if (this.mBinding instanceof NestedTypeBinding) {
                NestedTypeBinding ntb = (NestedTypeBinding)this.mBinding;
                if (ntb.enclosingType != null) {
                    return new EcjResolvedClass((TypeBinding)ntb.enclosingType);
                }
            }
            return null;
        }

        public boolean isSubclassOf(@NonNull String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                while (cls != null) {
                    if (EcjParser.sameChars(name, cls.readableName())) {
                        return true;
                    }
                    cls = cls.superclass();
                }
            }
            return false;
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            ReferenceBinding cls;
            MethodBinding[] methods;
            if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(TypeConstants.INIT)) != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (!method.isConstructor()) continue;
                    result.add(new EcjResolvedMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(@NonNull String name, boolean includeInherited) {
            return this.findMethods(name, includeInherited);
        }

        @NonNull
        public Iterable<JavaParser.ResolvedMethod> getMethods(boolean includeInherited) {
            return this.findMethods(null, includeInherited);
        }

        @NonNull
        private Iterable<JavaParser.ResolvedMethod> findMethods(@Nullable String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                MethodBinding[] methods;
                ReferenceBinding cls;
                if (includeInherited) {
                    ArrayList result = null;
                    for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                        int count;
                        MethodBinding[] methods2;
                        MethodBinding[] methodBindingArray = methods2 = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                        if (methods2 == null || (count = methods2.length) <= 0) continue;
                        if (result == null) {
                            result = Lists.newArrayListWithExpectedSize((int)count);
                        }
                        for (MethodBinding method : methods2) {
                            if (method.isConstructor()) continue;
                            boolean masked = false;
                            for (JavaParser.ResolvedMethod m : result) {
                                MethodBinding mb = ((EcjResolvedMethod)m).mBinding;
                                if (!mb.areParameterErasuresEqual(method)) continue;
                                masked = true;
                                break;
                            }
                            if (masked) continue;
                            result.add(new EcjResolvedMethod(method));
                        }
                    }
                    return result != null ? result : Collections.emptyList();
                }
                MethodBinding[] methodBindingArray = methods = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                if (methods != null) {
                    int count = methods.length;
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                    for (MethodBinding method : methods) {
                        if (method.isConstructor()) continue;
                        result.add(new EcjResolvedMethod(method));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ReferenceBinding cls;
            AnnotationBinding[] annotations;
            int count;
            if (this.mBinding instanceof ReferenceBinding && (count = (annotations = (cls = (ReferenceBinding)this.mBinding).getAnnotations()).length) > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    result.add(new EcjResolvedAnnotation(annotation));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Nullable
        public JavaParser.ResolvedField getField(@NonNull String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    FieldBinding[] fields = cls.fields();
                    if (fields != null) {
                        for (FieldBinding field : fields) {
                            if (!EcjParser.sameChars(name, field.name)) continue;
                            return new EcjResolvedField(field);
                        }
                    }
                    if (!includeInherited) break;
                }
            }
            return null;
        }

        public int getModifiers() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                return cls.getAccessFlags();
            }
            return 0;
        }

        public String getSignature() {
            return this.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedClass that = (EcjResolvedClass)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private static class EcjResolvedMethod
    extends JavaParser.ResolvedMethod {
        private MethodBinding mBinding;

        private EcjResolvedMethod(MethodBinding binding) {
            this.mBinding = binding;
            assert (this.mBinding.declaringClass != null);
        }

        @NonNull
        public String getName() {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return new String(c);
        }

        public boolean matches(@NonNull String name) {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return EcjParser.sameChars(name, c);
        }

        @NonNull
        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass((TypeBinding)this.mBinding.declaringClass);
        }

        public int getArgumentCount() {
            return this.mBinding.parameters != null ? this.mBinding.parameters.length : 0;
        }

        @NonNull
        public JavaParser.TypeDescriptor getArgumentType(int index) {
            TypeBinding parameterType = this.mBinding.parameters[index];
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.getTypeDescriptor(parameterType);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        @Nullable
        public JavaParser.TypeDescriptor getReturnType() {
            return this.isConstructor() ? null : EcjParser.getTypeDescriptor(this.mBinding.returnType);
        }

        public boolean isConstructor() {
            return this.mBinding.isConstructor();
        }

        @NonNull
        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    result.add(new EcjResolvedAnnotation(annotation));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedMethod that = (EcjResolvedMethod)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private static class EcjTypeDescriptor
    extends JavaParser.TypeDescriptor {
        private final TypeBinding mBinding;

        private EcjTypeDescriptor(@NonNull TypeBinding binding) {
            this.mBinding = binding;
        }

        @NonNull
        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matchesName(@NonNull String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public boolean matchesSignature(@NonNull String signature) {
            return EcjParser.sameChars(signature, this.mBinding.readableName());
        }

        @NonNull
        public String getSignature() {
            return this.getName();
        }

        @Nullable
        public JavaParser.ResolvedClass getTypeClass() {
            if (!this.mBinding.isPrimitiveType()) {
                return new EcjResolvedClass(this.mBinding);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjTypeDescriptor that = (EcjTypeDescriptor)((Object)o);
            return this.mBinding.equals(that.mBinding);
        }

        public int hashCode() {
            return this.mBinding.hashCode();
        }
    }

    private static class NonGeneratingCompiler
    extends Compiler {
        private Map<ICompilationUnit, CompilationUnitDeclaration> mUnits;
        private CompilationUnitDeclaration mCurrentUnit;

        public NonGeneratingCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, Map<ICompilationUnit, CompilationUnitDeclaration> units) {
            super(environment, policy, options, requestor, problemFactory, null, null);
            this.mUnits = units;
        }

        @Nullable
        CompilationUnitDeclaration getCurrentUnit() {
            return this.mCurrentUnit;
        }

        protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
            super.addCompilationUnit(sourceUnit, parsedUnit);
            this.mUnits.put(sourceUnit, parsedUnit);
        }

        public void process(CompilationUnitDeclaration unit, int unitNumber) {
            this.mCurrentUnit = this.lookupEnvironment.unitBeingCompleted = unit;
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            if (this.options.produceReferenceInfo && unit.scope != null) {
                unit.scope.storeDependencyInfo();
            }
            unit.finalizeProblems();
            unit.compilationResult.totalUnitsKnown = this.totalUnits;
            this.lookupEnvironment.unitBeingCompleted = null;
        }
    }

    private static class LocationHandle
    implements Location.Handle {
        private File mFile;
        private Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @NonNull
        public Location resolve() {
            Position pos = this.mNode.getPosition();
            return Location.create((File)this.mFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

