/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Beta
public class Main {
    static final int MAX_LINE_WIDTH = 78;
    private static final String ARG_ENABLE = "--enable";
    private static final String ARG_DISABLE = "--disable";
    private static final String ARG_CHECK = "--check";
    private static final String ARG_IGNORE = "--ignore";
    private static final String ARG_LIST_IDS = "--list";
    private static final String ARG_SHOW = "--show";
    private static final String ARG_QUIET = "--quiet";
    private static final String ARG_FULL_PATH = "--fullpath";
    private static final String ARG_SHOW_ALL = "--showall";
    private static final String ARG_HELP = "--help";
    private static final String ARG_NO_LINES = "--nolines";
    private static final String ARG_HTML = "--html";
    private static final String ARG_SIMPLE_HTML = "--simplehtml";
    private static final String ARG_XML = "--xml";
    private static final String ARG_TEXT = "--text";
    private static final String ARG_CONFIG = "--config";
    private static final String ARG_URL = "--url";
    private static final String ARG_VERSION = "--version";
    private static final String ARG_EXIT_CODE = "--exitcode";
    private static final String ARG_CLASSES = "--classpath";
    private static final String ARG_SOURCES = "--sources";
    private static final String ARG_RESOURCES = "--resources";
    private static final String ARG_LIBRARIES = "--libraries";
    private static final String ARG_NO_WARN_2 = "--nowarn";
    private static final String ARG_NO_WARN_1 = "-w";
    private static final String ARG_WARN_ALL = "-Wall";
    private static final String ARG_ALL_ERROR = "-Werror";
    private static final String PROP_WORK_DIR = "com.android.tools.lint.workdir";
    private LintCliFlags mFlags = new LintCliFlags();
    private IssueRegistry mGlobalRegistry;

    public static void main(String[] args) {
        new Main().run(args);
    }

    public void run(String[] args) {
        if (args.length < 1) {
            Main.printUsage(System.err);
            System.exit(2);
        }
        LintCliClient client = new LintCliClient(this.mFlags){

            @NonNull
            protected Project createProject(@NonNull File dir, @NonNull File referenceDir) {
                Project project = super.createProject(dir, referenceDir);
                if (project.isGradleProject()) {
                    String message = String.format("\"`%1$s`\" is a Gradle project. To correctly analyze Gradle projects, you should run \"`gradlew :lint`\" instead.", project.getName());
                    Location location = Location.create((File)project.getDir());
                    Context context = new Context(this.mDriver, project, project, project.getDir());
                    if (context.isEnabled(IssueRegistry.LINT_ERROR) && !this.getConfiguration(project).isIgnored(context, IssueRegistry.LINT_ERROR, location, message)) {
                        this.report(context, IssueRegistry.LINT_ERROR, project.getConfiguration().getSeverity(IssueRegistry.LINT_ERROR), location, message, TextFormat.RAW);
                    }
                }
                return project;
            }

            @Override
            public Configuration getConfiguration(@NonNull Project project) {
                if (project.isGradleProject()) {
                    return new LintCliClient.CliConfiguration(this.getConfiguration(), project, true){

                        @Override
                        @NonNull
                        public Severity getSeverity(@NonNull Issue issue) {
                            return issue == IssueRegistry.LINT_ERROR ? Severity.FATAL : Severity.IGNORE;
                        }

                        public boolean isIgnored(@NonNull Context context, @NonNull Issue issue, @Nullable Location location, @NonNull String message) {
                            if (issue == IssueRegistry.LINT_ERROR && new LintCliClient(mFlags).isSuppressed(IssueRegistry.LINT_ERROR)) {
                                return true;
                            }
                            return issue != IssueRegistry.LINT_ERROR;
                        }
                    };
                }
                return super.getConfiguration(project);
            }
        };
        String urlMap = null;
        ArrayList<File> files = new ArrayList<File>();
        for (int index = 0; index < args.length; ++index) {
            String paths;
            File output;
            String category;
            IssueRegistry registry;
            String arg = args[index];
            if (arg.equals(ARG_HELP) || arg.equals("-h") || arg.equals("-?")) {
                if (index < args.length - 1) {
                    String topic = args[index + 1];
                    if (topic.equals("suppress") || topic.equals("ignore")) {
                        Main.printHelpTopicSuppress();
                        System.exit(4);
                    } else {
                        System.err.println(String.format("Unknown help topic \"%1$s\"", topic));
                        System.exit(5);
                    }
                }
                Main.printUsage(System.out);
                System.exit(4);
                continue;
            }
            if (arg.equals(ARG_LIST_IDS)) {
                registry = this.getGlobalRegistry(client);
                if (index < args.length - 1 && !args[index + 1].startsWith("-")) {
                    String[] ids;
                    for (String id : ids = args[++index].split(",")) {
                        if (registry.isCategoryName(id)) {
                            category = id;
                            for (Issue issue : registry.getIssues()) {
                                if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                                Main.listIssue(System.out, issue);
                            }
                            continue;
                        }
                        System.err.println("Invalid category \"" + id + "\".\n");
                        Main.displayValidIds(registry, System.err);
                        System.exit(5);
                    }
                } else {
                    Main.displayValidIds(registry, System.out);
                }
                System.exit(0);
                continue;
            }
            if (arg.equals(ARG_SHOW)) {
                registry = this.getGlobalRegistry(client);
                if (index < args.length - 1 && !args[index + 1].startsWith("-")) {
                    String[] ids;
                    for (String id : ids = args[++index].split(",")) {
                        if (registry.isCategoryName(id)) {
                            category = id;
                            for (Issue issue : registry.getIssues()) {
                                if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                                Main.describeIssue(issue);
                                System.out.println();
                            }
                            continue;
                        }
                        if (registry.isIssueId(id)) {
                            Main.describeIssue(registry.getIssue(id));
                            System.out.println();
                            continue;
                        }
                        System.err.println("Invalid id or category \"" + id + "\".\n");
                        Main.displayValidIds(registry, System.err);
                        System.exit(5);
                    }
                } else {
                    Main.showIssues(registry);
                }
                System.exit(0);
                continue;
            }
            if (arg.equals(ARG_FULL_PATH) || arg.equals("--fullpaths")) {
                this.mFlags.setFullPath(true);
                continue;
            }
            if (arg.equals(ARG_SHOW_ALL)) {
                this.mFlags.setShowEverything(true);
                continue;
            }
            if (arg.equals(ARG_QUIET) || arg.equals("-q")) {
                this.mFlags.setQuiet(true);
                continue;
            }
            if (arg.equals(ARG_NO_LINES)) {
                this.mFlags.setShowSourceLines(false);
                continue;
            }
            if (arg.equals(ARG_EXIT_CODE)) {
                this.mFlags.setSetExitCode(true);
                continue;
            }
            if (arg.equals(ARG_VERSION)) {
                Main.printVersion(client);
                System.exit(0);
                continue;
            }
            if (arg.equals(ARG_URL)) {
                if (index == args.length - 1) {
                    System.err.println("Missing URL mapping string");
                    System.exit(5);
                }
                String map = args[++index];
                if (urlMap != null) {
                    urlMap = urlMap + ',' + map;
                    continue;
                }
                urlMap = map;
                continue;
            }
            if (arg.equals(ARG_CONFIG)) {
                File file;
                if (index == args.length - 1 || !LintUtils.endsWith((String)args[index + 1], (String)".xml")) {
                    System.err.println("Missing XML configuration file argument");
                    System.exit(5);
                }
                if (!(file = Main.getInArgumentPath(args[++index])).exists()) {
                    System.err.println(file.getAbsolutePath() + " does not exist");
                    System.exit(5);
                }
                this.mFlags.setDefaultConfiguration(file);
                continue;
            }
            if (arg.equals(ARG_HTML) || arg.equals(ARG_SIMPLE_HTML)) {
                boolean delete;
                if (index == args.length - 1) {
                    System.err.println("Missing HTML output file name");
                    System.exit(5);
                }
                output = Main.getOutArgumentPath(args[++index]);
                if ((output = output.getAbsoluteFile()).isDirectory() || !output.exists() && output.getName().indexOf(46) == -1) {
                    boolean mkdirs;
                    if (!output.exists() && !(mkdirs = output.mkdirs())) {
                        this.log(null, "Could not create output directory %1$s", output);
                        System.exit(3);
                    }
                    try {
                        MultiProjectHtmlReporter reporter = new MultiProjectHtmlReporter(client, output);
                        if (arg.equals(ARG_SIMPLE_HTML)) {
                            reporter.setSimpleFormat(true);
                        }
                        this.mFlags.getReporters().add(reporter);
                    }
                    catch (IOException e) {
                        this.log(e, null, new Object[0]);
                        System.exit(5);
                    }
                    continue;
                }
                if (output.exists() && !(delete = output.delete())) {
                    System.err.println("Could not delete old " + output);
                    System.exit(3);
                }
                if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
                    System.err.println("Cannot write HTML output file " + output);
                    System.exit(3);
                }
                try {
                    HtmlReporter htmlReporter = new HtmlReporter(client, output);
                    if (arg.equals(ARG_SIMPLE_HTML)) {
                        htmlReporter.setSimpleFormat(true);
                    }
                    this.mFlags.getReporters().add(htmlReporter);
                }
                catch (IOException e) {
                    this.log(e, null, new Object[0]);
                    System.exit(5);
                }
                continue;
            }
            if (arg.equals(ARG_XML)) {
                boolean delete;
                if (index == args.length - 1) {
                    System.err.println("Missing XML output file name");
                    System.exit(5);
                }
                output = Main.getOutArgumentPath(args[++index]);
                if ((output = output.getAbsoluteFile()).exists() && !(delete = output.delete())) {
                    System.err.println("Could not delete old " + output);
                    System.exit(3);
                }
                if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
                    System.err.println("Cannot write XML output file " + output);
                    System.exit(3);
                }
                try {
                    this.mFlags.getReporters().add(new XmlReporter(client, output));
                }
                catch (IOException e) {
                    this.log(e, null, new Object[0]);
                    System.exit(5);
                }
                continue;
            }
            if (arg.equals(ARG_TEXT)) {
                boolean closeWriter;
                String outputName;
                if (index == args.length - 1) {
                    System.err.println("Missing text output file name");
                    System.exit(5);
                }
                Writer writer = null;
                if ((outputName = args[++index]).equals("stdout")) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else {
                    boolean delete;
                    File output2 = Main.getOutArgumentPath(outputName);
                    if ((output2 = output2.getAbsoluteFile()).exists() && !(delete = output2.delete())) {
                        System.err.println("Could not delete old " + output2);
                        System.exit(3);
                    }
                    if (output2.getParentFile() != null && !output2.getParentFile().canWrite()) {
                        System.err.println("Cannot write text output file " + output2);
                        System.exit(3);
                    }
                    try {
                        writer = new BufferedWriter(new FileWriter(output2));
                    }
                    catch (IOException e) {
                        this.log(e, null, new Object[0]);
                        System.exit(5);
                    }
                    closeWriter = true;
                }
                this.mFlags.getReporters().add(new TextReporter(client, this.mFlags, writer, closeWriter));
                continue;
            }
            if (arg.equals(ARG_DISABLE) || arg.equals(ARG_IGNORE)) {
                String[] ids;
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to disable");
                    System.exit(5);
                }
                registry = this.getGlobalRegistry(client);
                for (String id : ids = args[++index].split(",")) {
                    if (registry.isCategoryName(id)) {
                        category = id;
                        for (Issue issue : registry.getIssues()) {
                            if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                            this.mFlags.getSuppressedIds().add(issue.getId());
                        }
                        continue;
                    }
                    if (!registry.isIssueId(id)) {
                        System.err.println("Invalid id or category \"" + id + "\".\n");
                        Main.displayValidIds(registry, System.err);
                        System.exit(5);
                        continue;
                    }
                    this.mFlags.getSuppressedIds().add(id);
                }
                continue;
            }
            if (arg.equals(ARG_ENABLE)) {
                String[] ids;
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to enable");
                    System.exit(5);
                }
                registry = this.getGlobalRegistry(client);
                for (String id : ids = args[++index].split(",")) {
                    if (registry.isCategoryName(id)) {
                        category = id;
                        for (Issue issue : registry.getIssues()) {
                            if (!issue.getCategory().getName().startsWith(category) && !issue.getCategory().getFullName().startsWith(category)) continue;
                            this.mFlags.getEnabledIds().add(issue.getId());
                        }
                        continue;
                    }
                    if (!registry.isIssueId(id)) {
                        System.err.println("Invalid id or category \"" + id + "\".\n");
                        Main.displayValidIds(registry, System.err);
                        System.exit(5);
                        continue;
                    }
                    this.mFlags.getEnabledIds().add(id);
                }
                continue;
            }
            if (arg.equals(ARG_CHECK)) {
                String[] ids;
                Set<String> checkedIds;
                if (index == args.length - 1) {
                    System.err.println("Missing categories or id's to check");
                    System.exit(5);
                }
                if ((checkedIds = this.mFlags.getExactCheckedIds()) == null) {
                    checkedIds = new HashSet<String>();
                    this.mFlags.setExactCheckedIds(checkedIds);
                }
                IssueRegistry registry2 = this.getGlobalRegistry(client);
                for (String id : ids = args[++index].split(",")) {
                    if (registry2.isCategoryName(id)) {
                        String category2 = id;
                        for (Issue issue : registry2.getIssues()) {
                            if (!issue.getCategory().getName().startsWith(category2) && !issue.getCategory().getFullName().startsWith(category2)) continue;
                            checkedIds.add(issue.getId());
                        }
                        continue;
                    }
                    if (!registry2.isIssueId(id)) {
                        System.err.println("Invalid id or category \"" + id + "\".\n");
                        Main.displayValidIds(registry2, System.err);
                        System.exit(5);
                        continue;
                    }
                    checkedIds.add(id);
                }
                continue;
            }
            if (arg.equals(ARG_NO_WARN_1) || arg.equals(ARG_NO_WARN_2)) {
                this.mFlags.setIgnoreWarnings(true);
                continue;
            }
            if (arg.equals(ARG_WARN_ALL)) {
                this.mFlags.setCheckAllWarnings(true);
                continue;
            }
            if (arg.equals(ARG_ALL_ERROR)) {
                this.mFlags.setWarningsAsErrors(true);
                continue;
            }
            if (arg.equals(ARG_CLASSES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing class folder name");
                    System.exit(5);
                }
                paths = args[++index];
                for (String path : LintUtils.splitPath((String)paths)) {
                    List<File> classes;
                    File input = Main.getInArgumentPath(path);
                    if (!input.exists()) {
                        System.err.println("Class path entry " + input + " does not exist.");
                        System.exit(5);
                    }
                    if ((classes = this.mFlags.getClassesOverride()) == null) {
                        classes = new ArrayList<File>();
                        this.mFlags.setClassesOverride(classes);
                    }
                    classes.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_SOURCES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing source folder name");
                    System.exit(5);
                }
                paths = args[++index];
                for (String path : LintUtils.splitPath((String)paths)) {
                    List<File> sources;
                    File input = Main.getInArgumentPath(path);
                    if (!input.exists()) {
                        System.err.println("Source folder " + input + " does not exist.");
                        System.exit(5);
                    }
                    if ((sources = this.mFlags.getSourcesOverride()) == null) {
                        sources = new ArrayList<File>();
                        this.mFlags.setSourcesOverride(sources);
                    }
                    sources.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_RESOURCES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing resource folder name");
                    System.exit(5);
                }
                paths = args[++index];
                for (String path : LintUtils.splitPath((String)paths)) {
                    List<File> resources;
                    File input = Main.getInArgumentPath(path);
                    if (!input.exists()) {
                        System.err.println("Resource folder " + input + " does not exist.");
                        System.exit(5);
                    }
                    if ((resources = this.mFlags.getResourcesOverride()) == null) {
                        resources = new ArrayList<File>();
                        this.mFlags.setResourcesOverride(resources);
                    }
                    resources.add(input);
                }
                continue;
            }
            if (arg.equals(ARG_LIBRARIES)) {
                if (index == args.length - 1) {
                    System.err.println("Missing library folder name");
                    System.exit(5);
                }
                paths = args[++index];
                for (String path : LintUtils.splitPath((String)paths)) {
                    List<File> libraries;
                    File input = Main.getInArgumentPath(path);
                    if (!input.exists()) {
                        System.err.println("Library " + input + " does not exist.");
                        System.exit(5);
                    }
                    if ((libraries = this.mFlags.getLibrariesOverride()) == null) {
                        libraries = new ArrayList<File>();
                        this.mFlags.setLibrariesOverride(libraries);
                    }
                    libraries.add(input);
                }
                continue;
            }
            if (arg.startsWith("--")) {
                System.err.println("Invalid argument " + arg + "\n");
                Main.printUsage(System.err);
                System.exit(5);
                continue;
            }
            String filename = arg;
            File file = Main.getInArgumentPath(filename);
            if (!file.exists()) {
                System.err.println(String.format("%1$s does not exist.", filename));
                System.exit(3);
            }
            files.add(file);
        }
        if (files.isEmpty()) {
            System.err.println("No files to analyze.");
            System.exit(5);
        } else if (files.size() > 1 && (this.mFlags.getClassesOverride() != null || this.mFlags.getSourcesOverride() != null || this.mFlags.getLibrariesOverride() != null || this.mFlags.getResourcesOverride() != null)) {
            System.err.println(String.format("The %1$s, %2$s, %3$s and %4$s arguments can only be used with a single project", ARG_SOURCES, ARG_CLASSES, ARG_LIBRARIES, ARG_RESOURCES));
            System.exit(5);
        }
        List<Reporter> reporters = this.mFlags.getReporters();
        if (reporters.isEmpty()) {
            if (urlMap != null) {
                System.err.println(String.format("Warning: The %1$s option only applies to HTML reports (%2$s)", ARG_URL, ARG_HTML));
            }
            reporters.add(new TextReporter(client, this.mFlags, new PrintWriter(System.out, true), false));
        } else if (urlMap != null) {
            for (Reporter reporter : reporters) {
                if (reporter.isSimpleFormat()) continue;
                reporter.setBundleResources(true);
            }
            if (!urlMap.equals("none")) {
                String[] replace;
                HashMap<String, String> map = new HashMap<String, String>();
                for (String s : replace = urlMap.split(",")) {
                    int index = s.indexOf(61);
                    if (index == -1) {
                        System.err.println("The URL map argument must be of the form 'path_prefix=url_prefix'");
                        System.exit(5);
                    }
                    String key = s.substring(0, index);
                    String value = s.substring(index + 1);
                    map.put(key, value);
                }
                for (Reporter reporter : reporters) {
                    reporter.setUrlMap(map);
                }
            }
        }
        try {
            int exitCode = client.run((IssueRegistry)new BuiltinIssueRegistry(), files);
            System.exit(exitCode);
        }
        catch (IOException e) {
            this.log(e, null, new Object[0]);
            System.exit(5);
        }
    }

    private IssueRegistry getGlobalRegistry(LintCliClient client) {
        if (this.mGlobalRegistry == null) {
            this.mGlobalRegistry = client.addCustomLintRules((IssueRegistry)new BuiltinIssueRegistry());
        }
        return this.mGlobalRegistry;
    }

    private static File getInArgumentPath(String filename) {
        File file2;
        File workDir;
        File file = new File(filename);
        if (!file.isAbsolute() && (workDir = Main.getLintWorkDir()) != null && (file2 = new File(workDir, filename)).exists()) {
            try {
                file = file2.getCanonicalFile();
            }
            catch (IOException e) {
                file = file2;
            }
        }
        return file;
    }

    private static File getOutArgumentPath(String filename) {
        File workDir;
        File file = new File(filename);
        if (!file.isAbsolute() && (workDir = Main.getLintWorkDir()) != null) {
            File file2 = new File(workDir, filename);
            try {
                file = file2.getCanonicalFile();
            }
            catch (IOException e) {
                file = file2;
            }
        }
        return file;
    }

    @Nullable
    private static File getLintWorkDir() {
        String path = System.getProperty(PROP_WORK_DIR);
        if (path == null || path.isEmpty()) {
            path = System.getenv(PROP_WORK_DIR);
        }
        if (path != null && !path.isEmpty()) {
            return new File(path);
        }
        return null;
    }

    private static void printHelpTopicSuppress() {
        System.out.println(Main.wrap(TextFormat.RAW.convertTo(Main.getSuppressHelp(), TextFormat.TEXT)));
    }

    static String getSuppressHelp() {
        String NBSP = "\u00a0\u00a0\u00a0\u00a0";
        return "Lint errors can be suppressed in a variety of ways:\n\n1. With a `@SuppressLint` annotation in the Java code\n2. With a `tools:ignore` attribute in the XML file\n3. With ignore flags specified in the `build.gradle` file, as explained below\n4. With a `lint.xml` configuration file in the project\n5. With a `lint.xml` configuration file passed to lint via the --config flag\n6. With the --ignore flag passed to lint.\n\nTo suppress a lint warning with an annotation, add a `@SuppressLint(\"id\")` annotation on the class, method or variable declaration closest to the warning instance you want to disable. The id can be one or more issue id's, such as `\"UnusedResources\"` or `{\"UnusedResources\",\"UnusedIds\"}`, or it can be `\"all\"` to suppress all lint warnings in the given scope.\n\nTo suppress a lint warning in an XML file, add a `tools:ignore=\"id\"` attribute on the element containing the error, or one of its surrounding elements. You also need to define the namespace for the tools prefix on the root element in your document, next to the `xmlns:android` declaration:\n`xmlns:tools=\"http://schemas.android.com/tools\"`\n\nTo suppress a lint warning in a `build.gradle` file, add a section like this:\n\nandroid {\n\u00a0\u00a0\u00a0\u00a0lintOptions {\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0disable 'TypographyFractions','TypographyQuotes'\n\u00a0\u00a0\u00a0\u00a0}\n}\n\nHere we specify a comma separated list of issue id's after the disable command. You can also use `warning` or `error` instead of `disable` to change the severity of issues.\n\nTo suppress lint warnings with a configuration XML file, create a file named `lint.xml` and place it at the root directory of the project in which it applies.\n\nThe format of the `lint.xml` file is something like the following:\n\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n\u00a0\u00a0\u00a0\u00a0<!-- Disable this given check in this project -->\n\u00a0\u00a0\u00a0\u00a0<issue id=\"IconMissingDensityFolder\" severity=\"ignore\" />\n\n\u00a0\u00a0\u00a0\u00a0<!-- Ignore the ObsoleteLayoutParam issue in the given files -->\n\u00a0\u00a0\u00a0\u00a0<issue id=\"ObsoleteLayoutParam\">\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<ignore path=\"res/layout/activation.xml\" />\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<ignore path=\"res/layout-xlarge/activation.xml\" />\n\u00a0\u00a0\u00a0\u00a0</issue>\n\n\u00a0\u00a0\u00a0\u00a0<!-- Ignore the UselessLeaf issue in the given file -->\n\u00a0\u00a0\u00a0\u00a0<issue id=\"UselessLeaf\">\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<ignore path=\"res/layout/main.xml\" />\n\u00a0\u00a0\u00a0\u00a0</issue>\n\n\u00a0\u00a0\u00a0\u00a0<!-- Change the severity of hardcoded strings to \"error\" -->\n\u00a0\u00a0\u00a0\u00a0<issue id=\"HardcodedText\" severity=\"error\" />\n</lint>\n\nTo suppress lint checks from the command line, pass the --ignore flag with a comma separated list of ids to be suppressed, such as:\n`$ lint --ignore UnusedResources,UselessLeaf /my/project/path`\n\nFor more information, see http://tools.android.com/tips/lint/suppressing-lint-warnings\n";
    }

    private static void printVersion(LintCliClient client) {
        String revision = client.getRevision();
        if (revision != null) {
            System.out.println(String.format("lint: version %1$s", revision));
        } else {
            System.out.println("lint: unknown version");
        }
    }

    private static void displayValidIds(IssueRegistry registry, PrintStream out) {
        List categories = registry.getCategories();
        out.println("Valid issue categories:");
        for (Category category : categories) {
            out.println("    " + category.getFullName());
        }
        out.println();
        List issues = registry.getIssues();
        out.println("Valid issue id's:");
        for (Issue issue : issues) {
            Main.listIssue(out, issue);
        }
    }

    private static void listIssue(PrintStream out, Issue issue) {
        out.print(Main.wrapArg("\"" + issue.getId() + "\": " + issue.getBriefDescription(TextFormat.TEXT)));
    }

    private static void showIssues(IssueRegistry registry) {
        List issues = registry.getIssues();
        ArrayList sorted = new ArrayList(issues);
        Collections.sort(sorted, new Comparator<Issue>(){

            @Override
            public int compare(Issue issue1, Issue issue2) {
                int d = issue1.getCategory().compareTo(issue2.getCategory());
                if (d != 0) {
                    return d;
                }
                d = issue2.getPriority() - issue1.getPriority();
                if (d != 0) {
                    return d;
                }
                return issue1.getId().compareTo(issue2.getId());
            }
        });
        System.out.println("Available issues:\n");
        Category previousCategory = null;
        for (Issue issue : sorted) {
            Category category = issue.getCategory();
            if (!category.equals(previousCategory)) {
                String name = category.getFullName();
                System.out.println(name);
                int n = name.length();
                for (int i = 0; i < n; ++i) {
                    System.out.print('=');
                }
                System.out.println('\n');
                previousCategory = category;
            }
            Main.describeIssue(issue);
            System.out.println();
        }
    }

    private static void describeIssue(Issue issue) {
        System.out.println(issue.getId());
        for (int i = 0; i < issue.getId().length(); ++i) {
            System.out.print('-');
        }
        System.out.println();
        System.out.println(Main.wrap("Summary: " + issue.getBriefDescription(TextFormat.TEXT)));
        System.out.println("Priority: " + issue.getPriority() + " / 10");
        System.out.println("Severity: " + issue.getDefaultSeverity().getDescription());
        System.out.println("Category: " + issue.getCategory().getFullName());
        if (!issue.isEnabledByDefault()) {
            System.out.println("NOTE: This issue is disabled by default!");
            System.out.println(String.format("You can enable it by adding %1$s %2$s", ARG_ENABLE, issue.getId()));
        }
        System.out.println();
        System.out.println(Main.wrap(issue.getExplanation(TextFormat.TEXT)));
        List moreInfo = issue.getMoreInfo();
        if (!moreInfo.isEmpty()) {
            System.out.println("More information: ");
            for (String uri : moreInfo) {
                System.out.println(uri);
            }
        }
    }

    static String wrapArg(String explanation) {
        return Main.wrap(explanation, 78, "      ");
    }

    static String wrap(String explanation) {
        return Main.wrap(explanation, 78, "");
    }

    static String wrap(String explanation, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap((String)explanation, (int)lineWidth, (String)hangingIndent);
    }

    private static void printUsage(PrintStream out) {
        String command = "lint";
        out.println("Usage: " + command + " [flags] <project directories>\n");
        out.println("Flags:\n");
        Main.printUsage(out, new String[]{ARG_HELP, "This message.", "--help <topic>", "Help on the given topic, such as \"suppress\".", ARG_LIST_IDS, "List the available issue id's and exit.", ARG_VERSION, "Output version information and exit.", ARG_EXIT_CODE, "Set the exit code to 1 if errors are found.", ARG_SHOW, "List available issues along with full explanations.", "--show <ids>", "Show full explanations for the given list of issue id's.", "", "\nEnabled Checks:", "--disable <list>", "Disable the list of categories or specific issue id's. The list should be a comma-separated list of issue id's or categories.", "--enable <list>", "Enable the specific list of issues. This checks all the default issues plus the specifically enabled issues. The list should be a comma-separated list of issue id's or categories.", "--check <list>", "Only check the specific list of issues. This will disable everything and re-enable the given list of issues. The list should be a comma-separated list of issue id's or categories.", "-w, --nowarn", "Only check for errors (ignore warnings)", ARG_WARN_ALL, "Check all warnings, including those off by default", ARG_ALL_ERROR, "Treat all warnings as errors", "--config <filename>", "Use the given configuration file to determine whether issues are enabled or disabled. If a project contains a lint.xml file, then this config file will be used as a fallback.", "", "\nOutput Options:", ARG_QUIET, "Don't show progress.", ARG_FULL_PATH, "Use full paths in the error output.", ARG_SHOW_ALL, "Do not truncate long messages, lists of alternate locations, etc.", ARG_NO_LINES, "Do not include the source file lines with errors in the output. By default, the error output includes snippets of source code on the line containing the error, but this flag turns it off.", "--html <filename>", "Create an HTML report instead. If the filename is a directory (or a new filename without an extension), lint will create a separate report for each scanned project.", "--url filepath=url", "Add links to HTML report, replacing local path prefixes with url prefix. The mapping can be a comma-separated list of path prefixes to corresponding URL prefixes, such as C:\\temp\\Proj1=http://buildserver/sources/temp/Proj1.  To turn off linking to files, use --url none", "--simplehtml <filename>", "Create a simple HTML report", "--xml <filename>", "Create an XML report instead.", "", "\nProject Options:", "--resources <dir>", "Add the given folder (or path) as a resource directory for the project. Only valid when running lint on a single project.", "--sources <dir>", "Add the given folder (or path) as a source directory for the project. Only valid when running lint on a single project.", "--classpath <dir>", "Add the given folder (or jar file, or path) as a class directory for the project. Only valid when running lint on a single project.", "--libraries <dir>", "Add the given folder (or jar file, or path) as a class library for the project. Only valid when running lint on a single project.", "", "\nExit Status:", "0", "Success.", Integer.toString(1), "Lint errors detected.", Integer.toString(2), "Lint usage.", Integer.toString(3), "Cannot clobber existing file.", Integer.toString(4), "Lint help.", Integer.toString(5), "Invalid command-line argument."});
    }

    private static void printUsage(PrintStream out, String[] args) {
        int argWidth = 0;
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            argWidth = Math.max(argWidth, arg.length());
        }
        argWidth += 2;
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < argWidth; ++i) {
            sb.append(' ');
        }
        String indent = sb.toString();
        String formatString = "%1$-" + argWidth + "s%2$s";
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            String description = args[i + 1];
            if (arg.isEmpty()) {
                out.println(description);
                continue;
            }
            out.print(Main.wrap(String.format(formatString, arg, description), 78, indent));
        }
    }

    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        System.out.flush();
        if (!this.mFlags.isQuiet()) {
            System.err.println();
        }
        if (format != null) {
            System.err.println(String.format(format, args));
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }
}

