/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBinding<T> {
    private final ModelReference<T> reference;
    private final ModelPath path;

    private ModelBinding(ModelReference<T> reference, ModelPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.reference = reference;
        this.path = path;
    }

    public static <T> ModelBinding<T> of(ModelReference<T> reference) {
        if (reference.getPath() == null) {
            throw new IllegalArgumentException("reference has no path: " + reference);
        }
        return new ModelBinding<T>(reference, reference.getPath());
    }

    public static <T> ModelBinding<T> of(ModelReference<T> reference, ModelPath path) {
        if (reference.getPath() != null && !reference.getPath().equals(path)) {
            throw new IllegalArgumentException("mismatched paths: " + reference.getPath() + " & " + path);
        }
        return new ModelBinding<T>(reference, path);
    }

    public ModelReference<T> getReference() {
        return this.reference;
    }

    public ModelPath getPath() {
        return this.path;
    }

    public String toString() {
        return "ModelBinding{reference=" + this.reference + ", path=" + this.path + '}';
    }
}

