/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.inspect.ModelRuleInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultModelRuleInvoker<I, R>
implements ModelRuleInvoker<R> {
    private final JavaMethod<I, R> javaMethod;
    private final ModelType<I> source;

    DefaultModelRuleInvoker(Method method, ModelType<I> source, ModelType<R> returnType) {
        this.javaMethod = JavaReflectionUtil.method(source.getConcreteClass(), returnType.getConcreteClass(), (Method)method);
        this.source = source;
    }

    @Override
    public R invoke(Object ... args) {
        Object instance = Modifier.isStatic(this.javaMethod.getMethod().getModifiers()) ? null : this.toInstance();
        return (R)this.javaMethod.invoke(instance, args);
    }

    private I toInstance() {
        try {
            Class<I> concreteClass = this.source.getConcreteClass();
            Constructor<I> declaredConstructor = concreteClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
    }
}

