/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompatibleTypeReferenceReporter {
    private static final String INDENT = "  ";
    private final String creator;
    private final String path;
    private final String type;
    private final String description;
    private final boolean writable;
    private final Iterable<String> candidateTypes;

    public IncompatibleTypeReferenceReporter(String creator, String path, String type, String description, boolean writable, Iterable<String> candidateTypes) {
        this.creator = creator;
        this.path = path;
        this.type = type;
        this.description = description;
        this.writable = writable;
        this.candidateTypes = candidateTypes;
    }

    public static IncompatibleTypeReferenceReporter of(ModelRuleDescriptor creator, ModelPromise promise, ModelReference<?> reference, boolean writable) {
        return new IncompatibleTypeReferenceReporter(creator.toString(), reference.getPath().toString(), reference.getType().toString(), reference.getDescription(), writable, writable ? promise.getWritableTypeDescriptions() : promise.getReadableTypeDescriptions());
    }

    public String asString() {
        StringWriter string = new StringWriter();
        this.writeTo(new PrintWriter(string));
        return string.toString();
    }

    public void writeTo(PrintWriter writer) {
        writer.print("Model reference to element '");
        writer.print(this.path);
        writer.print("' with type ");
        writer.print(this.type);
        if (this.description != null) {
            writer.print(" (");
            writer.print(this.description);
            writer.print(") ");
        }
        writer.println("is invalid due to incompatible types.");
        writer.print("This element was created by ");
        writer.print(this.creator);
        writer.print(" and can be ");
        writer.print(this.writable ? "mutated" : "read");
        writer.println(" as the following types:");
        boolean first = true;
        for (String candidateType : this.candidateTypes) {
            if (!first) {
                writer.println();
            }
            writer.print(INDENT);
            writer.print("- ");
            writer.print(candidateType);
            first = false;
        }
    }
}

