/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundRule {
    private final String descriptor;
    private final List<UnboundRuleInput> immutableInputs;
    private final List<UnboundRuleInput> mutableInputs;

    private UnboundRule(String descriptor, List<UnboundRuleInput> immutableInputs, List<UnboundRuleInput> mutableInputs) {
        this.descriptor = descriptor;
        this.immutableInputs = immutableInputs;
        this.mutableInputs = mutableInputs;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public List<? extends UnboundRuleInput> getImmutableInputs() {
        return this.immutableInputs;
    }

    public List<? extends UnboundRuleInput> getMutableInputs() {
        return this.mutableInputs;
    }

    public static Builder descriptor(String descriptor) {
        return new Builder(descriptor);
    }

    public static Builder descriptor(String descriptor, File location, int line, int column) {
        return new Builder(String.format("%s @ build file '%s' line %d, column %d", descriptor, location.getAbsolutePath(), line, column));
    }

    public static class Builder {
        private String descriptor;
        private final List<UnboundRuleInput> immutableInputs = Lists.newLinkedList();
        private final List<UnboundRuleInput> mutableInputs = Lists.newLinkedList();

        private Builder(String descriptor) {
            this.descriptor = descriptor;
        }

        public Builder immutableInput(UnboundRuleInput.Builder inputBuilder) {
            this.immutableInputs.add(inputBuilder.build());
            return this;
        }

        public Builder mutableInput(UnboundRuleInput.Builder inputBuilder) {
            this.mutableInputs.add(inputBuilder.build());
            return this;
        }

        public UnboundRule build() {
            return new UnboundRule(this.descriptor, this.immutableInputs, this.mutableInputs);
        }
    }
}

