/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jediterm.terminal.TtyConnectorWaitFor;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalActionProviderBase;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TtyConnectorWaitFor myWaitFor;

    public TerminalSessionEditor(Project project, TerminalSessionVirtualFileImpl terminalFile) {
        this.myProject = project;
        this.myFile = terminalFile;
        final TabbedSettingsProvider settings = this.myFile.getSettingsProvider();
        this.myFile.getTerminal().setNextProvider((TerminalActionProvider)new TerminalActionProviderBase(){

            public List<TerminalAction> getActions() {
                return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("Close Session", settings.getCloseSessionKeyStrokes(), (Predicate)new Predicate<KeyEvent>(){

                    public boolean apply(KeyEvent input) {
                        TerminalSessionEditor.this.handleCloseSession();
                        return true;
                    }
                }).withMnemonicKey(Integer.valueOf(83))});
            }
        });
        this.myWaitFor = new TtyConnectorWaitFor(this.myFile.getTerminal().getTtyConnector(), Executors.newSingleThreadExecutor());
        this.myWaitFor.setTerminationCallback((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer integer) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManagerEx.getInstanceEx((Project)TerminalSessionEditor.this.myProject).closeFile((VirtualFile)TerminalSessionEditor.this.myFile);
                    }
                });
                return true;
            }
        });
    }

    private void handleCloseSession() {
        this.myFile.getTerminal().close();
    }

    public JComponent getComponent() {
        return this.myFile.getTerminal();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFile.getTerminal();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        Boolean closingToReopen = (Boolean)this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN);
        this.myWaitFor.detach();
        if (closingToReopen == null || !closingToReopen.booleanValue()) {
            this.myFile.getTerminal().close();
        }
    }
}

