/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class ExternalAnnotationsManager {
    @NonNls
    public static final String ANNOTATIONS_XML = "annotations.xml";
    public static final Topic<ExternalAnnotationsListener> TOPIC = Topic.create((String)"external annotations", ExternalAnnotationsListener.class);
    private static final NotNullLazyKey<ExternalAnnotationsManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ExternalAnnotationsManager.class);

    public static ExternalAnnotationsManager getInstance(Project project) {
        return (ExternalAnnotationsManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public abstract boolean isExternalAnnotation(PsiAnnotation var1);

    public abstract PsiAnnotation findExternalAnnotation(PsiModifierListOwner var1, String var2);

    public abstract boolean isExternalAnnotationWritable(PsiModifierListOwner var1, String var2);

    public abstract PsiAnnotation[] findExternalAnnotations(PsiModifierListOwner var1);

    public abstract void annotateExternally(PsiModifierListOwner var1, String var2, PsiFile var3, PsiNameValuePair[] var4);

    public abstract boolean deannotate(PsiModifierListOwner var1, String var2);

    public abstract boolean editExternalAnnotation(PsiModifierListOwner var1, String var2, PsiNameValuePair[] var3);

    public abstract AnnotationPlace chooseAnnotationsPlace(PsiElement var1);

    public abstract List<PsiFile> findExternalAnnotationsFiles(PsiModifierListOwner var1);

    public static enum AnnotationPlace {
        IN_CODE,
        EXTERNAL,
        NOWHERE;

    }
}

