/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;

public class CompletionResult {
    private final LookupElement myLookupElement;
    private final PrefixMatcher myMatcher;
    private final CompletionSorter mySorter;

    private CompletionResult(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        this.myLookupElement = lookupElement;
        this.myMatcher = matcher;
        this.mySorter = sorter;
    }

    public static CompletionResult wrap(LookupElement lookupElement, PrefixMatcher matcher, CompletionSorter sorter) {
        if (matcher.prefixMatches(lookupElement)) {
            return new CompletionResult(lookupElement, matcher, sorter);
        }
        return null;
    }

    public PrefixMatcher getPrefixMatcher() {
        return this.myMatcher;
    }

    public CompletionSorter getSorter() {
        return this.mySorter;
    }

    public LookupElement getLookupElement() {
        return this.myLookupElement;
    }

    public CompletionResult withLookupElement(LookupElement element) {
        if (!this.myMatcher.prefixMatches(element)) {
            throw new AssertionError((Object)"The new element doesn't match the prefix");
        }
        return new CompletionResult(element, this.myMatcher, this.mySorter);
    }

    public boolean isStartMatch() {
        return this.myMatcher.isStartMatch(this.myLookupElement);
    }
}

