/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class CompletionService {
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> SORTING_KEY = Key.create((String)"completionSorting");

    public static CompletionService getCompletionService() {
        return ServiceManager.getService(CompletionService.class);
    }

    public abstract String getAdvertisementText();

    public abstract void setAdvertisementText(String var1);

    public void getVariantsFromContributors(CompletionParameters parameters, CompletionContributor from, Consumer<CompletionResult> consumer) {
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        for (int i = contributors.indexOf(from) + 1; i < contributors.size(); ++i) {
            CompletionContributor contributor = contributors.get(i);
            CompletionResultSet result = this.createResultSet(parameters, consumer, contributor);
            contributor.fillCompletionVariants(parameters, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    public abstract CompletionResultSet createResultSet(CompletionParameters var1, Consumer<CompletionResult> var2, CompletionContributor var3);

    public abstract CompletionProcess getCurrentCompletion();

    public LookupElement[] performCompletion(CompletionParameters parameters, final Consumer<CompletionResult> consumer) {
        final LinkedHashSet lookupSet = new LinkedHashSet();
        this.getVariantsFromContributors(parameters, null, new Consumer<CompletionResult>(){

            public void consume(CompletionResult result) {
                if (lookupSet.add(result.getLookupElement())) {
                    consumer.consume((Object)result);
                }
            }
        });
        return lookupSet.toArray(new LookupElement[lookupSet.size()]);
    }

    public abstract CompletionSorter defaultSorter(CompletionParameters var1, PrefixMatcher var2);

    public abstract CompletionSorter emptySorter();
}

