/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.completion.TemplateParameterTraversalPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;

public abstract class NextPrevParameterAction
extends CodeInsightAction {
    private final boolean myNext;

    protected NextPrevParameterAction(boolean next) {
        this.myNext = next;
    }

    @Override
    public CodeInsightActionHandler getHandler() {
        return new Handler();
    }

    @Override
    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        return NextPrevParameterAction.hasSutablePolicy(editor, file);
    }

    public static boolean hasSutablePolicy(Editor editor, PsiFile file) {
        return NextPrevParameterAction.findSuitableTraversalPolicy(editor, file) != null;
    }

    private static TemplateParameterTraversalPolicy findSuitableTraversalPolicy(Editor editor, PsiFile file) {
        for (TemplateParameterTraversalPolicy policy : (TemplateParameterTraversalPolicy[])Extensions.getExtensions(TemplateParameterTraversalPolicy.EP_NAME)) {
            if (!policy.isValidForFile(editor, file)) continue;
            return policy;
        }
        return null;
    }

    public static class Prev
    extends NextPrevParameterAction {
        public Prev() {
            super(false);
        }
    }

    public static class Next
    extends NextPrevParameterAction {
        public Next() {
            super(true);
        }
    }

    private class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        @Override
        public void invoke(Project project, Editor editor, PsiFile file) {
            TemplateParameterTraversalPolicy policy = NextPrevParameterAction.findSuitableTraversalPolicy(editor, file);
            if (policy != null) {
                PsiDocumentManager.getInstance(project).commitAllDocuments();
                policy.invoke(editor, file, NextPrevParameterAction.this.myNext);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }
}

